<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';
//require APPPATH . '/libraries/GroupeIncController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Bors
 * @version : 1.1
 * @since : 22 November 2018
 */
class Dashboard extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->isLoggedIn();   
        $this->action_type = 0;
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {

    }
    
    public function accessmembres($grpId,$extranetId){

        $this->global['pageTitle']        = 'E-learning : Trainee Fiche'; 
        $this->global['displaygrp']       = $this->DisplayGroupe($this->session->userdata ('STAGIAIREGRP'),$this->session->userdata ('STAGIAIREID'));
        $this->global['tracking_tuteur']       = $this->groupes_model->getListActivityByTuteur($this->session->userdata ('GUSERID'));
        $this->loadViews("tutor/trainee/index", $this->global, NULL , NULL);
    }

    public function readprog(){
        $paves_sequence_nom = '';
 
        if (isset($_GET['extranet_id']) && !empty($_GET['extranet_id'])) {           
            $this->global['displaygrp']       = $this->DisplayGroupe($_GET['groupe'],$_GET['id']);

            $sessionArray = array('STAGIAIREID'=>$_GET['id'],
                                    'STAGIAIREGRP'=>$_GET['groupe'],
                                    'STAGIAIRENAME'=>$this->membres_model->GetPrenom($_GET['id']).' '.$this->membres_model->GetNom($_GET['id']),
                                    'STAGIAIREEXTRANETID' =>$_GET['extranet_id']
                                ); 
            $this->session->set_userdata($sessionArray);
            $this->global['groupe']           = $_GET['groupe'];
            
            $this->global['STAGIAIREID']           = $_GET['id'];
            $this->global['STAGIAIREGRP']          = $_GET['groupe'];
        }
        else{
            $this->global['groupe']           = $this->session->userdata ('STAGIAIREGRP');
        }

        if (isset($_GET['paves_sequence'])) {
            define('PAVES_SEQUENCE',    $_GET['paves_sequence']);

            $date_debut = time();        
            if (PAVES_SEQUENCE==4) {
                $this->tracking_type = 6;
               $paves_sequence_nom.= $this->lang->line('educational_library_newsletter');
               $this->global['titlelibrary'] = $this->lang->line('educational_library_newsletter');
            }
            elseif (PAVES_SEQUENCE==6) {
                $this->tracking_type = 7; 
                $paves_sequence_nom.=$this->lang->line('educational_library_pedagogical_training');
                $this->global['titlelibrary'] = $this->lang->line('educational_library_pedagogical_training');
            }   
            elseif (PAVES_SEQUENCE==7) {
                $this->tracking_type = 8; 
                $paves_sequence_nom.= $this->lang->line('educational_library_personnal_interest');
                $this->global['titlelibrary'] =  $this->lang->line('educational_library_personnal_interest');
            }
            elseif(PAVES_SEQUENCE == 8){
                $this->tracking_type = 9;
                $paves_sequence_nom.=$this->lang->line('educational_library_lingustic_tools');
                $this->global['titlelibrary'] = $this->lang->line('educational_library_lingustic_tools');
            } 
        }
        else{
            define('PAVES_SEQUENCE',    '');
        }

        $data['PAVE_SEQUENCE'] = PAVES_SEQUENCE;

        $this->loadTrackingEl(0,0,$this->tracking_type);           
            
        $this->global['pageTitle'] = 'E-learning : '.$paves_sequence_nom;
        $this->global['sequenceTitle'] = $paves_sequence_nom;
        $data['TRACKING_TYPE'] = $this->tracking_type;

        $data['ret_newsletter2'] = $this->sequence_model->getPavetSequenceHaut($this->session->userdata ('STAGIAIREGRP'),$this->session->userdata ('GUSERID'),PAVES_SEQUENCE);
        
        $nbrBtn    = 1;
        $moduleId;
        $moduleName;
        $groupeId;
        if(isset($data['ret_newsletter2']) && !empty($data['ret_newsletter2'])){
            if(is_array($data['ret_newsletter2']['module'])){ 
                foreach($data['ret_newsletter2']['module'] as $key2=>$value2){ if(is_array($value2)){ 
                    foreach($value2 as $key3=>$value3){ 
                        if ($nbrBtn == 1) {
                            $moduleId     = $value3['module_id'];
                            $moduleName   = $key2;
                            $groupeId     = $value3['idg'];
                        }
                        $nbrBtn ++; }
                    }
                }
            }
        }

        if (isset($moduleId) && $moduleId > 0) {
            $data['dataLoadPageLibrary']  = $this->getModuleContentLoadPage($groupeId,$moduleId,$moduleName,PAVES_SEQUENCE);
        }
        $ret_complementary_activities=$this->sequence_model->getPavetComplementary($this->session->userdata ('STAGIAIREGRP')); 
        $array_newsletter = $this->sequence_model->getPavetHaut($this->session->userdata ('STAGIAIREGRP'),4);
        $array_ped_training = $this->sequence_model->getPavetHaut($this->session->userdata ('STAGIAIREGRP'),6);
        $array_pers_ling = $this->sequence_model->getPavetHaut($this->session->userdata ('STAGIAIREGRP'),7);
        $array_ling_tools = $this->sequence_model->getPavetHaut($this->session->userdata ('STAGIAIREGRP'),8);

        $arrayListeModule = array();
        $array_id_module_newsletter = array();
        $array_id_module_ped_training = array();
        $array_id_module_pers_ling = array();
        $array_id_module_ling_tools = array();   

        if(!empty($array_newsletter)){
            if (is_array($array_newsletter['module'])) {
                foreach($array_newsletter['module'] as $key=>$value){
                    foreach($value as $key2=>$value2){
                        $arrayListeModule[] = $value2['module_id'];
                        $array_id_module_newsletter[] = $value2['module_id'];
                    }
                }
            }
        }
        if(!empty($array_ped_training)){
            if (is_array($array_ped_training['module'])) {
                foreach($array_ped_training['module'] as $key=>$value){
                    foreach($value as $key2=>$value2){
                        $arrayListeModule[] = $value2['module_id'];
                        $array_id_module_ped_training[] = $value2['module_id'];
                    }
                }
            }
        }
        if(!empty($array_pers_ling)){
            if (is_array($array_pers_ling['module'])) {
                foreach($array_pers_ling['module'] as $key=>$value){
                    foreach($value as $key2=>$value2){
                        $arrayListeModule[] = $value2['module_id'];
                        $array_id_module_pers_ling[] = $value2['module_id'];
                    }
                }
            }
        }
        if(!empty($array_ling_tools)){
            if (is_array($array_ling_tools['module'])) {
                foreach($array_ling_tools['module'] as $key=>$value){
                    foreach($value as $key2=>$value2){
                        $arrayListeModule[] = $value2['module_id'];
                        $array_id_module_ling_tools[] = $value2['module_id'];
                    }
                }
            }
        }
        if(!empty($ret_complementary_activities)){
            if (is_array($ret_complementary_activities['module'])) {
                foreach($ret_complementary_activities['module'] as $key=>$value){
                    $arrayListeModule[] = $value['module_id'];
                }
            }
        }

        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_newsletter) ;
        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ped_training) ;
        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_pers_ling) ;
        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ling_tools) ;  
        $data['ret_complementary_activities']  = $ret_complementary_activities;
        $data['arrayListeModule']  = $arrayListeModule;
        $data['moduleloaded']  = isset($moduleId) ? $moduleId : NULL;
        $data['classification_favoris']              = $this->classificationFavoris_Model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP'));
        $data['historik_course'] = $this->coursHistorik_model->getByUserCreateIdGroupTraineeCreate($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREID'),$this->session->userdata ('STAGIAIREGRP')); 
        $this->loadViews("tutor/trainee/program", $this->global, $data , NULL); 
    }

    public function readActivity(){
        
    }

    public function viewTodo(){
        $this->global['pageTitle'] = 'E-learning : Forma2+';
        
        $this->loadViews("todoList/viewstodo", $this->global, NULL , NULL);
    }

    public function pageNotFound()
    {
        $this->global['pageTitle'] = 'CodeInsect : 404 - Page Not Found';
        
        $this->loadViews("404", $this->global, NULL, NULL);
    }
    
   
}

?>