<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Detail
 * Base Class to control over all the classes
 * @author : Alexandre Bors
 * @version : 1.1
 * @since : 22 November 2018
 */
class Detail extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('user_model');
        $this->load->model('connexion_model');
        $this->load->model('groupes_model');
        $this->load->model('membres_model');
        $this->load->model('traineestat_model');
        
        $this->isLoggedIn();   
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->global['pageTitle'] = 'E-learning : Connection Detail';
        $data['connexion_detail'] = $this->traineestat_model->detailsConnexionsTuteur($_GET['id'],$_GET['groupe']);
        $this->connexion_model->refresh($this->connexion_model->getIdCnxUser($_GET['id']));
        $this->loadViews('tutor/trainee/detail', $this->global, $data , NULL);        
        
    }   
   
    
    public function activityDetail(){
        if (isset($_GET['stag']) && isset($_GET['stag_cnx'])) {
            $this->load->library('pagination');
            $this->global['pageTitle'] = 'E-learning : Activity detail';
            $this->global['groupe'] = $this->session->userdata ('STAGIAIREGRP');
            $count      = $this->tracking_model->getCountStagiaireTracking($_GET['stag_cnx'],$_GET['stag'],$_GET['groupe']);
            $returns    = $this->paginationCompress ( "trainee-todo-in-tutor/", $count,12);
            $data['detailActivityResult'] = $this->tracking_model->getStagiaireTracking($_GET['stag_cnx'],$_GET['stag'],$_GET['groupe'], $returns["page"], $returns["segment"]);
            $data['trainneeSelect'] = $this->membres_model->Request('prenom',$_GET['stag']).' '.$this->membres_model->Request('nom',$_GET['stag']);
            $this->loadViews("tutor/stat/activity-detail", $this->global,$data, NULL );
        }
    }

    public function pageNotFound()
    {
        $this->global['pageTitle'] = 'CodeInsect : 404 - Page Not Found';
        
        $this->loadViews("404", $this->global, NULL, NULL);
    }
    
    
   
}

?>