<?php 
    if(!defined('BASEPATH')) exit('No direct script access allowed');

    require APPPATH . '/libraries/ElearningForma2PlusController.php';
    /**
     * Class : TraineeDashbord
     * Base Class to control over all the classes
     * @author : Alexandre Bors
     * @version : 2.2
     * @since : 29 April 2023
     */
    class TraineeDashbord extends ElearningForma2PlusController
    {
        /**
         * This is default constructor of the class
         */
        public function __construct()
        {
            parent::__construct();
            $this->isLoggedIn();   
            if (isset($_GET['extranet_id']) && !empty($_GET['extranet_id'])) {
                $langageFormation = $this->groupes_model->RequestByGrp('langue',$_GET['groupe']);
                $langagePlateform = '';
                if (preg_match('/Anglais/i', $langageFormation, $matches)) {  
                    $langagePlateform = 'english';
                } 
                else if (preg_match('/Français/i', $langageFormation, $matches)){
                    $langagePlateform = 'french';
                }             
                else if ($langageFormation == NULL || $langageFormation == ''){
                    $langagePlateform = 'english';
                }
                else{
                    $langagePlateform = 'french';
                }
                $sessionArray = array(
                    'site_lang'      =>$langagePlateform,
                    'GLOSSAIREONLINE'=>$this->groupes_model->Request('glossaireenligne',$_GET['groupe'])
                ); 
                $this->global['GLOSSAIREONLINE']          = $this->groupes_model->Request('glossaireenligne',$_GET['groupe']);
                $this->global['GEXTRANETID']          = isset($_GET['extranet_id']) ? $_GET['extranet_id'] : $GEXTRANETID;
                $this->global['IDSTAGE']              = isset($_GET['id']) ? $this->Stag_individu_model->getMaxNumStageByIdMembers($_GET['id']) : $IDSTAGE;
                $this->session->set_userdata($sessionArray);
            }
            $this->tracking_type = 38;
        }

        

        public function index(){
            $this->global['pageTitle']        = 'E-learning : '.$this->lang->line('trainee_dashbord');
            $order = '';
            $loader = FALSE;
            if (isset($_GET['extranet_id']) && !empty($_GET['extranet_id'])) {           
                
                $sessionArray = array(
                    'IDSTAGE'=> $this->Stag_individu_model->getMaxNumStageByIdMembers($_GET['id']),
                    'STAGIAIREID'=>$_GET['id'],
                    'STAGIAIREGRP'=>$_GET['groupe'],
                    'STAGIAIRENAME'=>$this->membres_model->GetPrenom($_GET['id']).' '.$this->membres_model->GetNom($_GET['id']),
                    'STAGIAIREEXTRANETID' =>$_GET['extranet_id'],
                    'IDSOCIETE'           =>$this->membres_model->Request('id_societe',$_GET['id']),
                    'IDSOCIETESTAGIAIRE'  =>$this->membres_model->Request('id_societe',$_GET['id']),
                    'NAMESOCIETESTAGIAIRE'=>$this->societe_model->Request('description',$this->membres_model->Request('id_societe',$_GET['id']))
                ); 
                $this->session->set_userdata($sessionArray);
                $this->global['groupe']                = $_GET['groupe'];
                
                $this->global['STAGIAIREID']           = $_GET['id'];
                $this->global['STAGIAIREGRP']          = $_GET['groupe'];

                $dataConnexion = array(
                    'id_groupe'  => $this->global['STAGIAIREGRP'],
                    'id_stage'   => $this->Stag_individu_model->getMaxNumStageByIdMembers($_GET['id'])
                );

                $this->connexion_model->update($this->session->userdata ('CNX'),$dataConnexion);

                $loader = TRUE;
            }
            else{
                $this->global['groupe']           = $this->session->userdata ('STAGIAIREGRP');
                $loader = TRUE;
            }

            if (isset($loader) && $loader == TRUE) {                
                $this->loadTrackingEl(0,0,$this->tracking_type);
                $this->loadViews("tutor/trainee-dashbord", $this->global,NULL, NULL );          
            }
             
        }

        public function setCurrentUrlSession(){
            $sessionUrl = $this->getFullUrlCurrent();
        }
       
    }

?>