<?php
    function convert_utf8($str) {
        $new2old = array(
          'á' => 'Ã¡',
          'À' => 'Ã€',
          'ä' => 'Ã¤',
          'Ä' => 'Ã„',
          'ã' => 'Ã£',
          'å' => 'Ã¥',
          'Å' => 'Ã…',
          'æ' => 'Ã¦',
          'Æ' => 'Ã†',
          'ç' => 'Ã§',
          'Ç' => 'Ã‡',
          'é' => 'Ã©',
          'É' => 'Ã‰',
          'è' => 'Ã¨',
          'È' => 'Ãˆ',
          'ê' => 'Ãª',
          'Ê' => 'ÃŠ',
          'ë' => 'Ã«',
          'Ë' => 'Ã‹',
          //'í' => 'Ã-',
          //'Í' => 'Ã',
          'ì' => 'Ã¬',
          'Ì' => 'ÃŒ',
          'î' => 'Ã®',
          'Î' => 'ÃŽ',
          'ï' => 'Ã¯',
          //'à' => 'Ã ',
          'ñ' => 'Ã±',
          'Ñ' => 'Ã‘',
          'ó' => 'Ã³',
          'Ó' => 'Ã“',
          'ò' => 'Ã²',
          'Ò' => 'Ã’',
          'ô' => 'Ã´',
          'Ô' => 'Ã”',
          'ö' => 'Ã¶',
          'Ö' => 'Ã–',
          'õ' => 'Ãµ',
          'Õ' => 'Ã•',
          'ø' => 'Ã¸',
          'Ø' => 'Ã˜',
          'œ' => 'Å“',
          'Œ' => 'Å’',
          'ß' => 'ÃŸ',
          'ú' => 'Ãº',
          'Ú' => 'Ãš',
          'ù' => 'Ã¹',
          'Ù' => 'Ã™',
          'û' => 'Ã»',
          'Û' => 'Ã›',
          'ü' => 'Ã¼',
          'Ü' => 'Ãœ',
          '€' => 'â‚¬',
          '’' => 'â€™',
          '‚' => 'â€š',
          'ƒ' => 'Æ’',
          '„' => 'â€ž',
          '…' => 'â€¦',
          '‡' => 'â€¡',
          'ˆ' => 'Ë†',
          '‰' => 'â€°',
          'Š' => 'Å ',
          '‹' => 'â€¹',
          'Ž' => 'Å½',
          '‘' => 'â€˜',
          '“' => 'â€œ',
          '•' => 'â€¢',
          '–' => 'â€“',
          '—' => 'â€”',
          '˜' => 'Ëœ',
          '™' => 'â„¢',
          'š' => 'Å¡',
          '›' => 'â€º',
          'ž' => 'Å¾',
          'Ÿ' => 'Å¸',
          '¡' => 'Â¡',
          '¢' => 'Â¢',
          '£' => 'Â£',
          '¤' => 'Â¤',
          '¥' => 'Â¥',
          '¦' => 'Â¦',
          '§' => 'Â§',
          '¨' => 'Â¨',
          '©' => 'Â©',
          'ª' => 'Âª',
          '«' => 'Â«',
          '¬' => 'Â¬',
          '®' => 'Â®',
          '¯' => 'Â¯',
          '°' => 'Â°',
          '±' => 'Â±',
          '²' => 'Â²',
          '³' => 'Â³',
          '´' => 'Â´',
          'µ' => 'Âµ',
          '¶' => 'Â¶',
          '·' => 'Â·',
          '¸' => 'Â¸',
          '¹' => 'Â¹',
          'º' => 'Âº',
          '»' => 'Â»',
          '¼' => 'Â¼',
          '½' => 'Â½',
          '¾' => 'Â¾',
          '¿' => 'Â¿',
          'à' => 'Ã',
          '†' => 'â€ ',
          '”' => 'â€',
          //'Á' => 'Ã',
          'â' => 'Ã¢',
          'Â' => 'Ã‚',
          'Ã' => 'Ãƒ',
          'â' => 'Ã¢',
          'ô' => 'Í´',
          'î' => 'Í®',
          'ù' => 'à¹',
          'oe' => 'Å"',
          '”' => 'â€',
          "'" => '&#39;',
        );
        $new = array();
        $old = array();
        foreach( $new2old as $key => $value ) {
          $new[] = $key;
          $old[] = $value;
        }
        return str_replace( $old, $new, $str );
    }

    function mobileDetect(){
        if(!empty($_SERVER['HTTP_USER_AGENT'])){
          $user_ag = $_SERVER['HTTP_USER_AGENT'];
          if(preg_match('/(Mobile|Android|Tablet|GoBrowser|[0-9]x[0-9]*|uZardWeb\/|Mini|Doris\/|Skyfire\/|iPhone|Fennec\/|Maemo|Iris\/|CLDC\-|Mobi\/)/uis',$user_ag)){
            return true;
         };
        };
        return false;
    }
    function getEmbedUrl($url) {
        // function for generating an embed link
        $finalUrl = '';
        if (strpos($url, 'facebook.com/') !== false) {
            // Facebook Video
            $finalUrl.='https://www.facebook.com/plugins/video.php?href='.rawurlencode($url).'&show_text=1&width=200';
        } 
        else if(strpos($url, 'vimeo.com/') !== false) {
            // Vimeo video
            $videoId = isset(explode("vimeo.com/",$url)[1]) ? explode("vimeo.com/",$url)[1] : null;
            if (strpos($videoId, '&') !== false){
            }
            $finalUrl.='https://player.vimeo.com/video/'.$videoId;
        } 
        else if (strpos($url, 'youtube.com/') !== false) {
            // Youtube video
            $videoId = isset(explode("v=",$url)[1]) ? explode("v=",$url)[1] : null;
            if (strpos($videoId, '&') !== false){
                $videoId = explode("&",$videoId)[0];
            }
            $finalUrl.='https://www.youtube.com/embed/'.$videoId;
        } 
        else if(strpos($url, 'youtu.be/') !== false) {
            // Youtube  video
            $videoId = isset(explode("youtu.be/",$url)[1]) ? explode("youtu.be/",$url)[1] : null;
            if (strpos($videoId, '&') !== false) {
                $videoId = explode("&",$videoId)[0];
            }
            $finalUrl.='https://www.youtube.com/embed/'.$videoId;
        } 
        else if (strpos($url, 'dailymotion.com/') !== false) {
            // Dailymotion Video
            $videoId = isset(explode("dailymotion.com/",$url)[1]) ? explode("dailymotion.com/",$url)[1] : null;
            if (strpos($videoId, '&') !== false) {
                $videoId = explode("&",$videoId)[0];
            }
            $finalUrl.='https://www.dailymotion.com/embed/'.$videoId;
        }
        else{
            $finalUrl.=$url;
        }
        return $finalUrl;
    }

    /*function getFinalUrlFromGroupMain($urlTodo1,$type,$repGroupIn,$httpmainGroup){
        $retour = array();
        if ($type == 0 && !existMediaUrl($urlTodo1)) {            
            if (strpos($urlTodo1, base_url()) !== false) {
                $retour['infoContent'] = 'local_file';
            }
            else{
                $retour['infoContent'] = 'simple_link';
            }

            if (getExtensionFileGoogleDoc($urlTodo1)) {
                $retour['linkF'] = 'https://docs.google.com/gview?url='.$urlTodo1.'&embedded=true'; 
            }
            elseif(getExtensionFilePPT($urlTodo1)){
                $retour['linkF'] = 'https://view.officeapps.live.com/op/embed.aspx?src='.$urlTodo1; 
            }
            else{
                $retour['linkF'] = $urlTodo1;
            }
        }
        elseif ($type == 0 && existMediaUrl($urlTodo1)) {
            $retour['linkF'] = getEmbedUrl($urlTodo1);
            $retour['infoContent'] = 'embend_url';
        }            
        elseif ($type != 0 && file_exists($repGroupIn.$urlTodo1) && getExtensionFile($httpmainGroup.$urlTodo1)){
            if (strpos($httpmainGroup.$urlTodo1, base_url()) !== false) {
                $retour['infoContent'] = 'local_file';
            }
            else{
                $retour['infoContent'] = 'simple_link';
            }

            if (getExtensionFileGoogleDoc($httpmainGroup.$urlTodo1)) {
                $retour['linkF'] = 'https://docs.google.com/gview?url='.$httpmainGroup.$urlTodo1.'&embedded=true'; 
            }
            elseif(getExtensionFilePPT($httpmainGroup.$urlTodo1)){
                $retour['linkF'] = 'https://view.officeapps.live.com/op/embed.aspx?src='.$httpmainGroup.$urlTodo1; 
            }
            else{
                $retour['linkF'] = $httpmainGroup.$urlTodo1;
            }
        }
        elseif($type != 0 && !file_exists($repGroupIn.$urlTodo1)){
          $retour['linkF'] = 'No_file';
          $retour['infoContent'] = '';
        }
        else{
            $retour['linkF'] = $httpmainGroup.$urlTodo1;
            $retour['infoContent'] = 'inconito';
        }
        return $retour;
    }*/
    function getFileExtension($path){
        return pathinfo($path, PATHINFO_EXTENSION);
    }

    function getFinalUrlFromGroupMain($urlTodo1,$type,$repGroupIn,$httpmainGroup){
        $retour = array();
        if ($type == 0) {    
            if (existMediaUrl($urlTodo1)) {
                $retour['linkF'] = getEmbedUrl($urlTodo1);
                $retour['infoContent'] = 'embend_url';
                $retour['fileExntesion'] = getFileExtension($urlTodo1);
            } 
            else{       
                if (strpos($urlTodo1, base_url()) !== false) {
                    $retour['infoContent'] = 'local_file';
                }
                else{
                    $retour['infoContent'] = 'simple_link';
                }


                if (getExtensionFileGoogleDoc($urlTodo1)) {
                    $retour['linkF'] = 'https://docs.google.com/gview?url='.$urlTodo1.'&embedded=true'; 
                }
                elseif(getExtensionFilePPT($urlTodo1)){
                    $retour['linkF'] = 'https://view.officeapps.live.com/op/embed.aspx?src='.$urlTodo1; 
                }
                else{
                    $retour['linkF'] = $urlTodo1;
                }

                $retour['fileExntesion'] = getFileExtension($urlTodo1);
            }
        }      
        else{
            if (file_exists($repGroupIn.$urlTodo1)) {
                if (strpos($httpmainGroup.$urlTodo1, base_url()) !== false) {
                    $retour['infoContent'] = 'local_file';
                }
                else{
                    $retour['infoContent'] = 'simple_link';
                }

                if (getExtensionFileGoogleDoc($httpmainGroup.$urlTodo1)) {
                    $retour['linkF'] = 'https://docs.google.com/gview?url='.$httpmainGroup.$urlTodo1.'&embedded=true'; 
                }
                elseif(getExtensionFilePPT($httpmainGroup.$urlTodo1)){
                    $retour['linkF'] = 'https://view.officeapps.live.com/op/embed.aspx?src='.$httpmainGroup.$urlTodo1; 
                }
                else{
                    $retour['linkF'] = $httpmainGroup.$urlTodo1;
                }

                $retour['fileExntesion'] = getFileExtension($repGroupIn.$urlTodo1);
            }
            else{
                $retour['linkF'] = 'No_file';
                $retour['infoContent'] = '';
                $retour['fileExntesion'] = '';
            }
        }   
        $retour['type'] = $type;
        $retour['httpmainGroup'] = $httpmainGroup.$urlTodo1;
        return $retour;
    }

    function existMediaUrl($url){
        $status = false;
        $mediaLinks = array('vimeo.com','facebook.com','dailymotion.com','youtube','youtu.be');
        foreach ($mediaLinks as $ext) { 
          if (strpos($url, $ext) !== false) {
            $status = true;
            break;
          }
        }
        return $status;
    }

    function getExtensionFileGoogleDoc($file){
        $status = false;
        $extensionarray = array('.doc','.docx','.gdoc','.gdocx','.odt','.rtf','.txt');
        foreach ($extensionarray as $ext) { 
          if (strpos($file, $ext) !== false) {
            $status = true;
            break;
          }
        }
        return $status;
    }

    function getExtensionFilePPT($file){
        $status = false;
        $extensionarray = array('.ppt','.pptx');
        foreach ($extensionarray as $ext) { 
          if (strpos($file, $ext) !== false) {
            $status = true;
            break;
          }
        }
        return $status;
    }

    function getExtensionFile($file){
        $status = false;
        $extensionarray = array('.doc','.docx','.pdf','.ppt','.png','.PNG','.jpg','.JPG','.jpeg','.JPEG','.wav','.WAV','.MP3','.mp3','.PDF','.xl','.xls','.xlsx');
        foreach ($extensionarray as $ext) { 
          if (strpos($file, $ext) !== false) {
            $status = true;
            break;
          }
        }
        return $status;
    }

    function getFinalUrl($data,$type,$repPgroupeSession){
        $linkF = '';
        $urlTodo1 = $data;
        if ($type == 0 && strpos($urlTodo1, 'youtube') === false && strpos($urlTodo1, 'youtu.be') === false && strpos($urlTodo1, 'vimeo.com') === false && strpos($urlTodo1, 'facebook.com') === false && strpos($urlTodo1, 'dailymotion.com') === false) {
            $linkF = $data;
        }
        elseif ($type == 0 && (strpos($urlTodo1, 'vimeo.com') !== false || strpos($urlTodo1, 'facebook.com') !== false || strpos($urlTodo1, 'dailymotion.com') !== false || strpos($urlTodo1, 'youtube') !== false || strpos($urlTodo1, 'youtu.be') !== false)) {
            $linkF = getEmbedUrl($urlTodo1);
        }            
        elseif (($type != 0 && file_exists(RP_GROUPES.$repPgroupeSession.'/documentTodo/'.$urlTodo1)) && (strpos(HTTP_MAIN.'groupes/'.$repPgroupeSession.'/documentTodo/'.$urlTodo1, '.doc') !== false) || (strpos(HTTP_MAIN.'groupes/'.$repPgroupeSession.'/documentTodo/'.$urlTodo1, '.docx') !== false) || (strpos(HTTP_MAIN.'groupes/'.$repPgroupeSession.'/documentTodo/'.$urlTodo1, '.ppt') !== false) || (strpos(HTTP_MAIN.'groupes/'.$repPgroupeSession.'/documentTodo/'.$urlTodo1, '.pdf') !== false)){

            $linkF = HTTP_MAIN.'groupes/'.$repPgroupeSession.'/documentTodo/'.$urlTodo1;
        }
        elseif($type != 0 && !file_exists(RP_GROUPES.$repPgroupeSession.'/documentTodo/'.$urlTodo1)){
          $linkF = 'No_file';
        }
        else{
            $linkF = HTTP_MAIN.'groupes/'.$repPgroupeSession.'/documentTodo/'.$urlTodo1;
        }
        return $linkF;
    }

    function validate_url($url){
        $curl = curl_init($url); 
        curl_setopt($curl, CURLOPT_NOBODY, true); 
        $result = curl_exec($curl); 
          
        if ($result !== false) { 
            $statusCode = curl_getinfo($curl, CURLINFO_HTTP_CODE); 
            if ($statusCode != 200 && $statusCode != 302 && $statusCode != 304) { 
                return false; 
            } 
            else { 
                return true; 
            } 
        } 
        else { 
            return false; 
        }
    }


    function jm_estimated_time_to_read_post( $content ) {           
        $wordCount = str_word_count( $content );
        $time_to_read = round($wordCount * ( 1/60 ) );
        return $time_to_read;
    }


    function detectMediaUrl($url) {
        // function for generating an embed link
        $status = false;
        if (strpos($url, 'facebook.com/') !== false) {
            // Facebook Video
            $status = true;
        } 
        else if(strpos($url, 'vimeo.com/') !== false) {
            // Vimeo video
            $status = true;
        } 
        else if (strpos($url, 'youtube.com/') !== false) {
            // Youtube video
            $status = true;
        } 
        else if(strpos($url, 'youtu.be/') !== false) {
            // Youtube  video
            $status = true;
        } 
        else if (strpos($url, 'dailymotion.com/') !== false) {
            // Dailymotion Video
            $status = true;
        }
        else{
            $status = false;
        }
        return $status;
    }

    function strpos_arr($haystack, $needle) {
        if(!is_array($needle)) $needle = array($needle);
        foreach($needle as $what) {
            if(($pos = strpos($haystack, $what))!==false) return $pos;
        }
        return false;
    }

    function extractValueFromSpecificKeyInArray($array, $cleRecherchee) {
        $resultat = [];

        foreach ($array as $cle => $valeur) {
            if (is_array($valeur)) {
                // Appel récursif si la valeur est un tableau
                $resultat = array_merge($resultat, extractValueFromSpecificKeyInArray($valeur, $cleRecherchee));
            } elseif ($cle === $cleRecherchee) {
                // Si la clé correspond, on ajoute la valeur au résultat
                $resultat[] = $valeur;
            }
        }

        return $resultat;
    }