<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/privacy/dlp/v2/dlp.proto

namespace Google\Cloud\Dlp\V2\Action;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Create a de-identified copy of the requested table or files.
 * A TransformationDetail will be created for each transformation.
 * If any rows in BigQuery are skipped during de-identification
 * (transformation errors or row size exceeds BigQuery insert API limits) they
 * are placed in the failure output table. If the original row exceeds
 * the BigQuery insert API limit it will be truncated when written to the
 * failure output table. The failure output table can be set in the
 * action.deidentify.output.big_query_output.deidentified_failure_output_table
 * field, if no table is set, a table will be automatically created in the
 * same project and dataset as the original table.
 * Compatible with: Inspect
 *
 * Generated from protobuf message <code>google.privacy.dlp.v2.Action.Deidentify</code>
 */
class Deidentify extends \Google\Protobuf\Internal\Message
{
    /**
     * User specified deidentify templates and configs for structured,
     * unstructured, and image files.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.TransformationConfig transformation_config = 7;</code>
     */
    private $transformation_config = null;
    /**
     * Config for storing transformation details. This is separate from the
     * de-identified content, and contains metadata about the successful
     * transformations and/or failures that occurred while de-identifying. This
     * needs to be set in order for users to access information about the status
     * of each transformation (see
     * [TransformationDetails][google.privacy.dlp.v2.TransformationDetails]
     * message for more information about what is noted).
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.TransformationDetailsStorageConfig transformation_details_storage_config = 3;</code>
     */
    private $transformation_details_storage_config = null;
    /**
     * List of user-specified file type groups to transform. If specified, only
     * the files with these filetypes will be transformed. If empty, all
     * supported files will be transformed. Supported types may be automatically
     * added over time. If a file type is set in this field that isn't supported
     * by the Deidentify action then the job will fail and will not be
     * successfully created/started. Currently the only filetypes supported are:
     * IMAGES, TEXT_FILES, CSV, TSV.
     *
     * Generated from protobuf field <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
     */
    private $file_types_to_transform;
    protected $output;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Dlp\V2\TransformationConfig $transformation_config
     *           User specified deidentify templates and configs for structured,
     *           unstructured, and image files.
     *     @type \Google\Cloud\Dlp\V2\TransformationDetailsStorageConfig $transformation_details_storage_config
     *           Config for storing transformation details. This is separate from the
     *           de-identified content, and contains metadata about the successful
     *           transformations and/or failures that occurred while de-identifying. This
     *           needs to be set in order for users to access information about the status
     *           of each transformation (see
     *           [TransformationDetails][google.privacy.dlp.v2.TransformationDetails]
     *           message for more information about what is noted).
     *     @type string $cloud_storage_output
     *           Required. User settable Cloud Storage bucket and folders to store de-identified
     *           files. This field must be set for cloud storage deidentification. The
     *           output Cloud Storage bucket must be different from the input bucket.
     *           De-identified files will overwrite files in the output path.
     *           Form of: gs://bucket/folder/ or gs://bucket
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $file_types_to_transform
     *           List of user-specified file type groups to transform. If specified, only
     *           the files with these filetypes will be transformed. If empty, all
     *           supported files will be transformed. Supported types may be automatically
     *           added over time. If a file type is set in this field that isn't supported
     *           by the Deidentify action then the job will fail and will not be
     *           successfully created/started. Currently the only filetypes supported are:
     *           IMAGES, TEXT_FILES, CSV, TSV.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Privacy\Dlp\V2\Dlp::initOnce();
        parent::__construct($data);
    }

    /**
     * User specified deidentify templates and configs for structured,
     * unstructured, and image files.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.TransformationConfig transformation_config = 7;</code>
     * @return \Google\Cloud\Dlp\V2\TransformationConfig|null
     */
    public function getTransformationConfig()
    {
        return $this->transformation_config;
    }

    public function hasTransformationConfig()
    {
        return isset($this->transformation_config);
    }

    public function clearTransformationConfig()
    {
        unset($this->transformation_config);
    }

    /**
     * User specified deidentify templates and configs for structured,
     * unstructured, and image files.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.TransformationConfig transformation_config = 7;</code>
     * @param \Google\Cloud\Dlp\V2\TransformationConfig $var
     * @return $this
     */
    public function setTransformationConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dlp\V2\TransformationConfig::class);
        $this->transformation_config = $var;

        return $this;
    }

    /**
     * Config for storing transformation details. This is separate from the
     * de-identified content, and contains metadata about the successful
     * transformations and/or failures that occurred while de-identifying. This
     * needs to be set in order for users to access information about the status
     * of each transformation (see
     * [TransformationDetails][google.privacy.dlp.v2.TransformationDetails]
     * message for more information about what is noted).
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.TransformationDetailsStorageConfig transformation_details_storage_config = 3;</code>
     * @return \Google\Cloud\Dlp\V2\TransformationDetailsStorageConfig|null
     */
    public function getTransformationDetailsStorageConfig()
    {
        return $this->transformation_details_storage_config;
    }

    public function hasTransformationDetailsStorageConfig()
    {
        return isset($this->transformation_details_storage_config);
    }

    public function clearTransformationDetailsStorageConfig()
    {
        unset($this->transformation_details_storage_config);
    }

    /**
     * Config for storing transformation details. This is separate from the
     * de-identified content, and contains metadata about the successful
     * transformations and/or failures that occurred while de-identifying. This
     * needs to be set in order for users to access information about the status
     * of each transformation (see
     * [TransformationDetails][google.privacy.dlp.v2.TransformationDetails]
     * message for more information about what is noted).
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.TransformationDetailsStorageConfig transformation_details_storage_config = 3;</code>
     * @param \Google\Cloud\Dlp\V2\TransformationDetailsStorageConfig $var
     * @return $this
     */
    public function setTransformationDetailsStorageConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dlp\V2\TransformationDetailsStorageConfig::class);
        $this->transformation_details_storage_config = $var;

        return $this;
    }

    /**
     * Required. User settable Cloud Storage bucket and folders to store de-identified
     * files. This field must be set for cloud storage deidentification. The
     * output Cloud Storage bucket must be different from the input bucket.
     * De-identified files will overwrite files in the output path.
     * Form of: gs://bucket/folder/ or gs://bucket
     *
     * Generated from protobuf field <code>string cloud_storage_output = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getCloudStorageOutput()
    {
        return $this->readOneof(9);
    }

    public function hasCloudStorageOutput()
    {
        return $this->hasOneof(9);
    }

    /**
     * Required. User settable Cloud Storage bucket and folders to store de-identified
     * files. This field must be set for cloud storage deidentification. The
     * output Cloud Storage bucket must be different from the input bucket.
     * De-identified files will overwrite files in the output path.
     * Form of: gs://bucket/folder/ or gs://bucket
     *
     * Generated from protobuf field <code>string cloud_storage_output = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setCloudStorageOutput($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(9, $var);

        return $this;
    }

    /**
     * List of user-specified file type groups to transform. If specified, only
     * the files with these filetypes will be transformed. If empty, all
     * supported files will be transformed. Supported types may be automatically
     * added over time. If a file type is set in this field that isn't supported
     * by the Deidentify action then the job will fail and will not be
     * successfully created/started. Currently the only filetypes supported are:
     * IMAGES, TEXT_FILES, CSV, TSV.
     *
     * Generated from protobuf field <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFileTypesToTransform()
    {
        return $this->file_types_to_transform;
    }

    /**
     * List of user-specified file type groups to transform. If specified, only
     * the files with these filetypes will be transformed. If empty, all
     * supported files will be transformed. Supported types may be automatically
     * added over time. If a file type is set in this field that isn't supported
     * by the Deidentify action then the job will fail and will not be
     * successfully created/started. Currently the only filetypes supported are:
     * IMAGES, TEXT_FILES, CSV, TSV.
     *
     * Generated from protobuf field <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFileTypesToTransform($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\Dlp\V2\FileType::class);
        $this->file_types_to_transform = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getOutput()
    {
        return $this->whichOneof("output");
    }

}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Deidentify::class, \Google\Cloud\Dlp\V2\Action_Deidentify::class);

