<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class CoursHistorik_model extends CI_Model
{
    
    public function __construct(){        
        parent::__construct();
        $this->table        = 'historique_cours';     
        $this->table_page   = 'course_hisotry_page';     
        $this->table_source = 'new_sequence';
        $this->table_membres= 'membres';
    }

    public function update($id,$data) {
        $this->db->where('id', $id);
        $this->db->update($this->table, $data);

    }
    public function updatePage($id,$data) {
        $this->db->where('id', $id);
        $this->db->update($this->table_page, $data); 
        return $this->db->affected_rows();       
    }
    public function delete($id){
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }

    public function getPageByIdCoursHistorik($idc){
        $this->db->select('*');
        $this->db->from($this->table_page);
        $this->db->where('id_historique_cours', $idc);
        $query = $this->db->get();
        return $query->result();
    }

    public function Request($field,$idc) {

        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id', $idc);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function addPage($arrayData){
        $this->db->trans_start();
        $this->db->insert($this->table_page, $arrayData);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $insert_id;
    }
    public function deletePage($id){
        $this->db->where('id', $id);
        $this->db->delete($this->table_page);
    }

    public function deletePageByCourseHistory($id_historique_cours){
        $this->db->where('id_historique_cours', $id_historique_cours);
        $this->db->delete($this->table_page);
    }

    public function add($arrayData){
        /*$this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('intitule', $arrayData['intitule']);
        $this->db->where('user_create', $arrayData['user_create']);
        $this->db->where('id_groupe', $arrayData['id_groupe']);
        $query = $this->db->get(); 
        $cnt = $query->num_rows();  
        if ($cnt >= 1) {
            foreach ($query->result() as $res) {
                return $res->id;
            }
        }  
        else{
            $this->db->trans_start();
            $this->db->insert($this->table, $arrayData);        
            $insert_id = $this->db->insert_id();        
            $this->db->trans_complete();
            return $insert_id;
        }*/
        $this->db->trans_start();
        $this->db->insert($this->table, $arrayData);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $insert_id;
    }

    public function getAll() {
        $this->db->select('*');
        $this->db->from($this->table);
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function getByIdGroup($idGroup) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_groupe', $idGroup);
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ; 
    }
    public function getByIdGroupAndTutor($idGroup,$idTutor) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_groupe', $idGroup);
        $this->db->where('user_create', $idTutor);
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ; 
    }

    public function getByGroupAndDateAndTuteur($idGroup,$date,$id_tuteur) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_groupe', $idGroup);
        $this->db->where('user_create', $id_tuteur);
        $this->db->like('intitule', $date);
        $this->db->limit(1);
        $query = $this->db->get(); 
        return $query->result()  ; 
    }


    public function getByUserCreateIdGroupTraineeCreateOrder($idUserCreate,$idTrainee,$idGroup,$order) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_groupe', $idGroup);
        $this->db->where_in('user_create', array($idUserCreate,$idTrainee));
        if ($order != '' && $order == 'name_asc' ) {
            $this->db->order_by('intitule', 'ASC');
        }
        elseif ($order != '' && $order == 'name_desc' ) {
            $this->db->order_by('intitule', 'DESC');
        }
        elseif ($order != '' && $order == 'create_date_asc' ) {
            $this->db->order_by('date', 'ASC');
        }
        elseif ($order != '' && $order == 'create_date_desc' ) {
            $this->db->order_by('date', 'DESC');
        }
        else{
            $this->db->order_by('id', 'DESC');
        }
        $query = $this->db->get(); 
        return $query->result()  ; 
    }
    
    public function getByUserCreateIdGroupTraineeCreate($idUserCreate,$idTrainee,$idGroup) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_groupe', $idGroup);
        $this->db->where_in('user_create', array($idUserCreate,$idTrainee));
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ; 
    }

    public function getByUserCreateIdGroup($idUserCreate,$idGroup) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('user_create', $idUserCreate);
        $this->db->where('id_groupe', $idGroup);
        $this->db->order_by('id', 'desc');
        $query = $this->db->get(); 
        return $query->result()  ; 
    }


    public function getByUserCreateIdGroupDashbordTrainee($idUserCreate,$idGroup) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('user_create', $idUserCreate);
        $this->db->where('id_groupe', $idGroup);
        $this->db->order_by('id', 'desc');
        $this->db->limit(2);
        $query = $this->db->get(); 
        return $query->result()  ; 
    }

    public function getByIdGroupNotInTrainee($idUserCreate,$idGroup) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('user_create !=', $idUserCreate);
        $this->db->where('id_groupe', $idGroup);
        $this->db->order_by('id', 'desc');
        $query = $this->db->get(); 
        return $query->result()  ; 
    }

    public function getClassTuteurByTrainee($idGroup) {
        $this->db->select('*');
        $this->db->from($this->table.' as c');
        $this->db->where('id_groupe', $idGroup);
        $this->db->order_by('id', 'desc');
        $query = $this->db->get(); 
        return $query->result()  ; 
    }

    public function getAllByKey($key,$user_create,$idGroup) {
        $this->db->select('*');
        $this->db->from($this->table);
        if(!empty($key)) {
            $likeCriteria = "(intitule  LIKE '%".$key."%')";
            $this->db->where($likeCriteria);
        } 
        $this->db->where('user_create', $user_create);
        $this->db->where('id_groupe', $idGroup);
        $query = $this->db->get(); 
        return $query->result()  ;
    }
    public function getTraineeAllByKey($key,$idGroup) {
        $this->db->select('*');
        $this->db->from($this->table);
        if(!empty($key)) {
            $likeCriteria = "(intitule  LIKE '%".$key."%')";
            $this->db->where($likeCriteria);
        } 
        $this->db->where('id_groupe', $idGroup);
        $query = $this->db->get(); 
        return $query->result()  ;
    }

}

?>
