<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Formations_model extends CI_Model
{
    
    /*public function __construct(){

    }*/
    /**
     * This public function used to check the login credentials of the user
     * @param string $email : This is email of the user
     * @param string $password : This is encrypted password of the user
     */
    public function __construct(){
        
        parent::__construct();
        $this->table = 'formation' ;        
        $this->table_membres = 'membres' ;        
        $this->table_list_parcours = 'list_parcours' ;        
        $this->table_session_groupe = 'session_groupe' ;        
        $this->load->model('utilities_model'); 
        $this->load->model('sequence_model');        
        $this->load->model('parcours_model');        
        $this->load->model('modules_model');          
    }

    public function read($idg,$idu) {

        $this->db->select('count(distinct p.parcours_id)');
        $this->db->from($this->table_session_groupe.' as s');
        $this->db->join($this->table_list_parcours.' as p','p.parcours_id=s.parcours_id','inner');
        $this->db->where('s.groupe_id', $idg);
        $this->db->where_in('p.matiere_id', '8,11');
        $query = $this->db->get(); 
        $row = $query->num_rows();
        if ( $row > 0 ) {
            $this->db->select('sequence_id,locs,module_id,locm,parcours_id,locp,ordre');
            $this->db->from($this->table);
            $this->db->where('groupe_id', $idg);
            $this->db->where('user_id', $idu);
            $this->db->where('sequence_id >',0);
            $this->db->order_by('ordre,parcours_id,module_id,sequence_id', 'asc');  
        } 
        else {      
            $this->db->select('sequence_id,locs,module_id,locm,parcours_id,locp,ordre');
            $this->db->from($this->table);
            $this->db->where('groupe_id', $idg);
            $this->db->where('user_id', $idu);
            $this->db->where('sequence_id >',0);
            $this->db->order_by('parcours_id,module_id,sequence_id,ordre', 'asc');   
        }
        
        
        $query1 = $this->db->get(); 
        $ret['cnt'] = $query1->num_rows();
        $i = 0 ;
        foreach ($query1->result() as $res){
            $ret[$i]['sequence_id'] = $res->sequence_id;
            $ret[$i]['locs']        = $res->locs;
            $ret[$i]['module_id']   = $res->module_id ;
            $ret[$i]['locm']        = $res->locm;
            $ret[$i]['parcours_id'] = $res->parcours_id ;
            $ret[$i]['locp']        = $res->locp;
            $ret[$i]['ordre']       = $res->ordre ;
            $i++ ;
        }

        for($i=0;$i<$ret['cnt'];$i++) {
            $name = '' ;
            $ret[$i]['sequence_name'] = $this->sequence_model->Title($ret[$i]['sequence_id'],$ret[$i]['locs']);
            $ret[$i]['module_name']   = $this->modules_model->Title($ret[$i]['module_id'],$ret[$i]['locm']);
            $ret[$i]['parcours_name'] = $this->parcours_model->Title($ret[$i]['parcours_id'],$ret[$i]['locp']);
        }
        return($ret);
    }

    public function readV3($idg,$idu) {
        $ret = array();
        $arrayParcoursCombine = array();
        $arrayModulesCombine = array();

        $this->db->select('sequence_id,locs,module_id,locm,parcours_id,locp,ordre');
        $this->db->from($this->table);
        $this->db->where('groupe_id', $idg);
        $this->db->where('user_id', $idu);
        $this->db->where('sequence_id >',0);
        $this->db->order_by('parcours_id,module_id,sequence_id,ordre', 'desc');  
        
        $query = $this->db->get(); 
        $i = 0 ;
        foreach ($query->result() as $res){      

            $ret[$i] = array(
                'ordre'                 => $res->ordre,
                'parcours_id'           => $res->parcours_id,
                'module_id'             => $res->module_id, 
                'sequence_id'           => $res->sequence_id,
                'sequence_name'         => $this->sequence_model->Title($res->sequence_id,$res->locs),
            );

            $i++ ;
        }
        
        $arrayParcoursCombine = $this->arrayGroupBy($ret, "parcours_id");
        for ($p=0; $p < count($arrayParcoursCombine) ; $p++) {            
            $arrayModulesCombine[$p] = array(
                'parcours_id'   => $arrayParcoursCombine[$p]['parcours_id'], 
                'domaine_id'    => $this->parcours_model->Request('domaine_id',$arrayParcoursCombine[$p]['parcours_id']), 
                'modules_content' => $this->arrayGroupBy($arrayParcoursCombine[$p]['data'], "module_id"), 
            );  
        };

        return($arrayModulesCombine);
    }

    public function arrayGroupBy($array, $key) {
        $groupedData = [];
        $data = [];
        $_id = "";
        for ($i=0; $i < count($array); $i++) { 
            $row = $array[$i];
            if($row[$key] != $_id){
                if(count($data) > 0){
                    $groupedData[] = $data;
                }
        
                $_id = $row[$key];
                $data = [
                    $key => $_id
                ];
            }
        
            unset($row[$key]);
            $data['data'][] = $row;

            if($i == count($array) - 1){
                $groupedData[] = $data;
            }
        }
        
        return $groupedData; 
    }

    public function readContent($groupe_id,$stagiaire_id) {

        $this->db->select('sequence_id,locs,module_id,locm,parcours_id,locp,ordre');
        $this->db->from($this->table);
        $this->db->where('groupe_id', $groupe_id);
        $this->db->where('user_id', $stagiaire_id);
        $this->db->where('sequence_id >',0);
        $this->db->order_by('parcours_id,module_id,sequence_id,ordre', 'asc'); 
        $query1 = $this->db->get(); 
        $ret['cnt'] = $query1->num_rows();

        $i = 0 ;
        foreach ($query1->result() as $res){
            $ret[$i] = array(
                'sequence_id'   => $res->sequence_id,
                'locs'          => $res->locs,
                'module_id'     => $res->module_id,
                'locm'          => $res->locm,
                'parcours_id'   => $res->parcours_id,
                'locp'          => $res->locp,
                'ordre'         => $res->ordre
            );
            $i++ ;
        }

        for($i=0;$i<$ret['cnt'];$i++) {
            $name = '' ;
            $ret[$i] = array(
                'sequence_name' => $this->sequence_model->Title($ret[$i]['sequence_id'],$ret[$i]['locs']),
                'module_name'   => $this->modules_model->Title($ret[$i]['module_id'],$ret[$i]['locm']),
                'parcours_name' => $this->parcours_model->Title($ret[$i]['parcours_id'],$ret[$i]['locp']),
            );
        }

        return($ret);
    }

    public function readThreeView($idg,$idu,$PAVE,$parcours_id) {

        $this->db->select('count(distinct p.parcours_id)');
        $this->db->from($this->table_session_groupe.' as s');
        $this->db->join($this->table_list_parcours.' as p','p.parcours_id=s.parcours_id','inner');
        $this->db->where('s.groupe_id', $idg);
        $this->db->where('p.parcours_id', $parcours_id);
        $this->db->where_in('p.matiere_id', '8,11');
        $query = $this->db->get(); 
        $row = $query->num_rows();
        if ( $row > 0 ) {
            $this->db->select('sequence_id,locs,module_id,locm,parcours_id,locp,ordre');
            $this->db->from($this->table);
            $this->db->where('groupe_id', $idg);
            $this->db->where('user_id', $idu);
            $this->db->where('parcours_id', $parcours_id);
            $this->db->where('sequence_id >',0);
            $this->db->order_by('ordre,parcours_id,module_id,sequence_id', 'asc');  
        } 
        else {      
            $this->db->select('sequence_id,locs,module_id,locm,parcours_id,locp,ordre');
            $this->db->from($this->table);
            $this->db->where('groupe_id', $idg);
            $this->db->where('user_id', $idu);
            $this->db->where('parcours_id', $parcours_id);
            $this->db->where('sequence_id >',0);
            $this->db->order_by('parcours_id,module_id,sequence_id,ordre', 'asc');   
        }
        
        
        $query1 = $this->db->get(); 
        $ret['cnt'] = $query1->num_rows();
        $i = 0 ;
        foreach ($query1->result() as $res){
            $ret[$i]['sequence_id'] = $res->sequence_id;
            $ret[$i]['locs']        = $res->locs;
            $ret[$i]['module_id']   = $res->module_id ;
            $ret[$i]['locm']        = $res->locm;
            $ret[$i]['parcours_id'] = $res->parcours_id ;
            $ret[$i]['locp']        = $res->locp;
            $ret[$i]['ordre']       = $res->ordre ;
            $i++ ;
        }

        for($i=0;$i<$ret['cnt'];$i++) {
            $name = '' ;
            $ret[$i]['sequence_name'] = $this->sequence_model->Title($ret[$i]['sequence_id'],$ret[$i]['locs']);
            $ret[$i]['module_name']   = $this->modules_model->Title($ret[$i]['module_id'],$ret[$i]['locm']);
            $ret[$i]['parcours_name'] = $this->parcours_model->Title($ret[$i]['parcours_id'],$ret[$i]['locp']);
        }
        return($ret);
    }
    public function getNote($idg,$idu,$ids,$locs,$idm,$locm,$idp,$locp) {
        $ret = 0 ;
        $this->db->select('note');
        $this->db->from($this->table);
        $this->db->where('groupe_id', $idg);
        $this->db->where('user_id', $idu);
        $this->db->where('sequence_id', $ids);
        $this->db->where('locs', $locs);
        $this->db->where('module_id', $idm);
        $this->db->where('locm', $locm);
        $this->db->where('parcours_id', $idp);
        $this->db->where('locp', $locp);
        $query = $this->db->get(); 
        $row = $query->num_rows();
        $result = $query->result()  ;        
        foreach ($result as $res){
            $ret = $res->note;
        }
        return($ret);
    }

    public function getData($data) {
        $ret = 0 ;
        $this->db->select('note');
        $this->db->from($this->table);
        if (isset($data['user_id'])) {
            $this->db->where('user_id', $data['user_id']);
        }

        if (isset($data['groupe_id'])) {
            $this->db->where('groupe_id', $data['groupe_id']);
        }

        if (isset($data['sequence_id'])) {
            $this->db->where('sequence_id', $data['sequence_id']);
        }

        if (isset($data['module_id'])) {
            $this->db->where('module_id', $data['module_id']);
        }

        if (isset($data['parcours_id'])) {
            $this->db->where('parcours_id', $data['parcours_id']);
        }

        $query = $this->db->get(); 
        return $query->result();
    }

    public function update($groupe_id,$user_id,$order,$data) {
        $this->db->where('groupe_id', $groupe_id);
        $this->db->where('user_id', $user_id);
        $this->db->where('ordre', $order);
        $this->db->update($this->table, $data);
        $this->db->affected_rows();
    }


    public function setNote($idg,$idu,$ids,$locs,$idm,$locm,$idp,$locp,$note) {
        
        $infoUpdateNote = array('note'=>$note);

        $this->db->where('groupe_id', $idg);
        $this->db->where('user_id', $idu);
        $this->db->where('sequence_id', $ids);
        $this->db->where('locs', $locs);
        $this->db->where('module_id', $idm);
        $this->db->where('locm', $locm);
        $this->db->where('parcours_id', $idp);
        $this->db->where('locp', $locp);

        $this->db->update($this->table, $infoUpdateNote);
        $this->db->affected_rows();
    }
    public function delItemByGroupAndModuleAndSequence($idg,$idm,$ids){
        
        if($ids!=-1){
            $this->db->where('sequence_id', $ids);
        }
        if($idm!=-1){
            $this->db->where('module_id', $idm);
        }
        if($idg!=-1){
            $this->db->where('groupe_id', $idg); 
        }
        $this->db->delete($this->table);
    }

     public function deleteByModule($module_id){        
        $this->db->where('module_id', $module_id);
        $this->db->delete($this->table);
    }

    public function delItem($idu=-1,$ids=-1,$locs=-1,$idm=-1,$locm=1,$idp=-1,$locp=1,$idg=-1){
    
        $this->db->where(1, 1);
        if($idu!=-1){
            $this->db->where('user_id', $idu);
        }        
        if($ids!=-1){
            $this->db->where('sequence_id', $ids);
            $this->db->where('locs', $locs);
        }
        if($idm!=-1){
            $this->db->where('module_id', $idm);
            $this->db->where('locm', $locm);
        }
        if($idp!=-1){
            $this->db->where('parcours_id', $idp);
            $this->db->where('locp', $locp);
        }
        if($idg!=-1){
            $this->db->where('groupe_id', $idg); 
        }
        $this->db->delete($this->table);

        #####
        $this->db->where(1, 1);
        /*if($idu!=-1){
            $this->db->where('user_id', $idu); 
        } */     
        if($ids!=-1){
            $this->db->where('sequence_id', $ids);
            $this->db->where('locs', $locs);
        }
        if($idm!=-1){
            $this->db->where('module_id', $idm);
            $this->db->where('locm', $locm);
        }
        if($idp!=-1){
            $this->db->where('parcours_id', $idp);
            $this->db->where('locp', $locp);
        }
        if($idg!=-1){
            $this->db->where('groupe_id', $idg); 
        }
        $this->db->delete('session_groupe');
    }

    public function add($data) {         
        $this->db->trans_start();
        $this->db->insert($this->table, $data);        
        $id = $this->db->insert_id();        
        $this->db->trans_complete();

    }

    public function getIdByGroupe($idGroup) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('groupe_id', $idGroup);
        $this->db->where('parcours_id !=', 0);
        $this->db->limit(1);
        $query = $this->db->get();    
        if ($query->num_rows() > 0) {  
            $result = $query->result()  ;
            foreach($result as $res){
                return $res->parcours_id;
            }
        }
        else{
            return 0;
        }
        
    }

    public function getInfosByModulesJoinActiveMembers($module_id) {
        $sql_actif = '((FROM_UNIXTIME(m.date_connexion, "%Y") >= (DATE_FORMAT(NOW(), "%Y")-1)) OR (m.date_fin_acces >= UNIX_TIMESTAMP()))';
        $this->db->select('f.*');
        $this->db->from($this->table.' AS f');
        $this->db->join($this->table_membres.' AS m', 'f.groupe_id = m.id_groupe');
        $this->db->where('f.module_id', $module_id);
        $this->db->where($sql_actif);
        $this->db->group_by('f.groupe_id');
        $query = $this->db->get();    
        return $query->result()  ;
    }
    public function getInfosByModules($module_id) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('module_id', $module_id);
        $this->db->group_by('groupe_id');
        $query = $this->db->get();    
        return $query->result()  ;
    }

    public function getInfoStagiaire() {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->group_by('groupe_id');
        $query = $this->db->get();    
        return $query->result()  ;
    }

    public function addItem($ids,$locs,$idm,$locm,$idp,$locp,$idg,$idu,$idd){

        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('groupe_id', $idg);  
        $this->db->where('sequence_id', $ids);  
        $this->db->where('locs', $locs);  
        $this->db->where('module_id', $idm);  
        $this->db->where('locm', $locm);  
        $this->db->where('parcours_id', $idp);  
        $this->db->where('locp', $locp);  
        $this->db->where('user_id', $idu);  
        $query = $this->db->get();        
        if ($query->num_rows() > 0) {
           return true;
        }

        $data = array (
            'groupe_id' => $idg,
            'sequence_id' => $ids,
            'locs' => $locs,
            'module_id' => $idm,
            'locm' => $locm,
            'parcours_id' => $idp,
            'locp' => $locp,
            'ordre' => $this->maxPosition($ids,$locs,$idm,$locm,$idp,$locp,$idg,$idu),
            'user_id' => $idu
        );
        $this->add($data);
        return true;
    }

    public function maxPosition($ids,$locs,$idm,$locm,$idp,$locp,$idg,$idu) {
        if ( is_int($idg) ) {
            if ( $ids>0 && $idm==0 && $idp==0 ){                
                $this->db->select('MAX(ordre) as orderMax');
                $this->db->from($this->table);
                $this->db->where('groupe_id', $idg);  
                $this->db->where('user_id', $idu);  
            } 
            else {
                if ( $idp>0) {
                    // parcours
                    $this->db->select('*');
                    $this->db->from($this->table);
                    $this->db->where('groupe_id', $idg);  
                    $this->db->where('user_id', $idu); 
                    $this->db->where('parcours_id', $idp); 
                    $this->db->where('locp', $locp); 
                    $query = $this->db->get();        
                    if ($query->num_rows() > 0) {
                        // parcours deja present....
                        $this->db->select('MAX(ordre) as orderMax');
                        $this->db->from($this->table);
                        $this->db->where('groupe_id', $idg);  
                        $this->db->where('user_id', $idu); 
                        $this->db->where('parcours_id', $idp); 
                        $this->db->where('locp', $locp); 
                    } 
                    else {
                        //parcours pas encore present....
                        $this->db->select('MAX(ordre) as orderMax');
                        $this->db->from($this->table);
                        $this->db->where('groupe_id', $idg);  
                        $this->db->where('user_id', $idu); 
                    }
                }
                elseif( $idm > 0) {
                    //module....
                    $this->db->select('*');
                    $this->db->from($this->table);
                    $this->db->where('groupe_id', $idg);  
                    $this->db->where('user_id', $idu); 
                    $this->db->where('module_id', $idm); 
                    $this->db->where('locm', $locm); 
                    if ($idp>0) {
                        $this->db->where('parcours_id', $idp); 
                        $this->db->where('locp', $locp); 
                    }
                    $query1 = $this->db->get();        
                    if ($query1->num_rows() > 0) {

                        $this->db->select('MAX(ordre) as orderMax');
                        $this->db->from($this->table);
                        $this->db->where('groupe_id', $idg);  
                        $this->db->where('user_id', $idu); 
                        $this->db->where('module_id', $idm); 
                        $this->db->where('locm', $locm); 
                    } 
                    else {
                        //module pas encore present....
                        $this->db->select('MAX(ordre) as orderMax');
                        $this->db->from($this->table);
                        $this->db->where('groupe_id', $idg);  
                        $this->db->where('user_id', $idu); 
                    }
                } 
                else {
                    //sequence
                    $this->db->select('MAX(ordre) as orderMax');
                    $this->db->from($this->table);
                    $this->db->where('groupe_id', $idg);  
                    $this->db->where('user_id', $idu); 
                    if ($idm>0) {
                        $this->db->where('module_id', $idm); 
                        $this->db->where('locm', $locm); 
                    }
                    if ($idp>0) {
                        $this->db->where('parcours_id', $idp); 
                        $this->db->where('locp', $locp); 
                    }
                }
            }
            $queryf = $this->db->get();        
            if ($queryf->num_rows() == 1) {
                $resultf = $queryf->result()  ;  
                foreach ($resultf as $res){
                    $ret = $res->orderMax+1 ;
                    $dataf = array(
                        'ordre' => 'ordre+1'
                    );
                    $this->update($idg,$idu,$ret,$dataf);
                    return($ret);
                }
            }
            else{
                return 0;
            }
        } 
        else {
            return(0);
        }
    }

    public function delUser($id,$idg=-1){
        $grp = $idg == -1 ? '':" AND groupe_id='".$idg."'";
        $this->db->delete($this->table, array('user_id' => $id,$grp));
    }

     public function delSessionUser($idg){
        $this->db->delete($this->table, array('groupe_id' => $idg));
    }

    public function addSession($idu,$idg,$session){
        if ( is_array($session)){
            for($i=0;$i<$session['cnt'];$i++){
                $this->addItem(
                    $session[$i]['sequence_id'],
                    $session[$i]['locs'],
                    $session[$i]['module_id'],
                    $session[$i]['locm'],
                    $session[$i]['parcours_id'],
                    $session[$i]['locp'],
                    $idg,
                    $idu,
                    ''
                );
            }
        }
    }

    public function ItemIsValid($idi,$idu,$type,$idg,$loc) {
        $this->db->select('*');
        $this->db->from($this->table);
        switch($type) {
            case TYPE_SEQUENCE :
                $this->db->where('sequence_id', $idi); 
                $this->db->where('groupe_id', $idg); 
                $this->db->where('locs', $loc); 
                if ($idu != -1) {
                    $this->db->where('user_id', $idu); 
                }                
                break;
            case TYPE_MODULE :
                $this->db->where('module_id', $idi); 
                $this->db->where('groupe_id', $idg); 
                $this->db->where('locm', $loc); 
                if ($idu != -1) {
                    $this->db->where('user_id', $idu); 
                }   
                break;
            case TYPE_PARCOURS :
                $this->db->where('parcours_id', $idi); 
                $this->db->where('groupe_id', $idg); 
                $this->db->where('locp', $loc); 
                if ($idu != -1) {
                    $this->db->where('user_id', $idu); 
                }   
                break;
        }
        $query = $this->db->get();        
        return $query->num_rows()  ;
    }
     
}

?>
