
<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Parcours_model extends CI_Model
{
    
    public function __construct(){    
        global $TBL ;    
        parent::__construct();

        $this->load->model('membres_model');
        $this->load->model('utilities_model');    
        $this->table     = 'list_parcours';
        $this->table_par = 'parcours';    
        $this->table_formation = 'formation';    
        $this->table_matiere = 'matiere';    

    }

    public function getByParams($arrayParams){
        $return = array();
        $i = 0;
        $this->db->select('*');
        $this->db->from($this->table);

        if (isset($arrayParams['domaine_id'])) {
            $this->db->where('domaine_id', $arrayParams['domaine_id']);
        }
        
        if (isset($arrayParams['matiere_id'])) {
            $this->db->where('matiere_id', $arrayParams['matiere_id']);
        }

        if (isset($arrayParams['key']) && $arrayParams['key'] != '') {
            $this->db->like('parcours_titre', $arrayParams['key']);
        }
        
        $query = $this->db->get();
        $result= $query->result()  ;
        foreach ($result as $res) {
            $return[$i] = array(
                'id'        => $res->parcours_id,
                'name'      => $res->parcours_titre,
                'objectif'  => $res->parcours_objectifs,
                'code'      => $res->code,
            );
            $i++;
        } 
        return $return;
    }

    public function del($id) {
        $this->db->where('parcours_id', $id);
        $this->db->delete($this->table_par);

        $this->db->where('parcours_id', $id);
        $this->db->delete($this->table);   

        return true;     
    }

    public function delContentByParams($arrayParams) {
        if (isset($arrayParams['parcours_id'])) {
            $this->db->where('parcours_id', $arrayParams['parcours_id']);
        }

        if (isset($arrayParams['item_id'])) {
            $this->db->where('item_id', $arrayParams['item_id']);
        }


        if (isset($arrayParams['type'])) {
            $this->db->where('type', $arrayParams['type']);
        }
        
        $this->db->delete($this->table_par);

        return true;     
    }

    public function getContentByParams($arrayParams) {
        $this->db->select('*');
        $this->db->from($this->table_par);
        if (isset($arrayParams['parcours_id'])) {
            $this->db->where('parcours_id', $arrayParams['parcours_id']);
        }

        if (isset($arrayParams['item_id'])) {
            $this->db->where('item_id', $arrayParams['item_id']);
        }


        if (isset($arrayParams['type'])) {
            $this->db->where('type', $arrayParams['type']);
        }
        
        $query = $this->db->get();       
        return $query->result()  ;
    }


    public function IsInt($x) {
       return ( is_numeric ($x) ?  intval(0+$x ) ==  $x  :  false );
    }

    public function addItem($idp,$idi,$type,$loc) {
        $this->db->select('MAX(ordre) AS OderMax');
        $this->db->from($this->table_par);
        $this->db->where('parcours_id', $idp);      
        $query = $this->db->get();       
        $result = $query->result()  ;
        foreach ($result as $res){
            $ordre = ($this->IsInt($res->OderMax) ? $res->OderMax+1 : 1 );
        }

        $data = array(
            'parcours_id' => $idp,
            'item_id'     => $idi,
            'ordre'       => $ordre,
            'type'        => $type,
            'loc'         => $loc
        );
        $this->db->trans_start();
        $this->db->insert($this->table_par, $data);        
        return $this->db->insert_id(); 

    }

    public function Request($field,$parcours_id) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('parcours_id', $parcours_id);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function rechercher($search){

        $search = trim(stripslashes($search));

        $fields = array("parcours_titre", "parcours_objectifs");
        $date = 0; //Avec 0, il n'y a pas de limite de date dans la recherche.
        $match = 1; //1 = recherche de tous les mots

        $ret = array() ;
        $ret['cnt'] = 0 ;
        if($search!="") {
            $terms = $this->utilities_model->build_search_terms($search, $match);
            if(count($terms)>0) {             


                $this->db->select('parcours_id, TRIM(parcours_titre) as titrep, TRIM(parcours_objectifs) as objectifsp');
                $this->db->from($this->table);
                $this->utilities_model->build_terms_clause($terms, $date, $fields, $match);   
                $this->db->order_by('parcours_titre', 'asc');      
                $query = $this->db->get(); 
                $ret['cnt'] = $query->num_rows();        
                $result = $query->result()  ;
                $i = 0 ;
                if (is_array($result)) {
                    foreach ($result as $res){
                        $ret[$i]['id']          = $res->parcours_id;
                        $ret[$i]['titre']     = $res->titrep;
                        $ret[$i]['objectifs']= $res->objectifsp;                    
                        $i++ ;
                    }
                }
      
            }
        }
        return $ret;
    }
    public function readByDomaineAndMatiere($idd,$idMat) {
        $ret = Array() ;
        $ret['cnt'] = 0;
        $i = 0 ;
        if ( $idd > 0 && $idMat > 0 ) {
            //$table_mat = $this->table=='list_parcours'?'matiere':'matieresrv';
            $this->db->select('parcours_id,parcours_type,parcours_titre,auteur_id,code,domaine_id,matiere_id');
            $this->db->from($this->table);
            $this->db->where('domaine_id', $idd);
            $this->db->where('matiere_id', $idMat);      
            $this->db->order_by('parcours_titre', 'asc');      
            $query = $this->db->get(); 
            $ret['cnt'] = $query->num_rows();        
            $result = $query->result()  ;
            if (is_array($result)) {
                foreach ($result as $res){
                    $ret[$i]['id']          = $res->parcours_id;
                    $ret[$i]['titre']     = $res->parcours_titre;
                    $ret[$i]['parcours_type']= $res->parcours_type;
                    $ret[$i]['nom']   = "???????????";
                    $ret[$i]['code']    = $res->code;
                    $ret[$i]['domaine_id']  = $res->domaine_id;
                    $ret[$i]['matiere_id']  = $res->matiere_id;
                    $i++ ;
                }
            }
      
            $this->db->select('p.parcours_id,p.parcours_type,p.parcours_titre,p.auteur_id,p.code,p.domaine_id,p.matiere_id,m.name'); 
            $this->db->from($this->table .' as p');
            $this->db->join('matiere AS m','p.domaine_id = m.domaine_id', 'left');
            $this->db->where('p.domaine_id', $idd);
            $this->db->where('p.matiere_id', $idMat);
            $this->db->where('p.domaine_id', "m.domaine_id");            
            $this->db->order_by('m.name', 'asc');
            $this->db->order_by('p.parcours_titre', 'asc');

        } 
        $query1 = $this->db->get(); 
        $cnt = $query1->num_rows();
        $ret['cnt']+= $cnt;

        $result1 = $query1->result()  ;
        if (is_array($result1)) {
            foreach ($result1 as $res1){
                $ret[$i]['id']      = $res1->parcours_id;
                $ret[$i]['titre']   = $res1->parcours_titre;
                $ret[$i]['parcours_type']= $res1->parcours_type;
                $ret[$i]['nom']     = "???????????";
                $ret[$i]['code']    = $res1->code;
                $ret[$i]['domaine_id']  = $res1->domaine_id;
                $ret[$i]['matiere_id']  = $res1->matiere_id;
                $i++ ;
            } 
        }
        return($ret);
    }

    public function readByDomaineAndNullMatiere($idd) {
        $ret = Array() ;
        $ret['cnt'] = 0;
        $i = 0 ;
        if ( $idd > 0 ) {
            //$table_mat = $this->table=='list_parcours'?'matiere':'matieresrv';
            $this->db->select('parcours_id,parcours_type,parcours_titre,auteur_id,code,domaine_id,matiere_id');
            $this->db->from($this->table);
            $this->db->where('domaine_id', $idd);
            $this->db->where('matiere_id', 0);      
            $this->db->order_by('parcours_titre', 'asc');      
            $query = $this->db->get(); 
            $ret['cnt'] = $query->num_rows();        
            $result = $query->result()  ;
            if (is_array($result)) {
                foreach ($result as $res){
                    $ret[$i]['id']          = $res->parcours_id;
                    $ret[$i]['titre']     = $res->parcours_titre;
                    $ret[$i]['parcours_type']= $res->parcours_type;
                    $ret[$i]['nom']   = "???????????";
                    $ret[$i]['code']    = $res->code;
                    $ret[$i]['domaine_id']  = $res->domaine_id;
                    $ret[$i]['matiere_id']  = $res->matiere_id;
                    $i++ ;
                }
            }
      
            $this->db->select('p.parcours_id,p.parcours_type,p.parcours_titre,p.auteur_id,p.code,p.domaine_id,p.matiere_id,m.name'); 
            $this->db->from($this->table .' as p');
            $this->db->join('matiere AS m','p.domaine_id = m.domaine_id', 'left');
            $this->db->where('p.domaine_id', $idd);
            $this->db->where('p.matiere_id', 0);
            $this->db->where('p.domaine_id', "m.domaine_id");            
            $this->db->order_by('m.name', 'asc');
            $this->db->order_by('p.parcours_titre', 'asc');

        } 
        $query1 = $this->db->get(); 
        $cnt = $query1->num_rows();
        $ret['cnt']+= $cnt;

        $result1 = $query1->result()  ;
        if (is_array($result1)) {
            foreach ($result1 as $res1){
                $ret[$i]['id']      = $res1->parcours_id;
                $ret[$i]['titre']   = $res1->parcours_titre;
                $ret[$i]['parcours_type']= $res1->parcours_type;
                $ret[$i]['nom']     = "???????????";
                $ret[$i]['code']    = $res1->code;
                $ret[$i]['domaine_id']  = $res1->domaine_id;
                $ret[$i]['matiere_id']  = $res1->matiere_id;
                $i++ ;
            } 
        }
        return($ret);
    }


    public function readByDomaine($idd) {
        $ret = Array() ;
        $ret['cnt'] = 0;
        $i = 0 ;
        if ( $idd > 0 ) {
            //$table_mat = $this->table=='list_parcours'?'matiere':'matieresrv';
            $this->db->select('parcours_id,parcours_type,parcours_titre,auteur_id,code,domaine_id,matiere_id');
            $this->db->from($this->table);
            $this->db->where('domaine_id', $idd);
            $this->db->where('matiere_id', 0);      
            $this->db->order_by('parcours_titre', 'asc');      
            $query = $this->db->get(); 
            $ret['cnt'] = $query->num_rows();        
            $result = $query->result()  ;
            if (is_array($result)) {
                foreach ($result as $res){
                    $ret[$i]['id']          = $res->parcours_id;
                    $ret[$i]['titre']     = $res->parcours_titre;
                    $ret[$i]['parcours_type']= $res->parcours_type;
                    $ret[$i]['nom']   = "???????????";
                    $ret[$i]['code']    = $res->code;
                    $ret[$i]['domaine_id']  = $res->domaine_id;
                    $ret[$i]['matiere_id']  = $res->matiere_id;
                    $i++ ;
                }
            }
      
            $this->db->select('p.parcours_id,p.parcours_type,p.parcours_titre,p.auteur_id,p.code,p.domaine_id,p.matiere_id,m.name'); 
            $this->db->from($this->table .' as p');
            $this->db->join('matiere AS m','p.domaine_id = m.domaine_id', 'left');
            $this->db->where('p.domaine_id', $idd);
            $this->db->where('p.domaine_id', "m.domaine_id");            
            $this->db->order_by('m.name', 'asc');
            $this->db->order_by('p.parcours_titre', 'asc');

        } 
        else {  
            $this->db->select('p.parcours_id,p.parcours_type,p.parcours_titre,p.auteur_id,p.code,p.domaine_id,p.matiere_id'); 
            $this->db->from($this->table .' AS p');
            $this->db->where('p.domaine_id', $idd);
            $this->db->order_by('p.parcours_titre', 'asc');


        }

        $query1 = $this->db->get(); 
        $cnt = $query1->num_rows();
        $ret['cnt']+= $cnt;

        $result1 = $query1->result()  ;
        if (is_array($result1)) {
            foreach ($result1 as $res1){
                $ret[$i]['id']      = $res1->parcours_id;
                $ret[$i]['titre']   = $res1->parcours_titre;
                $ret[$i]['parcours_type']= $res1->parcours_type;
                $ret[$i]['nom']     = "???????????";
                $ret[$i]['code']    = $res1->code;
                $ret[$i]['domaine_id']  = $res1->domaine_id;
                $ret[$i]['matiere_id']  = $res1->matiere_id;
                $i++ ;
            } 
        }
        return($ret);
    }

    public function readByDomaineThreeView($idd) {
        $ret = Array() ;
        $ret1 = Array() ;
        $ret['cnt'] = 0;
        $ret1['cnt'] = 0;
        $i = 0 ;
        if ( $idd > 0 ) {
            $this->db->select('p.parcours_id,p.parcours_type,p.parcours_titre,p.auteur_id,p.code,p.domaine_id,p.matiere_id,m.name'); 
            $this->db->from($this->table .' as p');
            $this->db->join($this->table_matiere.' as m','p.domaine_id = m.domaine_id', 'inner');
            $this->db->where('p.domaine_id', $idd);          
            $this->db->group_by('p.parcours_id');
            $this->db->order_by('m.name', 'asc');
            $this->db->order_by('p.parcours_titre', 'asc');
            $query1 = $this->db->get(); 
            $ret1['cnt'] = $query1->num_rows();
            $result1 = $query1->result()  ;
            if (is_array($result1)) {
                foreach ($result1 as $res1){
                    $ret1[$i]['id']      = $res1->parcours_id;
                    $ret1[$i]['titre']   = $res1->parcours_titre;
                    $ret1[$i]['parcours_type']= $res1->parcours_type;
                    $ret1[$i]['nom']     = "???????????";
                    $ret1[$i]['code']    = $res1->code;
                    $ret1[$i]['domaine_id']  = $res1->domaine_id;
                    $ret1[$i]['matiere_id']  = $res1->matiere_id;
                    $i++ ;
                } 
            }
            return($ret1);

        } 
        else {  
            $this->db->select('p.parcours_id,p.parcours_type,p.parcours_titre,p.auteur_id,p.code,p.domaine_id,p.matiere_id'); 
            $this->db->from($this->table .' AS p');
            $this->db->where('p.domaine_id', $idd);
            $this->db->order_by('p.parcours_titre', 'asc');
            $query1 = $this->db->get(); 
            $ret['cnt'] = $query1->num_rows();
            $result1 = $query1->result()  ;
            if (is_array($result1)) {
                foreach ($result1 as $res1){
                    $ret[$i]['id']      = $res1->parcours_id;
                    $ret[$i]['titre']   = $res1->parcours_titre;
                    $ret[$i]['parcours_type']= $res1->parcours_type;
                    $ret[$i]['nom']     = "???????????";
                    $ret[$i]['code']    = $res1->code;
                    $ret[$i]['domaine_id']  = $res1->domaine_id;
                    $ret[$i]['matiere_id']  = $res1->matiere_id;
                    $i++ ;
                } 
            }
            return($ret);
        }
        
    }

    public function getOtherParcoursByDomaine($idd){
        $ret1 = array();
        $ret1['cnt'] = 0;
        $i = 0;
        $this->db->select('p.parcours_id,p.parcours_type,p.parcours_titre,p.auteur_id,p.code,p.domaine_id,p.matiere_id,m.name'); 
        $this->db->from($this->table .' as p');
        $this->db->join($this->table_matiere.' as m','p.domaine_id = m.domaine_id', 'inner');
        $this->db->where('p.domaine_id', $idd);          
        $this->db->group_by('p.parcours_id');
        $this->db->order_by('m.name', 'asc');
        $this->db->order_by('p.parcours_titre', 'asc');
        $query1 = $this->db->get(); 
        $ret1['cnt'] = $query1->num_rows();
        $result1 = $query1->result()  ;
        if (is_array($result1)) {
            foreach ($result1 as $res1){
                $ret1[$i]['id']      = $res1->parcours_id;
                $ret1[$i]['titre']   = $res1->parcours_titre;
                $ret1[$i]['parcours_type']= $res1->parcours_type;
                $ret1[$i]['nom']     = "???????????";
                $ret1[$i]['code']    = $res1->code;
                $ret1[$i]['domaine_id']  = $res1->domaine_id;
                $ret1[$i]['matiere_id']  = $res1->matiere_id;
                $i++ ;
            } 
        }
        return $ret1;
    }


    public function getParcoursByDomaine($domaine){
        $this->db->distinct();
        $this->db->select('lp.*');
        $this->db->from($this->table_formation.' as f');
        $this->db->join($this->table.' as lp','lp.parcours_id=f.parcours_id','left');
        $this->db->where('lp.domaine_id', $domaine);      
        $this->db->order_by('f.ordre', 'asc');      
        $query = $this->db->get();        
        return $query->result()  ;   
    }
   
    public function getParcoursByGroupDomaine($groupes,$domaine){
        $this->db->distinct();
        $this->db->select('lp.*');
        $this->db->from($this->table_formation.' as f');
        $this->db->join($this->table.' as lp','lp.parcours_id=f.parcours_id','left');
        $this->db->where('f.groupe_id', $groupes);
        $this->db->where('lp.domaine_id', $domaine);      
        $this->db->order_by('f.ordre', 'asc');      
        $query = $this->db->get();        
        return $query->result()  ;   
    }
    
    public function Title($idp,$loc='') {
        $this->db->select('parcours_titre');
        $this->db->from($this->table);
        $this->db->where('parcours_id', $idp);  
        $query = $this->db->get();        
        $result = $query->result()  ;
        foreach ($result as $res){
            return $res->parcours_titre;
        }
    }

    public function readParcours($idp,$loc='') {
        $this->db->select('parcours_id,item_id,ordre,type,loc');
        $this->db->from($this->table_par);
        $this->db->where('parcours_id', $idp);
        $this->db->order_by('ordre', 'asc');  
        $query = $this->db->get();      
        return $query->result()  ;
        
    }

    public function getInfosById($idp,$loc='') {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('parcours_id', $idp);
        $query = $this->db->get();      
        return $query->result()  ;
        
    }

    public function getMatiereIdByParcoursId($idp) {
        $this->db->select('matiere_id as id_mat');
        $this->db->from($this->table);
        $this->db->where('parcours_id', $idp);
        $query = $this->db->get();      
        $result = $query->result()  ;
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret = $res->id_mat ;
            }
        }       
        return $ret;
        
    }

    public function getMaxId() {
        $this->db->select('MAX(parcours_id) AS parcours_id_max');
        $this->db->from($this->table);
        $query = $this->db->get();      
        $result = $query->result()  ;
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                return $res->parcours_id_max ;
            }
        }       
        
    }

    public function add($titre,$code,$aut,$objectifs,$type,$loc){
        $data = array(
            'parcours_titre'     => $titre,
            'parcours_type'      => $type,
            'parcours_objectifs' => $objectifs,
            'code'               => $code,
            'auteur_id'          => $aut
        );
        $this->db->trans_start();
        $this->db->insert($this->table, $data);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();       
        if ( strlen(trim($code)) == 0 ) {
            $data_update = array(
                'code' => 'P'.$insert_id
            );
            $this->update($insert_id,$data_update);
        } 
        return $insert_id;
    }
    public function update($id,$data) {
        $this->db->where('parcours_id', $id);
        $this->db->update($this->table, $data);

    }

    public function addV3($data){
        $this->db->trans_start();
        $this->db->insert($this->table, $data);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();       
        return $insert_id;
    }
}

?>
