<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Stag_individu_model extends CI_Model
{
    
    /*public function __construct(){

    }*/
    /**
     * This public function used to check the login credentials of the user
     * @param string $email : This is email of the user
     * @param string $password : This is encrypted password of the user
     */
    public function __construct(){
        
        parent::__construct();
        $this->table         = 'stag_individu';
        $this->table_membres = 'membres';
    }

    public function getMaxNumStageByIdExtranet($idExtranet){
        $this->db->select('MAX(id_stage_ext) AS NumStageMax');
        $this->db->from($this->table);
        $this->db->where('id_individu_ext', $idExtranet);
        $query = $this->db->get(); 
        if ($query->num_rows() != 0) {
            foreach ($query->result() as $res){
                return $res->NumStageMax ;
            }
        }  
    }

    public function add($data) {     
        $this->db->trans_start();
        $this->db->insert($this->table, $data);        
        $id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $id;

    }
     
    public function RequestByIdStagiaire($field,$idStagiaire) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id_stagiare_el', $idStagiaire);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function Request($field,$idStage) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id_stage_ext', $idStage);
        $this->db->order_by('id', 'desc');
        $this->db->limit(1);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function getMaxNumStageByIdMembers($idMembres){
        $this->db->select('MAX(id_stage_ext) AS NumStageMax');
        $this->db->from($this->table);
        $this->db->where('id_stagiare_el', $idMembres);
        $query = $this->db->get(); 
        if ($query->num_rows() != 0) {
            foreach ($query->result() as $res){
                return $res->NumStageMax ;
            }
        }  
    }

    public function getMaxIdMembresByStage($idStage){
        $ret = "";
        $this->db->select('MAX(id_stagiare_el) AS idMembres');
        $this->db->from($this->table);
        $this->db->where('id_stage_ext', $idStage);
        $this->db->limit(1);
        $query = $this->db->get(); 
        if ($query->num_rows() != 0) {
            foreach ($query->result() as $res){
                $ret .= $res->idMembres ;
            }
        }  
        return($ret);
    }

    public function getLastMembersByStageExtranetId($id_stage_ext, $id_individu_ext) {
        $this->db->select('m.id AS idMembres, m.id_groupe AS idGroupe, m.extranet_id AS extranetId, st.id_stage_ext AS numStage, m.date_fin_acces');
        $this->db->from($this->table.' AS st');
        $this->db->join($this->table_membres.' AS m', 'm.id = st.id_stagiare_el', 'INNER');
        $this->db->where('st.id_individu_ext', $id_individu_ext);
        $this->db->where('st.id_stage_ext', $id_stage_ext);
        $this->db->order_by('st.id', 'DESC');
        $query = $this->db->get();
        return $query->result();                   
    }

    public function getInfosByParams($id_stagiare_el, $id_stage_ext, $id_individu_ext) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_stagiare_el', $id_stagiare_el);
        $this->db->where('id_individu_ext', $id_individu_ext);
        $this->db->where('id_stage_ext', $id_stage_ext);
        $query = $this->db->get();
        return $query->result();                   
    }
}

?>
