<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Utilities_model extends CI_Model
{
    /**
    * Class : BaseController
    * Base Class to control over all the classes
    * @author : Alexandre Bors
    * @version : 1.1
    * @since : 22 November 2018
    */
    /*public function __construct(){

    }*/
    /**
     * This public function used to check the login credentials of the user
     * @param string $email : This is email of the user
     * @param string $password : This is encrypted password of the user
     */
    public function __construct(){
        
        parent::__construct();
        $this->table_thumb        = "thumbnailprg";
        $this->table_sequence     = "sequence";
        $this->table_new_sequence = "new_sequence";
        $this->table_stat_connexion = "stat_connexion";
        $this->table_pan_w        = "plan_de_travail";
        $this->table_content_lib  = "content_corporate_library_soc";
    }

    public function RequestArtileById($field,$idArticle) {
        $this->db->select($field);
        $this->db->from($this->table_thumb);
        $this->db->where('idArticle', $idArticle);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function FormatDate() {
        $date = getdate() ;
        return($date["0"]);
    }  

    public function updateTimeCnx($cnx)
    {
        $this->db->select('date_cnx');
        $this->db->from('stat_connexion');
        $this->db->where('cnx', $cnx);
        $query = $this->db->get();        
        $result =  $query->result();
        foreach ($result as $res){
            $now = time();
            $old = $res->date_cnx ;
            $time = $now - $old;
            $cnxInfo = array(
                'time_cnx'               => $time,
                'date_logout'            => $now,
                'type_event_deconnexion' => 'fin_de_session'
            );
            $this->db->where('cnx', $cnx);
            $this->db->update($this->table_stat_connexion, $cnxInfo);
        }
        return $cnx;
    }  

    public function addthumb($thumbinfo)
    {
        $this->db->trans_start();
        $this->db->insert('thumbnailprg', $thumbinfo);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();        
        return $insert_id;
    }
    public function updateThumbNL1($idthumb,$thumbinfo)
    {
        
        $this->db->where('id', $idthumb);
        $this->db->update("thumbnailnl", $thumbinfo);

    }
    public function updateThumbNL($thumbinfo)
    {
        
        $this->db->where('idMonth', $thumbinfo['idMonth']);
        $this->db->where('idArticle', $thumbinfo['idArticle']);
        $this->db->update("thumbnailnl", $thumbinfo);

    }

    public function addthumbNL($thumbinfo)
    {
                 
        $this->db->trans_start();
        $this->db->insert('thumbnailnl', $thumbinfo);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();        
        return $insert_id;
   
    }
    public function addthumbNLTemp($thumbinfo)
    {
                 
        $this->db->trans_start();
        $this->db->insert('thumbnailnltemp', $thumbinfo);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();        
        return $insert_id;
   
    }

    public function getthumbNL($id){
        $thumb = "";
        $this->db->select('*');
        $this->db->from("thumbnailnl");
        $this->db->where('idArticle', $id);
        $this->db->limit(1);
        $query = $this->db->get();        
        $result =  $query->result();
        foreach ($result as $res){
            $thumb .= $res->thumbnail;
        }
        return $thumb;
    }

    public function getThumActivity($id,$num){
        $thumb = "";
        $this->db->select('*');
        $this->db->from($this->table_sequence);
        $this->db->where('id_sequence', $id);
        $this->db->where('numero', $num);
        $this->db->limit(1);
        $query = $this->db->get();        
        $result =  $query->result();
        foreach ($result as $res){
            $thumb .= $res->thumbnail_file;
        }
        return $thumb;
    }
    public function getThumbTodoByIdLibCorporate($idContentLib){
        $ret = array();
        $this->db->select('*');
        $this->db->from($this->table_content_lib);
        $this->db->where('id', $idContentLib);
        $this->db->limit(1);
        $query = $this->db->get();        
        $result = $query->result();
        foreach ($result as $res){
            $ret['thumbnail']                  = $res->thumbnail_file;
            $ret['user_create']                = $res->user_create;
            $ret['id_corporate_library_soc']   = $res->id_corporate_library_soc;
        }
        return $ret;
    }
    public function getThumbTodoByIdPlanW($id_plan_de_travail){
        $ret = array();
        $this->db->select('*');
        $this->db->from($this->table_new_sequence." as n");
        $this->db->join($this->table_pan_w.' as p', 'n.id = p.num_sequence','left');
        $this->db->where('p.id_plan_de_travail', $id_plan_de_travail);
        $this->db->limit(1);
        $query = $this->db->get();        
        $result = $query->result();
        foreach ($result as $res){
            $ret['thumbnail']   = $res->thumbnail_file;
            $ret['user_create'] = $res->user_create;
            $ret['id_plan_w']   = $res->id_plan_de_travail;
        }
        return $ret;
    }
    public function getThumbTodo($id){
        $ret = array();
        $this->db->select('*');
        $this->db->from($this->table_new_sequence." as n");
        $this->db->join($this->table_pan_w.' as p', 'n.id = p.num_sequence','left');
        $this->db->where('n.id', $id);
        $this->db->limit(1);
        $query = $this->db->get();        
        $result = $query->result();
        foreach ($result as $res){
            $ret['thumbnail']   = $res->thumbnail_file;
            $ret['user_create'] = $res->user_create;
            $ret['id_plan_w']   = $res->id_plan_de_travail;
        }
        return $ret;
    }
    public function getthumbNLS($idM,$idA){
        $thumb = "";
        $this->db->select('*');
        $this->db->from("thumbnailnl");
        $this->db->where('idMonth', $idM);
        $this->db->where('idArticle', $idA);
        $this->db->limit(1);
        $query = $this->db->get();        
        return $query;
    }

    public function getThumbNlResult($idM,$idA){
        $thumb = "";
        $this->db->select('*');
        $this->db->from("thumbnailnl");
        $this->db->where('idMonth', $idM);
        $this->db->where('idArticle', $idA);
        $this->db->limit(1);
        $query = $this->db->get();        
        return $query->result();
    }

    public function getAllthumbNL(){
        $this->db->select('*');
        $this->db->from("thumbnailnl");
        $this->db->order_by('ID', 'desc');
        $query = $this->db->get();        
        return $query;
    }

    public function modifthumb($type,$id,$loc,$thumbinfo)
    {

        $this->db->select('*');
        $this->db->from($this->table_thumb);
        $this->db->where('type', $type);
        $this->db->where('id_pr', $id);
        $this->db->where('loc_pr', $loc);
        $query = $this->db->get();        
        $result =  $query->result();
        $row= $query->num_rows();
        if ($row >= 1) {
            $this->db->where('type', $type);
            $this->db->where('id_pr', $id);
            $this->db->where('loc_pr', $loc);
            $this->db->update($this->table_thumb, $thumbinfo);
        }
        else{
            $thumbinfos = array(            
                'id_pr'           =>$id, 
                "loc_pr"          => $loc, 
                "thumbnail"       => $thumbinfo['thumbnail'], 
                "date_create"     => time(), 
                "type"            => $type, 
                'user_create'     =>$this->session->userdata ('GUSERID')
            );
            $this->addthumb($thumbinfos);
        }


        
    }

    public function getthumb($type,$id,$loc){
        $thumb = "";
        $this->db->select('thumbnail');
        $this->db->from($this->table_thumb);
        $this->db->where('type', $type);
        $this->db->where('id_pr', $id);
        $this->db->where('loc_pr', $loc);
        $query = $this->db->get();        
        $result =  $query->result();
        foreach ($result as $res){
            $thumb .= $res->thumbnail;
        }
        return $thumb;
    }


    public function getinfothumb($id,$loc){
        $this->db->select("COUNT(id) AS COUNT");
        $this->db->from("thumbnailprg");
        $this->db->where('id_pr', $id);
        $this->db->where('loc_pr', $loc);
        $query = $this->db->get();
        $result =  $query->result();
        if(!empty($result)){
            $nb = $result[0]->COUNT;
        }
        else{
           $nb = 0; 
        }
        return $nb;
    }

    public function getinfothumbs($id,$loc,$type){
        $this->db->select("*");
        $this->db->from("thumbnailprg");
        $this->db->where('id_pr', $id);
        $this->db->where('loc_pr', $loc);
        $this->db->where('type', $type);
        $query = $this->db->get();
        $result =  $query->result();
        
        return $result;
    }

    public function  build_terms_clause($terms, $date, $fields, $match){

        if(empty($this->where_clause)){
          if($date!=0){
            $cutoff = date("Y-m-d", mktime(0,0,0,date("m"),date("d")-$date));

            $cutoff = strtotime($cutoff);
            $this->where_clause .= " datestamp >= '$cutoff' AND ";
          }

          while (list ($junk, $term) = each ($terms)) {
            $cmpfunc="LIKE";
            if(substr($term, 0, 1)=="-"){
              $term=substr($term, 1);
              $cmpfunc="NOT LIKE";
            }
            reset($fields);
            unset($likeArray);
            while (list ($key, $val) = each ($fields)) {
              $likeArray[]=" $val $cmpfunc '%".addslashes($term)."%' ";
            }
            if($cmpfunc=="NOT LIKE") {  //Ni dans le titre ET ni dans le body
                $termArray[] = " (".implode( $likeArray, " AND " ).") ";
            } else {
                $termArray[] = " (".implode( $likeArray, " OR " ).") ";
            }
          }

          $cmptype="AND";
          if($match!=1) $cmptype="OR";
          $this->where_clause.= " (".implode( $termArray, " $cmptype " ).") ";

        }
        return $this->where_clause;

    }

    public function afficheLienRechercher($ret,$loc,$sequence=false){
        $ligne = array();
        //$lseq = $this->lienTitreSuppModifView($ret,$loc,$sequence);

        //$result = $lseq['ldel'].' '.$lseq['lmodif'].' '.$lseq['lview'] ;
        $result = "" ;

        if ( strlen($ret['objectifs'])>0 ) {
            $result.= BR() ;
            $result.= str_replace(RECHERCHER, strong(RECHERCHER), $ret['objectifs']);
            $result.= BR() ;
        }
        return ($result);
    }

    public function ReplaceTime($val, $format=0) {
        $h = intval(intval($val) / 3600);
        if ($h < 10 && $format==0) {
            $h =  "0".$h;
        }

        $m = ((intval($val) / 60) % 60);
        if ($m < 10 && $format==0) {
            $m =  "0".$m;
        }

        $s = (intval($val) % 60);
        if ($s < 10 && $format==0) {
            $s = "0".$s;
        }

        switch($format) {
        case 0 :
            $res = $h.':'.$m.':'.$s;
            break;
        case 1 :
            $res = ($h>0?$h.' h ':'');
            $res.= ($m>0?$m.' mn ':'');
            $res.= ($s>0 || strlen($res)==0?$s.' s':'');
            break;
        }
        return($res);
    }

    
}

?>
