<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EL<?php echo date('Y') ?> - Reset password</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css" integrity="sha512-MV7K8+y+gLIBoVD59lQIYicR65iaqukzvf/nwasF0nqhPay5w/9lJmVM2hMDcnK1OnMGCdVK+iQrJ7lzPJQd1w==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/themes/other/css/bootstrap-grid.min.css">
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/themes/other/css/components.css">
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/themes/commun/dist/css/toastr.min.css">
    <script src="<?php echo base_url(); ?>assets/bootstrap4/js/jquery.min.js"></script>
    <script src="<?php echo base_url(); ?>assets/themes/commun/dist/js/toastr.min.js"></script>
    <script type="text/javascript">
        $(window).on('load', function(){
           $(".spinner").fadeOut("slow");
        });
        $(document).ready(function(){
            $('#reset-password-form').submit(function(e){
                e.preventDefault();        
                $(".spinner").fadeIn("slow"); 
                var loadform = false;
                var password_securte = test_pass($('#new_password').val());
                if (password_securte == 0) {
                    toastr.error("Your password is too short,<br>must be at least 6 characters long.");
                }

                if (password_securte == 1) {
                    toastr.success("Your password security is very low but acceptable");
                }

                if (password_securte == 2) {
                    toastr.success("The security of your password is medium,<br> therefore acceptable");
                }

                if (password_securte == 3) {
                    toastr.success("Congratulations, your password is secure");
                }


                if (password_securte >= 1) {
                    // Call ajax for pass data to other place
                    $.ajax({
                        type: $(this).attr('method'),
                        url:  $(this).attr('action'),
                        data:  new FormData(this),
                        contentType: false,
                        cache: false,
                        processData:false,
                        dataType: 'json',
                        beforeSend: function(){
                          $(this).css("opacity",".5");
                        },
                        success: function(data){
                          console.log(data);              
                          $(this).css("opacity","1");
                          if (data.success == false) {
                            toastr.error(data.error);
                            $(".spinner").fadeOut("slow");
                          }
                          else{
                            toastr.success('Thank you, your new password is saved successfully');
                            setTimeout('window.location.replace("login");','4000');
                          }
                          
                        }
                    });
                }
                else{
                    $(".spinner").fadeOut("slow"); 
                }
            });

            $('.close').click(function(e){
                e.preventDefault();
                $('.alert').fadeOut('slow');
            });
        });
        function test_pass(mdp) {
            var taille = mdp.length;
            var securite = taille;
            var Chiffre = new RegExp("[0-9]","gi");
            var Special = new RegExp("[^a-zA-Z0-9]","gi");
            var niveau="";
             
            for (var i=0;i<taille;i++)
            {
              var c = mdp.charAt(i);
              if (Chiffre.test(c)){
                securite = securite + 1;
              }
              else {
                if(Special.test(c)){
                  securite = securite + 4;
                }
              }
            }
            if (securite<6) niveau=0;
            if (securite>=6 && securite<=8) niveau=1;
            if (securite>=9 && securite<=12) niveau=2;
            if (securite>=13) niveau=3;
            return niveau;
        }  
    </script>
</head>
<body class="bg-body body-el">
    <div class="spinner"></div>
    <div class="limiter">
        <div class="page-content">
            <div class="login-container">
                <div class="container">
                    <div class="row justify-content-center align-items-center">

                        <!-- logo -->
                        <div class="col-10 col-sm-8 col-md-5 col-lg-6 col-xl-6 mb-5 mb-md-0">
                            <div class="brand-container">
                                <div class="brand-wrap">
                                    <a href=""><img src="assets/themes/other/images/forma2plus.svg" alt=""></a>                                
                                </div>
                            </div>
                            <div class="divider divider-lg"></div>

                            <div class="basline">
                                <h5>our training dashboard</h5>
                            </div>
                            <br>

                            <div class="basline">
                                <!--div class="brand-wrap incident-technic-wrag"-->
                                <div class="incident-technic-login">
                                    <a href="<?php echo $this->config->item('api_url_incident_technik') ?>?nom=&origin=<?php echo base_url() ?>&mail=" target="_blank" class="inc-btn"  data-page="incident-technic">
                                        <span><?php echo $this->lang->line('incident_technic') ?></span>
                                        <img src="<?php echo base_url() ?>assets/themes/other/images/inc-icon.svg" alt="">
                                    </a>
                                </div>
                            </div>

                        </div>

                        <!-- login -->
                        <div class="col-sm-10 col-md-7 col-lg-5 col-xl-4">
                            <div class="login-wrap">
                                <div class="login-inner">
                                    <div class="login" id="login-form-container">
                                        <div class="login-head">
                                            <i class="fa-solid fa-circle-user"></i>
                                            <span>Resetting your password</span>
                                        </div>

                                        <?php $this->load->helper('form'); $error = $this->session->flashdata('error'); if($error) { ?>
                                                <div class="alert alert-danger alert-dismissable">
                                                  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                                  <?php echo $error; ?>                    
                                                </div>
                                        <?php } $success = $this->session->flashdata('success');
                                            if($success) {  ?>
                                                <div class="alert alert-success alert-dismissable">
                                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                                    <?php echo $success; ?>                    
                                                </div>
                                        <?php } ?>

                                        <form id="reset-password-form" action="<?php echo base_url(); ?>resetpassword/<?php echo $GEXTRANETID ?>/<?php echo $GUSERID ?>" method="post">

                                            <div class="login-field">
                                                <label for="login-user" class="login-label">New password</label>
                                                <input type="password" class="login-input" id="new_password" name="new_password" required />
                                            </div>
                                            <div class="login-field">
                                                <label for="login-password" class="login-label">Password confirmation</label>
                                                <input type="password" class="login-input" name="confirm_password" required />
                                            </div>
                                            <button type="submit" class="login-submit">
                                                <span>Send</span>
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <footer class="footer">
                <span>© <?php echo date('Y') ?> E-learning by forma2plus.com</span>
            </footer>


        </div>
    </div>
</body>
</html>