<?php
  function getEmbedUrl($url) {
      // function for generating an embed link
      $finalUrl = '';

      if (strpos($url, 'facebook.com/') !== false) {
          // Facebook Video
          $finalUrl.='https://www.facebook.com/plugins/video.php?href='.rawurlencode($url).'&show_text=1&width=200';

      } else if(strpos($url, 'vimeo.com/') !== false) {
          // Vimeo video
          $videoId = isset(explode("vimeo.com/",$url)[1]) ? explode("vimeo.com/",$url)[1] : null;
          if (strpos($videoId, '&') !== false){

          }
          $finalUrl.='https://player.vimeo.com/video/'.$videoId;

      } else if (strpos($url, 'youtube.com/') !== false) {
          // Youtube video
          $videoId = isset(explode("v=",$url)[1]) ? explode("v=",$url)[1] : null;
          if (strpos($videoId, '&') !== false){
              $videoId = explode("&",$videoId)[0];
          }
          $finalUrl.='https://www.youtube.com/embed/'.$videoId;

      } else if(strpos($url, 'youtu.be/') !== false) {
          // Youtube  video
          $videoId = isset(explode("youtu.be/",$url)[1]) ? explode("youtu.be/",$url)[1] : null;
          if (strpos($videoId, '&') !== false) {
              $videoId = explode("&",$videoId)[0];
          }
          $finalUrl.='https://www.youtube.com/embed/'.$videoId;

      } else if (strpos($url, 'dailymotion.com/') !== false) {
          // Dailymotion Video
          $videoId = isset(explode("dailymotion.com/",$url)[1]) ? explode("dailymotion.com/",$url)[1] : null;
          if (strpos($videoId, '&') !== false) {
              $videoId = explode("&",$videoId)[0];
          }
          $finalUrl.='https://www.dailymotion.com/embed/'.$videoId;

      } else{
          $finalUrl.=$url;
      }

      return $finalUrl;
  }
?>
<link rel="stylesheet" type="text/css" href="<?php echo base_url(); ?>assets/themes/professor/css/historikcourse.css">
<link rel="stylesheet" type="text/css" href="<?php echo base_url(); ?>assets/themes/commun/css/styles.css">
<link rel="stylesheet" type="text/css" href="<?php echo base_url(); ?>assets/themes/commun/css/sequencestyle.min.css">
<input type="hidden" name="trainee-mail" id="trainee-mail" value="<?php echo $this->membres_model->Request('email',$this->session->userdata ('STAGIAIREID')); ?>">
  <section class="content-header">
    <div class="row">
      <div class="col-xs-12 ch-menu-navigation padding-elearning">
        <div class="col-xs-6">
          <h4 class="action-menu-nl">
            <a href="<?php echo base_url() ?>" class="home-ch-t">
              <img src="assets/icons-f2+/menu_transverse/ico-home.png" alt="User elearning" class="user-image img-home">&nbsp;<span class="home-title "><?php echo $this->lang->line('home_page'); ?></span>&nbsp;<img src="assets/icons-f2+/historique_de_cours/ico-arrowright.png" alt="User elearning" class="user-image img-home icons-rigth">
              </a>
              <a href="<?php echo current_url(); ?>" class="btn-action-nl-home home-page active"><span class=""><?php echo $this->lang->line('course_history_title'); ?></span></a>
            </a>
          </h4>
        </div>
        <div class="col-xs-6 text-right">
          <form style="float: inherit;" name="export-ch" method="post" action="<?php echo base_url(); ?>export-ch">
            <div class="bs-example btn-action-ch" data-example-id="single-button-dropdown">
              <div class="btn-group btn-action-download-ch">
                <a href="#" class="btn btn-primary btn-lg btn-new-histori-cours">
                  <i class="fa fa-plus fa-new-ch"></i>&nbsp;<span class="title-action-ch"><?php echo $this->lang->line('course_history_add_new'); ?></span>
                </a>
              </div>
              <div class="btn-group btn-grp-date-download-hc">
                <select name="date_hc" id="date_hc" class="btn btn-primary btn-lg btn-toogle-date-ch">
                  <?php foreach ($allDateFromTodo as $dch) { ?>
                    <option value="<?php echo $dch->date_value; ?>"><?php echo $dch->date_afficher; ?><span class="caret"></span></option>
                  <?php } ?>
                </select>
              </div>
              <div class="btn-group btn-action-download-ch">
                <button type="submit" class="btn btn-default btn-lg dropdown-toggle btn-download-ch"><?php echo $this->lang->line('course_history_btn_download'); ?></button>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </section>
  <section class="content">          
    <div class="row" style="margin-bottom: 0px;">
      <div class="col-sm-12 padding-elearning">
        <div class="col-sm-3 search-document-in-page">
          <input type="search" class="form-control form-control-sm key-data-course-historik" id="key-data-course-historik" name="key-data-course-historik" placeholder="<?php echo $this->lang->line('label_search'); ?>..." aria-controls="tableCh">
          <div id="data-list"></div>
        </div>
        <div class="col-sm-3">
          <div class="form-group">
            <div class="custom">
              <div class="input-group col-sm-12">
                <span class="input-group-addon span-label-order"><img src="<?php echo base_url() ?>assets/icons-f2+/link_and_document_and_favoris/ico-sort.png"> <?php echo $this->lang->line('course_history_sort_by'); ?> </span>
                <select class="form-control result-todo-order" name="result-todo-order">
                  <option value="name_asc" <?php echo isset($_GET['order']) && $_GET['order'] == 'name_asc' ? 'selected' : '' ?>><?php echo $this->lang->line('course_history_ascending_name'); ?></option>  
                  <option value="name_desc" <?php echo isset($_GET['order']) && $_GET['order'] == 'name_desc' ? 'selected' : '' ?>><?php echo $this->lang->line('course_history_descending_name'); ?></option>  
                  <option value="create_date_asc" <?php echo isset($_GET['order']) && $_GET['order'] == 'create_date_asc' ? 'selected' : '' ?>><?php echo $this->lang->line('course_history_ascending_date_of_creation'); ?></option>  
                  <option value="create_date_desc" <?php echo isset($_GET['order']) && $_GET['order'] == 'create_date_desc' ? 'selected' : '' ?>><?php echo $this->lang->line('course_history_descending_date_of_creation'); ?></option>  
                </select>
              </div>
            </div>
          </div>
        </div> 
        <?php if(count($allProfessorForTrainee) >= 1) { ?>     
          <div class="col-sm-6">
            <div class="multiselectProfessor">
              <div class="selectBoxProfessor" onclick="showCheckboxesInSelect()">
                <select class="form-control form-control-sm other-professor" name="other-professor" id="other-professor">
                  <option><?php echo $this->lang->line('trainer_other_cursus_formation'); ?></option>
                </select>
                <div class="overSelectOtherProfessor"></div>
              </div>
              <div id="OtherProfessor">
                <?php foreach ($allProfessorForTrainee as $res) { if($res->id_tuteur != $this->session->userdata ('GUSERID')) { ?>                  
                  <label for="<?php echo $res->id_tuteur; ?>">
                    <input type="checkbox" class="professorUserCreate" value="<?php echo $res->id_tuteur; ?>" id="<?php echo $res->id_tuteur; ?>" /> <?php echo $this->membres_model->Request('prenom',$res->id_tuteur).' '.$this->membres_model->Request('nom',$res->id_tuteur) ?>
                  </label>
                <?php } } ?>
              </div>
            </div>
          </div>
        <?php } ?>
    </div>
    <div class="container" id="container-historic-course">
      <div class="messageconfirmation"></div>
      <div class="parcours-trainee-loader" style="display: none;"></div>
      <br>
      <?php $nb_page=0; $i=0; ?>
      <div class="row">
        <div class="box border-top-elearning">
          <div class="col-sm-12">
            <br>
            <?php if (count($historiqcours) >= 1) { ?>
              <?php foreach ($historiqcours as $hc) { ?>
                <div class="col-sm-4 col-body-and-heading-todo">
                  <div class="panel-group" id="accordion">
                      <div class="panel panel-primary panel-heading-todo" style="background-color: <?php echo $hc->back_color; ?> !important;border-color: <?php echo $hc->back_color; ?> !important;">
                        <div class="panel-heading panel-heading-trainee" style="background-color: <?php echo $hc->back_color; ?> !important;border-color: <?php echo $hc->back_color; ?> !important;">
                          <h4 class="panel-title">
                            <div class="row cls-row-panel-action-hc">
                              <div class="col-md-12 cls-edit-cours-history" style="display: none;">
                                <div class="input-group input-edit-course-history">
                                  <div class="row">
                                    <div class="col-md-12">
                                      <div class="col-md-8">
                                        <input type="text" name="intitule-cours-history" class="form-control intitule-cours-history" value="<?php echo htmlentities($hc->intitule); ?>" data-id="<?php echo $hc->id; ?>">
                                      </div>
                                      <div class="col-md-4">
                                        <input type="color" name="color-cours-history" class="form-control color-cours-history" value="<?php echo htmlentities($hc->back_color); ?>" data-id="<?php echo $hc->back_color; ?>">
                                      </div>
                                    </div>
                                  </div>
                                  <span class="input-group-btn input-group-action-edit-h-c">
                                    <a class="btn btn-primary btn-save-edit-historik-course"><i class="glyphicon glyphicon glyphicon-thumbs-up"></i></a>
                                    <a class="btn btn-default btn-cancel-edit-hisorik-course"><i class="glyphicon glyphicon-retweet"></i></a>
                                  </span>
                                </div>
                              </div>
                              <div class="col-md-1 cls-dropdown-cours-history opacity-course-history">
                                <a href="#" data-toggle="dropdown" class="menu-dropdown-actions-audio" aria-haspopup="true" aria-expanded="true">
                                  <img src="assets/icons-f2+/historique_de_cours/menu_contextuel.png" alt="User elearning" class="user-image img-home">
                                </a>

                                <div class="dropdown-menu btn-action-panel-historik-course ation-add-plan-de-w" data-id="<?php echo $hc->id; ?>">
                                  <?php if ($hc->user_create == $this->session->userdata ('GUSERID')) { ?>
                                    <i class="glyphicon glyphicon-plus-sign add-todo-in-historik-course"></i>&nbsp;
                                    <i class="glyphicon glyphicon-remove-sign glyphicon-remove-historik-course"></i>&nbsp;
                                    <i class="glyphicon glyphicon glyphicon-edit glyphicon-edit-historik-course"></i>&nbsp;
                                    <i title="Duplicate" data-id="<?php echo $hc->id; ?>" data-name="<?php echo htmlentities($hc->intitule); ?>" data-theme="<?php echo htmlentities($hc->back_color); ?>" class="glyphicon glyphicon-copy glyphicon-copy-session-historik-course"></i>&nbsp;
                                  <?php } ?>
                                    <i onclick="window.location.replace('<?php echo base_url(); ?>get-detail-cours-historik?id=<?php echo $hc->id; ?>');" class="glyphicon glyphicon-eye-open glyphicon-open-historik-course"></i>
                                </div>
                              </div>
                              <div class="col-md-11 cls-libelle-cours-history">
                                <a class="accordion-toggle according-toogle-ch" data-toggle="collapse" data-parent="#accordion" href="#collapseOne<?php echo $i; ?>">
                                  <?php echo htmlentities($hc->intitule); ?>
                                  <span class="chevron-action-collapse-hc">
                                    <img src="assets/icons-f2+/historique_de_cours/ico-arrowdown-coursehistory.png" class="user-image img-home">
                                  </span>
                                </a>
                              </div>
                            </div>
                          </h4>
                        </div>
                        <div id="collapseOne<?php echo $i; ?>" class="panel-collapse collapse">
                          <div class="panel-body" style="padding: 10px 0px 10px 0 !important;">
                            <?php 
                              if ($hc->user_create == $this->session->userdata ('GUSERID')) { 
                                $todoResults = $this->todolist_model->TrainingProgTuteurInCoursHistorikAndUserCreate($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP'),$hc->id);
                              }
                              else{
                                $todoResults = $this->todolist_model->TrainingProgTuteurInCoursHistorikAndUserCreate($this->session->userdata ('STAGIAIREID'),$this->session->userdata ('STAGIAIREGRP'),$hc->id);
                              }

                              $pageResult = $this->coursHistorik_model->getPageByIdCoursHistorik($hc->id);

                              $nlhc = $this->historik_course_nl_model->getByUserCreateIdGroupIdHc($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP'),$hc->id);
                            ?>
                            <?php foreach ($todoResults as $record) {
                                if ($record->isDone == 1) {
                                    $checked = "checked='checked'";
                                }
                                else{
                                    $checked = "";
                                }

                                $thumbnail      =  RP_GROUPES."GRPT".$record->user_create.'/THUMBNAIL'.$record->user_create.'/'.$record->thumbnail_file;
                                if ($record->thumbnail_file != ''  && file_exists($thumbnail)) {
                                    $images = base_url()."groupes/GRPT".$record->user_create.'/THUMBNAIL'.$record->user_create.'/'.$record->thumbnail_file;
                                }
                                else{
                                    $images =  base_url()."groupes/default.png"; 
                                }


                                $linkF = '';
                                $local_files = '';
                                $extention = '';

                                $urlTodo1 = $record->link;
                                if ($this->todolist_model->RequestNewSequence('type',$record->num_sequence) == 0 && strpos($urlTodo1, 'youtube') === false && strpos($urlTodo1, 'youtu.be') === false && strpos($urlTodo1, 'vimeo.com') === false && strpos($urlTodo1, 'facebook.com') === false && strpos($urlTodo1, 'dailymotion.com') === false) {
                                    $linkF = $record->url;
                                }
                                elseif ($this->todolist_model->RequestNewSequence('type',$record->num_sequence) == 0 && (strpos($urlTodo1, 'vimeo.com') !== false || strpos($urlTodo1, 'facebook.com') !== false || strpos($urlTodo1, 'dailymotion.com') !== false || strpos($urlTodo1, 'youtube') !== false || strpos($urlTodo1, 'youtu.be') !== false)) {
                                    $linkF = getEmbedUrl($urlTodo1);
                                }            
                                elseif (($this->todolist_model->RequestNewSequence('type',$record->num_sequence) != 0 && file_exists(RP_GROUPES.'GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1)) && (strpos(HTTP_MAIN.'groupes/GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1, '.doc') !== false) || (strpos(HTTP_MAIN.'groupes/GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1, '.docx') !== false) || (strpos(HTTP_MAIN.'groupes/GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1, '.ppt') !== false) || (strpos(HTTP_MAIN.'groupes/GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1, '.pdf') !== false)){

                                    $linkF = HTTP_MAIN.'groupes/GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1;
                                    $local_files = 'groupes/GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1;
                                    //$linkFile = "https://docs.google.com/gview?url=".HTTP_MAIN.'groupes/GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1."&amp;embedded=true";
                                    $extension = pathinfo(basename($local_files), PATHINFO_EXTENSION);
                                    if ($extension == 'PNG' || $extension == 'png' || $extension == 'JPEG' || $extension == 'jpeg' || $extension == 'JPG' || $extension == 'jpg' || $extension == 'gif' || $extension == 'GIF') {
                                      $extention = '&data-type=images';
                                    }
                                    else{
                                      $extention = '&data-type=doc';
                                    }
                                }
                                elseif($this->todolist_model->RequestNewSequence('type',$record->num_sequence) != 0 && !file_exists(RP_GROUPES.'GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1)){
                                  $linkF = 'No_file';
                                }
                                else{
                                    $linkF = HTTP_MAIN.'groupes/GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1;
                                    $local_files = 'groupes/GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1;
                                    $extension = pathinfo(basename($local_files), PATHINFO_EXTENSION);
                                    if ($extension == 'PNG' || $extension == 'png' || $extension == 'JPEG' || $extension == 'jpeg' || $extension == 'JPG' || $extension == 'jpg' || $extension == 'gif' || $extension == 'GIF') {
                                      $extention = '&data-type=images';
                                    }
                                    else{
                                      $extention = '&data-type=doc';
                                    }
                                }

                                $commentsF = '';
                                if (strpos($record->comment, 'MID') === false) {
                                  $commentsF = $record->comment;
                                }
                                else{
                                  $ce = explode("MID", $record->comment);
                                  $r1 = str_replace("<", "", $ce[1]);
                                  $r2 = str_replace(">", "", $r1);
                                  $commentsF = str_replace("FIN", "", $r2);
                                }
                            ?>
                              <div class="row">
                                  <div class="col-sm-12 col-parents-label-todo">
                                      <div class="col-md-4 col-action-label-todo">
                                          <div class="form-check form-action-label-todo">
                                              <label class="form-check-label" for="exampleCheck1"><?php echo $this->lang->line('course_history_finished'); ?></label>
                                              <?php if ($record->isDone == 1) { ?>
                                                <img  data-id="<?php echo $record->id_plan_de_travail; ?>" src="assets/icons-f2+/historique_de_cours/finished.png" alt="User elearning" class="user-image finishedtodo">
                                              <?php } else { ?>        
                                                <input type="checkbox" data-id="<?php echo $record->id_plan_de_travail; ?>" name="finishedtodo" <?php echo $checked; ?> class="finishedtodo form-check-input">
                                              <?php } ?>

                                              <img  data-title="<?php echo $record->titre; ?>" data-id="<?php echo $record->id_plan_de_travail; ?>" src="assets/icons-f2+/historique_de_cours/favorite.png" alt="User elearning" class="user-image icons-favorites-todo">

                                              <img  data-id="<?php echo $record->id_plan_de_travail; ?>" src="assets/icons-f2+/historique_de_cours/delete.png" alt="User elearning" class="user-image icons-delete-todo">
                                          </div>
                                      </div>
                                      <div class="col-md-5">
                                        <textarea name="comment" style="border-radius: 16px;font-size: 12px;" data-id="<?php echo $record->id_plan_de_travail; ?>" data-id-seq="<?php echo $record->id; ?>" rows="8" cols="33" class="form-control comment-todo" value="<?php echo $commentsF; ?>"><?php echo $commentsF; ?></textarea>
                                      </div>
                                      <div class="col-md-3">
                                          <div class="container-image hovereffect">
                                            <img class="image-timthumb img-vignette" style="border-radius: 20px !important; max-width: 100% !important;" title="<?php echo $record->titre; ?>" alt="Avatar" src="<?php echo $images; ?>">
                                            <div class="overlay overlay-todo-in-cours-historik" data-ch="<?php echo $hc->id; ?>" data-local-file="<?php echo $local_files; ?>" data-acess="<?php echo base_url() ;?>read-todo-in-tutor?id=<?php echo $record->id_plan_de_travail;?><?php echo $local_files != '' ? '&local-data=blam' : ''; echo $extention; ?>" data-link="<?php echo $linkF; ?>" data-id-plan="<?php echo $record->id_plan_de_travail; ?>">
                                            </div>
                                          </div> 
                                          <div class="legend title-vignette"><span class="titleTumbnail"><?php echo $record->titre; ?></span></div>
                                      </div>
                                  </div>
                              </div>
                              <hr>
                            <?php } ?>

                            <?php foreach ($nlhc as $record) {
                                if ($record->isDone == 1) {
                                    $checked = "checked='checked'";
                                }
                                else{
                                    $checked = "";
                                }

                                $thumb = $this->utilities_model->getthumbNL($record->id_article);

                                if ($thumb == '') {
                                  $images =  base_url()."groupes/default.png"; 
                                }
                                elseif ($thumb != "" && is_file(REP_ACTIVITY_SEQUENCE.$thumb)) {
                                   $images  = base_url()."groupes/ACTIVITES/".$thumb;
                                }
                                else{
                                    $images =  base_url()."groupes/default.png"; 
                                }

                                $linkF = base_url().'read-data?id='.$record->id_article.'&id_h_c='.$hc->id;

                                $commentsF = '';
                                if (strpos($record->comment, 'MID') === false) {
                                  $commentsF = $record->comment;
                                }
                                else{
                                  $ce = explode("MID", $record->comment);
                                  $r1 = str_replace("<", "", $ce[1]);
                                  $r2 = str_replace(">", "", $r1);
                                  $commentsF = str_replace("FIN", "", $r2);
                                }
                            ?>
                            <div class="row">
                                <div class="col-sm-12 col-parents-label-todo">
                                    <div class="col-md-4 col-action-label-todo">
                                        <div class="form-check form-action-label-todo">
                                            <label class="form-check-label" for="exampleCheck1"><?php echo $this->lang->line('course_history_finished'); ?></label>
                                            <?php if ($record->isDone == 1) { ?>
                                              <img  data-id="<?php echo $record->id; ?>" src="assets/icons-f2+/historique_de_cours/finished.png" alt="User elearning" class="user-image finishedtodo">
                                            <?php } else { ?>        
                                              <input type="checkbox" data-id="<?php echo $record->id; ?>" name="finishedtodo" <?php echo $checked; ?> class="finishedtodo form-check-input" data-type="artcile">
                                            <?php } ?>

                                            <img  data-type="artcile" data-title="<?php echo $this->newsletter_model->Request('article',$record->id_article); ?>" data-id="<?php echo $record->id_article; ?>" src="assets/icons-f2+/historique_de_cours/favorite.png" alt="User elearning" class="user-image icons-favorites-todo">

                                            <img data-id="<?php echo $record->id; ?>" data-type="artcile" src="assets/icons-f2+/historique_de_cours/delete.png" alt="User elearning" class="user-image icons-delete-todo">
                                        </div>
                                    </div>
                                    <div class="col-md-5">
                                      <textarea  data-type="artcile" name="comment" style="border-radius: 16px;font-size: 12px;" data-id="<?php echo $record->id; ?>" data-id-seq="<?php echo $record->id; ?>" rows="8" cols="33" class="form-control comment-todo" value="<?php echo $commentsF; ?>"><?php echo $commentsF; ?></textarea>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="container-image hovereffect" style="cursor: pointer;" onclick="window.location.replace('<?php echo $linkF; ?>');">
                                          <img class="image-timthumb img-vignette" style="border-radius: 20px !important; max-width: 100% !important;" title="<?php echo $this->newsletter_model->Request('article',$record->id_article); ?>" alt="Avatar" src="<?php echo $images; ?>">
                                          <div class="overlay">
                                          </div>
                                        </div> 
                                        <div class="legend title-vignette"><span class="titleTumbnail"><?php echo $this->newsletter_model->Request('article',$record->id_article); ?></span></div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <?php } ?>
                            <?php foreach ($pageResult as $page) { ?>                              
                              <div class="row row_page_list">
                                <div class="col-xs-12 btn btn-action-page text-center">
                                  <div class="modal fade modal_read_content_of_page" id="modal_read_content_of_page" role="dialog">
                                    <div class="modal-dialog modal_dialog_read_content_of_page modal-lg">
                                      <div class="modal-content">
                                        <div class="modal-header">
                                          <button type="button" class="close close-modal-confirm-action" data-dismiss="modal">&times;</button>
                                          <h4 class="modal-title text-center confirmation"><?php echo $this->lang->line('course_history_page_content'); ?><br>
                                          </h4>
                                        </div>
                                        <div class="modal-body">
                                          <div class="content_of_select_page">   
                                            <div class="form-page-editor">      
                                              <form name="edit-page-loop" id="edit-page-loop" class="edit-page-loop" action="<?php echo base_url(); ?>update-page-historik-cours" method="post">
                                                <input type="hidden" name="content_page_ch_form">
                                                <input type="hidden" name="id_page_hc" class="id_page_hc" value="<?php echo $page->id ; ?>">
                                                <div class="row">
                                                  <div class="col-sm-12">
                                                    <textarea name="comment-page" style="border-radius: 16px;font-size: 12px;" data-id="<?php echo $page->id; ?>" rows="3" cols="33" class="form-control comment-page" value="<?php echo $page->comment; ?>"><?php echo htmlentities($page->comment); ?></textarea>
                                                  </div>
                                                </div>
                                                <br>
                                                <div class="row">
                                                  <div class="col-sm-12 col-parents-label-todo">
                                                    <textarea data-auto="<?php echo $nb_page ?>" class="form-control page-edit-content edit-page-view<?php echo $nb_page ?>" id="edit-page-view<?php echo $nb_page ?>" name="edit-page-view<?php echo $nb_page ?>" value="<?php echo htmlentities($page->content); ?>"><?php echo htmlentities($page->content); ?></textarea>
                                                  </div>
                                                </div>
                                                <br>
                                                <div class="text-center btn-action-page-edit">
                                                  <input type="submit" class="btn btn-success btn-save-modif-in-page-hc btn-action-el-ok" id="btn-save-modif-in-page-hc<?php echo $i;?>" value="Save modification">
                                                  <button type="button" class="btn btn-secondary btn-resufe-ch btn-action-el-cancel" data-dismiss="modal"><?php echo $this->lang->line('close_modal'); ?></button>
                                                </div>
                                              </form>
                                            </div>
                                          </div>
                                        </div>
                                      </div>    
                                    </div>
                                  </div>
                                  <a href="#" class="btn icons-delete-page"  title="Delete this page" data-id="<?php echo $page->id; ?>"><img data-type="artcile" src="assets/icons-f2+/historique_de_cours/delete.png" alt="Delete this page" class="user-image"></a>
                                  <a href="#" class="btn btn-action-el-cancel btn-open-page">
                                    <!--?php echo $this->lang->line('course_history_open_content_page'); ?-->
                                    <?php echo htmlentities($page->comment); ?>
                                    <input type="hidden" name="current-bn-page" value="<?php echo $nb_page; ?>" class="current-bn-page">
                                  </a>
                                </div>
                              </div>
                              <hr>
                            <?php $nb_page++; } ?>
                          </div>
                        </div>
                      </div>
                  </div>
                </div>
              <?php $i++; } ?>
            <?php } else { ?>
              <div class="text-center no-result">
                <?php echo $this->lang->line('course_history_nothing_data_trainee'); ?>
              </div>
            <?php } ?>
          </div>
        </div>
      </div>
      <?php if(count($allProfessorForTrainee) >= 1) {
        $counter = 0; 
        foreach ($allProfessorForTrainee as $res) { 
          $otherProfessorId = $res->id_tuteur; 
          if($otherProfessorId != $this->session->userdata ('GUSERID')) { 
            $historiqcours = $this->coursHistorik_model->getByUserCreateIdGroupTraineeCreateOrder($otherProfessorId,$this->session->userdata ('STAGIAIREID'),$this->session->userdata ('STAGIAIREGRP'),$order); ?>
            <h4 class="title author_ch" id="author_ch<?php echo $counter; ?>" style="display:none;" data-professorIndice="<?php echo $otherProfessorId ?>"><?php echo $this->lang->line('course_history_title'); ?> : <?php echo $this->membres_model->Request('prenom',$otherProfessorId).' '.$this->membres_model->Request('nom',$otherProfessorId) ?></h4>
            <div class="row otherCourseHistoryProfessor" id="otherCourseHistoryProfessor<?php echo $counter; ?>" style="display:none;" data-professorIndice="<?php echo $otherProfessorId ?>">
              <div class="box border-top-elearning">
                <div class="col-sm-12">
                  <br>
                  <?php if (count($historiqcours) >= 1) { ?>
                    <?php foreach ($historiqcours as $hc) { ?>
                      <div class="col-sm-4 col-body-and-heading-todo">
                        <div class="panel-group" id="accordion">
                            <div class="panel panel-primary panel-heading-todo" style="background-color: <?php echo $hc->back_color; ?> !important;border-color: <?php echo $hc->back_color; ?> !important;">
                              <div class="panel-heading panel-heading-trainee" style="background-color: <?php echo $hc->back_color; ?> !important;border-color: <?php echo $hc->back_color; ?> !important;">
                                <h4 class="panel-title">
                                  <div class="row cls-row-panel-action-hc">
                                    <div class="col-md-1 cls-dropdown-cours-history opacity-course-history">
                                      <a href="#" data-toggle="dropdown" class="menu-dropdown-actions-audio" aria-haspopup="true" aria-expanded="true">
                                        <img src="assets/icons-f2+/historique_de_cours/menu_contextuel.png" alt="User elearning" class="user-image img-home">
                                      </a>
                                      <div class="dropdown-menu btn-action-panel-historik-course ation-add-plan-de-w" data-id="<?php echo $hc->id; ?>">
                                        <i onclick="window.location.replace('<?php echo base_url(); ?>get-detail-cours-historik?id=<?php echo $hc->id; ?>');" class="glyphicon glyphicon-eye-open glyphicon-open-historik-course"></i>
                                      </div>
                                    </div>
                                    <div class="col-md-11 cls-libelle-cours-history">
                                      <a class="accordion-toggle according-toogle-ch" data-toggle="collapse" data-parent="#accordion" href="#collapseOne<?php echo $i; ?>">
                                        <?php echo htmlentities($hc->intitule); ?>
                                        <span class="chevron-action-collapse-hc">
                                          <img src="assets/icons-f2+/historique_de_cours/ico-arrowdown-coursehistory.png" class="user-image img-home">
                                        </span>
                                      </a>
                                    </div>
                                  </div>
                                </h4>
                              </div>
                              <div id="collapseOne<?php echo $i; ?>" class="panel-collapse collapse">
                                <div class="panel-body" style="padding: 10px 0px 10px 0 !important;">
                                  <?php 
                                    $todoResults = $this->todolist_model->TrainingProgTuteurInCoursHistorikAndUserCreate($otherProfessorId,$this->session->userdata ('STAGIAIREGRP'),$hc->id);

                                    $pageResult = $this->coursHistorik_model->getPageByIdCoursHistorik($hc->id);

                                    $nlhc = $this->historik_course_nl_model->getByUserCreateIdGroupIdHc($otherProfessorId,$this->session->userdata ('STAGIAIREGRP'),$hc->id);
                                  ?>
                                  <?php foreach ($todoResults as $record) {
                                      if ($record->isDone == 1) {
                                          $checked = "checked='checked'";
                                      }
                                      else{
                                          $checked = "";
                                      }

                                      $thumbnail      =  RP_GROUPES."GRPT".$record->user_create.'/THUMBNAIL'.$record->user_create.'/'.$record->thumbnail_file;
                                      if ($record->thumbnail_file != ''  && file_exists($thumbnail)) {
                                          $images = base_url()."groupes/GRPT".$record->user_create.'/THUMBNAIL'.$record->user_create.'/'.$record->thumbnail_file;
                                      }
                                      else{
                                          $images =  base_url()."groupes/default.png"; 
                                      }


                                      $linkF = '';
                                      $local_files = '';
                                      $extention = '';

                                      $urlTodo1 = $record->link;
                                      if ($this->todolist_model->RequestNewSequence('type',$record->num_sequence) == 0 && strpos($urlTodo1, 'youtube') === false && strpos($urlTodo1, 'youtu.be') === false && strpos($urlTodo1, 'vimeo.com') === false && strpos($urlTodo1, 'facebook.com') === false && strpos($urlTodo1, 'dailymotion.com') === false) {
                                          $linkF = $record->url;
                                      }
                                      elseif ($this->todolist_model->RequestNewSequence('type',$record->num_sequence) == 0 && (strpos($urlTodo1, 'vimeo.com') !== false || strpos($urlTodo1, 'facebook.com') !== false || strpos($urlTodo1, 'dailymotion.com') !== false || strpos($urlTodo1, 'youtube') !== false || strpos($urlTodo1, 'youtu.be') !== false)) {
                                          $linkF = getEmbedUrl($urlTodo1);
                                      }            
                                      elseif (($this->todolist_model->RequestNewSequence('type',$record->num_sequence) != 0 && file_exists(RP_GROUPES.'GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1)) && (strpos(HTTP_MAIN.'groupes/GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1, '.doc') !== false) || (strpos(HTTP_MAIN.'groupes/GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1, '.docx') !== false) || (strpos(HTTP_MAIN.'groupes/GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1, '.ppt') !== false) || (strpos(HTTP_MAIN.'groupes/GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1, '.pdf') !== false)){

                                          $linkF = HTTP_MAIN.'groupes/GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1;
                                          $local_files = 'groupes/GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1;
                                          //$linkFile = "https://docs.google.com/gview?url=".HTTP_MAIN.'groupes/GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1."&amp;embedded=true";
                                          $extension = pathinfo(basename($local_files), PATHINFO_EXTENSION);
                                          if ($extension == 'PNG' || $extension == 'png' || $extension == 'JPEG' || $extension == 'jpeg' || $extension == 'JPG' || $extension == 'jpg' || $extension == 'gif' || $extension == 'GIF') {
                                            $extention = '&data-type=images';
                                          }
                                          else{
                                            $extention = '&data-type=doc';
                                          }
                                      }
                                      elseif($this->todolist_model->RequestNewSequence('type',$record->num_sequence) != 0 && !file_exists(RP_GROUPES.'GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1)){
                                        $linkF = 'No_file';
                                      }
                                      else{
                                          $linkF = HTTP_MAIN.'groupes/GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1;
                                          $local_files = 'groupes/GRPT'.$record->user_create.'/documentTodo/'.$urlTodo1;
                                          $extension = pathinfo(basename($local_files), PATHINFO_EXTENSION);
                                          if ($extension == 'PNG' || $extension == 'png' || $extension == 'JPEG' || $extension == 'jpeg' || $extension == 'JPG' || $extension == 'jpg' || $extension == 'gif' || $extension == 'GIF') {
                                            $extention = '&data-type=images';
                                          }
                                          else{
                                            $extention = '&data-type=doc';
                                          }
                                      }

                                      $commentsF = '';
                                      if (strpos($record->comment, 'MID') === false) {
                                        $commentsF = $record->comment;
                                      }
                                      else{
                                        $ce = explode("MID", $record->comment);
                                        $r1 = str_replace("<", "", $ce[1]);
                                        $r2 = str_replace(">", "", $r1);
                                        $commentsF = str_replace("FIN", "", $r2);
                                      }
                                  ?>
                                    <div class="row">
                                        <div class="col-sm-12 col-parents-label-todo">
                                            <div class="col-md-4 col-action-label-todo">
                                                <div class="form-check form-action-label-todo">
                                                    <label class="form-check-label" for="exampleCheck1"><?php echo $this->lang->line('course_history_finished'); ?></label>
                                                    <?php if ($record->isDone == 1) { ?>
                                                      <img  data-id="<?php echo $record->id_plan_de_travail; ?>" src="assets/icons-f2+/historique_de_cours/finished.png" alt="User elearning" class="user-image finishedtodo">
                                                    <?php } else { ?>        
                                                      <input type="checkbox" disabled data-id="<?php echo $record->id_plan_de_travail; ?>" name="finishedtodo" <?php echo $checked; ?> class="finishedtodo form-check-input">
                                                    <?php } ?>

                                                    <img  data-title="<?php echo $record->titre; ?>" data-id="<?php echo $record->id_plan_de_travail; ?>" src="assets/icons-f2+/historique_de_cours/favorite.png" alt="User elearning" class="user-image icons-favorites-todo">
                                                </div>
                                            </div>
                                            <div class="col-md-5">
                                              <textarea name="comment" style="border-radius: 16px;font-size: 12px;" data-id="<?php echo $record->id_plan_de_travail; ?>" data-id-seq="<?php echo $record->id; ?>" rows="8" cols="33" class="form-control comment-todo" value="<?php echo $commentsF; ?>"><?php echo $commentsF; ?></textarea>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="container-image hovereffect">
                                                  <img class="image-timthumb img-vignette" style="border-radius: 20px !important; max-width: 100% !important;" title="<?php echo $record->titre; ?>" alt="Avatar" src="<?php echo $images; ?>">
                                                  <div class="overlay overlay-todo-in-cours-historik" data-ch="<?php echo $hc->id; ?>" data-local-file="<?php echo $local_files; ?>" data-acess="<?php echo base_url() ;?>read-todo-in-tutor?id=<?php echo $record->id_plan_de_travail;?><?php echo $local_files != '' ? '&local-data=blam' : ''; echo $extention; ?>" data-link="<?php echo $linkF; ?>" data-id-plan="<?php echo $record->id_plan_de_travail; ?>">
                                                  </div>
                                                </div> 
                                                <div class="legend title-vignette"><span class="titleTumbnail"><?php echo $record->titre; ?></span></div>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                  <?php } ?>

                                  <?php foreach ($nlhc as $record) {
                                      if ($record->isDone == 1) {
                                          $checked = "checked='checked'";
                                      }
                                      else{
                                          $checked = "";
                                      }

                                      $thumb = $this->utilities_model->getthumbNL($record->id_article);

                                      if ($thumb == '') {
                                        $images =  base_url()."groupes/default.png"; 
                                      }
                                      elseif ($thumb != "" && is_file(REP_ACTIVITY_SEQUENCE.$thumb)) {
                                         $images  = base_url()."groupes/ACTIVITES/".$thumb;
                                      }
                                      else{
                                          $images =  base_url()."groupes/default.png"; 
                                      }

                                      $linkF = base_url().'read-data?id='.$record->id_article.'&id_h_c='.$hc->id;

                                      $commentsF = '';
                                      if (strpos($record->comment, 'MID') === false) {
                                        $commentsF = $record->comment;
                                      }
                                      else{
                                        $ce = explode("MID", $record->comment);
                                        $r1 = str_replace("<", "", $ce[1]);
                                        $r2 = str_replace(">", "", $r1);
                                        $commentsF = str_replace("FIN", "", $r2);
                                      }
                                  ?>
                                  <div class="row">
                                      <div class="col-sm-12 col-parents-label-todo">
                                          <div class="col-md-4 col-action-label-todo">
                                              <div class="form-check form-action-label-todo">
                                                  <label class="form-check-label" for="exampleCheck1"><?php echo $this->lang->line('course_history_finished'); ?></label>
                                                  <?php if ($record->isDone == 1) { ?>
                                                    <img  data-id="<?php echo $record->id; ?>" src="assets/icons-f2+/historique_de_cours/finished.png" alt="User elearning" class="user-image finishedtodo">
                                                  <?php } else { ?>        
                                                    <input type="checkbox" disabled data-id="<?php echo $record->id; ?>" name="finishedtodo" <?php echo $checked; ?> class="finishedtodo form-check-input" data-type="artcile">
                                                  <?php } ?>

                                                  <img  data-type="artcile" data-title="<?php echo $this->newsletter_model->Request('article',$record->id_article); ?>" data-id="<?php echo $record->id_article; ?>" src="assets/icons-f2+/historique_de_cours/favorite.png" alt="User elearning" class="user-image icons-favorites-todo">
                                              </div>
                                          </div>
                                          <div class="col-md-5">
                                            <textarea  data-type="artcile" name="comment" style="border-radius: 16px;font-size: 12px;" data-id="<?php echo $record->id; ?>" data-id-seq="<?php echo $record->id; ?>" rows="8" cols="33" class="form-control comment-todo" value="<?php echo $commentsF; ?>"><?php echo $commentsF; ?></textarea>
                                          </div>
                                          <div class="col-md-3">
                                              <div class="container-image hovereffect" style="cursor: pointer;" onclick="window.location.replace('<?php echo $linkF; ?>');">
                                                <img class="image-timthumb img-vignette" style="border-radius: 20px !important; max-width: 100% !important;" title="<?php echo $this->newsletter_model->Request('article',$record->id_article); ?>" alt="Avatar" src="<?php echo $images; ?>">
                                                <div class="overlay">
                                                </div>
                                              </div> 
                                              <div class="legend title-vignette"><span class="titleTumbnail"><?php echo $this->newsletter_model->Request('article',$record->id_article); ?></span></div>
                                          </div>
                                      </div>
                                  </div>
                                  <hr>
                                  <?php } ?>
                                  <?php foreach ($pageResult as $page) { ?>                              
                                    <div class="row row_page_list">
                                      <div class="col-xs-12 btn btn-action-page text-center">
                                        <div class="modal fade modal_read_content_of_page" id="modal_read_content_of_page" role="dialog">
                                          <div class="modal-dialog modal_dialog_read_content_of_page modal-lg">
                                            <div class="modal-content">
                                              <div class="modal-header">
                                                <button type="button" class="close close-modal-confirm-action" data-dismiss="modal">&times;</button>
                                                <h4 class="modal-title text-center confirmation"><?php echo $this->lang->line('course_history_page_content'); ?><br>
                                                </h4>
                                              </div>
                                              <div class="modal-body">
                                                <div class="content_of_select_page">   
                                                  <div class="form-page-editor">      
                                                    <form name="edit-page-loop" id="edit-page-loop" class="edit-page-loop" action="<?php echo base_url(); ?>update-page-historik-cours" method="post">
                                                      <input type="hidden" name="content_page_ch_form">
                                                      <input type="hidden" name="id_page_hc" class="id_page_hc" value="<?php echo $page->id ; ?>">
                                                      <div class="row">
                                                        <div class="col-sm-12">
                                                          <textarea name="comment-page" style="border-radius: 16px;font-size: 12px;" data-id="<?php echo $page->id; ?>" rows="3" cols="33" class="form-control comment-page" value="<?php echo $page->comment; ?>"><?php echo htmlentities($page->comment); ?></textarea>
                                                        </div>
                                                      </div>
                                                      <br>
                                                      <div class="row">
                                                        <div class="col-sm-12 col-parents-label-todo">
                                                          <textarea data-auto="<?php echo $nb_page ?>" class="form-control page-edit-content edit-page-view<?php echo $nb_page ?>" id="edit-page-view<?php echo $nb_page ?>" name="edit-page-view<?php echo $nb_page ?>" value="<?php echo htmlentities($page->content); ?>"><?php echo htmlentities($page->content); ?></textarea>
                                                        </div>
                                                      </div>
                                                      <br>
                                                      <div class="text-center btn-action-page-edit">
                                                        <input type="submit" class="btn btn-success btn-save-modif-in-page-hc btn-action-el-ok" id="btn-save-modif-in-page-hc<?php echo $i;?>" value="Save modification">
                                                        <button type="button" class="btn btn-secondary btn-resufe-ch btn-action-el-cancel" data-dismiss="modal"><?php echo $this->lang->line('close_modal'); ?></button>
                                                      </div>
                                                    </form>
                                                  </div>
                                                </div>
                                              </div>
                                            </div>    
                                          </div>
                                        </div>
                                        <a href="#" class="btn btn-action-el-cancel btn-open-page">
                                          <?php echo htmlentities($page->comment); ?>
                                          <input type="hidden" name="current-bn-page" value="<?php echo $nb_page; ?>" class="current-bn-page">
                                        </a>
                                      </div>
                                    </div>
                                    <hr>
                                  <?php $nb_page++; } ?>
                                </div>
                              </div>
                            </div>
                        </div>
                      </div>
                    <?php $i++; } ?>
                  <?php } else { ?>
                    <div class="text-center no-result">
                      <?php echo $this->lang->line('course_history_nothing_data_trainee'); ?>
                    </div>
                  <?php } ?>
                </div>
              </div>
            </div>
      <?php } $counter++; } } ?>
    </div>
  </section>
</div>
<div id="modal_todo" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <input type="hidden" name="id_plan_d_w" class="id_plan_d_w">
            <div class="modal-body">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <?php echo $this->lang->line('other_delete_infos_confirm'); ?>
            </div>
            <div class="modal-footer">
                <button type="button" data-dismiss="modal" class="btn btn-danger btn-action-el-cancel"><?php echo $this->lang->line('modal_confirm_no'); ?></button>
                <button type="button" class="btn btn-primary btn-delete-todo btn-action-el-ok"><?php echo $this->lang->line('modal_confirm_yes'); ?></button>
            </div>
        </div>
    </div>
</div>
<div id="modal_cours_histori" class="modal fade">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close close-modal-classification" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><?php echo $this->lang->line('other_create_a_new_ch'); ?><br>
                <small><?php echo $this->lang->line('other_create_a_new_ch_infos'); ?></small>
                </h4>
            </div>
            <div class="modal-body">
                <div class="message_alert_ch"></div>
                <div class="row">
                  <div class="col-sm-9">
                    <div class="form-group row">
                        <div class="input-group group-data-ch">
                          <span class="input-group-addon lesson-label-disabled" id="basic-addon1"><?php echo $this->lang->line('other_create_a_new_ch_label_lesson'); ?></span>
                          <input type="text" class="form-control num_lesson" placeholder="Ex : 5/10" aria-describedby="basic-addon1">
                          <span class="input-group-addon" id="basic-addon1"><?php echo $this->lang->line('other_create_a_new_ch_of'); ?></span>
                          <input type="text" class="form-control date_lesson" name="date_lesson" id="date_lesson" placeholder="Ex : <?php echo date('m/d/Y'); ?>">
                          <span class="input-group-addon" id="basic-addon1">:</span>
                          <input type="text" class="form-control inputItem inputItemLesson" name="inputItem" id="inputItem" placeholder="Ex: Grammar lesson">
                        </div>
                    </div>
                  </div>
                  <div class="col-sm-3">
                    <div class="form-group row">
                        <label for="inputItem" class="col-sm-7 col-form-label"><?php echo $this->lang->line('other_create_a_new_ch_label_color'); ?></label>
                        <div class="col-sm-5">
                            <input type="color" class="form-control back_color" name="back_color" id="back_color">
                        </div>
                    </div>
                  </div>
                </div>
                <!--div class="form-group row">
                    <div class="col-sm-12">
                        <textarea class="form-control inputComment" rows="5" name="inputComment" id="inputComment" placeholder="Comment"></textarea>
                    </div>
                </div-->             
            </div>
            <div class="modal-footer">
                <div class="row">
                    <div class="col-sm-12 text-center">
                        <button type="button" class="btn btn-primary btn-save-new-cours-histori btn-action-el-ok"><?php echo $this->lang->line('menu_rigth_btn_save'); ?></button>
                        <button type="button" data-dismiss="modal" class="btn btn-default btn-close-modal-cours btn-action-el-cancel"><?php echo $this->lang->line('my_link_and_document_cancel_btn'); ?></button>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<div id="modal_todo_in_historik_cours" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close close-modal-seq-h" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><?php echo $this->lang->line('other_add_exercice_to_ch_info'); ?></small>
                </h4>
            </div>
            <div class="modal-body body-todo-in-historik-cours">
                <input type="hidden" name="id-cours-historik" class="id-cours-historik">            
            </div>
        </div>
    </div>
</div>
<div id="modal_todo_doc_and_link" class="modal fade">
    <div class="modal-dialog dialog-edit-course-history modal-lg <?php echo $this->session->userdata ('site_lang') == 'french' ? 'modal-view-fr' : '' ?>">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close close-modal-classification" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><?php echo $this->lang->line('other_add_exercice_to_ch_infos_modal'); ?>
                </h4>
            </div>
            <div class="modal-body">
                <div class="message"></div>
                <ul class="nav nav-tabs">
                    <li class="active"><a data-toggle="tab" href="#pedagogicalTraining"><i class="glyphicon glyphicon-plus-sign"></i>&nbsp;<?php echo $this->lang->line('educational_library_pedagogical_training'); ?></a></li>
                    <!--li><a data-toggle="tab" href="#exercises"><i class="glyphicon glyphicon-plus-sign"></i>&nbsp;Exercises</a></li>
                    <li><a data-toggle="tab" href="#linkAndDocsExist"><i class="glyphicon glyphicon-plus-sign"></i>&nbsp;Unclassified link & document</a></li-->
                    <li><a data-toggle="tab" href="#personnalinterest"><i class="glyphicon glyphicon-plus-sign"></i>&nbsp;<?php echo $this->lang->line('educational_library_personnal_interest'); ?></a></li>
                    <li><a data-toggle="tab" href="#newsletterofthemonth"><i class="glyphicon glyphicon-plus-sign"></i>&nbsp;Newsletter</a></li>
                    <li><a data-toggle="tab" href="#databaseDocument"><i class="glyphicon glyphicon-plus-sign"></i>&nbsp;<?php echo $this->lang->line('educational_library_my_link_and_document'); ?></a></li>
                    <li><a data-toggle="tab" href="#teacherLinkAndDocument"><i class="glyphicon glyphicon-plus-sign"></i>&nbsp;<?php echo $this->lang->line('educational_library_teacher_link_and_document'); ?></a></li>
                    <li><a data-toggle="tab" href="#pages"><i class="glyphicon glyphicon-plus-sign"></i>&nbsp;<?php echo $this->lang->line('other_ch_new_page'); ?></a></li>
                </ul>

                <div class="tab-content">
                  
                  <div class="notification-data-lib notification"></div>
                  <div id="pedagogicalTraining" class="tab-pane fade in active">                      
                      <h4>
                          <div class="form-group row">
                              <label for="pedagogical_training" class="col-sm-4 col-form-label"><?php echo $this->lang->line('educational_library_pedagogical_training'); ?>&nbsp;</label>
                              <div class="col-sm-6">
                                  <input list="pedagogical_training" onchange="refreshDataPdg(this);" class="pedagogical_training_choice form-control" id="pedagogical_training_choice" name="pedagogical_training_choice" />
                                  <datalist id="pedagogical_training">
                                  </datalist>
                              </div>
                              <div class="col-sm-2">
                                  <input type="button" name="" value="<?php echo $this->lang->line('label_search'); ?>" class="btn btn-success btn-search-pdg btn-action-el-ok">
                              </div>
                          </div>
                      </h4>
                      <div class="pedagogical-training-todo"></div>
                  </div>
                  <div id="databaseDocument" class="tab-pane fade">
                      <h4>
                          <div class="form-group row">
                              <label for="database_document_choice" class="col-sm-4 col-form-label"><?php echo $this->lang->line('educational_library_my_link_and_document'); ?>&nbsp;</label>
                              <div class="col-sm-6">
                                  <input list="database_document_search" onchange="refreshDataLinkAndDocs(this);" class="database_document_choice form-control" id="database_document_choice" name="database_document_choice" />
                                  <datalist id="database_document_search">
                                  </datalist>
                              </div>
                              <div class="col-sm-2">
                                  <input type="button" name="" value="<?php echo $this->lang->line('label_search'); ?>" class="btn btn-success btn-search-document-and-link btn-action-el-ok">
                              </div>
                          </div>
                      </h4>
                      <div class="database-document-exist"></div>                    
                  </div>
                  <div id="personnalinterest" class="tab-pane fade">
                      <h4>
                          <div class="form-group row">
                              <label for="personnal_interest" class="col-sm-4 col-form-label"><?php echo $this->lang->line('educational_library_personnal_interest'); ?>&nbsp;</label>
                              <div class="col-sm-6">
                                  <input list="personnal_interest_data_list" onchange="refreshDataPers(this);" class="personnal_interest form-control" id="personnal_interest" name="personnal_interest" />
                                  <datalist id="personnal_interest_data_list">
                                  </datalist>
                              </div>
                              <div class="col-sm-2">
                                  <input type="button" name="" value="<?php echo $this->lang->line('label_search'); ?>" class="btn btn-success btn-search-document-personnel btn-action-el-ok">
                              </div>
                          </div>
                      </h4>
                      <div class="personnal_interest_list"></div>                    
                  </div>
                  <div id="newsletterofthemonth" class="tab-pane fade">
                      <h4>
                          <div class="form-group row">
                              <label for="database_document_choice" class="col-sm-4 col-form-label"><?php echo $this->lang->line('other_article_of_newsletter'); ?>&nbsp;</label>
                              <div class="col-sm-6">
                                  <input list="newsletter_of_the_month" onchange="refreshDataNL(this);" class="newsletter_of_the_months form-control" id="newsletter_of_the_months" name="newsletter_of_the_months" />
                                  <datalist id="newsletter_of_the_month">
                                  </datalist>
                              </div>
                              <div class="col-sm-2">
                                  <input type="button" name="" value="<?php echo $this->lang->line('label_search'); ?>" class="btn btn-success btn-search-document-nl btn-action-el-ok">
                              </div>
                          </div>
                      </h4>
                      <div class="newsletterofthemonth"></div>                    
                  </div>
                  <div id="teacherLinkAndDocument" class="tab-pane fade">
                      <div class="message-confirmation-action"></div>
                      <h4>
                          <div class="form-group row">
                              <label for="todolist_choice" class="col-sm-4 col-form-label"><?php echo $this->lang->line('educational_library_teacher_link_and_document'); ?>&nbsp;</label>
                              <div class="col-sm-6">
                                  <input list="todolist_search" onchange="refreshDataTodo(this);" class="todolist_choice form-control" id="todolist_choice" name="todolist_choice" />
                                  <datalist id="todolist_search">
                                  </datalist>
                              </div>
                              <div class="col-sm-2">
                                  <input type="button" name="" value="<?php echo $this->lang->line('label_search'); ?>" class="btn btn-success btn-search-todo btn-action-el-ok">
                              </div>
                          </div>
                      </h4>
                      <div class="exercices-todo"></div>
                  </div>
                  <div id="pages" class="tab-pane fade">
                      <h4>
                        <div class="form-group row">
                          <label for="database_document_choice" class="col-sm-12 col-form-label"><?php echo $this->lang->line('other_ch_new_page'); ?>&nbsp;</label>
                        </div>                              
                      </h4>
                      <!--link rel="stylesheet" href="<?php echo base_url(); ?>assets/themes/commun/html-editor/css/font-awesome.min.css">
                      <link rel="stylesheet" href="<?php echo base_url(); ?>assets/themes/commun/html-editor/css/froala_editor.css">
                      <link rel="stylesheet" href="<?php echo base_url(); ?>assets/themes/commun/html-editor/css/froala_style.css">
                      <link rel="stylesheet" href="<?php echo base_url(); ?>assets/themes/commun/html-editor/css/plugins/code_view.css">
                      <link rel="stylesheet" href="<?php echo base_url(); ?>assets/themes/commun/html-editor/css/plugins/colors.css">
                      <link rel="stylesheet" href="<?php echo base_url(); ?>assets/themes/commun/html-editor/css/plugins/emoticons.css">
                      <link rel="stylesheet" href="<?php echo base_url(); ?>assets/themes/commun/html-editor/css/plugins/image_manager.css">
                      <link rel="stylesheet" href="<?php echo base_url(); ?>assets/themes/commun/html-editor/css/plugins/image.css">
                      <link rel="stylesheet" href="<?php echo base_url(); ?>assets/themes/commun/html-editor/css/plugins/line_breaker.css">
                      <link rel="stylesheet" href="<?php echo base_url(); ?>assets/themes/commun/html-editor/css/plugins/table.css">
                      <link rel="stylesheet" href="<?php echo base_url(); ?>assets/themes/commun/html-editor/css/plugins/char_counter.css">
                      <link rel="stylesheet" href="<?php echo base_url(); ?>assets/themes/commun/html-editor/css/plugins/video.css">
                      <link rel="stylesheet" href="<?php echo base_url(); ?>assets/themes/commun/html-editor/css/plugins/fullscreen.css">
                      <link rel="stylesheet" href="<?php echo base_url(); ?>assets/themes/commun/html-editor/css/plugins/quick_insert.css">
                      <link rel="stylesheet" href="<?php echo base_url(); ?>assets/themes/commun/html-editor/css/plugins/file.css">

                      <link rel="stylesheet" href="<?php echo base_url(); ?>assets/themes/commun/html-editor/css/themes/dark.css">

                      <link rel="stylesheet" href="<?php echo base_url(); ?>assets/themes/commun/html-editor/css/codemirror.min.css"-->
                      <script src="https://cdn.tiny.cloud/1/gqu38uxlevac9nkldsvejhmku689ltgi1n23hdff3jgi1u84/tinymce/5/tinymce.min.js" referrerpolicy="origin"></script>
                      <!--script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/dist/js/tinymce.min.js"></script-->

                      <form class="form-page-historik-cours" method="post" name="form-page-historik-cours" id="form-page-historik-cours" action="<?php echo base_url(); ?>add-page-historik-cours" enctype='multipart/form-data'>
                        <input type="hidden" name="id-cours-historik" class="id-cours-historik" value="">
                        <p><textarea class="form-control edit-page-comment" name="edit-page-comment" id="edit-page-comment" placeholder="<?php echo $this->lang->line('course_history_page_title'); ?>"></textarea></p>
                        <p><textarea class="form-control edit-page" id="edit-page" name="edit-page"></textarea></p>
                        <p style="text-align: center;"><label class="label-send-mail"><input type="checkbox" name="send_mail" id="send_mail"> <?php echo $this->lang->line('el_send_mail_infos_notify_owner'); ?></label>&nbsp;&nbsp;<input type="submit" class="btn btn-success btn-add-page-in-course-history btn-action-el-ok" value="<?php echo $this->lang->line('menu_rigth_btn_save'); ?>"></p>
                      </form>

                      <!--script type="text/javascript"
                        src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/codemirror.min.js"></script>
                      <script type="text/javascript"
                        src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/xml.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/froala_editor.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/align.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/code_beautifier.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/code_view.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/colors.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/draggable.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/emoticons.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/font_size.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/font_family.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/image.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/file.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/image_manager.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/line_breaker.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/link.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/lists.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/paragraph_format.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/paragraph_style.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/video.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/table.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/url.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/entities.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/char_counter.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/inline_style.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/save.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/fullscreen.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/quick_insert.min.js"></script>
                      <script type="text/javascript" src="<?php echo base_url(); ?>assets/themes/commun/html-editor/js/plugins/quote.min.js"></script-->
                      <script>
                        (function () {
                          /*new FroalaEditor("#edit-page,.edit-page-view", {
                            theme: 'gray'
                          });*/
                          <?php for ($p = 0; $p < $nb_page; $p++) { ?>
                            tinymce.init({
                              selector: 'textarea#edit-page-view<?php echo $p; ?>',
                              plugins: [
                                'advlist autolink link image lists charmap print preview hr anchor pagebreak',
                                'searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking',
                                'table emoticons template paste help'
                              ],
                              toolbar: 'undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | print preview media fullscreen | forecolor backcolor emoticons | help',
                              menu: {
                                favs: {title: 'My Favorites', items: 'code visualaid | searchreplace | emoticons'}
                              },
                              menubar: 'favs file edit view insert format tools table help',
                              /*content_css: 'css/content.css',*/
                              toolbar_mode: 'floating',
                              tinycomments_mode: 'embedded',
                              tinycomments_author: 'Author name',
                              branding: false,
                            });
                          <?php } ?>
                          tinymce.init({
                            selector: 'textarea#edit-page',
                            plugins: [
                              'advlist autolink link image lists charmap print preview hr anchor pagebreak',
                              'searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking',
                              'table emoticons template paste help'
                            ],
                            toolbar: 'undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | print preview media fullscreen | forecolor backcolor emoticons | help',
                            menu: {
                              favs: {title: 'My Favorites', items: 'code visualaid | searchreplace | emoticons'}
                            },
                            menubar: 'favs file edit view insert format tools table help',
                            /*content_css: 'css/content.css',*/
                            toolbar_mode: 'floating',
                            tinycomments_mode: 'embedded',
                            tinycomments_author: 'Author name',
                            branding: false,
                          });
                        })();
                      </script>
                  </div>
                </div>        
            </div>
            <div class="modal-footer">
                <div class="row">
                    <div class="col-sm-12 text-center">
                        <button type="button" data-dismiss="modal" class="btn btn-default btn-close-modal-todo btn-action-el-cancel"><?php echo $this->lang->line('close_modal_pr'); ?></button>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<div class="modal fade modal_classification_favoris" id="modal_classification_favoris" role="dialog" style="display: none;">
  <div class="modal-dialog modal_classification_favorites">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close close-modal-classification" data-dismiss="modal">&times;</button>
        <h4 class="modal-title"><?php echo $this->lang->line('modal_title_add_favorites_and_classification'); ?><br>
        <small><?php echo $this->lang->line('my_link_and_document_add_favorites_fav_infos'); ?></small>
        </h4>
      </div>
      <div class="modal-body">
        <div class="text-center">
          <form class="navbar-form" role="Classroom" method="post" action="<?php echo base_url(); ?>classify">
            <input type="hidden" name="program_stat_id" id="program_stat_id" class="program_stat_id">
            <div class="form-group" style="max-width: 459px ​!important;">
              <select class="form-control classification" id="classification" name="classification" style="width: 100% !important;padding: 6px 12px !important;height: 34px !important;">
                <?php foreach ($classification_favoris as $res) { ?>
                  <option value="<?php echo $res->id; ?>"><?php echo htmlentities($res->intitule); ?></option>
                <?php } ?>
              </select>
            </div>
            <button type="submit" class="btn btn-primary btn-save-classification btn-action-el-ok"><?php echo $this->lang->line('modal_btn_classify'); ?></button>
          </form>
        </div>
      </div>
    </div>    
  </div>
</div>
<div class="modal fade modal_confirm_action_access_link" id="modal_confirm_action_access_link" role="dialog" style="display: none;">
  <div class="modal-dialog modal_confirm_action_access_link_todo">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close close-modal-confirm-action" data-dismiss="modal">&times;</button>
        <h4 class="modal-title text-center confirmation"><?php echo $this->lang->line('modal_confirm_title'); ?><br>
        </h4>
      </div>
      <div class="modal-body">
        <p class="alert-confirmation"><?php echo $this->lang->line('modal_confirm_link_status'); ?></p>
        <input type="hidden" name="url_access_confirmation" class="url_access_confirmation" value="http://www.cityu.edu.hk/lc/quiz/subverb1.htm">
      </div>
      <div class="modal-footer">
        <div class="text-center">
          <button type="button" class="btn btn-secondary btn-resufe-ch btn-action-el-cancel" data-dismiss="modal"><?php echo $this->lang->line('modal_confirm_no'); ?></button>
          <button type="button" class="btn btn-primary btn-confirm-yes-ch btn-action-el-ok"><?php echo $this->lang->line('modal_confirm_yes'); ?></button>
          <button type="button" class="btn btn-primary btn-confirm-ok-ch btn-action-el-ok" style="display: none;" data-dismiss="modal"><?php echo $this->lang->line('modal_confirm_ok'); ?></button>
        </div>
      </div>
    </div>    
  </div>
</div>

<div id="modal_duplicate_session_course_historik" class="modal fade">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close close-modal-classification" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><?php echo $this->lang->line('other_duplicate_ch_info'); ?>
                </h4>
            </div>
            <div class="modal-body">
                <div class="message_alert_ch"></div>
                <div class="row">
                  <div class="col-sm-7">
                    <div class="form-group row">
                        <div class="input-group group-data-ch">
                          <span class="input-group-addon lesson-label-disabled" id="basic-addon1">Lesson n°</span>
                          <input type="text" class="form-control num_lesson_session" name="num_lesson_session" placeholder="Ex : 5/10" aria-describedby="basic-addon1">
                          <span class="input-group-addon" id="basic-addon1">of</span>
                          <input type="text" class="form-control date_lesson_session" name="date_lesson_session" id="date_lesson_session" placeholder="Ex : <?php echo date('m/d/Y'); ?>">
                          <span class="input-group-addon" id="basic-addon1">:</span>
                          <input type="text" class="form-control inputItemSession" name="inputItemSession" id="inputItemSession" placeholder="Ex: Grammar lesson">
                        </div>
                    </div>
                  </div>
                  <div class="col-sm-2">
                    <div class="form-group row">
                        <label for="inputItem" class="col-sm-5 col-form-label"><?php echo $this->lang->line('other_choose_a_theme'); ?></label>
                        <div class="col-sm-7">
                            <input type="color" class="form-control back_color_session" name="back_color_session" id="back_color_session">
                        </div>
                    </div>
                  </div>
                  <div class="col-sm-3">
                    <div class="form-group row">
                        <label for="inputItem" class="col-sm-4 col-form-label"><?php echo $this->lang->line('other_trainee'); ?></label>
                        <div class="col-sm-8">
                            <select class="form-control trainee_session" name="trainee_session" id="trainee_session">
                              <option><?php echo $this->lang->line('other_choose_a_trainee'); ?></option>
                              <?php foreach ($allTraineeFromSession as $value){ ?>
                                <option <?php echo $value['id_groupe']==$this->session->userdata ('STAGIAIREGRP') ? 'selected' : '' ?> data-groupe="<?php echo $value['id_groupe']; ?>" value="<?php echo $value['id']; ?>"><?php echo utf8_decode($value['name']); ?></option>
                              <?php } ?>  
                            </select>
                        </div>
                    </div>
                  </div>
                </div>           
            </div>
            <div class="modal-footer">
                <div class="row">
                    <div class="col-sm-12 text-center">
                        <input type="hidden" name="session_ch_id" id="session_ch_id">
                        <button type="button" class="btn btn-primary btn-duplicate-session-cours-histori btn-action-el-ok"><?php echo $this->lang->line('other_duplicate'); ?></button>
                        <button type="button" data-dismiss="modal" id="btn-close-modal-duplicate" class="btn btn-default btn-action-el-cancel"><?php echo $this->lang->line('my_link_and_document_cancel_btn'); ?></button>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<div class="modal fade modal_dialog_send_mail" id="modal_dialog_send_mail" role="dialog" style="display: none;">
  <div class="modal-dialog modal-send-mail">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close close-modal-confirm-action" data-dismiss="modal">&times;</button>
        <h4 class="modal-title text-center confirmation"><?php echo $this->lang->line('el_send_mail_infos_confirm'); ?><br>
        </h4>
      </div>
      <div class="modal-body">
        <h4 class="infos infos-warning question-send-mail"><?php echo $this->lang->line('el_send_mail_infos_confirm_send_ch'); ?> "<?php echo $this->lang->line('modal_confirm_yes'); ?>"</h4>
        <input type="hidden" name="idCourseHistory" id="idCourseHistory">
        <input type="hidden" name="idTodo" id="idTodo">
        <input type="hidden" name="data_type" id="data_type">
      </div>
      <div class="modal-footer">
        <div class="text-center">
          <a href="#" class="btn btn-primary btn-confirm-ok-send-mail-ch btn-action-el-ok"><?php echo $this->lang->line('modal_confirm_yes'); ?></a>
          <button type="button" class="btn btn-primary btn-action-el-cancel btn-cancel-send-mail-ch" data-dismiss="modal"><?php echo $this->lang->line('modal_confirm_no'); ?></button>
        </div>
      </div>
    </div>    
  </div>
</div>
<input type="hidden" name="current-page-open" class="current-page-open">

<script type="text/javascript">
  var el_send_mail_infos_ko_send = '<?php echo $this->lang->line('my_link_and_document_btn_new_doc'); ?>';
  var el_send_mail_infos_trainee_data = "<?php echo $this->lang->line('el_send_mail_infos_trainee_data').' '.$this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID')).' '.$this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID')).' < '.$this->membres_model->Request('email',$this->session->userdata ('STAGIAIREID')).' > ' ?>";
  var el_send_mail_infos_trainee_data_erno = "<?php echo $this->lang->line('el_send_mail_infos_trainee_data_erno'); ?>";
  var course_history_save_ok = "<?php echo $this->lang->line('course_history_save_ok'); ?>";
  var el_send_mail_infos_send_erno = "<?php echo $this->lang->line('el_send_mail_infos_send_erno'); ?>";
  var course_history_page_content_required = "<?php echo $this->lang->line('course_history_of'); ?>";
  var course_history_of = "<?php echo $this->lang->line('course_history_of'); ?>";
  var course_history_required_number_lesson = "<?php echo $this->lang->line('course_history_required_number_lesson'); ?>";
  var course_history_required_date_lesson = "<?php echo $this->lang->line('course_history_required_date_lesson'); ?>";
</script>

