let tabmain = document.querySelector('.tab-main');
let tablinks = document.querySelectorAll('.tablinks');
let tab_content = document.querySelectorAll('.tab-content');

document.addEventListener('click', e =>{
    const id = e.target.dataset.id;
    
    if(id && e.target.classList.contains('tablinks')){

        tablinks.forEach(btn => {
            btn.classList.remove('active');
        })
        e.target.classList.add('active')

        tab_content.forEach(content => {
            content.classList.remove('active');
        })

        let element = document.getElementById(id);
        element.classList.add('active')

        window.scroll(0, 0)
    }
});

$(document).ready(function(){
  $('#module_domaine').change(function(e){
    e.preventDefault();
    $('.spinner').fadeIn('slow');
    var optionMatiere = '<option value="0"></option>';
    var d = $(this);
    getOptionMatiereByDomaine(d.val(), 0,'module_matiere');    
  });

  $('#domaine_id').change(function(e){
    e.preventDefault();
    $('.spinner').fadeIn('slow');
    var optionMatiere = '<option value="0"></option>';
    var d = $(this);
    getOptionMatiereByDomaine(d.val(), 0,'matiere_id');    
  });

  $('#module_domaine_edit').change(function(e){
    e.preventDefault();
    $('.spinner').fadeIn('slow');
    var d = $(this);    
    getOptionMatiereByDomaine(d.val(), 0,'module_matiere_edit');    
  });

  $('.btn-open-modal-form-sequence').click(function(e){
    e.preventDefault();
    $('#modal-new-sequence').addClass('open');
  });

  $('#activite-form-modif').on('submit', function(e){
    e.preventDefault();
    $('.btn-save-form').addClass('d-none');
    $('.spinner-save-form').removeClass('d-none');
    $.ajax({
      url :         $(this).attr('action'),
      type:         $(this).attr('method'),
      data:         new FormData(this),
      processData:  false,
      contentType:  false,
      dataType: 'json',
      success: function(result){
        if (result.errors == true) {
          toastr.error(result.message);
        }
        else{
          toastr.success(result.message);
          $('#activite-form').trigger('reset');
          $('.default_choise_type').click();
        }

        $('.liste-content').click();

        $('.btn-view-detail-sequence').each(function(){
          var btn = $(this);
          if (btn.attr('data-active') == 'true') {
            btn.click();
            console.log('click');
          }
        });

        $('.btn-save-form').removeClass('d-none');
    $('.spinner-save-form').addClass('d-none');   
      },
      error: function(error, msg){
        $('.spinner').fadeOut('slow');
      }
    });
  });

  $('#activite-form').on('submit', function(e){
    e.preventDefault();
    $('.btn-save-form').addClass('d-none');
    $('.spinner-save-form').removeClass('d-none');
    $.ajax({
      url :         $(this).attr('action'),
      type:         $(this).attr('method'),
      data:         new FormData(this),
      processData:  false,
      contentType:  false,
      dataType: 'json',
      success: function(result){
        if (result.errors == true) {
          toastr.error(result.message);
        }
        else{
          toastr.success(result.message);
          $('#activite-form').trigger('reset');
          $('.default_choise_type').click();
        }

        $('.liste-content').click();

        $('.btn-view-detail-sequence').each(function(){
          var btn = $(this);
          if (btn.attr('data-active') == 'true') {
            btn.click();
            console.log('click');
          }
        });

        $('.btn-save-form').removeClass('d-none');
    $('.spinner-save-form').addClass('d-none');   
      },
      error: function(error, msg){
        $('.spinner').fadeOut('slow');
      }
   });
  });
  /*$('.label-input-file').click(function(e){
    e.preventDefault();
    var label = $(this);
    label.find('input').trigger('click');  
  });*/

  $('.btn-confirm-delete-select').click(function(e){
    e.preventDefault();
    $('.spinner').fadeOut('slow');
    var ret = false;
    $('.folder-checkbox').each(function(){
      var checkBox = $(this);
      if (checkBox.is(':checked')) {
        emptyAndDeleteSequence(checkBox.val());
        ret = true;
      }
    });

    if (ret == true) {
      $('#modal-confirm-suppression-selection').removeClass('open');
      toastr.error('Données supprimer avec succés.');
    }
  });

  $('.btn-confirm-delete-sequence').click(function(e){
    e.preventDefault();
    $('.spinner').fadeIn('show');
    emptyAndDeleteSequence($('#del_sequence_id').val());
    $('#modal-confirm-delete-sequence').removeClass('open');
    toastr.error('Données supprimer avec succés.');
  });

  $('.btn-confirm-delete-module').click(function(e){
    e.preventDefault();
    $('.spinner').fadeIn('show');
    emptyAndDeleteModule($('#del_module_id').val());
    $('#modal-confirm-delete-sequence').removeClass('open');
    toastr.error('Données supprimer avec succés.');
  });

  $('.btn-save-modif-sequence').click(function(e){
    e.preventDefault();
    var btn = $(this);
    if ($('#sequence_titre').val() == '') {
      toastr.error('Veuillez saisir le titre de la séquence');
    }
    else{
      $('.spinner').fadeIn('show');
      $.ajax({
        url        : "ajaxEditSequence",
        type       : 'POST',       
        data       : { idSequence: $('#sequence_id').val(), sequence_titre: $('#sequence_titre').val(), sequence_objectifs: $('#sequence_objectif').val(), sequence_module: $('#sequence_module').val() }, 
        dataType   : 'json',  
        success : function(data){
          console.log(data);
          $('.btn-modif-sequence').each(function(){
            var case_btn_action = $(this);
            if (case_btn_action.attr('data-active') == 'true') {
              case_btn_action.attr('data-title', $('#sequence_titre').val());
              case_btn_action.attr('data-objectifs',$('#sequence_objectif').val());
              case_btn_action.parents('.btn-group').parents('td').parents('.clsLineSequence').find('.clscasesequence').html($('#sequence_titre').val());
            }
          });
          $('#modal-modification-sequence').removeClass('open');
          toastr.success('Données enregister avec succés.')
          $('.spinner').fadeOut('slow');
        }
      });
    }
    
  });

  $('.btn-save-modif-module').click(function(e){
    e.preventDefault();
    var btn = $(this);
    if ($('#sequence_titre').val() == '') {
      toastr.error('Veuillez saisir l\'intitulé du module');
    }
    else{
      $('.spinner').fadeIn('show');

      var module_maj_formation_edit = false;
      $('.module_maj_formation_edit').each(function(){
        var radio = $(this);
        if (radio.is(':checked')) {
          module_maj_formation_edit = radio.val();
        }
      });

      $.ajax({
        url        : "ajax-edit-module",
        type       : 'POST',       
        data       : { module_maj_formation_edit: module_maj_formation_edit, module_id: $('#module_id').val(), module_titre: $('#module_titre_edit').val(), module_objectif: $('#module_objectif_edit').val(), module_domaine: $('#module_domaine_edit').val(), module_matiere: $('#module_matiere_edit').val() }, 
        dataType   : 'json',  
        success : function(data){
          $('.btn-modif-module').each(function(){
            var case_btn_action = $(this);
            if (case_btn_action.attr('data-active') == 'true') {
              case_btn_action.attr('data-title', $('#module_titre_edit').val());
              case_btn_action.attr('data-objectifs',$('#module_objectif_edit').val());
              case_btn_action.attr('data-domaine',$('#module_domaine_edit').val());
              case_btn_action.attr('data-matiere',$('#module_matiere_edit').val());
              case_btn_action.parents('.btn-group').parents('td').parents('.clsLineModule').find('.clscasesmodule').html($('#module_titre_edit').val());
            }
          });
          $('#modal-modification-sequence').removeClass('open');
          toastr.success('Données enregister avec succés.')
          $('.spinner').fadeOut('slow');
        }
      });
    }
    
  });
  $('#cancel-form').click(function(e){
    e.preventDefault();
    $('.liste-content').click();
  });

  $('#cancel-form-edit').click(function(e){
    e.preventDefault();
    $('.liste-content').click();
  });

  $('.activite_type').click(function(){
    var radio = $(this);
    if (radio.val() == '1') {
      $('.activite_content_link').removeClass('bo-d-none');
      $('.activite_content_file').addClass('bo-d-none');
    }
    else{
      $('.activite_content_file').removeClass('bo-d-none');
      $('.activite_content_link').addClass('bo-d-none');
    }
  });

  $('.check-all-control').click(function(){
    $( ".connexion-checkbox" ).click();
  });

  $('#btn-disconnect-other-user').click(function(e){
    var btn = $(this); 
    e.preventDefault();   
    $('.connexion-checkbox').each(function(){
      var checkBox = $(this);
      if (checkBox.is(':checked')) {
        checkBox.parents('.container-checkbox').parents('.tr_body_el').find('.case-btn-action').find('.btn-disconnect').click();
      }
    });
    btn.fadeOut('slow');
  });

  $('.generateThumbCkeck').click(function(){    
    $('.form-check-nl').each(function(){
      if ($(this).is(':checked')) {
        var monthId = $(this).parents('.caseCheck').find('.monthId').val();
        $('.spinner').fadeIn('show');
        $.ajax({
          url : "generateThumbNlByOrigin",
          type : 'POST',       
          data : { monthId: monthId, ACTION: "ALL" },   
          success : function(data){
            toastr.success('Données enregister avec succés.')
            $('.spinner').fadeOut('slow');
          }
        });
      }
    });
  });

  $('#startDate').each(function(){
     MCDatepicker.create({ 
      el: '#startDate',
      disableWeekends: true,
      autoClose: true,
      dateFormat: 'DD/MM/YYYY',
   })
  });

  $('#endDate').each(function(){
    MCDatepicker.create({ 
      el: '#endDate',
      disableWeekends: true,
      autoClose: true,
      dateFormat: 'DD/MM/YYYY',
    })
  });

  $('#expediteur_date_d1').each(function(){
     MCDatepicker.create({ 
      el: '#expediteur_date_d1',
      disableWeekends: true,
      autoClose: true,
      dateFormat: 'YYYY-MM-DD',
   })
  });

  $('#expediteur_date_d2').each(function(){
     MCDatepicker.create({ 
      el: '#expediteur_date_d2',
      disableWeekends: true,
      autoClose: true,
      dateFormat: 'YYYY-MM-DD',
   })
  });

  if($('.multiple-select-field').length >= '1'){
    var multipleCancelButton = new Choices('.multiple-select-field', {
      removeItemButton: true,
      maxItemCount:false,
      searchResultLimit:5,
    }); 
  }   

  $('.close-modal').click(function(e){
    $('.modal-close').click();
  });

  $('.modal-close').click(function(e){
    e.preventDefault();
    $(this).parents('.modal-header').parents('.modal-content').parents('.modal').removeClass('open');
  }); 

  $('a[data-toggle=modal]').click(function(e){
    e.preventDefault();
    $('#'+$(this).attr('data-target')+'').addClass('open');
  }); 

  $('.i-show-password').click(function(e){
    e.preventDefault();
    var status = $('#utilisateur_password').attr('data-show');
    if (status == 'p') {
      $('#utilisateur_password').attr('type','text');
      $('#utilisateur_password').attr('data-show','t');
    }
    else{
      $('#utilisateur_password').attr('type','password');
      $('#utilisateur_password').attr('data-show','p');
    }
    
  });     
});


$(window).on('load', function(){
  $(".spinner").fadeOut("slow");
});

function checkUsersConnected(){
  var nbCheck = $( ".connexion-checkbox:checked" ).length;

  if (nbCheck >= 2) {
    $('#btn-disconnect-other-user').fadeIn('slow');
  }
  else{
    $('#btn-disconnect-other-user').fadeOut('slow');
  }
}

function checkBoxContent(){
  var nbCheck = $( ".input-checkbox:checked" ).length;

  if (nbCheck >= 2) {
    $('#btn-action-multiple').removeClass('d-none');
  }
  else{
    $('#btn-action-multiple').addClass('d-none');
  }
}

function disconnectTrainneeOnline(line){
  var btn = $(line);
  btn.hide();
  var userCount = $('.users-count').text();
  var userCountF = 0;
  btn.parents('.case-btn-action').find('.spinner-admin-dashbord').removeClass('d-none');
  $.ajax({
    url :     "disconnect-manual",
    type:     'POST',
    data:     { cnx: btn.attr('data-cnx') },        
    dataType: 'json',
    success:function(data){
      userCountF += userCount - 1
      btn.parents('.case-btn-action').find('.spinner-admin-dashbord').addClass('d-none');
      btn.parents('.case-btn-action').parents('.tr_body_el').fadeOut('slow');
      usersConnected.draw();
      $('.users-count').html(userCountF);
    }
  });
  return false;
}

function voirDetailNotification(btn,mailId){
  $('#modal-detail-mail-notification .expediteur').html(' de : '+$(btn).attr('data-sender'));
  $('#modal-detail-mail-notification .dest-mail-box').html($(btn).attr('data-recipient'));
  $('#modal-detail-mail-notification .objet-mail-box').html($(btn).attr('data-subject'));
  $('#modal-detail-mail-notification .container-mail-box').html($(btn).attr('data-body'));

  $('#modal-detail-mail-notification').addClass('open');
}

function uploadThumbnailNl(elm) {
  $(elm).parents('.btn-actions-groups').find('.content-display-action').addClass('d-none');
  $(elm).parents('.btn-actions-groups').find('.spinner-border').removeClass('d-none');
  var formData = new FormData();           
  formData.append("fileThumbNailNl", elm.files[0]);
  formData.append("artcileId", $(elm).parents('.btn-actions-groups').find('.artcileId').val());
  formData.append("origine", $(elm).parents('.btn-actions-groups').find('.origine').val());
  formData.append("monthId", $(elm).parents('.btn-actions-groups').find('.monthId').val());

  $.ajax({
    type        : "POST",
    url         : "uploadThumbnailNl",    
    contentType : false,
    processData : false,
    data        : formData,
    dataType    : 'json',
    success: function (data) {
      toastr.success('Données enregister avec succés.');
      $(elm).parents('.btn-actions-groups').parents('.actionCase').parents('.line-action-thumb').find('.container-img .photos-presentation').attr('src',data.uploadFileUrl);
      $(elm).parents('.btn-actions-groups').find('.content-display-action').removeClass('d-none');
      $(elm).parents('.btn-actions-groups').find('.spinner-border').addClass('d-none');
    }
  });
}

function generateThumbNl(btn){
  var link= $(btn);

  var artcileId = link.parents('.btn-actions-groups').find('.artcileId').val();
  var monthId = link.parents('.btn-actions-groups').find('.monthId').val();
  var origine = link.parents('.btn-actions-groups').find('.origineArt').val();

  if (origine == '') {
    toastr.error('L\'origin de la newsletter n\'est pas définie !<br>Desollé, impossible de générer la vignette.');
  }
  else{
    link.parents('.btn-actions-groups').find('.content-display-action').addClass('d-none');
    link.parents('.btn-actions-groups').find('.spinner-border').removeClass('d-none');
    $.ajax({
      url : "api-generate-thumb",
      type : 'POST',       
      data : {artcileId: artcileId, monthId: monthId, origine: origine},  
      dataType    : 'json', 
      success : function(data){
        link.parents('.btn-actions-groups').parents('.actionCase').parents('.line-action-thumb').find('.container-img .photos-presentation').attr('src',data.message.uploadFileUrl);
        link.parents('.btn-actions-groups').find('.content-display-action').removeClass('d-none');
        link.parents('.btn-actions-groups').find('.spinner-border').addClass('d-none');
        toastr.success('Données enregister avec succés.');
      }
    });
  }
}

function viewPhotosPresentation(img){
  $('.photos-presentation').attr('data-status','');
  $(img).attr('data-status','active');
  $('.photos-viewer').attr('src',$(img).attr('src'));
  $('#artcileIdModal').val($(img).attr('data-article'));
  $('#origineArtModal').val($(img).attr('data-origin'));
  $('#monthIdModal').val($(img).attr('data-month'));
  $('#modal-photos-viewer').addClass('open');
}

function uploadThumbnailNlModal(elm) {
  $('.photos-viewer').addClass('d-none');
  $('#modal-photos-viewer .spinner-border').find('.spinner-border').removeClass('d-none');

  var formData = new FormData();           
  formData.append("fileThumbNailNl", elm.files[0]);
  formData.append("artcileId", $('#artcileIdModal').val());
  formData.append("origine", $('#origineArtModal').val());
  formData.append("monthId", $('#monthIdModal').val());

  $.ajax({
    type        : "POST",
    url         : "uploadThumbnailNl",    
    contentType : false,
    processData : false,
    data        : formData,
    dataType    : 'json',
    success: function (data) {
      toastr.success('Données enregister avec succés.');
      $('.photos-viewer').removeClass('d-none');
      $('.photos-viewer').attr('src',data.uploadFileUrl);
      $('.photos-presentation').each(function(){
        var p = $(this);
        if (p.attr('data-status') == 'active') {
          p.attr('src',data.uploadFileUrl);
        }
      });
      $('#modal-photos-viewer .spinner-border').find('.spinner-border').addClass('d-none');
    }
  });
}

function viewSequence(link,sequence_id) {
  var btn = $(link);
  var html = '';
  $('.liste-content').click();
  $('.btn-view-detail-sequence').attr('data-active', false);
  $('#activite_sequence_id').val(sequence_id);
  $('.action-multiple').addClass('d-none');
  $('#bo-table-activity-sequence').DataTable().clear().destroy();
  $.ajax({
    type        : "POST",
    url         : "get-infos-sequence",    
    data        : { sequence_id : sequence_id },
    dataType    : 'json',
    success: function (jsonData) { 
      btn.attr('data-active', true);        
      $.each(jsonData.allResults, function(i, sequence) {
        if(sequence.titre != undefined){
          html += '<tr class="activityLine" data-sequence-id='+sequence.id_sequence+' data-sequence-numero='+sequence.numero+'>';
          html += '<td><input onchange="checkBoxActiviteSequence(this);" data-sequence-id='+sequence.id_sequence+' data-sequence-numero='+sequence.numero+' type="checkbox" class="form-check-nl style-1 activite-sequence-checkbox" name="form-check-nl" id="form-check-nl"></td>';
            html += '<td>'+sequence.titre+'</td>';
            html += sequence.titre != "Support" ? '<td><a href="'+sequence.link+'" target="_blank" class="el-btn-circle"><i class="bx bx-download"></i></td>' : '<td></td>';
            html += sequence.titre != "Support" ? '<td class="'+sequence.status.color+'">'+sequence.status.infos+'</td>' : '<td></td>';
            
            html += '<td>'+sequence.nbconsult+'</td>';
            //html += '<td>'+sequence.dernierclick+'</td>';

            html += sequence.titre != "Support" ? '<td class="action-thumb-activite-sequence"><div class="btn-group btn-groupe-margin"><img class="img-thumb" src="'+sequence.thumbnailLink+'" onclick="viewPhotosPresentation(this);" ><label for="nl_thumbnail" class="drop-container-bo-table-content content-display-action" id="dropcontainer"> Uploader<input type="file" onchange="uploadThumbnailActivitySequence(this,'+sequence.id_sequence+','+sequence.numero+');" id="content_thumbnail" name="content_thumbnail" accept="image/png, image/jpeg, image/gif"></label><div class="spinner-border text-primary d-none" role="status"><span class="visually-hidden">Loading...</span></div><button data-link="'+sequence.link+'" class="btn-table-less el-btn-dark btn-generate-thumb-activite-sequence" onclick="generateThumbActivityInSequence(this,'+sequence.id_sequence+','+sequence.numero+')"><i class="bx bx-images"></i>Générer</button></div></td>' : '<td></td>';
            html += '<td class="actions-activite-sequence">';
              html += '<div class="text-right">';
                html += '<div class="btn-group btn-groupe-margin">';
                  html += '<button class="btn-table-less el-btn-orange" data-title="'+sequence.titre+'" data-link="'+sequence.link+'" onclick="modifActivityInSequence(this,'+sequence.id_sequence+','+sequence.numero+')"><i class="bx bx-edit"></i>Modifier</button>';
                  html += '<button class="btn-table-less el-btn-pink btn-delete-activite-sequence" onclick="deleteActivityInSequence(this,'+sequence.id_sequence+','+sequence.numero+');return false;"><i class="bx bx-trash"></i>Supprimer</button>';
                html += '</div>';
              html += '</div>';
            html += '</td>';
          html += '</tr>';
        }
      });

      $('#bo-table-activity-sequence').find('tbody').html(html);
      loadDatatable('bo-table-activity-sequence');

      $('#modal-sequence-detail .infos-sequence').html('Détails de la séquene <span class="text-green">'+btn.attr('data-title')+'</span>');
      $('#modal-sequence-detail').addClass('open');
    }
  });
}

function checkBoxActiviteSequence(input){
  var nbCheck = $( ".activite-sequence-checkbox:checked" ).length;

  if (nbCheck >= 2) {
    $('.action-multiple').removeClass('d-none');
  }
  else{
    $('.action-multiple').addClass('d-none');
  }
}

function generateThumbSequence(line, idSequence){
  var btn = $(line);
  btn.addClass("d-none");
  btn.parents('.btn-group').find('.spinner-border').removeClass('d-none');
  $.ajax({
    type        : "POST",
    url         : "ajax-generate-thumb-activite-sequence",
    data        : { idSequence: idSequence},
    dataType    : 'json',
    success: function (result) {
      console.log(result); 
      if (result.errors == true) {
        toastr.error(result.message);
      }
      else{
        toastr.success(result.message);
        btn.parents('.btn-group').find('img').attr('src',result.thumbnailLink);
      }

      btn.removeClass('d-none');
      btn.parents('.btn-group').find('.spinner-border').addClass('d-none');
    },
    error: function(error, msg){
      console.log(error);
      console.log(msg);
      btn.removeClass('d-none');
      btn.parents('.btn-group').find('.spinner-border').addClass('d-none');
    }
  });
}

function generateThumbActivityInSequence(elm,idSequence,numSequence){
  var btn = $(elm);
  btn.addClass('d-none');
  btn.parents('.btn-group').find('.spinner-border').removeClass('d-none');
  $.ajax({
    type        : "POST",
    url         : "ajax-generate-thumb-activite",
    data        : { idSequence: idSequence, numSequence: numSequence, link: btn.attr('data-link') },
    dataType    : 'json',
    success: function (result) {
      console.log(result); 
      if (result.errors == true) {
        toastr.error(result.message);
      }
      else{
        toastr.success(result.message);
        btn.parents('.btn-group').find('img').attr('src',result.thumbnailLink);
      }

      btn.removeClass('d-none');
      btn.parents('.btn-group').find('.spinner-border').addClass('d-none');
    },
    error: function(error, msg){
      console.log(error);
      console.log(msg);
      btn.removeClass('d-none');
      btn.parents('.btn-group').find('.spinner-border').addClass('d-none');
    }
  });
}

function modifActivityInSequence(elm,idSequence,numSequence){
  var btn = $(elm);
  $('#activite_sequence_id_modif').val(idSequence);
  $('#activite_sequence_parent').val(idSequence);
  $('#activite_sequence_numero_modif').val(numSequence);
  $('#activite_titre_modif').val(btn.attr('data-title'));
  $('#activite_content_modif').val(btn.attr('data-link'));
  $('.tablinks').removeClass('active');
  $('.tab-content').removeClass('active');
  $('#modifier').addClass('active');
}

function deleteSelectActivityInSequence(){
  $('.activite-sequence-checkbox').each(function(){
    var checkBox = $(this);
    if (checkBox.is(':checked')) {
      checkBox.parents('td').parents('.activityLine').find('.actions-activite-sequence .btn-delete-activite-sequence').click();
    }
  });
}

function generateThumbSelectActivityInSequence(){
  $('.activite-sequence-checkbox').each(function(){
    var checkBox = $(this);
    if (checkBox.is(':checked')) {
      checkBox.parents('td').parents('.activityLine').find('.action-thumb-activite-sequence .btn-generate-thumb-activite-sequence').click();
    }
  });
}

function deleteActivityInSequence(elm,idSequence,numSequence){
  var btn = $(elm);
  $('.spinner').fadeIn('slow');
  $.ajax({
    type        : "POST",
    url         : "delete-activity",
    data        : { idSequence : idSequence, numero : numSequence},
    success: function (data) {
      toastr.error('Données supprimer avec succés.');
      $('.activityLine').each(function(){
        var line = $(this);
        if (line.attr('data-sequence-id') == idSequence && line.attr('data-sequence-numero') == numSequence) {
          line.remove();
        }
      });
      $('.btn-view-detail-sequence').each(function(){
        var btn = $(this);
        if (btn.attr('data-active') == 'true') {
          btn.click();
        }
      });
      $('.spinner').fadeOut('slow');
    }
  });
}

function deleteSequence(sequence_id){
  $('#del_sequence_id').val(sequence_id);
  $('#modal-confirm-delete-sequence').addClass("open");
}

function uploadThumbnailActivitySequence(elm,idSequence,numSequence) {
  $(elm).parents('label').addClass('d-none');
  $(elm).parents('.btn-group').find('.spinner-border').removeClass('d-none');
  var formData = new FormData();           
  formData.append("fileThumbNailContent", elm.files[0]);
  formData.append("sequence_id", idSequence);
  formData.append("sequence_num", numSequence);

  $.ajax({
    type        : "POST",
    url         : "upload-thumb-activity",    
    contentType : false,
    processData : false,
    data        : formData,
    dataType    : 'json',
    success: function (data) {
      toastr.success('Données enregister avec succés.');
      $(elm).parents('.btn-group').find('img').attr('src',data.uploadFileUrl);
      $(elm).parents('label').removeClass('d-none');
      $(elm).parents('.btn-group').find('.spinner-border').addClass('d-none');
    }
  });
}

function modifSequence(line, sequence_id){
  var btn = $(line);
  $('.btn-modif-sequence').attr('data-active', false);
  btn.attr('data-active', true);
  $('#sequence_id').val(sequence_id);
  $('#sequence_titre').val(btn.attr('data-title'));
  $('#sequence_objectif').val(btn.attr('data-objectifs'));
  $('#modal-modification-sequence').addClass('open');
}


function openModalConfirmSuppressionSelection(){
  $('#modal-confirm-suppression-selection').addClass("open");
}

function emptyAndDeleteSequence(sequence_id){
  return $.ajax({
    url        : "deleteSequence",
    type       : 'POST',       
    data       : { id: sequence_id, loc: 1 }, 
    success : function(data){
      $('.clsLineSequence').each(function(){
        var line = $(this);
        if (line.attr('data-ident') == sequence_id) {               
          sequenceTable.row(line).remove().draw();      
        }
      });
      $('.spinner').fadeOut('slow');
    }
  });
}

function emptyAndDeleteModule(idModule){
  return $.ajax({
    url        : "delListModule",
    type       : 'POST',       
    data       : { idModule: idModule}, 
    success : function(data){
      $('.clsLineModule').each(function(){
        var line = $(this);
        if (line.attr('data-ident') == idModule) {               
          sequenceTable.row(line).remove().draw();      
        }
      });
      $('.spinner').fadeOut('slow');
    }
  });
}


/*Module*/
function viewModule(link,module_id) {
  var btn = $(link);
  var html = '';
  var htmlSequenceNotInResult = '';
  $('.liste-content').click();
  $('.btn-view-detail-module').attr('data-active', false);
  $('#current_module_id').val(module_id);
  $('#active_domaine_id').val(btn.attr('data-domaine'));
  $('#active_matiere_id').val(btn.attr('data-matiere'));
  $('.action-multiple').addClass('d-none');
  $('#bo-table-activity-sequence').DataTable().clear().destroy();
  $('#bo-table-sequence-module').DataTable().clear().destroy();
  $.ajax({
    type        : "POST",
    url         : "get-infos-module",    
    data        : { module_id : module_id },
    dataType    : 'json',
    success: function (jsonData) { 
      btn.attr('data-active', true);        
      $.each(jsonData.allResults, function(i, modules) {
        if(modules.sequence_titre != undefined){
          html += '<tr class="activityLine" data-module-id='+module_id+' data-module-sequence-id='+modules.sequence_id+'>';
            html += '<td><input onchange="checkBoxActiviteSequence(this);" data-module-id='+module_id+' data-module-sequence-id='+modules.sequence_id+' type="checkbox" class="form-check-nl style-1 activite-sequence-checkbox" name="form-check-nl" id="form-check-nl"></td>';
            html += '<td>'+modules.sequence_titre+'</td>';
            html += '<td class="actions-activite-sequence">';
              html += '<div class="text-right">';
                html += '<div class="btn-group btn-groupe-margin">';
                  //html += '<button class="btn-table-less el-btn-orange" data-title="'+modules.sequence_titre+'" onclick="modifSequenceInModule(this,'+module_id+','+modules.id_sequence+')"><i class="bx bx-edit"></i>Modifier</button>';
                  html += '<button class="btn-table-less el-btn-blue btn-delete-activite-sequence btn-with-draw" onclick="withdrawSequenceInModule(this,'+module_id+','+modules.sequence_id+');return false;"><i class="bx bx-list-minus"></i>Rétirer</button>';
                  html += '<div class="spinner-border text-primary d-none" role="status"><span class="visually-hidden">Loading...</span></div>';
                  html += '<button class="btn-table-less el-btn-pink btn-delete-activite-sequence btn-remove-content" onclick="deleteSequenceInModule(this,'+module_id+','+modules.sequence_id+');return false;"><i class="bx bx-trash"></i>Supprimer définitivement</button>';
                html += '</div>';
              html += '</div>';
            html += '</td>';
          html += '</tr>';
        }
      });

      $.each(jsonData.sequencesResultsNotInModule, function(ii, seuquencesNotInModule) {
          if(seuquencesNotInModule.sequence_titre != undefined){
            htmlSequenceNotInResult += '<tr class="activityLine" data-module-id='+module_id+' data-module-sequence-id='+seuquencesNotInModule.sequence_id+'>';
              htmlSequenceNotInResult += '<td>'+seuquencesNotInModule.sequence_titre+'</td>';
              htmlSequenceNotInResult += '<td class="actions-activite-sequence">';
                htmlSequenceNotInResult += '<div class="text-right">';
                  htmlSequenceNotInResult += '<div class="btn-group btn-groupe-margin">';
                    htmlSequenceNotInResult += '<div class="spinner-border text-primary d-none" role="status"><span class="visually-hidden">Loading...</span></div>';
                    htmlSequenceNotInResult += '<button class="btn-table-less el-btn-orange" data-title="'+seuquencesNotInModule.sequence_titre+'" onclick="addSequenceInModule(this,'+module_id+','+seuquencesNotInModule.sequence_id+')"><i class="bx bx-list-plus"></i>Affecter à cette module</button>';
                  htmlSequenceNotInResult += '</div>';
                htmlSequenceNotInResult += '</div>';
              htmlSequenceNotInResult += '</td>';
            htmlSequenceNotInResult += '</tr>';
          }
      });

      $('#bo-table-activity-sequence').find('tbody').html(html);
      loadDatatable('bo-table-activity-sequence');

      $('#bo-table-sequence-module').find('tbody').html(htmlSequenceNotInResult);
      loadDatatable('bo-table-sequence-module');

      $('#modal-sequence-detail .infos-sequence').html('Détails du module <span class="text-green">'+btn.attr('data-title')+'</span>');
      $('#modal-sequence-detail').addClass('open');
    }
  });
}

function modifModule(line, sequence_id){
  var btn = $(line);
  $('.btn-modif-sequence').attr('data-active', false);
  btn.attr('data-active', true);
  $('#module_id').val(sequence_id);
  $('#module_titre_edit').val(btn.attr('data-title'));
  $('#module_objectif_edit').val(btn.attr('data-objectifs'));
  $('#module_domaine_edit').val(btn.attr('data-domaine'));
  getOptionMatiereByDomaine(btn.attr('data-domaine'),btn.attr('data-matiere'),'module_matiere_edit')

  $('#modal-modification-sequence').addClass('open');
}

function deleteModule(sequence_id){
  $('#del_module_id').val(sequence_id);
  $('#modal-confirm-delete-sequence').addClass("open");
}

function deleteSelectSequenceInModule(){
  $('.activite-sequence-checkbox').each(function(){
    var checkBox = $(this);
    if (checkBox.is(':checked')) {
      checkBox.parents('td').parents('.activityLine').find('.actions-activite-sequence .btn-delete-activite-sequence').click();
    }
  });
}


function modifSequenceInModule(elm,idSequence,numSequence){
  var btn = $(elm);
  $('#activite_sequence_id_modif').val(idSequence);
  $('#activite_sequence_parent').val(idSequence);
  $('#activite_sequence_numero_modif').val(numSequence);
  $('#activite_titre_modif').val(btn.attr('data-title'));
  $('#activite_content_modif').val(btn.attr('data-link'));
  $('.tablinks').removeClass('active');
  $('.tab-content').removeClass('active');
  $('#modifier').addClass('active');
}


function getOptionMatiereByDomaine(domaine_id,matiere_id = 0,cible){
  var optionMatiere = '<option value="0"></option>';
  return $.ajax({
    url :         'get-matiere-by-domaine',
    type:         'post',
    data:         {domaine_id : domaine_id},
    dataType:     'json',
    success:      function(result){
      $.each(result, function(i, matiere) {
        if(matiere_id == 0){
          optionMatiere += '<option value="'+matiere.matiere_id+'">'+matiere.name+'</option>';
        }
        else if(matiere_id == matiere.matiere_id){
          optionMatiere += '<option selected value="'+matiere.matiere_id+'">'+matiere.name+'</option>';
        }
        else{
          optionMatiere += '<option value="'+matiere.matiere_id+'">'+matiere.name+'</option>';
        }
        
      });
      $('#'+cible+'').html(optionMatiere);
      $('.spinner').fadeOut('slow');
    },
    error:        function(error, msg){
      $('.spinner').fadeOut('slow');
    }
  });
};

function addSequenceInModule(line, module_id, sequence_id){
  $(line).fadeOut('slow');
  $(line).parents('.spinner-border').removeClass('d-none');
  $.ajax({
    url :         'add-sequence-to-module',
    type:         'post',
    data:         { domaine_id: $('#active_domaine_id').val(), module_id: module_id, sequence_id: sequence_id },
    dataType:     'json',
    success:      function(result){
      $(line).fadeOut('slow');
      $(line).parents('.btn-group').parents('.text-right').parents('.actions-activite-sequence').parents('.activityLine').addClass('d-none');
      $('.btn-view-detail-module').each(function(){
        var parentsbtn = $(this);
        if (parentsbtn.attr('data-active') == 'true') {
          viewModule(parentsbtn,module_id);
          $('#add-exist').click();
        }
      });
      toastr.success('Données enregister avec succés');
    },
    error: function(error, msg){
      toastr.error(error);
      toastr.error(msg);
    }
  });
}

function  withdrawSequenceInModule(line, module_id, sequence_id){
  $(line).fadeOut('slow');
  $(line).parents('.spinner-border').removeClass('d-none');
  $.ajax({
    url :         'withdraw-sequence-in-module',
    type:         'post',
    data:         { module_id: module_id, sequence_id: sequence_id },
    dataType:     'json',
    success:      function(result){
      $(line).parents('.btn-group').parents('.text-right').parents('.actions-activite-sequence').parents('.activityLine').addClass('d-none');
      $('.btn-view-detail-module').each(function(){
        var parentsbtn = $(this);
        if (parentsbtn.attr('data-active') == 'true') {
          viewModule(parentsbtn,module_id);
          $('#add-exist').click();
        }
      });
      toastr.success('Données enregister avec succés');
    },
    error: function(error, msg){
      toastr.error(error);
      toastr.error(msg);
    }
  });
}

function  deleteSequenceInModule(line, module_id, sequence_id){
  $(line).fadeOut('slow');
  $(line).parents('.spinner-border').removeClass('d-none');
  $.ajax({
    url :         'delete-sequence-in-module',
    type:         'post',
    data:         { module_id: module_id, sequence_id: sequence_id },
    dataType:     'json',
    success:      function(result){
      $(line).parents('.btn-group').parents('.text-right').parents('.actions-activite-sequence').parents('.activityLine').addClass('d-none');
      $('.btn-view-detail-module').each(function(){
        var parentsbtn = $(this);
        if (parentsbtn.attr('data-active') == 'true') {
          viewModule(parentsbtn,module_id);
          $('#add-exist').click();
        }
      });
      toastr.success('Données enregister avec succés');
    },
    error: function(error, msg){
      toastr.error(error);
      toastr.error(msg);
    }
  });
}

function  withDrawSelectSequenceInModule(){
  $('.activite-sequence-checkbox').each(function(){
    var checkBox = $(this);
    if (checkBox.is(':checked')) {      
      checkBox.parents('td').parents('.activityLine').find('.actions-activite-sequence .btn-with-draw').click();     
    }
  });

}


function  deleteSelectSequenceInModule(){
  $('.activite-sequence-checkbox').each(function(){
    var checkBox = $(this);
    if (checkBox.is(':checked')) {      
      checkBox.parents('td').parents('.activityLine').find('.actions-activite-sequence .btn-remove-content').click();     
    }
  });
}