<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding managemodulescontroller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There area two reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router what URI segments to use if those provided
| in the URL cannot be matched to a valid route.
|
*/

$route['default_controller'] = "login";
$route['404_override'] = 'error';


/*********** USER DEFINED ROUTES *******************/

$route['api-certification']  = 'api/AunthentificationEL/login';
$route['loginMe']          = 'login/loginMe';
$route['resetpassword/(:any)/(:any)']    = 'login/changePassword/$1/$2';
$route['dashboard']        = 'trainee/dashbord';
$route['getstatcnx']       = 'trainee/dashbord/getStatCnx';
$route['tutordashbord']    = 'tutor/index';



//$route['fiche-membres/(:num)'] = 'tutor/dashboard/accessmembres/$1';
$route['fiche-membres/(:any)/(:any)']    = "tuteur/dashboard/accessmembres/$1/$2";
$route['readprog-trainee']               = 'tuteur/dashboard/readprog';
$route['personnalize-program']           = 'tuteur/groupes/personnalize';
$route['custom-content-personnals-interest'] = 'tuteur/groupes/customContentPersonnalInterest';
$route['admindashbord']                  = 'admin/dashboard';


$route['logout'] = 'user/logout';
$route['loadDisconnect/(:num)'] = "user/loadDisconnect/$1";
$route['userListing'] = 'user/userListing';
$route['userListing/(:num)'] = "user/userListing/$1";
$route['addNew'] = "user/addNew";
$route['disconnect-manual'] = 'user/logoutManual';


$route['traineeTodoList'] = 'tuteur/todolist';

$route['sequenceProgrameTr/(:any)/(:any)/(:any)/(:any)/(:any)/(:any)/(:any)'] = "sequence/viewDetail/$1/$2/$3/$4/$5/$6/$7";
//$route['sequenceProgrameTr/(:any)/(:any)(:any)/(:any)(:any)/(:any)(:any)'] = "sequence/viewDetail/$1/$2/$3/$4/$5/$6/$7";



$route['todolist'] = "todolist/viewTodo";
$route['addNewLink'] = "admin/todolist/addnewlink";
$route['addDocsOrLinkInTodo'] = "tuteur/todolist/addDocsOrLinkInTodo";
$route['add-docs-or-link-in-todo-tut'] = "tuteur/todolist/addDocsOrLinkInTodo1";
$route['updatesequence/(:num)'] = "tuteur/todolist/updatelink/$1";
$route['addTodo']    = "tuteur/todolist/addTodo";
$route['add-database-document-in-todo']    = "tuteur/todolist/addDatabaseDocumentInTodo";
$route['ajax-add-database-document-in-todo']    = "tuteur/todolist/addDbDocInTodo";
$route['add-lib-in-todo']    = "tuteur/todolist/addLibToCourseHistory";
$route['addNewLinkT'] = "tuteur/todolist/addnewlink";
$route['updatetodo']   = "tuteur/todolist/update";

$route['add-activity-to-ch']            = 'tuteur/todolist/addActivity';


$route['updatecommentodo']   = "tuteur/todolist/updatecomment";
$route['deletetodo']   = "tuteur/todolist/delete";
$route['trainee-todo-in-tutor']   = "tuteur/todolist/index";
$route['trainee-todo-in-tutor/(:num)']      = "tuteur/todolist/index/$1";
$route['deletenewsequence']   = "tuteur/todolist/deletenewsequence";
$route['get-status-by-todo-in-tutor']      = 'tuteur/todolist/getStat';
$route['read-todo-in-tutor']               = 'tuteur/todolist/accessinlink';


$route['fbTuteur']   = "tuteur/whitepaper/view";
$route['dcTuteur']   = "tuteur/document";
$route['modifdc']    = "tuteur/document/edit";
$route['commentdoc'] = "tuteur/document/comment";
$route['getHeaderLink'] = "tuteur/dashboard/getHeader";
$route['addDocTuteur']      = "tuteur/document/addMine";
$route['editDocTuteur']      = "tuteur/document/editMine";


$route['get-all-todo-and-docs-and-link']   = "tuteur/todolist/getAllTodoAndDocsAndLink";

//$route['listLinkDocs/(:num)']      = "tuteur/todolist/listLinkAndDocs/$1";
$route['listLinkDocsByParams']        = "tuteur/todolist/listLinkDocsByParams";
$route['tutorExpression']         = "tuteur/expression/index";
$route['addexpressiontut']        = "tuteur/expression/add";
$route['editexpressiontut']       = "tuteur/expression/edit";
$route['deletedbtut']             = "tuteur/expression/delete";
$route['exportexpressiontut']     = "tuteur/expression/export";
$route['addAudioTut']             = 'tuteur/expression/record';
$route['upload-audio-tut']        = 'tuteur/expression/uploadaudio';



$route['tutor-document']           = "tuteur/document/mine";

/*Document sign professor */
$route['dcsigntuteur']            = 'tuteur/dcsigntuteur';

$route['addNewUser'] = "user/addNewUser";
$route['editOld'] = "user/editOld";
$route['editOld/(:num)'] = "user/editOld/$1";
$route['editUser'] = "user/editUser";
$route['deleteUser'] = "user/deleteUser";
$route['loadChangePass'] = "user/loadChangePass";
$route['changePassword'] = "user/changePassword";
$route['pageNotFound'] = "user/pageNotFound";
$route['checkEmailExists'] = "user/checkEmailExists";

$route['forgotPassword'] = "login/forgotPassword";
$route['resetPasswordUser'] = "login/resetPasswordUser";
$route['resetPasswordConfirmUser'] = "login/resetPasswordConfirmUser";
$route['resetPasswordConfirmUser/(:any)'] = "login/resetPasswordConfirmUser/$1";
$route['resetPasswordConfirmUser/(:any)/(:any)'] = "login/resetPasswordConfirmUser/$1/$2";
$route['createPasswordUser'] = "login/createPasswordUser";
$route['forgot-username-password'] = "login/forgotUserPassword";
$route['reset-password-el'] = "login/resetPasswordEl";


//ROUTE TO TRAINEE
$route['sequencePrograme/(:num)'] = "trainee/sequence/viewprogramme/$1";
$route['traineewp']               = "trainee/whitepaper/view";
$route['trainingobjectif']        = "trainee/trainingobjectif/index";
$route['scan-activity/(:any)/(:any)'] = "trainee/sequence/scan/$1/$2";
$route['stat-activite']             = 'trainee/sequence/addStat';
$route['add-tracking-and-get-status-by-link']   = 'trainee/sequence/addTrackingAndSatus';
$route['add-tracking']   = 'trainee/sequence/addTracking';
$route['add-tracking-exercice-in-fav']   = 'trainee/sequence/addTrackingExerciceInFav';


$route['get-chapitre-by-sequence-ohter-user']   = 'commun/sequence/getById';
$route['get-chapitre-by-sequence-ohter-user-in-fav']   = 'commun/sequence/getByIdInFav';
$route['get-chapitre-by-sequence-ohter-user-in-fav-for-thumb']   = 'commun/sequence/getByIdInFavThumb';
$route['add-sequence-items-formation']   = 'commun/sequence/addSequenceItemsFormation';
$route['del-sequence-items-formation']   = 'commun/sequence/delSequenceItemsFormation';
$route['add-tracking-and-get-status-com']= 'commun/sequence/addTrackingAndSatus';
$route['add-tracking-com']               = 'commun/sequence/addTracking';
$route['get-all-activity-by-params']     = 'commun/sequence/getDataByParams';
$route['personnal-interest']             = "commun/sequence/personalInterest";
$route['get-chapitre-by-sequence']       = 'commun/sequence/getById';
$route['get-module-content']             = 'commun/sequence/getModuleContent';
$route['search-data-library']            = 'commun/sequence/searchDataLib';
$route['add-tracking-navigation']        = 'commun/sequence/addTrackingNavigation';
$route['list-sequence-by-module']        = 'commun/sequence/getListSequenceByModule';
$route['add-content-sequence']           = 'commun/sequence/addContentSequence';
$route['edit-content-sequence']           = 'commun/sequence/editContentSequence';
$route['add-tracking-to-access-content']  = 'commun/sequence/addTrackingToAccessContent';

$route['corpus-lexical']                 = "commun/Glossaire/index";
$route['get-all-vocabulary-by-key']      = "commun/Glossaire/getAllByKey";
$route['get-all-le-by-prototype-access'] = "commun/Glossaire/getLeByIdPrototypeAccess";
$route['get-all-expression-by-cat']      = "commun/Glossaire/listExpressionByCat";
$route['personnalise-content-gl']        = "commun/Glossaire/personalise";
$route['command-glossary-papers']        = "commun/Glossaire/commanderGlossairePapier";
$route['update-lexique']                 = "commun/Glossaire/updateLexique";
$route['finalise-command']               = "commun/Glossaire/finaliseCommand";
$route['loop-glossary']                  = "commun/Glossaire/getAllPrototype";

$route['traineedoc']                     = "trainee/document/index";
$route['traineedoc/(:num)']              = "trainee/document/index/$1";
$route['modif-doc']                      = "trainee/document/edit";


$route['addexpressiontrainee']     = "trainee/expression/add";
$route['add-expression-to-myodb']  = "trainee/expression/addGlossaryToMyOdb";


$route['comment']                 = "trainee/document/comment";

//$route['traineestat']             = "trainee/stat/index";
$route['statistic']                    = "commun/Statistic";
$route['traineestat/(:num)']             = "trainee/stat/index/$1";
$route['traineestat/(:any)/(:any)']      = "trainee/stat/index/$1/$2";

$route['statdetail']              = "trainee/stat/detail";
$route['statdetail/(:num)']       = "trainee/stat/detail/$1";
$route['exportstat']              = "trainee/stat/export";
$route['get-all-data-by-stat']    = "trainee/stat/getjsondata";


$route['traineeTodo']             = "trainee/todolist/todoListing";
$route['traineeTodo/(:num)']      = "trainee/todolist/todoListing/$1";
$route['view-todo']               = 'trainee/todolist/viewTodo';
$route['read-todo']               = 'trainee/todolist/viewTodo';
$route['add-trainee-todo']        = 'trainee/todolist/add';
$route['upload-docs-todo/(:num)'] = 'trainee/todolist/addDoc/$1';


$route['trainee-newsletter']      = "trainee/newsletter";

$route['add-docs-or-link-in-todo'] = "trainee/todolist/addDocsOrLinkInTodo";
$route['get-all-docs-and-link']   = "trainee/todolist/getAllDocsAndLink";
$route['addTraineeTodo']          = "trainee/todolist/addTraineeTodo";
$route['removeTodoInTraineePeriod']  = "trainee/todolist/removeInTraineePeriod";

$route['databank-expression']     = "commun/DatabankExpression";
$route['new-expression']          = 'commun/DatabankExpression/add';
$route['edit-expressions-databank']= 'commun/DatabankExpression/edit';
$route['delete-expression-databank']= 'commun/DatabankExpression/delete';
$route['ajax-new-expression']     = "commun/DatabankExpression/ajaxAdd";
$route['add-content-glossary-to-ddbk']     = "commun/DatabankExpression/ajaxAddFromGlossary";

$route['audio-list']              = 'commun/audio/list';
$route['get-audio-content-by-expression-id']= 'commun/audio/getByExpressionId';
$route['new-rework']              = 'commun/audio/addRework';
$route['delete-audio']            = 'commun/audio/deleteRecord';
$route['modif-audio']             = 'commun/audio/modifContent';
$route['new-record-audio']        = 'commun/audio/ajaxAddNewReworkAudio';
$route['update-content-other-audio'] = 'commun/audio/updateOtherContent';
$route['register-comment-audio'] = 'commun/audio/registerComment';

$route['listLangage']             = 'commun/ExpressionDatabank/getListLangage';
$route['removeExpression']        = 'commun/ExpressionDatabank/del';
$route['viewEpression']           = 'commun/ExpressionDatabank/view';
$route['edit-expressions']        = 'commun/ExpressionDatabank/ajaxEdition';
$route['add-audio']               = 'commun/ExpressionDatabank/record';
$route['upload-audio']            = 'commun/ExpressionDatabank/uploadaudio';
$route['export-expression']       = 'commun/ExpressionDatabank/export';
$route['edit-expression-origin']   = 'commun/ExpressionDatabank/editExpressionOrigin';
$route['edit-content-expression-origin']   = 'commun/ExpressionDatabank/editContentExpressionOrigin';
$route['edit-expression-cible']   = 'commun/ExpressionDatabank/editExpressionCible';
$route['add-therme-to-expression-databank']   = 'commun/ExpressionDatabank/addTherme';



/*Document sign trainee*/
$route['traineedoctosign']        = 'trainee/doctosign';

/*Add expression without article NL*/
$route['addTermeExpression']      = 'commun/newsletter/addTermeExpression';


$route['page-theme']               = 'trainee/newsletter/getArticlePage';
$route['view-article']             = 'trainee/newsletter/getArticle';
$route['stat-article']             = 'commun/newsletter/addStat';
$route['read-data']                = 'commun/newsletter/read';
$route['read-activite']            = 'commun/sequence/read';
$route['read-detail']              = 'commun/sequence/detail';
$route['get-activity-by-id-num-in-user-in-fav'] = 'commun/sequence/getSequenceInfo';

$route['getHeaderLink']            = "commun/sequence/getHeader";
$route['list-sequence-items']      = "commun/sequence/getListItems";

$route['getAllArticleByOtherUser'] = 'commun/newsletter/getAllArticleByOtherUser';
$route['getAllArticleByOtherUser/(:num)'] = 'commun/newsletter/getAllArticleByOtherUser/$1';

$route['getAllArticleByOtherUserInFav'] = 'commun/newsletter/getAllArticleByOtherUserInFav';
$route['getAllArticleByOtherUserInFav/(:num)'] = 'commun/newsletter/getAllArticleByOtherUserInFav/$1';


$route['getAllArticle']            = 'commun/newsletter/getArticle';
$route['getCategory']              = 'commun/newsletter/getArticleUsingLink';
$route['page-theme-by-other-user'] = 'commun/newsletter/getArticlePageByOtherUser';
$route['readArtcile']              = 'commun/newsletter/readArticleByOhterUser';
$route['publish-article']          = 'commun/newsletter/publish';
//$route['get-all-comment-in-article '] = 'commun/newsletter/getAllCommentInArticle';


$route['getfavstat']                = 'commun/statpgr';
$route['getlatest']                 = 'commun/statpgr/getlatest';
$route['mostviewed']                = 'commun/statpgr/mostviewed';
$route['add-tracking-favoris']      = 'commun/statpgr/addstat';
$route['get-all-comment-in-data']= 'commun/statpgr/getAllCommentByDataType';
$route['get-all-comment-in-activity']= 'commun/statpgr/getActivityComment';
$route['get-all-comment-in-favorites']= 'commun/statpgr/getAllCommentByDataInFavorites';
$route['add-article-to-workbook']     = 'commun/statpgr/addArticle';
$route['add-therme-to-workbook']     = 'commun/statpgr/addTherme';
$route['add-comment-therme']     = 'commun/statpgr/addCommentTherme';
$route['get-all-container-personnal-traning-area']     = 'commun/statpgr/getJsonContainer';
$route['add-content-to-personal-traning-area']     = 'commun/statpgr/addContent';
$route['add-page-training-area']       = 'commun/statpgr/addContentPage';
$route['update-page-traning-area']    = 'commun/statpgr/updateContentPage';

$route['refresh-tracking-btn-lateral'] = "commun/tracking/refreshBtnLateral";
$route['refresh-tracking']          = "commun/tracking/refresh";
$route['refresh-data']              = "commun/refreshData/initialise";
$route['saveTracking']             = "commun/tracking/addDoc";
$route['add-tracking-lib']             = "commun/tracking/addTrackingLib";
$route['add-tracking-document']             = "commun/tracking/addTrackingDocument";
$route['saveTrackingLib']             = "commun/tracking/addDocLib";

$route['add-tracking-shortcut-navigation']     = 'commun/tracking/addTrackingShortcutNavigation';



/*bno route*/
$route['bno']                     = "commun/bno/index";

/*help route*/
$route['helpusage']               = 'commun/help';






//Read doc in iframe
//$route['gview/(:any)/(:any)'] = "todoList/gview/$1/$2";
$route['gviewFrm/(:any)/(:any)/(:any)'] = "todolist/gviewIfrm/$1/$2/$3";
$route['scan/(:any)/(:any)'] = "trainee/todolist/scan/$1/$2";





//Tracking

$route['addTracking/(:any)'] = "trainee/todolist/addtracking/$1";



/* End of file routes.php */
/* Location: ./application/config/routes.php */


//admin

/*1 - Sequence*/
/*1.1 - Sequence List*/
$route['managesequences'] = "admin/sequence/list";
/*1.2 - Sequence List usign pagination*/
$route['managesequences/(:num)'] = "admin/sequence/list/$1";
/*1.3 - Delete sequence*/
$route['deleteSequence'] = "admin/sequence/deleteSequence";

/*1.4 - Add thumbnail from sequence*/
$route['addthumbnailsequence/(:any)/(:any)/(:any)'] = "admin/sequence/addthumb/$1/$2/$3";

/*1.5 - Modif thumbnail from sequence*/
$route['modifthumbnailsequence/(:any)/(:any)/(:any)'] = "admin/sequence/modifthumb/$1/$2/$3";

/*1.6 - Edit sequence*/
$route['editsequence/(:any)/(:any)'] = "admin/sequence/editsequence/$1/$2";
$route['ajaxEditSequence'] = "admin/sequence/ajaxEditSequence";

/*1.7 - Edit sequence*/
$route['addauthorsequence'] = "admin/sequence/addauthor";

/*1.8 - Add new sequence*/
$route['addsequence'] = "admin/sequence/add";
$route['new-sequence'] = "admin/sequence/addSequence";

/*1.9 - Re order activity in sequence*/
$route['editactivity'] = "admin/sequence/editActivity";
$route['update-link']  = "admin/sequence/updateLink";
$route['delete-activity'] = "admin/sequence/delActivity";
$route['upload-thumb-activity']  = "admin/sequence/uploadThumbActivity";
$route['ajax-new-activite'] = "admin/sequence/newActivite";
$route['ajax-edit-activite'] = "admin/sequence/editActivite";
$route['ajax-generate-thumb-activite'] = "admin/sequence/generateThumbActivite";
$route['ajax-generate-thumb-activite-sequence'] = "admin/sequence/generateThumbActiviteInSequence";


/*1.10 - view sequence*/
$route['viewseq'] = "admin/sequence/views";

/*1.11 - view sequence*/
$route['gthumb'] = "admin/sequence/generatethumb";

/*1.12 - get infos sequence*/
$route['get-infos-sequence'] = "admin/sequence/getInfos";





/*2 - Module*/
$route['managemodules']   = "admin/module/index";
$route['addListModule']   = "admin/module/addListModule";
$route['delListModule']   = "admin/module/delListModule";
$route['get-infos-module']= "admin/module/getInfos";
$route['admin-add-module']= "admin/module/addModulePostData";
$route['ajax-edit-module'] = "admin/module/ajaxEditModule";
$route['add-sequence-to-module'] = "admin/module/addSequence";
$route['withdraw-sequence-in-module'] = "admin/module/withDrawSequence";
$route['delete-sequence-in-module'] = "admin/module/deleteSequence";
/*domaine*/
$route['get-matiere-by-domaine']= "admin/Matiere/getInfosByDomaine";

/*3 - Parcours*/
$route['manageparcours']           ="admin/Parcours";
$route['list-parcours']            ="admin/Parcours/list";
$route['delete-parcours']          ="admin/Parcours/ajaxDelete";
$route['delete-parcours-v3']          ="admin/Parcours/ajaxDeleteV3";
$route['del-parcours']             ="admin/Parcours/deleteParcoursAdmin";
$route['add-new-parcours']         ="admin/Parcours/addNew";
$route['add-sequence-to-parcours'] ="admin/Parcours/addSequence";
$route['add-module-to-parcours']   ="admin/Parcours/addModule";
$route['get-details-parcours']     ="admin/Parcours/getDetail";
$route['add-parcours-v3']          ="admin/Parcours/addParcoursV3";
$route['delete-content-parcours-el']="admin/Parcours/deleteContentParcoursV3";
$route['ajax-delete-content-parcours-el']="admin/Parcours/ajaxDeleteContentParcoursV3";
$route['parcours-get-content-plateforme'] = "admin/Parcours/getContentPlateforme";
$route['admin-add-items-parcours'] = "admin/Parcours/addContentPlateforme";
$route['update-parcours'] = "admin/Parcours/updateParcours";
$route['get-parcours-by-domaine-and-matiere'] = "admin/Parcours/getByDomaineAndParcours";

/*manage etherpad*/
$route['managefb']       ="admin/Etherpad";
$route['get-content-etherpad']       ="admin/Etherpad/getContentById";
$route['detect-pad-exist-or-create']       ="admin/Etherpad/detectPadExistOrCreate";


/*manage etherpad*/
$route['manage-audio-content']       ="admin/Audio";


/*get content plateforme*/
$route['get-content-plateforme'] = "admin/sequence/getContentPlateforme";




/*4 - File manager*/
$route['filemanager']  = "commun/filemanager/views";
$route['filemanager/(:any)/(:any)/(:any)/(:any)/(:any)/(:any)']  = "commun/filemanager/views/$1/$2/$3/$4/$5/$6";
$route['filemanager/(:any)/(:any)/(:any)/(:any)/(:any)/(:any)/(:any)']  = "commun/filemanager/views/$1/$2/$3/$4/$5/$6/$7";
$route['filemanager']  = "commun/filemanager/views";


$route['download/(:any)/(:any)']  = "commun/donwload/download/$1/$2";
$route['updateTracking']          = "commun/tracking/updatetracking";
$route['addThumbNlManagement']    = "commun/thumbnail/addThumbNlManagement";


/*5 - Domains management*/
/*5.1 List of Domains*/
$route['managedomains']= "admin/domains/index";
/*5.2 Delete Domains*/
$route['deleteDomaine']= "admin/domains/delete";
/*5.3 Add new Domains*/
$route['addDomains']= "admin/domains/add";
/*5.4 Modif a Domains*/
$route['modifdomains']= "admin/domains/edit";
/*5.5 Add material of a Domains*/
$route['addmaterial']= "admin/domains/addmaterial";

/*5.6 Delete material*/
$route['deletematerial']= "admin/domains/deletematerial";

/*5.7 Edit material*/
$route['editmatiere']= "admin/domains/editmatiere";

/*5.8 Edit material*/
$route['showdomains']= "admin/domains/showall";

/*5.9 Move material*/
$route['movematerial']= "admin/domains/movematerial";



/*6 - Manage parcours*/
/*6.1 List parcours*/


/*6 - Manage newsletter*/
/*6.1 List newsletter*/
$route['managenewsletter']= "admin/Newsletter";
/*6.2 Generate thumbnail*/
$route['getThumbNl']      = "admin/Newsletter/getThumb";

/*api Generate thumbnail*/
$route['generateThumbNlByOrigin']        = "admin/Newsletter/generateThumbNlByOrigin";




$route['trackindAdd/(:any)'] = "commun/tracking/addtracking/$1";


/*7 - Manage todo*/
$route['admintodo']             = "admin/todolist";
$route['admintodo/(:num)']      = "admin/todolist/index/$1";

/*8 - Database document*/
$route['managedc']             = "admin/document";
$route['managedc/(:num)']      = "admin/document/index/$1";
$route['dexportdoc']           = "admin/document/export";
$route['adminAddDatabaseDoc']  = "admin/document/addDoc";
$route['managedctutor']        = "admin/document/TutorList";
$route['managedctutor/(:num)'] = "admin/document/TutorList/$1";

$route['deletedc']             = "trainee/document/delete";

/*8 - Expression databank*/
$route['managedb']             = "admin/ExpressionDatabank";
$route['deletedb']             = "admin/ExpressionDatabank/delete";
$route['addexpression']        = "admin/ExpressionDatabank/add";
$route['editexpressionAdmin']       = "admin/ExpressionDatabank/edit";
$route['exportexpression']     = "admin/ExpressionDatabank/export";
$route['get-cat-expression']   = "admin/ExpressionDatabank/getCatExpression";
$route['valide-expression']     = "admin/ExpressionDatabank/validate";

/*9 - Users management*/
$route['members']              = "admin/members";
$route['members/(:num)']       = "admin/members/index/$1";
$route['deleteMembers']        = "admin/members/del";
$route['editmembers']          = "admin/members/edit";
$route['add-members']          = "admin/members/add";
$route['update-groupes-members'] = "admin/members/updateGroups";
$route['adminbno']             = "commun/bno/adminBno";

/*10 - Document sign management*/
/*10.1 - Document sign list*/
$route['documentsign']         = "admin/documentsign";
/*10.2 - Document sign del*/
$route['deldoctosign/(:num)']  = "admin/documentsign/del/$1";
/*10.3 - Send mail/sms*/
$route['sendmailsms/(:num)']   = "admin/documentsign/sendmailsms/$1";


/*11 - Société*/
$route['listsociete']            = "admin/societe";
$route['listsociete/(:num)']     = "admin/societe/index/$1";
$route['removesociete']          = "admin/societe/delete";
$route['updatesocietebymembers'] = "admin/societe/updatebymembers";

/*12 - Manage groupes*/
$route['listesGroupes']          = "admin/Groupes";
$route['listesGroupes/(:num)']   = "admin/Groupes/index/$1";
$route['removegroup']            = "admin/Groupes/removegroup";
$route['updategrpmembers']       = "admin/Groupes/updategrpmembers";
$route['editgroupes']            = "admin/Groupes/edit";
$route['removetutor']            = "admin/Groupes/removetutor";
$route['removetutorajax']        = "admin/Groupes/removetutorjson";
$route['addtutor']               = "admin/Groupes/addtutor";
$route['addtutorajax']           = "admin/Groupes/addtutorjson";
$route['getjsonTutorList']       = "admin/Groupes/tutorlistJson";
$route['getjsonTraineeList']     = "admin/Groupes/traineelistJson";
$route['tutorlist']              = "admin/Groupes/tutorlist";
$route['tutorlist/(:num)']       = "admin/Groupes/tutorlist/$1";
$route['delete-session-groupe']  = "admin/Groupes/deleteSession";
$route['managegroups']           = "admin/Groupes/list";
$route['managegroups/(:num)']    = "admin/Groupes/list/$1";
$route['update-trainer-groupes'] = "admin/Groupes/updateTrainerGroupes";
$route['remove-trainee-in-group']= "admin/Groupes/removetrainee";
$route['add-trainee-in-group']   = "admin/Groupes/addtrainee";
$route['admin-add-items-formations'] = 'admin/Groupes/addItemsFormation';
$route['delete-items-formation']  = 'admin/Groupes/delItemsFormation';

/*13 - Audio*/
$route['audio-tutor-list']       = "tuteur/audio";
$route['audio-tutor-list/(:num)']= "tuteur/audio/index/$1";
$route['audio-tutor-new']        = "tuteur/audio/new";
$route['update-visibilite-audio']= "tuteur/audio/updatevisibilite";
$route['detele-audio']           = "tuteur/audio/delete";

/*13 - Statistique connexion*/
$route['tutor-stat-cnx']         = "tuteur/statcnx";
$route['tutor-stat-cnx/(:num)']  = "tuteur/statcnx/index/$1";

$route['tutor-detail-cnx/(:any)/(:any)']  = "tuteur/statcnx/detail/$1/$2";
$route['tutor-detail-cnx/(:any)/(:any)/(:any)']  = "tuteur/statcnx/detail/$1/$2/$3";

/*14 - Detail of connexion*/
$route['get-activity-detail']    = "tuteur/detail/activityDetail";


//15 - admin manage link";
$route['managelink']             = "admin/sequence/link";
$route['managelink/(:num)']      = "admin/sequence/link/$1";
$route['get-status-by-link']     = "admin/sequence/getStatusByLink";


//16 - stat program
$route['add-stat-program-user-commun'] = 'commun/statpgr/add';
$route['get-trainee-favorite']         = 'commun/statpgr/getFavForAllUser';
$route['deteFav']                      = 'commun/statpgr/del';
$route['scan-content-personnal-training-area']  = 'commun/statpgr/scancontent';

//17 - Classification favorites
$route['classify']                     = 'commun/favoriteClassification/merge';
$route['classifySequence']             = 'commun/favoriteClassification/mergeSequence';
$route['classify-activity']            = 'commun/favoriteClassification/classActivity';
$route['classdata']                    = 'commun/favoriteClassification/classify';
$route['edit-class']                   = 'commun/favoriteClassification/edit';
$route['delete-class-and-fav']         = 'commun/favoriteClassification/delclassandfav';
$route['add-new-class']                = 'commun/favoriteClassification/new';
$route['get-all-classification-favoris'] = 'commun/favoriteClassification/getAllByKey';



//18 - Todolist commun
$route['scan-todo']                     = 'commun/todolist/scan';
$route['get-all-comment-in-todo']       = 'commun/todolist/getallcomment';
$route['get-all-docs-and-link-in-user'] = 'commun/todolist/getalldocsandlinks';



//19 - workbook student


//20- - Get current group
$route['get-current-group']             = 'commun/groupes/getcurrent';
$route['del-session-group']             = 'commun/groupes/delsession';
$route['add-items-formation']           = 'commun/groupes/addItemsFormation';

//21- Manage module
$route['list-modules']                  = 'commun/module/listByAjax';
$route['list-modules-in-matiere']       = 'commun/module/getListByMatiere';
$route['add-items-module-formation']    = 'commun/module/addItemsFormation';
$route['del-module-items-session']      = 'commun/module/delItemsFormation';


/*22- Mange cours histori*/
$route['add-article-to-course_history'] = 'commun/coursHistorik/addArticle';
$route['get-status-by-todo']            = 'commun/coursHistorik/getStat';
$route['add-new-histori-cours']         = 'commun/coursHistorik/addnew';
$route['duplicate-histori-cours']       = 'commun/coursHistorik/duplicate';
$route['delete-historik-course']        = 'commun/coursHistorik/delete';
$route['delete-data-historik-course']   = 'commun/coursHistorik/deletedata';
$route['edit-cours-histori']            = 'commun/coursHistorik/edit';
$route['get-detail-cours-historik']     = 'commun/coursHistorik/detail';
$route['add-page-historik-cours']       = 'commun/coursHistorik/addpage';
$route['update-page-historik-cours']    = 'commun/coursHistorik/updatepage';
$route['add-link-pedagogical-training-to-ch'] = 'commun/coursHistorik/addPedagogicalTrainingInCoursHistorik';
$route['export-ch']                     = 'commun/coursHistorik/exportHistorikCouse';
$route['get-all-course-historik']       = 'commun/coursHistorik/getAllByParams';
$route['delete-page']                   = 'commun/coursHistorik/deletepage';
/*23 - Speed connexion*/
$route['speed-connexion']               = 'commun/speedConnexion';
$route['garbage']                       = 'commun/speedConnexion/garbage';
$route['empty']                         = 'commun/speedConnexion/empty';
$route['getIP']                         = 'commun/speedConnexion/getIP';

/*24 - Historik manage link*/
$route['historik-manage-link']          = 'admin/historikModifLink';

/*25 - Api BDDL*/
$route['get-theme-bddl']                = 'commun/apiBddl/getThemes';
$route['add-prototype-bddl']            = 'api/manageDataBddl/addPrototype';
$route['delete-prototype-bddl']         = 'api/manageDataBddl/delPrototype';
$route['delete-papers-glossary/(:num)'] = 'api/manageDataBddl/delPapersGlossary/$1';


/*26 - Supervisor root*/
$route['supervisor']                    = 'supervisor/dashboard';
$route['query-list']                    = 'supervisor/query/list';
$route['monitoring-trainee-cnx']        = 'supervisor/query/monitoringtraineecnx';
$route['monitoring-trainee-tracking']   = 'supervisor/query/monitoringtraineetracking';
$route['user-connected']                = 'supervisor/Members/conncted';
$route['course-history-professor']      = 'supervisor/query/coursHistorikList';
$route['refresh-data-user-connected']   = 'supervisor/Members/refreshdata';
$route['refresh-tracking-user-connected']= 'supervisor/Tracking/refreshdata';
$route['get-infos-trainee-cnx']         = 'supervisor/Members/getInfosCnx';
$route['course-plan']                   = 'supervisor/CoursPlanifier';
$route['search-course-plan']            = 'supervisor/CoursPlanifier/search';
$route['get-tutor-connect-by-date']     = 'supervisor/CoursPlanifier/getTutorConnectByDate';
$route['user-tracking']                 = 'supervisor/Tracking';

$route['course-product']                = 'supervisor/CoursProduct';
$route['search-course-product']         = 'supervisor/CoursProduct/search';

$route['stat-course-history']           = 'supervisor/Statistique/coursehistory';
$route['stat-links-document']           = 'supervisor/Statistique/linksdocument';
$route['stat-training-area']            = 'supervisor/Statistique/trainingarea';
$route['stat-all-data']                 = 'supervisor/Statistique/alldata';
$route['tracking-connexion']                 = 'supervisor/Tracking/Detail';
$route['screen-piloting']                 = 'supervisor/ScreenPiloting';


/*27 - Repertory document*/
$route['new-repertory']                 = 'commun/DocumentRepertory/add';
$route['get-all-doc-by-all-criteria']   = 'commun/DocumentRepertory/getDocumentByOtherCriteria';
$route['update-document-by-rep']        = 'commun/DocumentRepertory/update';
$route['delete-repertory']              = 'commun/DocumentRepertory/delete';
$route['edit-repertory']                = 'commun/DocumentRepertory/edit';


/*send mail dc*/
$route['send-mail-dc']                  = 'commun/document/sendmail';
$route['addDatabaseLink']               = "commun/document/addLink";
$route['addDatabaseDoc']                = "commun/document/addDoc";
$route['deletedoc']                     = "commun/document/delete";
$route['editDocOrLink']                 = "commun/document/saveEdit";
$route['scan-url']                      = 'commun/document/scanContent';
$route['notify-owner-by-maj-ch']        = 'commun/coursHistorik/notifyItern';

$route['save-update-comment-content']   = 'commun/document/saveUpdateComment';

/*28 - Con call*/
$route['conference-call']               = 'commun/ConferenceCall';

/*29 - Con call*/
$route['add-article-nl-to-hc']          = 'commun/historikCourseNl/add';
$route['check-todo-nl']                 = "commun/historikCourseNl/check";
$route['delete-nl-in-ch']               = "commun/historikCourseNl/delete";
$route['update-comment-article-todo']   = "commun/historikCourseNl/updatecomment";


/*30 - Integrator*/
$route['get-all-integrator']            = "admin/membres/getAllIntegrator";


$route['user-profil']                   = "commun/members/profil";

/*32 - Library*/
$route['listLinkDocs']                  = "tuteur/library";
$route['new-library']                   = "tuteur/library/add";
$route['get-all-data-library']          = 'tuteur/library/getAll';
$route['update-document-by-lib']        = 'tuteur/library/update';
$route['addLibraryLink']                = "tuteur/library/addLink";
$route['addLibraryDoc']                 = "tuteur/library/addDoc";
$route['deletedoc-in-library']          = "tuteur/library/deleteDoc";
$route['add-data-lib-to-fav']           = "tuteur/library/addToFav";
$route['modif-data-lib']                = "tuteur/library/editData";
$route['edit-data-library']             = "tuteur/library/saveEdit";
$route['scan-library']                  = 'tuteur/library/scan';
$route['edit-repertory-lib']            = 'tuteur/library/saveUpdate';
$route['delete-repertory-library']      = 'tuteur/library/deleteLib';


/*for api*/
$route['get-all-members-g-ok']          = 'api/members/getAllMembresGOk';
$route['get-all-ip-members']            = 'api/members/getIpAllMembres';

/*Catgory expresssion*/
$route['ajax-add-category-expression']  = "commun/categoryExpression/ajaxAdd";
$route['add-category-expression']       = "commun/categoryExpression/add";
$route['edit-category-expression']      = "commun/categoryExpression/edit";
$route['delete-category-expression']    = "commun/categoryExpression/delete";



/*Api extranet*/
$route['add-profil-el']                 = 'api/manageDataExtranet/createProfilElearning';
$route['maj-data-el']                   = 'api/manageDataExtranet/majDataEl';
$route['update-profil-el']                 = 'api/manageDataExtranet/updateProfilByExtranetId';



/*QCM*/
$route['qcm-result']                    = 'commun/qcm/result';


/*MANUAL*/
$route['manual-el']                     = 'commun/manual';


/*MAIL & SMS*/
$route['communic']                      = 'admin/mailSmsCommunication';
$route['sendsms']                       = 'admin/mailSmsCommunication/sendsms';
$route['delete-sms-history']            = 'admin/mailSmsCommunication/deletesms';
$route['sendemail']                     = 'admin/mailSmsCommunication/sendemail';


/*corporate library*/
$route['coporate-lib-soc']                 = 'commun/corporateLibrarySoc';
$route['new-repertory-library-soc']        = 'commun/corporateLibrarySoc/addRep';
$route['addDatabaseLinkCorporateLib']      = "commun/corporateLibrarySoc/addLink";
$route['addDatabaseDocCorporateLib']       = "commun/corporateLibrarySoc/addDoc";
$route['edit-repertory-library-corporate'] = 'commun/corporateLibrarySoc/saveEditRepertory';
$route['delete-repertory-library-soc']     = 'commun/corporateLibrarySoc/deleteRepertory';
$route['modif-content-library']            = "commun/corporateLibrarySoc/saveEditContent";
$route['delete-data-library-soc']          = "commun/corporateLibrarySoc/deletedata";
$route['update-comment-data-lib']          = "commun/corporateLibrarySoc/saveUpdateComment";
$route['add-data-lib-cop-in-todo']         = "commun/corporateLibrarySoc/addContentInTodo";
$route['scan-corporate-library']           = "commun/corporateLibrarySoc/scan";

/*command glossary papers*/
$route['list-command-papers-glossary']     = "admin/glossaire";


/*data cours plannify*/
$route['add-data-cours-plannify']          = 'api/ManageWebCalendar/addCoursPlannifierNextDate';



$route['media-list']                       = 'commun/video';
$route['rework-audio-media']               = 'commun/reworkAudio';
$route['video-tutor-list']                 = 'tuteur/video';
$route['get-media-content-by-expression-id']= 'commun/video/getByExpressionId';

$route['picture-list']                       = 'commun/Picture';
$route['picture-modif']                      = 'commun/Picture/edit';
$route['picture-delete']                     = 'commun/Picture/delete';
$route['picture-update-content']             = 'commun/Picture/updateContent';

$route['load-google-api-text-to-speach']     = 'commun/GoogleApi/textToSpeach';
$route['get-voice-language']                 = 'commun/GoogleApi/detectLanguage';


/*glossary tuteur*/
$route['trainerglossary']                  = "tuteur/glossaire/index";

/*trainee dashbord tuteur*/
$route['trainee-dashbord']                 = "tuteur/traineeDashbord/index";


/*Notepad f2+*/
$route['note-pad-f2plus']                  = "commun/notePadF2Plus/index";
$route['update-note-el']                   = "commun/notePadF2Plus/update";

$route['trainer-newsletter']               = "tuteur/newsletter";

$route['logout-by-params']                 = "commun/Connexion/logoutbyparams";


/*inceident technique*/
$route['add-incident-technic']             = "admin/IncidentTechnic/add";
$route['api-add-incident-technic']         = "api/IncidentTechnic/add";



/*- Community library forma2plus*/

$route['community-library-f2plus']                   = "tuteur/CommunityLibraryForma2Plus";
$route['add-repertory-community-library-f2plus']     = "tuteur/CommunityLibraryForma2Plus/add";
$route['edit-repertory-community-library-f2plus']    = 'tuteur/CommunityLibraryForma2Plus/update';
$route['delete-repertory-community-library-f2plus']  = 'tuteur/CommunityLibraryForma2Plus/delete';
$route['add-doc-community-library-f2plus']           = "tuteur/ContentCommunityLibraryForma2Plus/addDoc";
$route['add-link-community-library-f2plus']          = "tuteur/ContentCommunityLibraryForma2Plus/addLink";
$route['del-data-community-library-f2plus']          = "tuteur/ContentCommunityLibraryForma2Plus/delete";
$route['edit-data-community-library-f2plus']         = "tuteur/ContentCommunityLibraryForma2Plus/update";
$route['add-content-community-library-f2plus-to-fav']= "tuteur/ContentCommunityLibraryForma2Plus/addToFav";
$route['add-content-community-library-f2plus-to-ch'] = "tuteur/ContentCommunityLibraryForma2Plus/addToCourseHistory";
$route['add-content-community-library-f2plus-to-course-history'] = "tuteur/ContentCommunityLibraryForma2Plus/ajaxAddToCourseHistory";



/*Expression recording*/
$route['expression-recording']                   = 'commun/ExpressionRecording';
$route['new-expression-recording']               = 'commun/ExpressionRecording/add';
$route['transcript-expression-audio']            = 'commun/ExpressionRecording/transcript';
$route['unlik-file-audio']                       = 'commun/ExpressionRecording/unlinkFile';
$route['delete-expression-recording']            = 'commun/ExpressionRecording/delete';
$route['update-content-expression-recording']    = 'commun/ExpressionRecording/update';
/*Translate*/
$route['translate']                              = 'commun/ExpressionRecording/translate';

/*Token authentification*/
$route['get-token']                              = 'api/TokenElearning/GenerateToken';
$route['authorization']                          = 'api/TokenElearning/Login';
$route['authorization-baerer']                   = 'api/TokenElearning/loadSessionToken';

$route['switch-to-v1']                           = 'Login/SwitchToV1';


$route['mail-box']                = 'commun/MailBox/adminView';


/*api upload file thumbnail NL*/
$route['uploadThumbnailNl']  = "api/Newsletter/uploadThumbnailNl";
$route['api-generate-thumb'] = "api/Newsletter/generateThumbNlByOrigin";

/*Manage folder groups*/
$route['folder-group']           = "admin/FolderGroup";
$route['delete-folder-group']    = "admin/FolderGroup/delete";

$route['connect-to-backup-server'] = "api/SftpConnexion/toBackupServer";

/*Manage connexion tentative*/
$route['connexion-failure']        = "admin/ConnexionFailure";