<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require  APPPATH . '/libraries/ElearningForma2PlusController.php';
require  APPPATH. '/libraries/ExportData.php';


/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Bors
 re
 * @version : 1.1
 * @since : 22 November 2018
 */
class Document extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('user_model');
        $this->load->model('connexion_model');
        $this->load->model('document_model');
        $this->load->model('membres_model');
        $this->load->library('pagination'); 
        $this->isLoggedIn();   
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->global['pageTitle'] = 'E-learning : Forma2+'; 

        $data['searchText']   = $this->input->post('searchText');        
        $data['searchAuthor'] = $this->input->post('author_');     

        $count = $this->document_model->CountDocumentsFiltreAdmin($data['searchText'],$data['searchAuthor']);
        $returns = $this->paginationCompress ("managedc/", $count, 15 );
        $data['document'] = $this->document_model->ListerDocumentsFiltreAdmin($data['searchText'], $data['searchAuthor'], $returns["page"], $returns["segment"]);
        $data['author_doc'] = $this->membres_model->getInfoAuthorDoc();
        $this->loadViews("admin/document/list", $this->global, $data , NULL);
    }  

    public function TutorList()
    {
        $this->global['pageTitle'] = 'E-learning : Forma2+'; 

        $data['searchText']   = $this->input->post('searchText');        
        $data['searchAuthor'] = $this->input->post('author_');     

        $count = $this->document_model->CountDocumentsTutorFiltreAdmin($data['searchText'],$data['searchAuthor']);
        $returns = $this->paginationCompress ("managedctutor/", $count, 15 );
        $data['document'] = $this->document_model->ListDocumentTuteur($data['searchText'], $data['searchAuthor'], $returns["page"], $returns["segment"]);
        $data['author_doc'] = $this->membres_model->getInfoAuthorDoc();
        $this->loadViews("admin/document/tutorList", $this->global, $data , NULL);
    }  

     public function addDoc(){
        $date      = date('d/m/Y H:i:s');
        $mycomment = "" ;
        $retour = "" ;
        
        
        $rep = RP_GROUPES.'GRP'.$this->input->post('authors_');
       

        if ( ! is_dir($rep) ) {
            mkdir($rep, 0755,true);
        }

        $config['upload_path']=$rep;       

        $config['allowed_types']='*';
        $config['encrypt_name'] = TRUE;
        $config['max_size'] = '100000';
        
         
        $this->load->library('upload');
        $this->upload->initialize($config);  
        if($this->upload->do_upload("inputFileDoc")){
            $data = array('upload_data' => $this->upload->data());
 
            if (strlen(trim($this->input->post('textareaCommentDoc'))) == 0) {
                $mycomment .= "" ;
                $nb   = 0 ;
            }
            else{
                $mycomment .= "<DEB>".$this->session->userdata('GUSER')." a écrit le ".$date."<MID>".$this->input->post('textareaCommentDoc')."<FIN>" ;
                $nb   = 1 ;
            }

            $additional_data = array(
                'titre'          => $this->input->post('inputTitleDoc'),
                'comment'        => $mycomment,
                'fichier'        => $data['upload_data']['file_name'],
                'prop'           => $this->input->post('authors_'),       
                'groupe'         => "",       
                'type'           => 3,       
                'priv'           => 0,       
                'date'           => $date,       
                'taille'         => "",       
                'nbcomment'      => $nb,       
                'lien'           => '',       
            );


            $result= $this->document_model->add($additional_data);
            $retour .= 1 ;
        }
        else{
            $retour .= 0 ;
        }

        echo "retour".$retour;


    }


    public function export(){

        
        $documents    = $this->document_model->ListerDocumentsFiltreAdmin($this->input->post('searchText'), $this->input->post('author_'), "", "");
        $exporter = new ExportDataExcel('browser', 'Export_document.xls');
        $exporter->initialize();
        $exporter->addRow(array("Titre", "Author", "Focument/Link", "Creation date", "Trainee")); 
       

        foreach($documents as $doc){
            $exporter->addRow(array($doc['titre'],$doc['user'],$doc['file'],$doc['date'],$this->membres_model->RequestFullNameTrainee($doc['stagiaireGrp'])));  
        }
        $exporter->addRow(array("\r\r","Total lien",count($documents))); 
        $exporter->finalize();
        exit(); 
    }

    public function delete(){
        $id   =  $this->input->post('id');
        $this->document_model->delete($id);
        echo $id;
    }
}

?>