<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class ManageWebCalendar extends CI_Controller
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('CoursPlannifier_model');
        $this->load->model('CoursProduit_model');
        
    }
  
    public function index(){
    }

    public function addCoursPlannifierNextDate(){
        $ret = array();
        $allResultsInfosCoursPlannifierNextDate = $this->curlInfosDataWebcalendar($this->config->item('webcal_api_remonte_data')."?func=getInfosCoursPlannifierNow&first_date=&end_date="); 
        $jsonDataDecode = json_decode($allResultsInfosCoursPlannifierNextDate)->data; 
        if (!empty($jsonDataDecode)) { 
            foreach ($jsonDataDecode as $value) { 
                $data = array(
                    'idStageCoursPlannifier'              => $value->idStageCoursPlannifier,
                    'dateHeureCoursPlannifier'            => $value->dateHeureCoursPlannifier,
                    'dateHeureSaisieCoursPlannifier'      => $value->dateHeureSaisieCoursPlannifier,
                    'refIndividuProfCoursPlannifier'      => $value->refIndividuProfCoursPlannifier,
                    'dureeCoursPlannifier'                => $value->dureeCoursPlannifier,
                    'typeDureeCoursPlannifier'            => $value->typeDureeCoursPlannifier,
                    'nomProfCoursPlannifier'              => $value->nomProfCoursPlannifier,
                    'prenomProfCoursPlannifier'           => $value->prenomProfCoursPlannifier,
                    'loginProfCOursPlannifier'            => $value->loginProfCOursPlannifier,
                    'dateValidationCoursPlannifier'       => $value->dateValidationCoursPlannifier,
                    'soldeStageCoursPlannifier'           => $value->soldeStageCoursPlannifier,
                    'typeDeCoursCoursPlannifier'          => $value->typeDeCoursCoursPlannifier,
                    'matiereCoursPlannifier'              => $value->matiereCoursPlannifier,
                    'refIndividuStagiaireCoursPlannifier' => $value->refIndividuStagiaireCoursPlannifier,
                    'nomStagiaireCoursPlannifier'         => $value->nomStagiaireCoursPlannifier,
                    'prenomStagiaireCoursPlannifier'      => $value->prenomStagiaireCoursPlannifier,
                    'dateInsertCoursPlannifier'           => time()
                );

                $this->addLog($value->dateHeureSaisieCoursPlannifier);

                $dataVerifyInDb = $this->CoursPlannifier_model->checkDataExist($data);
                if (count($dataVerifyInDb) < 1 && $value->dateHeureSaisieCoursPlannifier != '') {
                    $ret['insert'] = $this->CoursPlannifier_model->add($data);
                }

            }
        }
        echo json_encode($ret);

    }

    public function addCoursProduit(){
        $ret = array();
        $allResultsInfosCoursProduit = $this->curlInfosDataWebcalendar($this->config->item('webcal_api_remonte_data')."?func=getCoursProduit&first_date=&end_date="); 
        $jsonDataDecode = json_decode($allResultsInfosCoursProduit)->data; 
        if (!empty($jsonDataDecode)) { 
            foreach ($jsonDataDecode as $value) { 
                $rowExist = $this->CoursProduit_model->getByEventId($value->EvennementId);
                $this->addLog('nb : '.count($rowExist).' => '.$value->EvennementId);
                if (count($rowExist) >= 1) {
                    $ret['insert'] = 0;
                }
                else{
                    $data = array(
                        'evennementId'                             => $value->EvennementId,
                        'idStageCoursProduit'                      => $value->idStage,
                        'dateHeureDebutCoursProduit'               => $value->DateHeureDebut,
                        'dateHeureSaisieCoursProduit'              => $value->DateHeureSaisie,
                        'dateHeureValidationCoursProduit'          => $value->DateValidation,
                        'refIndividuProfCoursProduit'              => $value->refIndividuProf,
                        'dureeCoursProduit'                        => $value->DureeCours,
                        'typeDureeCoursProduit'                    => $value->typeDureeCours,
                        'nomProfCoursProduit'                      => $value->nomProf,
                        'prenomProfCoursProduit'                   => $value->prenomProf,
                        'loginProfCoursProduit'                    => $value->loginProf,
                        'dateInsertCoursProduit'                   => time(),
                    );

                    $ret['insert'] = $this->CoursProduit_model->add($data);

                }
            }
        }
        echo json_encode($ret);
    }

    public function curlInfosDataWebcalendar($url_api_webcal_remonte_data){
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => "".$url_api_webcal_remonte_data."",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "GET",
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }

    public function addLog($content) {
        if (!is_dir(RP_MAIN."cron/logs")) {
            mkdir(RP_MAIN."cron/logs", 0755, false);
            if (!is_dir(RP_MAIN."cron/logs/remonteDataWebcal")) {
                mkdir(RP_MAIN."cron/logs/remonteDataWebcal", 0755, false);
            }
        }
        $logFileName = RP_MAIN."cron/logs/remonteDataWebcal/remonteDataWebcal_" . date('dmY') . ".log";

        if (!file_exists($logFileName)) file_put_contents($logFileName, "");
        file_put_contents($logFileName,date("[j/m/y H:i:s]")." - $content \r\n".file_get_contents($logFileName));
    }

}

?>