<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Members extends CI_Controller
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('membres_model');
        $this->load->model('Societe_model');
        
    }
  
    public function index(){
    }

    public function getAllMembresGOk(){
        $i = 0;
        $ret = array();
        $allResult = $this->membres_model->getAllMembresGOk();
        foreach($allResult as $m){
            $ret[$i]['id'] = $m->id;
            $ret[$i]['nom'] = $m->nom;
            $ret[$i]['prenom'] = $m->prenom;
            $ret[$i]['id_groupe'] = $m->id_groupe;
            $ret[$i]['ref_individu'] = $m->id_individu_ext;
            $ret[$i]['num_stage'] = $m->id_stage_ext;
            $ret[$i]['tel'] = $m->tel;
            $ret[$i]['email'] = $m->email;
            $ret[$i]['login'] = $m->login;
            $ret[$i]['password'] = $m->password;
            $ret[$i]['societe'] = $this->Societe_model->Request('description',$m->id_societe);
            $i++;
        }
        echo json_encode($ret);
    }

    public function getIpAllMembres(){
        $i = 0;
        $ret = array();
        $allResult = $this->membres_model->getIpAllMembres();
        foreach($allResult as $m){
            switch ($m->type) {
                case 0:
                    $ret[$i]['ROLE'] = 'STAGIAIRE';
                    break;    
                case 2:
                    $ret[$i]['ROLE'] = 'ADMINISTRATEUR';
                    break;            
                case 3:
                    if ($m->tuteur_entreprise == 0) {
                        $ret[$i]['ROLE'] = 'TUTEUR';
                    }
                    else{
                        $ret[$i]['ROLE'] = 'RESPONSABLE FORMATION';
                    }
                    break;                
                case 4:
                    $ret[$i]['ROLE'] = 'SUPERVISEUR';
                    break;
                default:
                    $ret[$i]['ROLE'] = 'AUTEUR';
                    break;
            }
            $ret[$i]['nom'] = $m->nom;
            $ret[$i]['prenom'] = $m->prenom;
            $ret[$i]['ref_individu'] = $m->extranet_id;
            $ret[$i]['ip_ardess'] = $m->id_adresse;
            $i++;
        }
        echo json_encode($ret);
    }

}

?>