<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

class CategoryExpression extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        
        $this->tracking_type = 45;
        $this->isLoggedIn();   
    }
    
    /*public function add(){
        $array = array();
        if (isset($_POST['dataSerialiseArray'])) {
            $idGroupes;
            if ($this->isTuteurConnet()) {    
                $idGroupes = $this->session->userdata ('STAGIAIREGRP');   
            }
            else{
                $idGroupes = $this->session->userdata ('GROUPE');  
            }
            $data = array(
                'user_create' => $this->session->userdata ('GUSERID'),
                'id_groupe' => $idGroupes,
                'intitule' => $_POST['dataSerialiseArray']['expression-title'],
                'description' => $_POST['dataSerialiseArray']['commentaire'],
                'date_creation' => time(),
            );
            $array['insert'] = $this->categoryExpression_model->add($data);
            echo json_encode($array);
        }
    }*/

    public function add(){
        $idGroupes;
        if ($this->isTuteurConnet()) {    
            $idGroupes = $this->session->userdata ('STAGIAIREGRP');   
        }
        else{
            $idGroupes = $this->session->userdata ('GROUPE');  
        }
        $this->global['trackingsession'] = $this->session->userdata ('TRACKINGID');
        $this->form_validation->set_rules('expression-title', $this->lang->line('training_expression_new_expression_title'), 'required');
        $this->form_validation->set_rules('commentaire', $this->lang->line('my_link_and_document_th_table_desc'), '');

        if($this->form_validation->run() != FALSE){
            $data = array(
                'user_create' => $this->session->userdata ('GUSERID'),
                'id_groupe' => $idGroupes,
                'intitule' => $this->input->post('expression-title'),
                'description' => $this->input->post('commentaire'),
                'date_creation' => time(),
            );
            $this->categoryExpression_model->add($data);
            redirect("/databank-expression","refresh");
        }
        else{
            $this->session->set_flashdata('message', "Expression add succefully");
            redirect("/databank-expression","refresh");
        }
    }

    public function ajaxAdd(){
        $idGroupes;
        $return = array();
        if ($this->isTuteurConnet()) {    
            $idGroupes = $this->session->userdata ('STAGIAIREGRP');   
        }
        else{
            $idGroupes = $this->session->userdata ('GROUPE');  
        }


        if(isset($_POST['cetgoryName'])){
            $data = array(
                'user_create' => $this->session->userdata ('GUSERID'),
                'id_groupe' => $idGroupes,
                'intitule' => $_POST['cetgoryName'],
                'description' => isset($_POST['cetgoryDescription']) ? $_POST['cetgoryDescription'] :  NULL,
                'date_creation' => time(),
            );
            $return['data'] = $data;
            $return['id'] = $this->categoryExpression_model->add($data);
        }
        else{
            $return['id'] = '';
        }

        echo json_encode($return);
    }

    public function edit(){
        $idGroupes;
        if ($this->isTuteurConnet()) {    
            $idGroupes = $this->session->userdata ('STAGIAIREGRP');   
        }
        else{
            $idGroupes = $this->session->userdata ('GROUPE');  
        }
        $this->global['trackingsession'] = $this->session->userdata ('TRACKINGID');
        $this->form_validation->set_rules('expression-title-edit', $this->lang->line('training_expression_new_expression_title'), 'required');
        $this->form_validation->set_rules('commentaire-edit', $this->lang->line('my_link_and_document_th_table_desc'), '');

        if($this->form_validation->run() != FALSE){
            $data = array(
                'user_create' => $this->session->userdata ('GUSERID'),
                'id_groupe' => $idGroupes,
                'intitule' => $this->input->post('expression-title-edit'),
                'description' => $this->input->post('commentaire-edit'),
                'date_creation' => time(),
            );
            $this->categoryExpression_model->update($this->input->post('idCategory'),$data);
            redirect("/databank-expression","refresh");
        }
        else{
            $this->session->set_flashdata('message', "Expression add succefully");
            redirect("/databank-expression","refresh");
        }
    }

    public function delete(){
        if (isset($_POST['category_id'])) {
            $this->categoryExpression_model->delete($_POST['category_id']);
            redirect("/databank-expression","refresh");
        }
    }
}

?>
