<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';
//require APPPATH . '/libraries/GroupeIncController.php';
//require APPPATH.'/libraries/export-data.class.php';
require_once APPPATH.'/libraries/PHPEXCEL/PHPExcel.php';

/**
 * Class : CoursHistorik
 * Base Class to control over all the classes
 * @author : Alexandre Bors
 * @version : 1.1
 * @since : 22 November 2018
 */
class CoursHistorik extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->isLoggedIn();   
        $this->action_type = 30;
        $this->tracking_type = 2;
        $this->encoding = 'utf-8';
        $this->load->library('FPDF');
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {

    }

    public function addArticle(){
        $retour = array();
        $sender = Array();
        $replyto = Array();
        $destination = Array();
        $subject = '';
        $mailbody = '';
        $mailAltBody = '';
        $filePath = '';
        $paramsotherdata = '';
        
        if (isset($_POST['dataSerialise'])) {            
            $data = array(
                'id_article'            => $_POST['dataSerialise']['id_article'],
                'user_create'           => $this->session->userdata('GUSERID'),
                'id_groupe'             => $this->session->userdata('STAGIAIREGRP'),
                'id_h_c'                => $_POST['dataSerialise']['course_history'],
                'date_create'           => time()
            );
            $id_ch_nl = $this->historik_course_nl_model->add($data);
            $retour['infosIdCh'] = $id_ch_nl;

            /*add data to notification trainee*/
            $data_notification = array(
                'id_tuteur'  => $this->session->userdata('GUSERID'),
                'id_groupe'  => $this->session->userdata('STAGIAIREGRP'),
                'data_type'  => 'article_todo',
                'id_data'    => $id_ch_nl,
                'date_create'=> time()
            );

            $this->Notification_model->add($data_notification);

            if (isset($_POST['dataSerialise']['send_mail']) && $_POST['dataSerialise']['send_mail'] == 'on') {

                $sender = array(
                    'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                    'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
                );
                $replyto = array(
                    'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                    'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
                );
                $destination = array(
                    'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('STAGIAIREID'))),
                    'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))),
                );

                $subject = 'Forma2plus - E-learning plateform ('.$this->convert_utf8($this->lang->line('training_period_course_history')).' - '.utf8_decode($this->coursHistorik_model->Request('intitule',$_POST['dataSerialise']['course_history'])).')';

                $mailbody .= $this->lang->line('el_send_mail_infos_hello').' '.$this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))).',<br><br>';

                if (isset($_POST['dataSerialise']['data_type_fav']) && $_POST['dataSerialise']['data_type_fav'] == 'nl_article') {
                    $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_new_article_nl')).' ';
                }

                $paramsotherdata = '&data_type=article_nl';

                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been')).'<br>';
                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been_access')).' : <br>';
                
                $mailbody .= '<a href="'.base_url().'loginMe?auth=true&pr='.$this->session->userdata ('STAGIAIREID').'&action=ch_tr&ident='.$this->convert_utf8($this->membres_model->Request('login',$this->session->userdata ('STAGIAIREID'))).'&pd='.$this->convert_utf8($this->membres_model->Request('password',$this->session->userdata ('STAGIAIREID'))).'&access=ch&id='.$_POST['dataSerialise']['course_history'].'&container='.$_POST['dataSerialise']['id_article'].''.$paramsotherdata.'" target="_blank">F2+ | E-learning Plateform</a><br>';
                $mailbody .= '<br><br><br>';
                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_sign')).' <br>';
                $mailbody .= $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))).' <br>';
                $mailbody .= $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID')));

                $sendMail = $this->sendMailElearning($sender,$destination,$subject,$mailbody,$mailAltBody,$filePath,$replyto);
                if ($sendMail) {
                    $retour['infosSendMail'] = true;
                    $dataUpdate = array(
                        'notify' => 1
                    );
                    $this->historik_course_nl_model->add($id_ch_nl,$dataUpdate);
                }
                else{
                    $retour['infosSendMail'] = false;
                }

                $this->load->model('Mail_box_model');

                $data_mail_box = array(
                    'sender'    => $sender['email'],
                    'recipient' => $destination['email'],
                    'subject'   => $subject,
                    'body'      => $mailbody,
                    'attachfile'=> $filePath,
                    'status'    => $sendMail,
                    'author'    => $this->session->userdata ('GUSERID'),
                    'target'    => $this->session->userdata ('STAGIAIREID'),
                    'source'    => $this->lang->line('educational_library_newsletter'),
                    'date'      => date("Y-m-d H:i:s")
                );
                $this->Mail_box_model->add($data_mail_box);
                
            }
        }
        echo json_encode($retour);
        
    }

    public function exportHistorikCouseToPdf(){
        
        $header = array(
            strtoupper($this->lang->line('training_period_course_history')),
            strtoupper($this->lang->line('other_user_sequences')),
            strtoupper($this->lang->line('my_link_and_document_form_link_label_input')),
            strtoupper($this->lang->line('my_link_and_document_th_table_comment')),
            strtoupper($this->lang->line('creation_date_add')),
            strtoupper($this->lang->line('status_excercise'))
        );

        // Chargement des données
        $data = $this->LoadDataFpdf('pays.txt');
        $this->FPDF->SetFont('Arial','',11);
        $this->FPDF->AddPage();
        $this->ImprovedTableFpdf($header,$data);
        $this->FPDF->Output();
    }

    public function LoadDataFpdf($file){
        // Lecture des lignes du fichier
        $lines = file($file);
        $data = array();
        foreach($lines as $line)
            $data[] = explode(';',trim($line));
        return $data;
    }


    public function ImprovedTableFpdf($header, $data){
        // Largeurs des colonnes
        $w = array(30, 30, 30, 30, 30, 30);
        // En-tête
        for($i=0;$i<count($header);$i++)
            $this->FPDF->Cell($w[$i],7,$header[$i],1,0,'C');
        $this->FPDF->Ln();
        // Données
        foreach($data as $row)
        {
            $this->FPDF->Cell($w[0],6,$row[0],'LR');
            $this->FPDF->Cell($w[1],6,$row[1],'LR');
            isset($row[2]) ? $this->FPDF->Cell($w[2],6,number_format($row[2],0,',',' '),'LR',0,'R') : '';
            isset($row[3]) ? $this->FPDF->Cell($w[3],6,number_format($row[3],0,',',' '),'LR',0,'R') : '';
            isset($row[4]) ? $this->FPDF->Cell($w[4],6,number_format($row[4],0,',',' '),'LR',0,'R') : '';
            isset($row[5]) ? $this->FPDF->Cell($w[5],6,number_format($row[5],0,',',' '),'LR',0,'R') : '';
            $this->FPDF->Ln();
        }
        // Trait de terminaison
        $this->fpdf->Cell(array_sum($w),0,'','T');
    }


    public function exportHistorikCouse(){
        $id_groupe;
         if ($this->isTuteurConnet()) {                
            $id_groupe  = $this->session->userdata('STAGIAIREGRP');
        }
        else{
           $id_groupe  = $this->session->userdata('GROUPE'); 
        }

        if (isset($_POST['date_hc']) && isset($id_groupe)) {            
            $explortName =  $this->lang->line('training_period_course_history').' - '.$_POST['date_hc'].'.xlsx';
            $i = 2;
            $phpExcel = new PHPExcel();
            $phpExcel->setActiveSheetIndex(0); 
            $styleArray = array(
                'font' => array(
                    'bold' => true,
                )
            );
            $foo = $phpExcel->getActiveSheet();

            $foo->setCellValue("A1", strtoupper($this->lang->line('training_period_course_history')))
                ->setCellValue("B1", strtoupper($this->lang->line('other_user_sequences')))
                ->setCellValue("C1", strtoupper($this->lang->line('my_link_and_document_form_link_label_input')))
                ->setCellValue("D1", strtoupper($this->lang->line('my_link_and_document_th_table_comment')))
                ->setCellValue("E1", strtoupper($this->lang->line('creation_date_add')))
                ->setCellValue("F1", strtoupper($this->lang->line('status_excercise')))
                ->setTitle("Export course history - ".$_POST['date_hc'])
                ->getStyle("A1:F1")->applyFromArray($styleArray);

            
            if ($_POST['date_hc'] == 'all') {
                $todoListResult = $this->todolist_model->getByAllByIdGroup($id_groupe);
            }
            else{
                $todoListResult = $this->todolist_model->getByAllByDateAndIdGroup($_POST['date_hc'],$id_groupe);
            }
            
            foreach ($todoListResult as $res) {
                $content = '';
                if($res->url != '') {
                    if ($res->documentType == 2 && file_exists(RP_GROUPES.'GRP'.$res->id_groupe.'/documentTodo/'.$res->url)) {
                        $content = HTTP_MAIN.'groupes/GRP'.$res->id_groupe.'/documentTodo/'.$res->url;
                    
                    }
                    elseif ($res->documentType == 2 && !file_exists(RP_GROUPES.'GRP'.$res->id_groupe.'/documentTodo/'.$res->url)) {
                        $content = '';
                    
                    }
                    else{
                        $content = $res->url;
                    }  


                    if ($content != '') {  
                        //$foo->setCellValue("A".$i, 'A'.$i.':A'.$res->nbPlandeWParCh.' '.$res->documentType.' '.$res->nbPlandeWParCh.' '.$this->convert_utf8($this->coursHistorik_model->Request('intitule',$res->historique_cours)))
                        $foo->setCellValue("A".$i, $this->convert_utf8($this->coursHistorik_model->Request('intitule',$res->historique_cours)))
                        ->setCellValue("B".$i, $this->convert_utf8($res->sequence))
                        ->setCellValue("C".$i, $this->convert_utf8($content))
                        ->setCellValue("D".$i, $this->convert_utf8($res->commentaire))
                        ->setCellValue("E".$i, $res->date_creation)
                        ->setCellValue("F".$i, ($res->isDone == 1) ? $this->lang->line('status_excercise_done') : $this->lang->line('status_excercise_done_in_process'));
                        //$phpExcel->getActiveSheet()->mergeCells('A'.$i.':A'.$res->nbPlandeWParCh.'');
                        $i++ ;
                    }
                }
            }
            $foo->getColumnDimension("A")->setAutoSize(true);
            $foo->getColumnDimension("B")->setAutoSize(true);
            $foo->getColumnDimension("C")->setAutoSize(true);
            $foo->getColumnDimension("D")->setAutoSize(true);
            $foo->getColumnDimension("E")->setAutoSize(true);
            $foo->getColumnDimension("F")->setAutoSize(true);

            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="'.basename($explortName).'"');
            header('Cache-Control: max-age=0'); //no cache 
            ob_end_clean();
            $objWriter = PHPExcel_IOFactory::createWriter($phpExcel, "Excel2007");
            $objWriter->save("php://output");
            exit;
        }

    }
    /*public function exportHistorikCouse(){
        $id_groupe;
         if ($this->isTuteurConnet()) {                
            $id_groupe  = $this->session->userdata('STAGIAIREGRP');
        }
        else{
           $id_groupe  = $this->session->userdata('GROUPE'); 
        }

        if (isset($_POST['date_hc']) && isset($id_groupe)) {
            $i = 0;
            $explortName =  $this->lang->line('training_period_course_history').' - '.$_POST['date_hc'].'.xls';
            $export = new ExportDataExcel('browser', $explortName);
            $export->initialize();
            $export->addRow(
                array(
                    $this->lang->line('training_period_course_history'),
                    $this->lang->line('other_user_sequences'),
                    $this->lang->line('my_link_and_document_form_link_label_input'),
                    $this->lang->line('my_link_and_document_th_table_comment'),
                    $this->lang->line('creation_date_add'),
                    $this->lang->line('status_excercise')
                )
            );

            if ($_POST['date_hc'] == 'all') {
                $todoListResult = $this->todolist_model->getByAllByIdGroup($id_groupe);
            }
            else{
                $todoListResult = $this->todolist_model->getByAllByDateAndIdGroup($_POST['date_hc'],$id_groupe);
            }
            foreach ($todoListResult as $res) {
                $content = '';
                if($res->url != '') {
                    if ($res->documentType == 2 && file_exists(RP_GROUPES.'GRP'.$res->id_groupe.'/documentTodo/'.$res->url)) {
                        $content = HTTP_MAIN.'groupes/GRP'.$res->id_groupe.'/documentTodo/'.$res->url;
                    
                    }
                    elseif ($res->documentType == 2 && !file_exists(RP_GROUPES.'GRP'.$res->id_groupe.'/documentTodo/'.$res->url)) {
                        $content = '';
                    
                    }
                    else{
                        $content = $res->url;
                    }  


                    if ($content != '') {   
                        $export->addRow(
                            array(
                                $this->convert_utf8($this->coursHistorik_model->Request('intitule',$res->historique_cours)),
                                $this->convert_utf8($res->sequence),
                                $this->convert_utf8($content),
                                $this->convert_utf8($res->commentaire),
                                $res->date_creation,
                                ($res->isDone == 1) ? $this->lang->line('status_excercise_done') : $this->lang->line('status_excercise_done_in_process')
                            )
                        );

                        $i++ ;
                    }
                } 
            }
            $export->addRow(array("\r\r\r\r","Total course history",count($todoListResult))); 
            $export->finalize();
            exit();
        }

    }*/

    public function notifyItern(){
        $retour = '1';
        //$retour = Array();
        $sender = Array();
        $replyto = Array();
        $destination = Array();
        $subject = '';
        $mailbody = '';
        $mailAltBody = '';
        $filePath = '';
        $paramsotherdata = '';

        $width      = "1200";
        $height     = "1280";
        $type;
        $linkD;
        $idHistorikCours;
        if (isset($_POST['idCourseHistory'])) {
            $idHistorikCours = $_POST['idCourseHistory'];  


            $sender = array(
                'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
            );
            $replyto = array(
                'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
            );
            $destination = array(
                'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('STAGIAIREID'))),
                'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))),
            );

            $subject = 'Forma2plus - E-learning plateform ('.$this->convert_utf8($this->lang->line('training_period_course_history')).' - '.utf8_decode($this->coursHistorik_model->Request('intitule',$_POST['idCourseHistory'])).')';

            $mailbody .= $this->lang->line('el_send_mail_infos_hello').' '.$this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))).',<br><br>';

            if (isset($_POST['dataType']) && $_POST['dataType'] == 'article_nl') {
                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_new_article_nl')).' ';
            }
            else{
                if ($this->document_model->Request('lien',$_POST['idTodo']) == 'lien') {
                    $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_new_doc')).' ';
                }
                else{
                    $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_new_link')).' ';
                }
            }

            if (isset($_POST['dataType']) && $_POST['dataType'] != '') {
                $paramsotherdata = '&data_type='.$_POST['dataType'];
            }

            $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been')).'<br>';
            $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been_access')).' : <br>';
            
            $mailbody .= '<a href="'.base_url().'loginMe?auth=true&pr='.$this->session->userdata ('GUSERID').'&action=ch_tr&ident='.$this->convert_utf8($this->membres_model->Request('login',$this->session->userdata ('STAGIAIREID'))).'&pd='.$this->convert_utf8(explode('_', $this->membres_model->Request('register_remember_pwd_time',$this->session->userdata ('STAGIAIREID')))[1]).'&access=ch&id='.$_POST['idCourseHistory'].'&container='.$_POST['idTodo'].''.$paramsotherdata.'" target="_blank">F2+ | E-learning Plateform</a><br>';
            $mailbody .= '<br><br><br>';
            $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_sign')).' <br>';
            $mailbody .= $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))).' <br>';
            $mailbody .= $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID')));

            $sendMail = $this->sendMailElearning($sender,$destination,$subject,$mailbody,$mailAltBody,$filePath,$replyto);
            if ($sendMail) {
                $retour = '1';
                $data = array(
                    'notify' => 1
                );
                if (isset($_POST['dataType']) && $_POST['dataType'] == 'article_nl') {
                    $this->historik_course_nl_model->update($_POST['idTodo'],$data);
                }
                else{
                    $this->todolist_model->updateTodo($_POST['idTodo'],$data);
                }
            }
            else{
                $retour = '0';
            }

            $this->load->model('Mail_box_model');

            $data_mail_box = array(
                'sender'    => $sender['email'],
                'recipient' => $destination['email'],
                'subject'   => $subject,
                'body'      => $mailbody,
                'attachfile'=> $filePath,
                'status'    => $sendMail,
                'author'    => $this->session->userdata ('GUSERID'),
                'target'    => $this->session->userdata ('STAGIAIREID'),
                'source'    => $_POST['source'],
                'date'      => date("Y-m-d H:i:s")
            );
            $this->Mail_box_model->add($data_mail_box);
                
            echo "###".$retour;
        }
    }
    
    public function addnew(){

        if (isset($_POST['items']) && $this->isTuteurConnet()) {
            $retourHtml = array();
            $HTML = '';
            $LinkAndDocs = '';
            $optionLinkAndDocs = '';
            $optionTodo = '';
            
            $pedagogicalTraining = '';
            $pedagogicalTrainingOption = '';

            $personnalInterest = '';
            $personnalInterestOption = '';

            $databaseDocument = '';
            $databaseDocumentOption = '';
            $newsletter = '';
            $newsletterOption = '';
            $OPTIONLIBRARY  = '';
            $LIBRARY = '';

            $communityLibraryForma2Plus = '';
            $communityLibraryForma2PlusOption = '';

           
            $date_planification_ = isset($_POST['date_lesson']) ? explode('/', $_POST['date_lesson']) : '';        
            $data = array(
                'intitule'            => $_POST['items'],
                'date_planification'  => (isset($date_planification_[2]) && isset($date_planification_[1]) && isset($date_planification_[0])) ? $date_planification_[2].'-'.$date_planification_[1].'-'.$date_planification_[0] : NULL,
                'commentaire'         => isset($_POST['comment']) && $_POST['comment'] != '' ? $_POST['comment'] : NULL,
                'back_color'         => $_POST['back_color'],
                'user_create'         => $this->session->userdata('GUSERID'),
                'id_groupe'           => $this->session->userdata('STAGIAIREGRP'),
                'date'                => time()
            );

            $idHistorikCours = $this->coursHistorik_model->add($data);

            $newsletterResult = $this->newsletter_model->getAllArticle();
            $newsletter .= '<ul class="newslettermenu">';
            foreach ($newsletterResult as $nl) {
                $newsletter .= '
                    <li>
                        <a href="#" onclick="addNlInCoursHistorik(this,'.$nl->ID.','.$idHistorikCours.');" class="btn btn-add-in-cours text-docs-and-link"><i class="bx bxs-plus-circle glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;<span class="nl-text">'.htmlentities($nl->article).'</span>
                        </a>
                    </li>';
                $newsletterOption .= '<option data-id="'.$nl->ID.'" value="'.htmlentities($nl->article).'">';
            }
            $newsletter .= '</ul>';
            
            $teacherLinksAndDocs = $this->Teacher_link_and_document_model->getContentByUserCreate($this->session->userdata ('GUSERID'));

            $LIBRARY .= '<ul class="todolistmenu">';
            foreach ($teacherLinksAndDocs as $tld) {
                if($tld->titre != ''){
                    $LIBRARY .= '<li>';
                        $LIBRARY .= '<a href="#"  data-type="teacherLinkAndDocs" class="btn btn-add-in-cours text-link-and-docs-lib" onclick="addTeacherLinkAndDocsInCoursHistorik(this,'.$tld->id.','.$idHistorikCours.');"><i class="bx bxs-plus-circle glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;<span class="teacter-link-and-doc-text">'.$this->convert_utf8($tld->titre).'</span></a>';
                    $LIBRARY .= '</li>';
                    $OPTIONLIBRARY .= '<option data-id="'.$tld->id.'" value="'.$this->convert_utf8($tld->titre).'">';
                }
            }
            $LIBRARY .= '</ul>';

            
            $pedagogicalTraining .= '<ul class="pedagogicalMenu">';
            $pedagogicalResult = $this->sequence_model->getLinksByIdGroupIdDomaine($this->session->userdata ('STAGIAIREGRP'),6);
            for ($i=0; $i < count($pedagogicalResult) ; $i++) {
                $pedagogicalTraining .= '<li>';
                    $pedagogicalTraining .= '<a href="#" data-linkInit = "'.$pedagogicalResult[$i]['link'].'" data-titre = "'.$pedagogicalResult[$i]['titre'].'" data-final-url = "'.$pedagogicalResult[$i]['final_url'].'" data-thumb="'.$pedagogicalResult[$i]['thumbnail_file'].'" class="btn btn-add-in-cours" onclick="addPedagogicalTrainingInCoursHistorik(this,'.$pedagogicalResult[$i]['id_sequence'].','.$pedagogicalResult[$i]['numero'].','.$idHistorikCours.', 6);"><i class="bx bxs-plus-circle glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;<span class="text-pdg">'.htmlentities($pedagogicalResult[$i]['titre']).'</span></a>';
                $pedagogicalTraining .= '</li>';
                $pedagogicalTrainingOption .= '<option data-id="'.$pedagogicalResult[$i]['id_sequence'].'" value="'.htmlentities($pedagogicalResult[$i]['titre']).'">';
            }


            /*complementary activities*/

            $array_ped_training = $this->sequence_model->getPavetHaut($this->session->userdata ('STAGIAIREGRP'),6);
            $array_pers_ling = $this->sequence_model->getPavetHaut($this->session->userdata ('STAGIAIREGRP'),7);

            $ret_complementary_activities = $this->sequence_model->getPavetComplementary($this->session->userdata ('STAGIAIREGRP'));

            $arrayListeModule = array();
            $array_id_module_ped_training = array();
            $array_id_module_pers_ling = array();


            if(!empty($array_pers_ling)){
                if (is_array($array_pers_ling['module'])) {
                    foreach($array_pers_ling['module'] as $key=>$value){
                        foreach($value as $key2=>$value2){
                            $arrayListeModule[] = $value2['module_id'];
                            $array_id_module_pers_ling[] = $value2['module_id'];
                        }
                    }
                }
            }

            if(!empty($array_ped_training)){
                if (is_array($array_ped_training['module'])) {
                    foreach($array_ped_training['module'] as $key=>$value){
                        foreach($value as $key2=>$value2){
                            $arrayListeModule[] = $value2['module_id'];
                            $array_id_module_ped_training[] = $value2['module_id'];
                        }
                    }
                }
            }
            if(!empty($ret_complementary_activities)){
                if (is_array($ret_complementary_activities['module'])) {
                    foreach($ret_complementary_activities['module'] as $key=>$value){
                        $arrayListeModule[] = $value['module_id'];
                    }
                }
            }

            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ped_training) ;
            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_pers_ling) ;

            if(!empty($ret_complementary_activities)){
                foreach($ret_complementary_activities['module'] as $key=>$value){
                    $chapitre = $this->chapitres_model->read($value['sequence_id'],$this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP'));
                    if (isset($chapitre['cnt'])) {                                                    
                        for($i=0;$i<$chapitre['cnt'];$i++) {
                            $pedagogicalTraining .= '<li>';
                                $pedagogicalTraining .= '<a href="#" data-linkInit = "'.$chapitre[$i]['link'].'" data-titre = "'.$chapitre[$i]['titre'].'" data-final-url = "'.$chapitre[$i]['final_url'].'" data-thumb="'.$chapitre[$i]['thumbnail_file'].'" class="btn btn-add-in-cours" onclick="addPedagogicalTrainingInCoursHistorik(this,'.$chapitre[$i]['id_sequence'].','.$chapitre[$i]['numero'].','.$idHistorikCours.',6);"><i class="bx bxs-plus-circle glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;<span class="text-pdg">'.htmlentities($chapitre[$i]['titre']).'</span></a>';
                            $pedagogicalTraining .= '</li>';
                            $pedagogicalTrainingOption .= '<option data-id="'.$chapitre[$i]['id_sequence'].'" value="'.htmlentities($chapitre[$i]['titre']).'">';
                        }
                    }
                }
            }

            $pedagogicalTraining .= '</ul>';


            $personnalInterest .= '<ul class="pedagogicalMenu">';
            $personnalIntersetResult = $this->sequence_model->getLinksByIdGroupIdDomaine($this->session->userdata ('STAGIAIREGRP'),7);
            for ($i=0; $i < count($personnalIntersetResult) ; $i++) {
                $personnalInterest .= '<li>';
                    $personnalInterest .= '<a href="#" data-linkInit = "'.$personnalIntersetResult[$i]['link'].'" data-titre = "'.$personnalIntersetResult[$i]['titre'].'" data-final-url = "'.$personnalIntersetResult[$i]['final_url'].'" data-thumb="'.$personnalIntersetResult[$i]['thumbnail_file'].'" class="btn btn-add-in-cours" onclick="addPedagogicalTrainingInCoursHistorik(this,'.$personnalIntersetResult[$i]['id_sequence'].','.$personnalIntersetResult[$i]['numero'].','.$idHistorikCours.',7);"><i class="bx bxs-plus-circle glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;<span class="text-persint">'.htmlentities($personnalIntersetResult[$i]['titre']).'</span></a>';
                $personnalInterest .= '</li>';
                $personnalInterestOption .= '<option data-id="'.$personnalIntersetResult[$i]['id_sequence'].'" value="'.htmlentities($personnalIntersetResult[$i]['titre']).'">';
            }
            $personnalInterest .= '</ul>';


            $databaseDocument .= '<ul class="pedagogicalMenu">';
            $databasedc = $this->document_model->getAllDocumentByIdGroup($this->session->userdata ('STAGIAIREGRP'));
            foreach ($databasedc as $d) {
                $databaseDocument .= '<li>';
                    $databaseDocument .= '<a href="#" data-titre = "'.$d->titre.'" data-fichier = "'.$d->fichier.'" class="btn btn-add-in-cours" onclick="addDatabaseDocumentInCoursHistorik(this,'.$d->id.','.$idHistorikCours.');"><i class="bx bxs-plus-circle glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;<span class="text-dc">'.htmlentities($d->titre).'<span></a>';
                $databaseDocument .= '</li>';
                $databaseDocumentOption .= '<option data-id="'.$d->id.'" value="'.htmlentities($d->titre).'">';
            }
            $databaseDocument .= '</ul>';

            $communityLibraryForma2Plus .= '<ul class="communityLibraryForma2plus">';
            $commulintyLibraryResult = $this->Content_community_library_forma2plus_model->getAll();
            foreach ($commulintyLibraryResult as $clf) {
                $communityLibraryForma2Plus .= '<li>';
                    $communityLibraryForma2Plus .= '<a href="#" data-titre = "'.$clf->titre.'" data-fichier = "'.$clf->link.'" class="btn btn-add-in-cours" onclick="addLibraryCommunityForma2PlusInCourseHistory(this,'.$clf->id.','.$idHistorikCours.');"><i class="bx bxs-plus-circle glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;<span class="text-dc">'.$this->convert_utf8($clf->titre).'</span></a>';
                $communityLibraryForma2Plus .= '</li>';
                $communityLibraryForma2PlusOption .= '<option data-id="'.$clf->id.'" value="'.$this->convert_utf8($clf->titre).'">';
            }
            $communityLibraryForma2Plus .= '</ul>';

            $retourHtml = array(
                'htmlLibLinkAndDocs'                   => $LinkAndDocs,
                'htmlLibLinkAndDocsOption'             => $optionLinkAndDocs,
                'htmlLibPedagogicalTraining'           => $pedagogicalTraining,
                'htmlLibPedagogicalTrainingOption'     => $pedagogicalTrainingOption,
                'htmlLibDatabaseDocs'                  => $databaseDocument,
                'htmlLibDatabaseDocsOption'            => $databaseDocumentOption,
                'htmlLibNewsletter'                    => $newsletter,
                'htmlLibNewsletterOption'              => $newsletterOption,
                'htmlLibPersonnalInterest'             => $personnalInterest,
                'htmlLibPersonnalInterestOption'       => $personnalInterestOption,
                'htmlLibTeacherLinkAndDocs'            => $LIBRARY,
                'htmlLibTeacherLinkAndDocsOption'      => $OPTIONLIBRARY,
                'htmlLibCommunityLibF2P'               => $communityLibraryForma2Plus,
                'htmlLibCommunityLibF2POption'         => $communityLibraryForma2PlusOption,
                'idHistorikCours'                      => $idHistorikCours,
            );

            echo json_encode($retourHtml);
        }
    }
    public function duplicate(){
        $retour = '';
        if (isset($_POST['items'])) {
            if ($this->isTuteurConnet()) {  
                $groupe_id = $this->membres_model->Request('id_groupe',$_POST['id_trainee']);              
                $data = array(
                    'intitule'            => $_POST['items'],
                    'back_color'          => $_POST['back_color'],
                    'user_create'         => $this->session->userdata('GUSERID'),
                    'id_groupe'           => $groupe_id,
                    'date'                => time()
                );
                $idHistorikCours = $this->coursHistorik_model->add($data);

                //Get all data form ch original to clone 

                //1 - Plan de travail
                $allDataPlanDeWToClone = $this->todolist_model->getAllByCourseHistory($_POST['id_session']);
                foreach ($allDataPlanDeWToClone as $pl) {
                    $this->todolist_model->addTodo($pl->num_sequence,$groupe_id,$idHistorikCours);
                }

                //2 - Page
                $allDataPageToClone = $this->coursHistorik_model->getPageByIdCoursHistorik($_POST['id_session']);
                foreach ($allDataPageToClone as $p) {

                    $data = array(
                        'id_historique_cours' => $idHistorikCours,
                        'comment'             => $p->comment,
                        'content'             => $p->content,
                        'id_groupe'           => $groupe_id,
                        'user_create'         => $this->session->userdata ('GUSERID'),
                        'create_date'         => time()
                    );
                    $this->coursHistorik_model->addPage($data);
                }
                
                //3 - NL
                $allDataNlToClone = $this->historik_course_nl_model->getByIdCh($_POST['id_session']);
                foreach ($allDataNlToClone as $nl) {
                    $data = array(
                        'id_article'            => $nl->id_article,
                        'user_create'           => $this->session->userdata('GUSERID'),
                        'id_groupe'             => $groupe_id,
                        'id_h_c'                => $idHistorikCours,
                        'date_create'           => time()
                    );
                    $this->historik_course_nl_model->add($data);
                }
                if ($groupe_id == $this->session->userdata ('STAGIAIREGRP')) {
                    $retour .= 'SESSION_ACTIVE';
                }
                echo $retour;
            }
        }
    }

    public function addPedagogicalTrainingInCoursHistorik(){
        $retour = array();
        if (isset($_POST['idHisorikC'])) {
            $idCh = $_POST['idHisorikC'];
            $link;
            if ($_POST['linkFinal'] != '') {
               $link = $_POST['linkFinal'];
            }
            else{
                $link = $_POST['linkInit'];
            }
            $linkInfo = array(
                'titre'         => $_POST['title'], 
                'link'          => $link,
                'type'          =>0, 
                'commentaire'   =>"",
                'date_create'   =>date('Y-m-d'), 
                'user_create'   =>$this->session->userdata ('GUSERID'),
                "thumbnail_file"=>$_POST['thumb']
            );
            $idNewLink = $this->todolist_model->addnewlink($linkInfo);
            $todoId = $this->todolist_model->addTodo($idNewLink,$this->session->userdata ('STAGIAIREGRP'),$idCh);

            /*add data to notification trainee*/
            $data_notification = array(
                'id_tuteur'  => $this->session->userdata('GUSERID'),
                'id_groupe'  => $this->session->userdata('STAGIAIREGRP'),
                'data_type'  => 'todo',
                'id_data'    => $todoId,
                'date_create'=> time()
            );
            $this->Notification_model->add($data_notification);
            
            if ($linkInfo['thumbnail_file'] != "") {
                $rep      =  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/THUMBNAIL'.$this->session->userdata('GUSERID');
                if ( ! is_dir($rep) ) {
                    mkdir($rep, 0755,true);
                }
                $sourceFile      =  REP_ACTIVITY_SEQUENCE.$linkInfo['thumbnail_file'];
                if (is_file($sourceFile)) {
                    copy($sourceFile,$rep.'/'.$linkInfo['thumbnail_file']);
                }
            }
            $retour['todoId'] = $todoId;
            $retour['lib']    = (isset($_POST['pave']) && $_POST['pave'] == 6) ? $this->lang->line('educational_library_pedagogical_training') : $this->lang->line('educational_library_personnal_interest');

            echo json_encode($retour);
        }
    }

    public function delete(){
        if (isset($_POST['idHistorikCours'])) {
            $this->coursHistorik_model->deletePageByCourseHistory($_POST['idHistorikCours']);
            $this->historik_course_nl_model->deleteByCourseHistory($_POST['idHistorikCours']);
            $this->todolist_model->deleteByHistorikCours($_POST['idHistorikCours']);
            $this->coursHistorik_model->delete($_POST['idHistorikCours']);
        }
    }

    public function deletedata(){
        $return = array();
        if (isset($_POST['inputIdPlanW'])) {            
            $this->todolist_model->delete($_POST['inputIdPlanW']);
            $return['idDataDelete'] = $_POST['inputIdPlanW'];
        }
        echo json_encode($return);
    }

    public function addpage(){
        if (isset($_POST['dataPageHistorikCours'])) {
            if ($this->isTuteurConnet()) {
                $data = array(
                    'id_historique_cours' => $_POST['dataPageHistorikCours']['id-cours-historik'],
                    'comment'             => $_POST['dataPageHistorikCours']['edit-page-comment'],
                    'content'             => $_POST['dataPageHistorikCours']['page-content'],
                    'id_groupe'           => $this->session->userdata ('STAGIAIREGRP'),
                    'user_create'         => $this->session->userdata ('GUSERID'),
                    'create_date'         => time()
                );
            }
            else{
                $data = array(
                    'id_historique_cours' => $_POST['dataPageHistorikCours']['id-cours-historik'],
                    'comment'             => $_POST['dataPageHistorikCours']['edit-page-comment'],
                    'content'             => $_POST['dataPageHistorikCours']['page-content'],
                    'id_groupe'           => $this->session->userdata ('GROUPE'),
                    'user_create'         => $this->session->userdata ('GUSERID'),
                    'create_date'         => time()
                );
            }

            $idPage = $this->coursHistorik_model->addPage($data);



            /*add data to notification trainee*/
            $data_notification = array(
                'id_tuteur'  => $this->session->userdata('GUSERID'),
                'id_groupe'  => $this->session->userdata('STAGIAIREGRP'),
                'data_type'  => 'page_todo',
                'id_data'    => $idPage,
                'date_create'=> time()
            );
            $this->Notification_model->add($data_notification);


            if (isset($_POST['notify']) && $_POST['notify'] == 'on') {
                $retour = '1';
                $sender = Array();
                $replyto = Array();
                $destination = Array();
                $subject = '';
                $mailbody = '';
                $mailAltBody = '';
                $filePath = '';
                $paramsotherdata = '';

                if (isset($_POST['dataType']) && $_POST['dataType'] != '') {
                    $paramsotherdata = '&data_type='.$_POST['dataType'];
                }


                $sender = array(
                    'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                    'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
                );
                $replyto = array(
                    'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                    'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
                );
                $destination = array(
                    'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('STAGIAIREID'))),
                    'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))),
                );

                $subject = 'Forma2plus - E-learning plateform ('.$this->convert_utf8($this->lang->line('training_period_course_history')).' - '.utf8_decode($this->coursHistorik_model->Request('intitule',$_POST['dataPageHistorikCours']['id-cours-historik'])).')';

                $mailbody .= $this->lang->line('el_send_mail_infos_hello').' '.$this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))).',<br><br>';

                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_new_page')).' ';
                
                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been')).'<br>';
                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been_access')).' : <br>';
                
                $mailbody .= '<a href="'.base_url().'loginMe?auth=true&pr='.$this->session->userdata ('GUSERID').'&action=ch_tr&ident='.$this->convert_utf8($this->membres_model->Request('login',$this->session->userdata ('STAGIAIREID'))).'&pd='.$this->convert_utf8(explode('_', $this->membres_model->Request('register_remember_pwd_time',$this->session->userdata ('STAGIAIREID')))[1]).'&access=ch&id='.$_POST['dataPageHistorikCours']['id-cours-historik'].'&container='.$idPage.''.$paramsotherdata.'" target="_blank">F2+ | E-learning Plateform</a><br>';
                $mailbody .= '<br><br><br>';
                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_sign')).' <br>';
                $mailbody .= $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))).' <br>';
                $mailbody .= $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID')));

                $sendMail = $this->sendMailElearning($sender,$destination,$subject,$mailbody,$mailAltBody,$filePath,$replyto);
                if ($sendMail) {
                    $retour = '1';
                }
                else{
                    $retour = '0';
                }

                $this->load->model('Mail_box_model');

                $data_mail_box = array(
                    'sender'    => $sender['email'],
                    'recipient' => $destination['email'],
                    'subject'   => $subject,
                    'body'      => $mailbody,
                    'attachfile'=> $filePath,
                    'status'    => $sendMail,
                    'author'    => $this->session->userdata ('GUSERID'),
                    'target'    => $this->session->userdata ('STAGIAIREID'),
                    'source'    => $this->lang->line('other_ch_new_page'),
                    'date'      => date("Y-m-d H:i:s")
                );
                $this->Mail_box_model->add($data_mail_box);
            }
            else{
                $retour = $idPage;
            }
            echo "###".$retour;
        }
    }

    public function deletepage(){
        if (isset($_POST['id'])) {
            echo $this->coursHistorik_model->deletePage($_POST['id']);
        }
    }

    public function updatepage(){
        $return = array();
        
        if (isset($_POST['dataPageHistorikCours'])) {
            $data = array(
                'comment'              => $_POST['dataPageHistorikCours']['comment-page'],
                'content'              => $_POST['dataPageHistorikCours']['page-content'],
                'modif_date'           => time()
            );
            $return['data'] = $data;
            $return['id_page_hc'] = $_POST['dataPageHistorikCours']['id_page_hc'];
            $return['updateId'] = $this->coursHistorik_model->updatePage($_POST['dataPageHistorikCours']['id_page_hc'],$data);
        }
        else{
            if (isset($_GET['action']) && $_GET['action'] == "content") {
                $data = array(
                    'content' => $_POST['content'],
                    'modif_date' => time()
                );
            }
            else{
                $data = array(
                    'comment' => $_POST['comment'],
                    'modif_date' => time()
                );
            }
            $return['updateId'] = $this->coursHistorik_model->updatePage($_POST['id'],$data);
        }
        echo json_encode($return);
    }

    public function detail(){
        if (isset($_GET['id'])) {
            $this->global['pageTitle'] = 'E-learning : Detail course history';

            $this->loadTrackingEl($_GET['id'],0,$this->tracking_type);

            $data['titlecoursehistory'] = $this->coursHistorik_model->Request('intitule',$_GET['id']);
            $data['historikCoursDetail'] = $this->todolist_model->getByIdHistorikCours($_GET['id']);
            $data['historikCoursDetail_nl'] = $this->historik_course_nl_model->getByIdCh($_GET['id']);
            if ($this->isTuteurConnet()) {
                $data['classification_favoris'] = $this->classificationFavoris_Model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP'));
                $this->loadViews("tutor/todolist/detail", $this->global,$data, NULL );
            }
            else{

                $data['classification_favoris'] = $this->classificationFavoris_Model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$this->session->userdata ('GROUPE'));
                $this->loadViews("trainee/todolist/detail", $this->global,$data, NULL );
            }
        }
    }

    public function edit(){
        if (isset($_POST['id'])) {
            $data = array(
                'intitule'            => $_POST['items'],
                'back_color'          => $_POST['back_color'],
                'date'                => time()
            );
            echo $this->coursHistorik_model->update($_POST['id'],$data);
        }
    }

    public function getAllByParams(){
        $output = '';
        if (isset($_POST['key'])) {
            $output   .= '<ul class="nav classification-favoris-list">';
            if ($this->isTuteurConnet()) {
                $allResult = $this->coursHistorik_model->getAllByKey($_POST['key'],$this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP'));
            }
            else{
                $allResult = $this->coursHistorik_model->getTraineeAllByKey($_POST['key'],$this->session->userdata ('GROUPE'));
            }
            if (count($allResult) >= 1) {                
                foreach ($allResult as $res) {
                    $output   .= '<li class="classification-favoris-list-data">'.$res->intitule.'</li>';
                }
            }
            else{
                $output   .= '<li class="classification-favoris-list-data">No data found</li>';
            }
            $output   .= '</ul>';
        }
        echo $output;
    }
    

    public function getStat(){
        $ret = array();
        $ret['retour'] = "tracking and url final";
        /*if (isset($_POST['link']) && $_POST['linkType'] && $_POST['linkType'] != 'embend_url' && $_POST['linkType'] != 'local_file') {
            $ret['finalUrl']  = $this->findUltimateDestination($_POST['link'],10);
            $ret['responses'] = $this->getHeaderResponses($_POST['link']);
        }*/

        if (isset($_POST['link']) && $_POST['linkType'] && $_POST['linkType'] != 'embend_url' && $_POST['linkType'] != 'local_file') {
            if(isset($_POST['extension']) && $_POST['extension'] == 'mp3' && $_POST['extension'] == 'MP3' && $_POST['extension'] == 'wav'  && $_POST['extension'] == 'WAV'){

            }
            elseif (strpos($_POST['link'], 'learnenglishteens.britishcouncil.org') !== false || strpos($_POST['link'], 'learnenglish.britishcouncil.org') !== false || strpos($_POST['link'], 'learnenglishkids.britishcouncil.org') !== false || strpos($_POST['link'], 'www.liveworksheets.com') !== false || strpos($_POST['link'], 'www.teachingenglish.org.uk') !== false || strpos($_POST['link'], 'www.usingenglish.com') !== false || strpos($_POST['link'], 'www.englisch-hilfen.de') !== false || strpos($_POST['link'], 'leo.stcloudstate.edu') !== false || strpos($_POST['link'], 'elt.oup.com') !== false || strpos($_POST['link'], 'thebalancecareers.com') !== false || strpos($_POST['link'], 'premierskillsenglish.britishcouncil.org') !== false || strpos($_POST['link'], 'grammar.ccc.commnet.edu') !== false || strpos($_POST['link'], 'continuingstudies.uvic.ca') !== false || strpos($_POST['link'], 'www.grammarly.com') !== false){
                $ret['finalUrl']  = $_POST['link'];
                $ret['responses'] = false;
            }
            else{
                $ret['finalUrl']  = $this->findUltimateDestination($_POST['link'],10);
                $ret['responses'] = $this->getAllHeaderResponses($_POST['link']);

            }
        }
        $ret['trackingsession'] = (isset($_POST['idPlanDeTravail']) && $_POST['idPlanDeTravail'] != '') ? $this->loadTrackingEl($_POST['idPlanDeTravail'],0,$this->tracking_type,$_POST['idCh']) : $this->loadTrackingEl(0,0,$this->tracking_type);  
        echo json_encode($ret);
    }
   
}

?>