<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
require APPPATH . '/libraries/ElearningSupervisorForma2PlusController.php';
/**
 * Class : BaseController
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Tracking extends ElearningSupervisorForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Tracking_model');      
        $this->load->model('QueryStat_model');    
        $this->load->model('CoursPlannifier_model');    
        $this->isLoggedIn(); 
        $this->tracking_type = 7878;  
    }
    
    /**
     * This function used to load the first screen of the user
     */
    /*public function index()
    {
        $this->global['pageTitle'] = 'E-learning : Tracking';
        
         $trackingid = $this->Tracking_model->Add(0,0,$this->tracking_type);
        $sessionArray = array('TRACKINGID'=>$trackingid);                                    
        $this->session->set_userdata($sessionArray);
        $this->global['trackingsession'] = $this->session->userdata ('TRACKINGID');
        $dateTimeSoustraire = strtotime('-5 minute');
        $data['trackingResults'] = $this->Tracking_model->getAllByDateTimeAndType($dateTimeSoustraire,0); 

        $this->loadViews("supervisor/tracking/list", $this->global, $data , NULL);
    }

    public function refreshdata(){
        $retour = array();
        $i = 0;
        if (isset($_POST['RELOAD'])) {
            $dateTimeSoustraire = strtotime('-5 minute');
            $dataResult = $this->Tracking_model->getAllByDateTimeAndType($dateTimeSoustraire,0); 
            
            if (count($dataResult) >= 1) {
                foreach($dataResult as $res){
                    $retour[$i]['trackingResultArray'] = array(
                        'user_id'         => $res->user_id,
                        'trackingId'      => $res->id_tracking,
                        'user_nomination' => $this->convert_utf8($res->nomination),
                        'dernier_click'   => $this->convert_utf8($res->timeCnx),
                        'last_activity'   => $this->convert_utf8($this->Tracking_model->returnMAxLastActivityByCnx($res->id_cnx))
                    );
                    $i++;
                }
            }
        }
        echo json_encode($retour);
    }*/

    public function Detail(){
        ini_set('memory_limit', -1);
        $this->global['pageTitle'] = 'E-learning : Tracking stagiaire';   

        $this->load->library('form_validation');
        $this->form_validation->set_rules('connexion_date', 'Date début', 'required');
        //$this->form_validation->set_rules('trainee', 'Stagiaire', '');
        $this->form_validation->set_rules('prof', 'Professeur', '');
        $this->form_validation->set_rules('creneau_horaire', 'Créneau horaire', '');

        //$data['traineeResults'] = $this->membres_model->filtrer('',STAGIAIRE,'2'); 
        $data['trainerResults'] = $this->CoursPlannifier_model->getAllTrainerCp(); 
        $data['creneauHoraire']  = $this->CoursPlannifier_model->getAllCrenauRes(); 
        //$data['all_society'] = $this->societe_model->read(''); 

        if ($this->form_validation->run() != FALSE) { 
            $dateTracking = explode(' - ', $this->input->post('connexion_date'));
            $postData = array(
                'connexion_date'   => array(
                    0 => isset($dateTracking[0]) ? $dateTracking[0] : '',
                    1 => isset($dateTracking[1]) ? $dateTracking[1] : ''
                ),
                'crenneauHoraire'      => $this->input->post('creneau_horaire'),
                //'trainee'                => $this->input->post('trainee'),
                'prof'                    => $this->input->post('prof')
            );
            $data['postData']            = $postData; 
            $data['allResults']          = $this->QueryStat_model->monitoringTraineeTrackingDetail($postData); 
        }
        $this->loadViews("supervisor/tracking/detail", $this->global, $data , NULL);
    }
}

?>