<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Sequence extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->isLoggedIn();   
        $this->width      = "1200";
        $this->height     = "1280";
        $this->date       = time();
        $this->tracking_type = 8; 
    }
    
    /**
     * This function used to load the first screen of the sequence
     */
  
    public function index()
    {
        
        $this->global['pageTitle'] = 'E-learning : Forma2+';
        
        $this->loadViews("traineeTodoList", $this->global, NULL , NULL);
    }

    /*public function viewprogramme($PAVE)
    {
        $retour = "";
        $nbrBtn= 1;
        $nbrMod= 1;
        $nbrSeq= 1;
        $lienCol= 1;
        $sequence_id;
        $paves_sequence_nom = '';
        //Declaration variable numero pour chaque liste
        $numeroSeq = 0;
        switch ($PAVE) {
            case 4:
               $paves_sequence_nom.= $this->lang->line('educational_library_newsletter');
               $this->global['titlelibrary'] = $this->lang->line('educational_library_newsletter');
               $this->tracking_type = 6; 
                break;
            case 6:
                $paves_sequence_nom.=$this->lang->line('educational_library_pedagogical_training');
                $this->global['titlelibrary'] = $this->lang->line('educational_library_pedagogical_training');
                $this->tracking_type = 7; 
                break;
            case 7:
                $paves_sequence_nom.= $this->lang->line('educational_library_personnal_interest');
                $this->global['titlelibrary'] =  $this->lang->line('educational_library_personnal_interest');
                $this->tracking_type = 8; 
                break;
            case 8:
                $paves_sequence_nom.=$this->lang->line('educational_library_lingustic_tools');
                $this->global['titlelibrary'] = $this->lang->line('educational_library_lingustic_tools');
                $this->tracking_type = 9; 
                break;           
        }
        $trackingid = $this->tracking_model->Add(0,0,$this->tracking_type);
        $sessionArray = array('TRACKINGID'=>$trackingid);                                    
        $this->session->set_userdata($sessionArray);
        $this->global['trackingsession'] = $this->session->userdata ('TRACKINGID');
        
        $this->global['pageTitle'] = 'E-learning : '.$paves_sequence_nom;
        $this->global['sequenceTitle'] = $paves_sequence_nom;
        $this->global['groupe'] = $this->session->userdata ('GROUPE');

        $url_sequence = ""; 
        $codeHTML  = '<div class="box">'; 
        $codeHTML  .='<input type="hidden" class="current_module" id="current_module">';
        $codeHTML  .='<input type="hidden" class="current_tracking_type" id="current_tracking_type" value="'.$this->tracking_type.'">';
        $codeHTML  .= '<div class="item" id="item-smart">'; 
        define('PAGELOCALFORMATION',  base_url().'formation'); 
       
        if($PAVE!=''){
            $ret_complementary_activities=$this->sequence_model->getPavetComplementary($this->session->userdata ('GROUPE'));  
            $ret_newsletter2 = $this->sequence_model->getPavetSequenceHaut($this->session->userdata ('GROUPE'),$this->session->userdata ('GUSERID'),$PAVE);
            if(!empty($ret_newsletter2)){
                if(is_array($ret_newsletter2['module'])){
                    $active_menu = '';
                    foreach($ret_newsletter2['module'] as $key2=>$value2){
                        if(is_array($value2)){ 
                            $ident = str_replace(" ", "_", $key2);
                            $identity = str_replace("-", "_", $ident);
                            $keywordLabel = '';
                            foreach($value2 as $key3=>$value3){
                                $keywordLabel .= ($this->session->userdata ('site_lang') == 'english' && $key2 == "Les conseils d'Anastasia") ? "Anastasia's Tips" : $key2;
                                $back = $this->codeColor_model->Request('background',$nbrBtn); 
                                $brdl = $this->codeColor_model->Request('border_left',$nbrBtn); 
                                $text = $this->codeColor_model->Request('text',$nbrBtn); 

                                $codeHTML.= ' <button  style="background-color: '.$back.';border-color:'.$brdl.';color:'.$text.' !important;" data-id="'.$value3['module_id'].'" class="btn btn-module-'.$nbrBtn.' btn-mod" value="'.$nbrBtn.'">'.$keywordLabel.'</button>';
                                $nbrBtn= $nbrBtn + 1;
                            }
                            
                        }
                    }
                    if($PAVE=='6'){
                        $codeHTML.= ' <button class="btn btn-module-'.$nbrBtn.' btn-mod" value="'.$nbrBtn.'">Complementary Activities</button>';
                    }
                    
                    $codeHTML.='</div>';
                    $codeHTML.='<input type="hidden" class="domain_select" value="'.$PAVE.'">';
                    $codeHTML.='<div class="box text-left title-active-menu-pg"><h5 class="content_title"><b>Your sequences (content of your module)</b></h5></div>';
                    //$codeHTML.='<div class="box" style="display:none;"><h5 class="titre-your-module titre-seq"><span class="navigation-title-pdg">Navigation</span> : <a onclick="showSequence(this);" class="btn btn-module-1 btn-mod ChangeBtn btn-stan-incons" value="'.$nbrBtn.'"></a></h5><br></div>';

                    $nbrBtn= 1;
                    $codeHTML.='<div class="embed-responsive embed-responsive-16by9 iframe-sequence-activity-el"><iframe class="embed-responsive-item iframeActivitySequence" allowfullscreen style="visibility:visible"></iframe></div> ';
                    foreach($ret_newsletter2['module'] as $key2=>$value2){
                        if(is_array($value2)){ 
                            $ident = str_replace(" ", "_", $key2);
                            $identity = str_replace("-", "_", $ident);

                            $codeHTML.= '<div class="row module'.$nbrMod.' modus" value="'.$nbrBtn.'">';
                            $nbrBtn= $nbrBtn + 1;
                            $nbrMod= $nbrMod + 1;
                            foreach($value2 as $key3=>$value3){
                                $ret_newsletter3=$this->sequence_model->getPavetSequenceHauts($value3['MODULENAME'],$value3['idg'],$value3['module_id'],$PAVE);
                                foreach($ret_newsletter3['module'] as $key4=>$value4){
                                    if(is_array($value4)){
                                        $sequenceName = '';
                                        foreach($value4 as $key5=>$value5){
                                            if($value5['sequence_name'] != "") {
                                                $sequenceName = ($this->session->userdata ('site_lang') == 'english' && $value5['sequence_name'] == "Articles REBONDIR") ? "Anastasia Autret's Tips" : $value5['sequence_name'];
                                                $sequenceUrl   = $value5['sequence_url'];  
                                                $idsequence    = $value5['sequence_id'];   
                                                $locsequence    = $value5['locs'];   
                                                //$resutlthumb = $this->utilities_model->getinfothumbs($idsequence,$locsequence,1);
                                                //Thumb
                                                $thumbnailSeq = $this->sequence_model->getThumbFromLastSequence($idsequence);
                                                if ($thumbnailSeq != '') {
                                                    $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnailSeq;
                                                }
                                                else{

                                                    $fileimg = base_url()."groupes/img_default.jpg";
                                                }
                                                $codeHTML .=' 
                                                    <div class="col-md-2 sequenceTotal">
                                                        <div class="sequ1 sequence" onclick="getAllActivityBySequence(this);"" value="'.$nbrSeq.'" data-name="'.$sequenceName.'" data-id="'.$idsequence.'">
                                                        <img class="" id="image-thumb"  src="'.$fileimg.'" width="100%" height="100%" style="border-radius:10px;">
                                                        <div class="sequence-hover" value="'.$nbrSeq.'">
                                                            <div class = "btn-group-vertical btn-action-activity">
                                                                <a class="btn link-action-nl" onclick="addCommentSequence(this);" data-id="'.$idsequence.'" data-code="'.$value5['code'].'" title="Add comment">
                                                                    <img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" class="image-action-nl img-comment-nl" style="z-index:100 !important;">
                                                                </a>
                                                                <a data-title="'.$sequenceName.'" data-id="'.$idsequence.'" data-code="'.$value5['code'].'" class="btn link-action-nl" onclick="addSequenceInFavorite(this);" title="Add favorite">
                                                                    <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Favorites-vignette-Normal.png" class="image-action-nl img-favorite-nl" style="z-index:100 !important;">
                                                                </a>
                                                            </div>
                                                        </div>
                                                        </div>
                                                        <p>'.$sequenceName.'</p>
                                                     ';
                                                    $nbrSeq= $nbrSeq + 1;
                                                    $imgthumbnail = '';
                                                    $class = '';
                                                
                                                $codeHTML .='</div>';
                                                if (isset($chapitre['cnt'])) {
                                                    // colonne lien
                                                    $codeHTML.=' <div class="row col_lien " value="'.$lienCol.'">
                                                    <div class="col-md-12">
                                                    <h5 class="titre-your-module titre-activ"><b>Activities of '.$sequenceName.' </b></h5> 
                                                    </div>
                                                    <div class="row row-lien">
                                                    ';
                                                    $lienCol= $lienCol + 1;
                                                    $codeHTML .='</div></div>';
                                                    
                                                }
                                            }
                                        }


                                    }
                                }
                            }
                            
                            $codeHTML.='</div>';
                        }
                    }
                }
            }
            
            $array_newsletter = $this->sequence_model->getPavetHaut($this->session->userdata ('GROUPE'),4);
            $array_ped_training = $this->sequence_model->getPavetHaut($this->session->userdata ('GROUPE'),6);
            $array_pers_ling = $this->sequence_model->getPavetHaut($this->session->userdata ('GROUPE'),7);
            $array_ling_tools = $this->sequence_model->getPavetHaut($this->session->userdata ('GROUPE'),8);

            $arrayListeModule = array();
            $array_id_module_newsletter = array();
            $array_id_module_ped_training = array();
            $array_id_module_pers_ling = array();
            $array_id_module_ling_tools = array();   

            if(!empty($array_newsletter)){
                if (is_array($array_newsletter['module'])) {
                    foreach($array_newsletter['module'] as $key=>$value){
                        foreach($value as $key2=>$value2){
                            $arrayListeModule[] = $value2['module_id'];
                            $array_id_module_newsletter[] = $value2['module_id'];
                        }
                    }
                }
            }
            if(!empty($array_ped_training)){
                if (is_array($array_ped_training['module'])) {
                    foreach($array_ped_training['module'] as $key=>$value){
                        foreach($value as $key2=>$value2){
                            $arrayListeModule[] = $value2['module_id'];
                            $array_id_module_ped_training[] = $value2['module_id'];
                        }
                    }
                }
            }
            if(!empty($array_pers_ling)){
                if (is_array($array_pers_ling['module'])) {
                    foreach($array_pers_ling['module'] as $key=>$value){
                        foreach($value as $key2=>$value2){
                            $arrayListeModule[] = $value2['module_id'];
                            $array_id_module_pers_ling[] = $value2['module_id'];
                        }
                    }
                }
            }
            if(!empty($array_ling_tools)){
                if (is_array($array_ling_tools['module'])) {
                    foreach($array_ling_tools['module'] as $key=>$value){
                        foreach($value as $key2=>$value2){
                            $arrayListeModule[] = $value2['module_id'];
                            $array_id_module_ling_tools[] = $value2['module_id'];
                        }
                    }
                }
            }
            if(!empty($ret_complementary_activities)){
                if (is_array($ret_complementary_activities['module'])) {
                    foreach($ret_complementary_activities['module'] as $key=>$value){
                        $arrayListeModule[] = $value['module_id'];
                    }
                }
            }

            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_newsletter) ;
            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ped_training) ;
            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_pers_ling) ;
            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ling_tools) ;          
            if(!empty($ret_complementary_activities)){
                if(is_array($ret_complementary_activities['module']) && $PAVE=='6'){
                    $codeHTML.= '<div class="row module'.$nbrMod.' modus" value="'.$nbrBtn.'">';
                    foreach($ret_complementary_activities['module'] as $key=>$value){
                        if (in_array($value['module_id'], $arrayListeModule)) {
                            $thumbnailSeq = $this->sequence_model->getThumbFromLastSequence($value['sequence_id']);
                            if ($thumbnailSeq != '') {
                                $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnailSeq;
                            }
                            else{

                                $fileimg = base_url()."groupes/img_default.jpg";
                            }
                            $codeHTML .=' 
                                <div class="col-md-2 sequenceTotal">
                                    <div class="sequ1 sequence" onclick="getAllActivityBySequence(this);"" value="'.$nbrSeq.'" data-name="'.$value['sequence_name'].'" data-id="'.$value['sequence_id'].'">
                                    <img class="" id="image-thumb"  src="'.$fileimg.'" width="100%" height="100%" style="border-radius:10px;">
                                    <div class="sequence-hover" value="'.$nbrSeq.'">
                                        <div class = "btn-group-vertical btn-action-activity">
                                            <a class="btn link-action-nl btn-add-comment-activity" title="Add comment">
                                                <img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" class="image-action-nl img-comment-nl" style="z-index:100 !important;">
                                            </a>
                                            <a data-title="'.$value['sequence_name'].'" data-id="'.$value['sequence_id'].'" data-code="'.$value['code'].'" class="btn link-action-nl" onclick="addSequenceInFavorite(this);" title="Add favorite">
                                                <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Favorites-vignette-Normal.png" class="image-action-nl img-favorite-nl" style="z-index:100 !important;">
                                            </a>
                                        </div>
                                    </div>
                                    </div>
                                    <p>'.htmlentities($value['sequence_name']).'</p>
                                 ';
                            $codeHTML .='</div>';
                        } 
                    } 
                    $codeHTML.='</div>';
                } 
            }

            if(empty($array_newsletter) && empty($ret_complementary_activities)){
                $codeHTML.='
                <div class="row">
                    <div class="col-md-12 text-center">
                        <h4 class="nothing-data text-center">No data available in database</h4>
                    </div>
                </div>';
            }
          
        }
        else
        {
            $codeHTML.= '
                <div class="bloc_customisedprog">
                    <h2>Your customised program</h2>
                    <div id="sidetree"><div class="treeheader">&nbsp;</div><strong>To start, Select your program from the four buttons above</strong>
                    </div>
                </div>';
              
        }
        $codeHTML.="</div>";    

        $this->global['classification_favoris']  = $this->classificationFavoris_Model->getByUserCreateIdGroup($this->session->userdata('GUSERID'),$this->session->userdata ('GROUPE'));          

        $data['sequenceview'] = $codeHTML;

        $this->loadViews("trainee/sequence/index", $this->global,$data, NULL );
    }*/
    /*public function viewprogramme($PAVE)
    {
        $retour = "";
        $nbrBtn= 1;
        $nbrMod= 1;
        $nbrSeq= 1;
        $lienCol= 1;
        $sequence_id;
        $paves_sequence_nom = '';
        $tabContentHtml = '';
        //Declaration variable numero pour chaque liste
        $numeroSeq = 0;
        switch ($PAVE) {
            case 4:
               $paves_sequence_nom.= $this->lang->line('educational_library_newsletter');
               $this->global['titlelibrary'] = $this->lang->line('educational_library_newsletter');
               $this->tracking_type = 6; 
                break;
            case 6:
                $paves_sequence_nom.=$this->lang->line('educational_library_pedagogical_training');
                $this->global['titlelibrary'] = $this->lang->line('educational_library_pedagogical_training');
                $this->tracking_type = 7; 
                break;
            case 7:
                $paves_sequence_nom.= $this->lang->line('educational_library_personnal_interest');
                $this->global['titlelibrary'] =  $this->lang->line('educational_library_personnal_interest');
                $this->tracking_type = 8; 
                break;
            case 8:
                $paves_sequence_nom.=$this->lang->line('educational_library_lingustic_tools');
                $this->global['titlelibrary'] = $this->lang->line('educational_library_lingustic_tools');
                $this->tracking_type = 9; 
                break;           
        }
        $data['PAVE_SEQUENCE'] = $PAVE;
        $trackingid = $this->tracking_model->Add(0,0,$this->tracking_type);
        $sessionArray = array('TRACKINGID'=>$trackingid);                                    
        $this->session->set_userdata($sessionArray);
        $this->global['trackingsession'] = $this->session->userdata ('TRACKINGID');
        
        $this->global['pageTitle'] = 'E-learning : '.$paves_sequence_nom;
        $this->global['groupe'] = $this->session->userdata ('GROUPE');
        $this->global['sequenceTitle'] = $paves_sequence_nom;
        $data['TRACKING_TYPE'] = $this->tracking_type;

        $url_sequence = ""; 
        define('PAGELOCALFORMATION',  base_url().'formation'); 
       
        if($PAVE!=''){
            $ret_complementary_activities=$this->sequence_model->getPavetComplementary($this->session->userdata ('GROUPE'));  
            $data['ret_newsletter2'] = $this->sequence_model->getPavetSequenceHaut($this->session->userdata ('GROUPE'),$this->session->userdata ('GUSERID'),$PAVE);  
            $nbrBtn= 1;
            $active = '';
            foreach($data['ret_newsletter2']['module'] as $key2=>$value2){
                if(is_array($value2)){ 
                    $active = $nbrBtn == 1 ? 'active' : '';
                    $tabContentHtml.= '<div id="content-'.$nbrBtn.'" class="tab-content '.$active.' container-sequence">';
                        $tabContentHtml.= '<div class="tab-title title-active-menu-pg"><h2 class="content_title">Your sequences (content of '.$key2.')</h2></div>';
                        $tabContentHtml .= '<div class="card-container">';
                            foreach($value2 as $key3=>$value3){
                                $ret_newsletter3=$this->sequence_model->getPavetSequenceHauts($value3['MODULENAME'],$value3['idg'],$value3['module_id'],$PAVE);
                                foreach($ret_newsletter3['module'] as $key4=>$value4){
                                    if(is_array($value4)){
                                        $sequenceName = '';
                                        foreach($value4 as $key5=>$value5){
                                            if($value5['sequence_name'] != "") {
                                                $sequenceName = ($this->session->userdata ('site_lang') == 'english' && $value5['sequence_name'] == "Articles REBONDIR") ? "Anastasia Autret's Tips" : $value5['sequence_name'];
                                                $sequenceUrl   = $value5['sequence_url'];  
                                                $idsequence    = $value5['sequence_id'];   
                                                $locsequence    = $value5['locs'];   
                                                //Thumb
                                                $thumbnailSeq = $this->sequence_model->getThumbFromLastSequence($idsequence);
                                                if ($thumbnailSeq != '' && file_exists($thumbnailSeq)) {
                                                    $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnailSeq;
                                                }
                                                else{

                                                    $fileimg = base_url()."groupes/bg-laptop.png";
                                                }
                                                $tabContentHtml .= '<div class="card-style-1">
                                                    <div class="card">
                                                        <div class="card-left">
                                                            <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                        </div>
                                                        <div class="card-right sequenceTotal">
                                                            <div class="card-title">
                                                                <h4>'.$this->convert_utf8($sequenceName).'</h4>
                                                            </div>
                                                            <div class="card-footer">
                                                                <a href="#" class="btn-see" onclick="getAllActivityBySequence(this);" data-pave="'.$PAVE.'" value="'.$nbrSeq.'" data-name="'.$sequenceName.'" data-ids="'.$idsequence.'">
                                                                    <i class="fa-solid fa-eye"></i>
                                                                </a>
                                                                <a href="#" data-title="'.$this->convert_utf8($sequenceName).'" class="add-comment" onclick="addCommentSequence(this);" data-id="'.$idsequence.'" data-code="'.$value5['code'].'" title="Add comment">
                                                                    <i class="fa-solid fa-comment"></i>
                                                                </a>
                                                                <a data-title="'.$this->convert_utf8($sequenceName).'" data-id="'.$idsequence.'" data-code="'.$value5['code'].'" class="add-favorite" onclick="addSequenceInFavorite(this);" title="Add favorite">
                                                                    <i class="fa-solid fa-heart"></i>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>';
                                            }
                                        }
                                    }
                                }
                            }
                        $tabContentHtml.='</div>';
                    $tabContentHtml.='</div>';
                    $nbrBtn= $nbrBtn + 1;
                }
            }   

            $array_newsletter = $this->sequence_model->getPavetHaut($this->session->userdata ('GROUPE'),4);
            $array_ped_training = $this->sequence_model->getPavetHaut($this->session->userdata ('GROUPE'),6);
            $array_pers_ling = $this->sequence_model->getPavetHaut($this->session->userdata ('GROUPE'),7);
            $array_ling_tools = $this->sequence_model->getPavetHaut($this->session->userdata ('GROUPE'),8);

            $arrayListeModule = array();
            $array_id_module_newsletter = array();
            $array_id_module_ped_training = array();
            $array_id_module_pers_ling = array();
            $array_id_module_ling_tools = array();   

            if(!empty($array_newsletter)){
                if (is_array($array_newsletter['module'])) {
                    foreach($array_newsletter['module'] as $key=>$value){
                        foreach($value as $key2=>$value2){
                            $arrayListeModule[] = $value2['module_id'];
                            $array_id_module_newsletter[] = $value2['module_id'];
                        }
                    }
                }
            }
            if(!empty($array_ped_training)){
                if (is_array($array_ped_training['module'])) {
                    foreach($array_ped_training['module'] as $key=>$value){
                        foreach($value as $key2=>$value2){
                            $arrayListeModule[] = $value2['module_id'];
                            $array_id_module_ped_training[] = $value2['module_id'];
                        }
                    }
                }
            }
            if(!empty($array_pers_ling)){
                if (is_array($array_pers_ling['module'])) {
                    foreach($array_pers_ling['module'] as $key=>$value){
                        foreach($value as $key2=>$value2){
                            $arrayListeModule[] = $value2['module_id'];
                            $array_id_module_pers_ling[] = $value2['module_id'];
                        }
                    }
                }
            }
            if(!empty($array_ling_tools)){
                if (is_array($array_ling_tools['module'])) {
                    foreach($array_ling_tools['module'] as $key=>$value){
                        foreach($value as $key2=>$value2){
                            $arrayListeModule[] = $value2['module_id'];
                            $array_id_module_ling_tools[] = $value2['module_id'];
                        }
                    }
                }
            }
            if(!empty($ret_complementary_activities)){
                if (is_array($ret_complementary_activities['module'])) {
                    foreach($ret_complementary_activities['module'] as $key=>$value){
                        $arrayListeModule[] = $value['module_id'];
                    }
                }
            }

            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_newsletter) ;
            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ped_training) ;
            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_pers_ling) ;
            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ling_tools) ;          
            if(!empty($ret_complementary_activities)){
                if(is_array($ret_complementary_activities['module']) && $PAVE=='6'){
                    $tabContentHtml.= '<div id="content-000000" class="tab-content container-sequence">';
                        $tabContentHtml.= '<div class="tab-title title-active-menu-pg"><h2 class="content_title">Your sequences (content of Complementary Activities)</h2></div>';
                        $tabContentHtml .= '<div class="card-container">';
                            foreach($ret_complementary_activities['module'] as $key=>$value){
                                if (in_array($value['module_id'], $arrayListeModule)) {
                                    $thumbnailSeq = $this->sequence_model->getThumbFromLastSequence($value['sequence_id']);
                                    if ($thumbnailSeq != '' && file_exists($thumbnailSeq)) {
                                        $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnailSeq;
                                    }
                                    else{

                                        $fileimg = base_url()."groupes/bg-laptop.png";
                                    }
                                    $tabContentHtml .= '
                                    <div class="card-style-1">
                                        <div class="card">
                                            <div class="card-left">
                                                <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                            </div>
                                            <div class="card-right sequenceTotal">
                                                <div class="card-title">
                                                    <h4>'.$value['sequence_name'].'</h4>
                                                </div>
                                                <div class="card-footer">
                                                    <a href="#" class="btn-see" onclick="getAllActivityBySequence(this);" tablinks" data-pave="'.$PAVE.'" value="'.$nbrSeq.'" data-name="'.$value['sequence_name'].'" data-ids="'.$value['sequence_id'].'">
                                                        <i class="fa-solid fa-eye"></i>
                                                    </a>
                                                    <a href="#" data-title="'.$this->convert_utf8($value['sequence_name']).'" class="add-comment" onclick="addCommentSequence(this);" data-id="'.$value['sequence_id'].'" data-code="'.$value5['code'].'" title="Add comment">
                                                        <i class="fa-solid fa-comment"></i>
                                                    </a>
                                                    <a data-title="'.$this->convert_utf8($value['sequence_name']).'" data-id="'.$value['sequence_id'].'" data-code="'.$value5['code'].'" class="add-favorite" onclick="addSequenceInFavorite(this);" title="Add favorite">
                                                        <i class="fa-solid fa-heart"></i>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>';
                                } 
                            } 
                        $tabContentHtml.='</div>';
                    $tabContentHtml.='</div>';
                } 
            }

            if($tabContentHtml == ''){
                $tabContentHtml.='
                <div class="row empty-data-row">
                    <div class="col-md-12 text-center">
                        <h4 class="nothing-data text-center">'.$this->lang->line('my_link_and_document_datatable_empty_data').'</h4>
                    </div>
                </div>';
            }      
          
        }
        $data['tabContentHtml'] = $tabContentHtml;

        $this->global['classification_favoris']  = $this->classificationFavoris_Model->getByUserCreateIdGroup($this->session->userdata('GUSERID'),$this->session->userdata ('GROUPE'));          


        $this->loadViews("trainee/sequence/index", $this->global,$data, NULL );
    }*/
    public function viewprogramme($PAVE)
    {
        $retour = "";
        $nbrBtn= 1;
        $nbrMod= 1;
        $nbrSeq= 1;
        $lienCol= 1;
        $sequence_id;
        $paves_sequence_nom = '';
        $tabContentHtml = '';
        //Declaration variable numero pour chaque liste
        $numeroSeq = 0;
        switch ($PAVE) {
            case 4:
               $paves_sequence_nom.= $this->lang->line('educational_library_newsletter');
               $this->global['titlelibrary'] = $this->lang->line('educational_library_newsletter');
               $this->tracking_type = 6; 
                break;
            case 6:
                $paves_sequence_nom.=$this->lang->line('educational_library_pedagogical_training');
                $this->global['titlelibrary'] = $this->lang->line('educational_library_pedagogical_training');
                $this->tracking_type = 7; 
                break;
            case 7:
                $paves_sequence_nom.= $this->lang->line('educational_library_personnal_interest');
                $this->global['titlelibrary'] =  $this->lang->line('educational_library_personnal_interest');
                $this->tracking_type = 8; 
                break;
            case 8:
                $paves_sequence_nom.=$this->lang->line('educational_library_lingustic_tools');
                $this->global['titlelibrary'] = $this->lang->line('educational_library_lingustic_tools');
                $this->tracking_type = 9; 
                break;           
        }
        $data['PAVE_SEQUENCE'] = $PAVE;

        $dataLastActivity = array(
            'last_activity' => $paves_sequence_nom
        );
        $this->updateLastActivity($dataLastActivity);
        
        $this->loadTrackingEl(0,0,$this->tracking_type);
        
        $this->global['pageTitle'] = 'E-learning : '.$paves_sequence_nom;
        $this->global['groupe'] = $this->session->userdata ('GROUPE');
        $this->global['sequenceTitle'] = $paves_sequence_nom;
        $data['TRACKING_TYPE'] = $this->tracking_type;

        $url_sequence = ""; 
        define('PAGELOCALFORMATION',  base_url().'formation'); 
        $data['ret_newsletter2'] = $this->sequence_model->getPavetSequenceHaut($this->session->userdata ('GROUPE'),$this->session->userdata ('GUSERID'),$PAVE);
        $nbrBtn    = 1;
        $moduleId;
        $moduleName;
        $groupeId;
        if(isset($data['ret_newsletter2']) && !empty($data['ret_newsletter2'])){
            if(is_array($data['ret_newsletter2']['module'])){ 
                foreach($data['ret_newsletter2']['module'] as $key2=>$value2){ if(is_array($value2)){ 
                    foreach($value2 as $key3=>$value3){ 
                        if ($nbrBtn == 1) {
                            $moduleId     = $value3['module_id'];
                            $moduleName   = $key2;
                            $groupeId     = $value3['idg'];
                        }
                        $nbrBtn ++; }
                    }
                }
            }
        }

        
        if (isset($moduleId) && $moduleId > 0) {
            $data['dataLoadPageLibrary']  = $this->getModuleContentLoadPage($groupeId,$moduleId,$moduleName,$PAVE);

        }
        $ret_complementary_activities=$this->sequence_model->getPavetComplementary($this->session->userdata ('GROUPE')); 
        $array_newsletter = $this->sequence_model->getPavetHaut($this->session->userdata ('GROUPE'),4);
        $array_ped_training = $this->sequence_model->getPavetHaut($this->session->userdata ('GROUPE'),6);
        $array_pers_ling = $this->sequence_model->getPavetHaut($this->session->userdata ('GROUPE'),7);
        $array_ling_tools = $this->sequence_model->getPavetHaut($this->session->userdata ('GROUPE'),8);

        $arrayListeModule = array();
        $array_id_module_newsletter = array();
        $array_id_module_ped_training = array();
        $array_id_module_pers_ling = array();
        $array_id_module_ling_tools = array();   

        if(!empty($array_newsletter)){
            if (is_array($array_newsletter['module'])) {
                foreach($array_newsletter['module'] as $key=>$value){
                    foreach($value as $key2=>$value2){
                        $arrayListeModule[] = $value2['module_id'];
                        $array_id_module_newsletter[] = $value2['module_id'];
                    }
                }
            }
        }
        if(!empty($array_ped_training)){
            if (is_array($array_ped_training['module'])) {
                foreach($array_ped_training['module'] as $key=>$value){
                    foreach($value as $key2=>$value2){
                        $arrayListeModule[] = $value2['module_id'];
                        $array_id_module_ped_training[] = $value2['module_id'];
                    }
                }
            }
        }
        if(!empty($array_pers_ling)){
            if (is_array($array_pers_ling['module'])) {
                foreach($array_pers_ling['module'] as $key=>$value){
                    foreach($value as $key2=>$value2){
                        $arrayListeModule[] = $value2['module_id'];
                        $array_id_module_pers_ling[] = $value2['module_id'];
                    }
                }
            }
        }
        if(!empty($array_ling_tools)){
            if (is_array($array_ling_tools['module'])) {
                foreach($array_ling_tools['module'] as $key=>$value){
                    foreach($value as $key2=>$value2){
                        $arrayListeModule[] = $value2['module_id'];
                        $array_id_module_ling_tools[] = $value2['module_id'];
                    }
                }
            }
        }
        if(!empty($ret_complementary_activities)){
            if (is_array($ret_complementary_activities['module'])) {
                foreach($ret_complementary_activities['module'] as $key=>$value){
                    $arrayListeModule[] = $value['module_id'];
                }
            }
        }

        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_newsletter) ;
        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ped_training) ;
        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_pers_ling) ;
        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ling_tools) ;  
        $data['ret_complementary_activities']  = $ret_complementary_activities;
        $data['arrayListeModule']  = $arrayListeModule;
        $data['moduleloaded']  = (isset($moduleId) && $moduleId > 0) ? $moduleId : null;
        $data['classification_favoris']  = $this->classificationFavoris_Model->getByUserCreateIdGroup($this->session->userdata('GUSERID'),$this->session->userdata ('GROUPE')); 

        $this->loadViews("trainee/sequence/index", $this->global,$data, NULL );
    }


    
    public function pageNotFound()
    {
        $this->global['pageTitle'] = 'CodeInsect : 404 - Page Not Found';
        
        $this->loadViews("404", $this->global, NULL, NULL);
    }
    public function isRedirectLinks($link) {
        $isRedirect = false;
        $redirectlinksArray = array("manythings.org", 
                                    "e-anglais.com", 
                                    "a4esl.org", 
                                    "iteslj.org", 
                                    "owl.english.purdue.edu", 
                                    "rottentomatoes.com", 
                                    "cdkitchen.com",
                                    "nytimes.com");
        foreach ($redirectlinksArray as $i => $value) {
            if((preg_match("#".$redirectlinksArray[$i]."#", $link))|| (preg_match("#https#", $link))) {
            //if(preg_match("https", $link)) {
                $isRedirect = true;
                break;
            }
        }
        return $isRedirect;
    }   


    public function scan($id,$num){
        $seq= $this->sequence_model->readSequence($id,"",$num);
        for($j=0;$j<$seq['cnt'];$j++)  {             
            $link_support = $seq[$j]['link'];
            $thumbnailFile="";
            $redir        = 'redir.php?url';
            $support      = '';
            $urlF         = "";
            if (($seq[$j]['link'] != "" || $seq[$j]['link'] != NULL) && $seq[$j]['thumbnail'] == "") {
               
                if ($this->validate_url($link_support)){
                    $support      .= $redir.$link_support;
                    $urlF         .= $link_support;
                }
                else{
                    if (strpos($link_support, $redir) == false) { 
                        //echo "1 : ".$link_support."<br>";
                        $filename      = $this->getFileName($link_support);

                        $ext            = explode(".", $filename);

                        if (isset($ext[1]) && $ext[1]=="pdf") {
                            $urlF         .= HTTP_FORMATIONS.$link_support;
                        }
                        elseif (isset($ext[1]) && ($ext[1]=="doc" || $ext[1]=="docx" || $ext[1]=="ppt")){
                            $urlF   .= base_url().'groupes/index.php?link='.HTTP_FORMATIONS.$link_support;;
                        }
                        else{
                            //donwload file (default thumbnail)
                            $urlF  .= HTTP_FORMATIONS.$link_support;
                        }
                        //Lecture document localement
                        $support      .= $link_support;
                    }                 
                    else { 
                        //echo "2 : ".$link_support."<br>";
                        $support      .=$link_support;
                        $urlF         .= str_replace("/redir.php?url=", "", $link_support);                 
                    } 
                }
                $thumbnailFiles = "thumbnail_".time().'_'.$this->session->userdata('GUSERID').'.png';
                
                if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                    mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
                }   

                $fileLocation = REP_ACTIVITY_SEQUENCE.$thumbnailFiles; 
                $urlDest = $this->findUltimateDestination($urlF,10);
                if ($this->validate_url($urlDest)){
                    $thumb = $this->generateThumbnail($urlDest,$this->width,$this->height,$fileLocation);

                    if($thumb){
                        $activityInfo = array(
                            "date_create" => $this->date,
                            "thumbnail_file" => $thumbnailFiles
                        );
                        $this->sequence_model->updateChapitre($id,$num,$activityInfo);

                    }
                    //echo "link initial : ".$seq[$j]['link']." link final : ".$urlF;
                   
                }
            }
            elseif ($seq[$j]['thumbnail'] != "" && !file_exists(REP_ACTIVITY_SEQUENCE.$seq[$j]['thumbnail'])) {
                if ($this->validate_url($link_support)){
                    $support      .= $redir.$link_support;
                    $urlF         .= $link_support;
                }
                else{
                    if (strpos($link_support, $redir) == false) { 
                        //echo "1 : ".$link_support."<br>";
                        $filename      = $this->getFileName($link_support);

                        $ext            = explode(".", $filename);

                        if (isset($ext[1]) && $ext[1]=="pdf") {
                            $urlF         .= HTTP_FORMATIONS.$link_support;
                        }
                        elseif (isset($ext[1]) && ($ext[1]=="doc" || $ext[1]=="docx" || $ext[1]=="ppt")){
                            $urlF   .= base_url().'groupes/index.php?link='.HTTP_FORMATIONS.$link_support;;
                        }
                        else{
                            //donwload file (default thumbnail)
                            $urlF  .= HTTP_FORMATIONS.$link_support;
                        }
                        //Lecture document localement
                        $support      .= $link_support;
                    }                 
                    else { 
                        //echo "2 : ".$link_support."<br>";
                        $support      .=$link_support;
                        $urlF         .= str_replace("/redir.php?url=", "", $link_support);                 
                    } 
                }
                $thumbnailFiles = "thumbnail_".time().'_'.$this->session->userdata('GUSERID').'.png';
                
                if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                    mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
                }   

                $fileLocation = REP_ACTIVITY_SEQUENCE.$thumbnailFiles; 
                $urlDest = $this->findUltimateDestination($urlF,10);
                if ($this->validate_url($urlDest)){
                    $thumb = $this->generateThumbnail($urlDest,$width,$height,$fileLocation);

                    if($thumb){
                        $activityInfo = array(
                            "date_create" => $date,
                            "thumbnail_file" => $thumbnailFiles
                        );
                        if (isset($_POST['num']) && ($_POST['num'] != "" || $_POST['num'] != NULL)) {
                            $this->sequence_model->updateChapitre($id,$_POST['num'],$activityInfo);
                        }
                        else{
                            $this->sequence_model->updateChapitre($id,$seq[$j]['numero'],$activityInfo);
                        }
                        echo "fileLocation : " .$fileLocation." id : ".$id. " numero : ".$seq[$j]['numero'].'<br>';
                    }
                    //echo $id." link initial2 : ".$seq[$j]['link']." link final2 : ".$urlDest.'<br>';
                }
            }
        }
  
    }

    public function addTrackingAndSatus(){
        $ret = array();
        $ret['retour'] = "tracking and url final";
        if (isset($_POST['link'])) {
            $ret['finalUrl']  = $this->findUltimateDestination($_POST['link'],10);
            $ret['responses'] = $this->getHeaderResponses($_POST['link']);
        }

        if (isset($_POST['idSequence'])) {
            $this->loadTrackingEl($_POST['idSequence'],$_POST['numero'],$_POST['tracking_type'],$_POST['module_id']);
        }
        echo json_encode($ret);
    }
    public function addTracking(){
        $ret = array();
        $ret['retour'] = "tracking and url final";

        if (isset($_POST['idSequence'])) {
            $this->loadTrackingEl($_POST['idSequence'],$_POST['numero'],$_POST['tracking_type'],$_POST['module_id']);
        }
        echo json_encode($ret);
    }
    public function addTrackingExerciceInFav(){
        $ret = array();
        $ret['retour'] = "tracking";
        if (isset($_POST['id'])) {
            $this->loadTrackingEl($_POST['id'],$_POST['numero'],24,$_POST['module_id']);
        }
        echo json_encode($ret);
    }

}

?>