<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Video extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('video_model');
        $this->isLoggedIn();  
        $this->tracking_type = 44;  
        $this->load->library('user_agent');  
        Header('Access-Control-Allow-Origin: *'); //for allow any domain, insecure
        Header('Access-Control-Allow-Headers: *'); //for allow any headers, insecure
        Header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE'); //method allowed
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index(){     
        $this->loadTrackingEl(0,0,$this->tracking_type);

        $this->load->library('pagination');
        $this->global['pageTitle'] = 'E-learning : '.$this->lang->line('video_label');
        $this->global['groupe'] = $this->session->userdata ('STAGIAIREGRP');
        $data['allResult'] = $this->video_model->trainee_first_videolist($this->session->userdata ('GUSERID'));
        $this->loadViews("trainee/video/list", $this->global,$data, NULL ); 
    }

    public function trainee_comment_file($id_exp){ 
        try {
            $this->video_model->trainee_comment($id_exp); 
            echo json_encode("obs added succesfuly");
        } catch (\Exception $e) {
            echo json_encode($e);
            die($e->getMessage());

        }
    }


}

?>