<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class ContentCommunityLibraryForma2Plus extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->isLoggedIn();   
        $this->tracking_type = 77;
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
      
    }

    public function addDoc(){
        $retour = array();
        $this->loadTrackingEl(0,0,$this->tracking_type); 

        $date      = date('d/m/Y H:i:s');
        $mycomment = "" ;
        $retour = "" ;
        
        $rep      =  RP_GROUPES."GRPCOMMUNITYF2PLUS/";       

        if ( ! is_dir($rep) ) {
            mkdir($rep, 0755,true);
            chmod($rep, 0777);
        }

        $config['upload_path']=$rep;  
        $config['allowed_types']='*';
        $config['encrypt_name'] = TRUE;
        $config['max_size'] = '200000';
        
         
        $this->load->library('upload');
        $this->upload->initialize($config);  
        if($this->upload->do_upload("inputFileDoc")){
            $data = array('upload_data' => $this->upload->data());
 
            if (strlen(trim($this->input->post('textareaCommentDoc'))) == 0) {
                $mycomment .= "" ;
                $nb   = 0 ;
            }
            else{
                $mycomment .= $this->input->post('textareaCommentDoc');
                $nb   = 1 ;
            }
            $repert  = ($this->input->post('repertory') == "" || $this->input->post('repertory') == 0) ? NULL : $this->input->post('repertory');

            $dataInfos = array(
                'titre'=>$this->input->post('inputTitleDoc'), 
                'link'=>$data['upload_data']['file_name'],
                'type'=>2, 
                'commentaire'=>$mycomment,
                'date_create'=>date('Y-m-d'), 
                'user_create'=>$this->session->userdata ('GUSERID'),
                "id_community_library_forma2plus"=>$repert
            );
            $retour['upload'] = true;

            $retour['idDocument'] = $this->Content_community_library_forma2plus_model->add($dataInfos);
        }
        else{
            $retour = array(
                'upload' => false,
                'rep' => $rep,
                'error_upload' => $this->upload->display_errors()
            );
        }
        echo json_encode($retour);
    }

    public function addLink(){
        $this->loadTrackingEl(0,0,$this->tracking_type); 

        $date    = date('d/m/Y H:i:s');  
        $Title   = $this->input->post('dataLink')['inputTitleLink'];
        $link    = $this->input->post('dataLink')['inputLink'];
        $comment = $this->input->post('dataLink')['textareaCommentLink'];
        $repert  = ($this->input->post('dataLink')['repertory'] == "" || $this->input->post('dataLink')['repertory'] == 0) ? NULL : $this->input->post('dataLink')['repertory'];
        $date = date('d/m/Y H:i:s');      

    
        $dataInfos = array(
            'titre'=>$Title, 
            'link'=>$link,
            'type'=>0, 
            'commentaire'=>$comment,
            'date_create'=>date('Y-m-d'), 
            'user_create'=>$this->session->userdata ('GUSERID'),
            "id_community_library_forma2plus"=>$repert
        );
        echo $this->Content_community_library_forma2plus_model->add($dataInfos);
    }

    public function delete(){
        $id   =  $this->input->post('id');
        if($this->Content_community_library_forma2plus_model->Request('type',$id) != 0){
            unlink(RP_GROUPES."GRPCOMMUNITYF2PLUS/".$this->Content_community_library_forma2plus_model->Request('link',$id));
        }
        $this->Content_community_library_forma2plus_model->delete($id);
        echo $id;
    }

    public function update(){
        $retour = array();
        $fichier = '';
        $groupe = $this->session->userdata ('STAGIAIREGRP');

        if (isset($_POST['inputTitleDoc_edit'])) {
            if ($_POST['type_doc_edit'] == 0) {
                $fichier          = $_POST['inputLink_edit'];
            }
            else{
                $rep = RP_GROUPES."GRPCOMMUNITYF2PLUS/";
                if ( ! is_dir($rep) ) {
                    mkdir($rep, 0755,true);
                }
                $config['upload_path']=$rep;
                $config['allowed_types']='*';
                $config['encrypt_name'] = TRUE;
                $config['max_size'] = '100000';
                $this->load->library('upload');
                $this->upload->initialize($config); 
                if($this->upload->do_upload("inputFileDoc_edit")){
                    $data = array('upload_data' => $this->upload->data());
                    $fichier   = $data['upload_data']['file_name'];
                    $retour['upload'] = true;
                }
                
            }

            if ($_POST['textareaCommentDoc_edit'] != "") {
                if (isset($fichier) && $fichier != '') {                
                    $edit_data = array(
                        'titre'          => $_POST['inputTitleDoc_edit'],
                        'link'        => $fichier,
                        'id_community_library_forma2plus'   => $_POST['repertory_edit'],
                        'commentaire'        => $_POST['textareaCommentDoc_edit']
                    );
                }
                else{
                    $edit_data = array(
                        'titre'          => $_POST['inputTitleDoc_edit'],
                        'id_community_library_forma2plus'   => $_POST['repertory_edit'],
                        'commentaire'        => $_POST['textareaCommentDoc_edit']
                    );                    
                }
            }
            else{
                if (isset($fichier) && $fichier != '') {                    
                    $edit_data = array(
                        'titre'          => $_POST['inputTitleDoc_edit'],
                        'link'        => $fichier,
                        'id_community_library_forma2plus'   => $_POST['repertory_edit']
                    );
                }
                else{
                    $edit_data = array(
                        'titre'          => $_POST['inputTitleDoc_edit'],
                        'id_community_library_forma2plus'   => $_POST['repertory_edit']
                    );
                }
            }
            $retour['idDoc'] = $this->Content_community_library_forma2plus_model->update($_POST['id_doc_edit'],$edit_data);
        }
        echo json_encode($retour);
    }

    public function addToFav(){
        if (isset($_POST['idNewSeq'])) {
            $data = array(
                'id_membres'               => $this->session->userdata ('STAGIAIREID'), 
                'user_create'              => $this->session->userdata ('GUSERID'),
                'id_classification_favoris'=> $_POST['classification'],
                'id_prg'                   => $_POST['idNewSeq'],
                'numero'                   => NULL,
                'intitule'                 => $this->convert_utf8($this->Content_community_library_forma2plus_model->Request('titre',$_POST['idNewSeq'])),
                'status'                   => 1,
                'type'                     => 'community_library_forma2plus',
                'commentaire'              => $this->Content_community_library_forma2plus_model->Request('commentaire',$_POST['idNewSeq']),
                'date_creation'            => time()
            );
            $ret = $this->stat_prg_model->add($data);
            echo '##'.$ret;
        }
        else{
            echo var_dump($_POST);
        }
    }

    public function addToCourseHistory(){
        $retour = '1';
        //$retour = Array();
        $sender = Array();
        $replyto = Array();
        $destination = Array();
        $subject = '';
        $mailbody = '';
        $mailAltBody = '';
        $filePath = '';

        $width      = "1200";
        $height     = "1280";
        $type;
        $linkD;
        $idHistorikCours;
        if (isset($_POST['id'])) {

            $idHistorikCours = $_POST['ch'];

            if ($this->Content_community_library_forma2plus_model->Request('type',$_POST['id']) == 0) {
                $type = 0;
                $filename = $this->Content_community_library_forma2plus_model->Request('link',$_POST['id']);
            }
            else{
                $type = 2;
                $repDocTodoTuteur=  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/documentTodo';
                if ( ! is_dir($repDocTodoTuteur) ) {
                    mkdir($repDocTodoTuteur, 0777,true);
                } 
                $ext            = explode(".", $this->Content_community_library_forma2plus_model->Request('link',$_POST['id']));
                $filename       = "DOCUMENT_".$this->session->userdata('GUSERID').'_'.time().'.'.$ext[1];
                copy(RP_GROUPES.'GRPCOMMUNITYF2PLUS/'.$this->Content_community_library_forma2plus_model->Request('link',$_POST['id']) , $repDocTodoTuteur."/".$filename);
            }


            $linkInfo = array(
                'titre'=>$this->Content_community_library_forma2plus_model->Request('titre',$_POST['id']), 
                'link'=>$filename,
                'type'=>$type, 
                'commentaire'=>"",
                'date_create'=>date('Y-m-d'), 
                'user_create'=>$this->session->userdata ('GUSERID'),
                "thumbnail_file"=>''
            );
            $idNewLink = $this->todolist_model->addnewlink($linkInfo);
            
            $todoId = $this->todolist_model->addTodo($idNewLink,$this->session->userdata ('STAGIAIREGRP'),$idHistorikCours);


            /*add data to notification trainee*/
            $data_notification = array(
                'id_tuteur'  => $this->session->userdata('GUSERID'),
                'id_groupe'  => $this->session->userdata('STAGIAIREGRP'),
                'data_type'  => 'todo',
                'id_data'    => $todoId,
                'date_create'=> time()
            );

            $this->Notification_model->add($data_notification);

            if (isset($_POST['notify']) && $_POST['notify'] == 'on') {
                            
                $sender = array(
                    'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                    'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
                );
                $replyto = array(
                    'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                    'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
                );
                $destination = array(
                    'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('STAGIAIREID'))),
                    'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))),
                );

                $subject = 'Forma2plus - E-learning plateform ('.$this->convert_utf8($this->lang->line('training_period_course_history')).' - '.$this->convert_utf8($this->coursHistorik_model->Request('intitule',$idHistorikCours)).')';

                $mailbody .= $this->lang->line('el_send_mail_infos_hello').' '.$this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))).',<br><br>';

                if($type == 2){
                    $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_new_doc')).' ';
                }
                else{
                    $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_new_link')).' ';
                }

                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been')).'<br>';
                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been_access')).' : <br>';
                
                $mailbody .= '<a href="'.base_url().'loginMe?auth=true&pr='.$this->session->userdata ('GUSERID').'&action=ch_tr&ident='.$this->convert_utf8($this->membres_model->Request('login',$this->session->userdata ('STAGIAIREID'))).'&pd='.$this->convert_utf8($this->membres_model->Request('password',$this->session->userdata ('STAGIAIREID'))).'&access=ch&id='.$idHistorikCours.'&container='.$todoId.'" target="_blank">F2+ | E-learning Plateform</a><br>';
                $mailbody .= '<br><br><br>';
                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_sign')).' <br>';
                $mailbody .= $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))).' <br>';
                $mailbody .= $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID')));

                //$retour['url-elearning'] = base_url().'loginMe?auth=true&pr='.$this->session->userdata ('GUSERID').'&action=ch_tr&ident='.$this->convert_utf8($this->membres_model->Request('login',$this->session->userdata ('STAGIAIREID'))).'&pd='.$this->convert_utf8($this->membres_model->Request('password',$this->session->userdata ('STAGIAIREID'))).'&access=ch&id='.$idHistorikCours.'&container='.$todoId;
                $sendMail = $this->sendMailElearning($sender,$destination,$subject,$mailbody,$mailAltBody,$filePath,$replyto);
                if ($sendMail) {
                    $retour = '1';
                }
                else{
                    $retour = '0';
                }

                $this->load->model('Mail_box_model');

                $data_mail_box = array(
                    'sender'    => $sender['email'],
                    'recipient' => $destination['email'],
                    'subject'   => $subject,
                    'body'      => $mailbody,
                    'attachfile'=> $filePath,
                    'status'    => $sendMail,
                    'author'    => $this->session->userdata ('GUSERID'),
                    'target'    => $this->session->userdata ('STAGIAIREID'),
                    'source'    => $this->lang->line('educational_library_community_forma2plus'),
                    'date'      => date("Y-m-d H:i:s")
                );
                $this->Mail_box_model->add($data_mail_box);
            }
            //$retour['success'] = '1';
            //echo json_encode($retour);

            if (isset($_POST['modal_view']) && $_POST['modal_view'] == "on") {
                $retour = $todoId;
            }
            echo "###".$retour;
        }
  
    }

    public function ajaxAddToCourseHistory(){
        $retour = array();
        $type;
        $linkD;
        $idHistorikCours;
        if (isset($_POST['id'])) {

            $idHistorikCours = $_POST['ch'];

            if ($this->Content_community_library_forma2plus_model->Request('type',$_POST['id']) == 0) {
                $type = 0;
                $filename = $this->Content_community_library_forma2plus_model->Request('link',$_POST['id']);
            }
            else{
                $type = 2;
                $repDocTodoTuteur=  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/documentTodo';
                if ( ! is_dir($repDocTodoTuteur) ) {
                    mkdir($repDocTodoTuteur, 0777,true);
                } 
                $ext            = explode(".", $this->Content_community_library_forma2plus_model->Request('link',$_POST['id']));
                $filename       = "DOCUMENT_".$this->session->userdata('GUSERID').'_'.time().'.'.$ext[1];
                if (file_exists(RP_GROUPES.'GRPCOMMUNITYF2PLUS/'.$this->Content_community_library_forma2plus_model->Request('link',$_POST['id']))) {
                    copy(RP_GROUPES.'GRPCOMMUNITYF2PLUS/'.$this->Content_community_library_forma2plus_model->Request('link',$_POST['id']) , $repDocTodoTuteur."/".$filename);
                }
            }


            $linkInfo = array(
                'titre'=>$this->Content_community_library_forma2plus_model->Request('titre',$_POST['id']), 
                'link'=>$filename,
                'type'=>$type, 
                'commentaire'=>"",
                'date_create'=>date('Y-m-d'), 
                'user_create'=>$this->session->userdata ('GUSERID'),
                "thumbnail_file"=>''
            );
            $idNewLink = $this->todolist_model->addnewlink($linkInfo);
            
            $retour['todoId'] = $this->todolist_model->addTodo($idNewLink,$this->session->userdata ('STAGIAIREGRP'),$idHistorikCours);


            /*add data to notification trainee*/
            $data_notification = array(
                'id_tuteur'  => $this->session->userdata('GUSERID'),
                'id_groupe'  => $this->session->userdata('STAGIAIREGRP'),
                'data_type'  => 'todo',
                'id_data'    => $retour['todoId'],
                'date_create'=> time()
            );

            $this->Notification_model->add($data_notification);

            $retour['lib'] = $this->lang->line('educational_library_community_forma2plus');
        }

        echo json_encode($retour);
  
    }

}

?>