<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';
//require APPPATH . '/libraries/GroupeIncController.php';

/**
 * Class : Dcsigntuteur
 * Dcsigntuteur Class to control over all the classes
 * @author : Alexandre Bors
 * @version : 1.1
 * @since : 17 Jully 2020
 */
class Dcsigntuteur extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        
        $this->isLoggedIn();   
        $this->action_type = 14;
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {

        $this->global['pageTitle'] = 'E-learning : Document sign';
        $this->global['groupe'] = $this->session->userdata ('GROUPE');   
        $data['results']     = $this->documentsign_model->getListByTrainne($this->session->userdata ('GROUPE'))->result();        
        $this->loadViews("tutor/documentsign/list", $this->global, $data , NULL);
    }
    
    public function pageNotFound()
    {
        $this->global['pageTitle'] = 'E-learning : 404 - Page Not Found';
        
        $this->loadViews("404", $this->global, NULL, NULL);
    }
    
   
}

?>