<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Library extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->isLoggedIn();   
        $this->tracking_type = 33;
        $this->idNewSequence = 0;
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->global['pageTitle']        = 'E-learning : Documents library';
        $this->loadTrackingEl(0,0,$this->tracking_type);         
        $this->global['groupe']           = $this->session->userdata ('STAGIAIREGRP');

        //verify existance default repertory test person
        //$lib_person_name = $this->lang->line('educational_library');
        $lib_person_name = 'Démo E-book Pearson';
        $lib_person = $this->Teacher_link_and_document_model->getByAuthorAndName($this->session->userdata ('GUSERID'),$lib_person_name);
        if(count($lib_person) == 0){
            $data_lib = array(
                'name'        => $lib_person_name,
                'description' => $lib_person_name,
                'user_create' => $this->session->userdata ('GUSERID'),
                'date'        => time(),
            );

            $linkInfo = array(
                'id_sequence'=>$this->Teacher_link_and_document_model->getSequenceMaxOrder(), 
                'titre'=>"Pearson 2 access", 
                'link'=>"https://english-dashboard.pearson.com/login?redirectUrl=https://english-dashboard.pearson.com",
                'type'=>0, 
                'commentaire'=>"(identifiant: Forma2plus/ mot de passe :EquipeForma2)",
                'date_create'=>date('Y-m-d'), 
                'user_create'=>$this->session->userdata ('GUSERID'),
                "ifrmaccess"=>$this->detecturl("https://english-dashboard.pearson.com/login?redirectUrl=https://english-dashboard.pearson.com"),
                "id_repertory"=>$this->Teacher_link_and_document_model->add($data_lib) 
            );
            $idNewLink = $this->Teacher_link_and_document_model->addContent($linkInfo);
        }

        $order = '';
        if (isset($_GET['order']) && $_GET['order'] != '') {
            $order = $_GET['order'];
        }

        $data['data_not_in_library']      = $this->Teacher_link_and_document_model->getAllDataNotInLibrary($this->session->userdata ('GUSERID')); 
        $data['library_result']           = $this->Teacher_link_and_document_model->getByAuthor($this->session->userdata ('GUSERID'),$order); 
        $data['historik_course']          = $this->coursHistorik_model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP')); 
        $data['classification_favoris']   = $this->classificationFavoris_Model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP'));
        $this->loadViews("tutor/library/index", $this->global,$data, NULL );  
      
    }
    
    public function add(){
        if (isset($_POST)) {                                     
            $data_lib = array(
                'name'        => $_POST['repertory'],
                'description' => $_POST['description'],
                'user_create' => $this->session->userdata ('GUSERID'),
                'date'        => time(),
            );
            $ret = $this->Teacher_link_and_document_model->add($data_lib);
            echo '##'.$ret;
        }
        else{
            echo "error";
        }

    }  

    public function saveUpdate(){
        if (isset($_POST['dataRep'])) {
            $data = array(
                'name'        => $_POST['dataRep']['repertory-document-edit'],
                'description' => $_POST['dataRep']['description-cat-edit']
            );
            echo $this->Teacher_link_and_document_model->update($_POST['dataRep']['id_repertory_edit'],$data);
        }
    }

    public function deleteLib(){
        if (isset($_POST['id_repertory'])) {
            $this->Teacher_link_and_document_model->deleteContentByLib($_POST['id_repertory']);
            $this->Teacher_link_and_document_model->delete($_POST['id_repertory']); 
            echo "1";
        } 
    }

    public function addLink(){
        $this->loadTrackingEl(0,0,$this->tracking_type); 

        $date    = date('d/m/Y H:i:s');  
        $Title   = $this->input->post('dataLink')['inputTitleLink'];
        $link    = $this->input->post('dataLink')['inputLink'];
        $comment = $this->input->post('dataLink')['textareaCommentLink'];
        $repert  = ($this->input->post('dataLink')['repertory'] == "" || $this->input->post('dataLink')['repertory'] == 0) ? NULL : $this->input->post('dataLink')['repertory'];
        $date = date('d/m/Y H:i:s');      

    
        $data = array(
            'id_sequence'=>$this->Teacher_link_and_document_model->getSequenceMaxOrder(), 
            'titre'=>$Title, 
            'link'=>$link,
            'type'=>0, 
            'commentaire'=>$comment,
            'date_create'=>date('Y-m-d'), 
            'user_create'=>$this->session->userdata ('GUSERID'),
            "ifrmaccess"=>$this->detecturl($link),
            "id_repertory"=>$repert
        );
        echo $this->Teacher_link_and_document_model->addContent($data);
    }

    public function addDoc(){
        $retour = array();
        $this->loadTrackingEl(0,0,$this->tracking_type); 

        $date      = date('d/m/Y H:i:s');
        $mycomment = "" ;
        $retour = "" ;
        
        $rep      =  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/documentTodo/';       

        if ( ! is_dir($rep) ) {
            mkdir($rep, 0755,true);
            chmod($rep, 0777);
        }

        $config['upload_path']=$rep;  
        $config['allowed_types']='*';
        $config['encrypt_name'] = TRUE;
        $config['max_size'] = '200000';
        
         
        $this->load->library('upload');
        $this->upload->initialize($config);  
        if($this->upload->do_upload("inputFileDoc")){
            $data = array('upload_data' => $this->upload->data());
 
            if (strlen(trim($this->input->post('textareaCommentDoc'))) == 0) {
                $mycomment .= "" ;
                $nb   = 0 ;
            }
            else{
                $mycomment .= $this->input->post('textareaCommentDoc');
                $nb   = 1 ;
            }
            $repert  = ($this->input->post('repertory') == "" || $this->input->post('repertory') == 0) ? NULL : $this->input->post('repertory');

            $linkInfo = array(
                'id_sequence'=>$this->Teacher_link_and_document_model->getSequenceMaxOrder(), 
                'titre'=>$this->input->post('inputTitleDoc'), 
                'link'=>$data['upload_data']['file_name'],
                'type'=>2, 
                'commentaire'=>$mycomment,
                'date_create'=>date('Y-m-d'), 
                'user_create'=>$this->session->userdata ('GUSERID'),
                "id_repertory"=>$repert
            );
            $retour['upload'] = true;

            $retour['idDocument'] = $this->Teacher_link_and_document_model->addContent($linkInfo);
        }
        else{
            $retour = array(
                'upload' => false,
                'rep' => $rep,
                'error_upload' => $this->upload->display_errors()
            );
        }
        echo json_encode($retour);
    }

    public function edit(){
        if (isset($_POST['dataRep'])) {
            $data = array(
                'name'        => $_POST['dataRep']['repertory-document-edit'],
                'description' => $_POST['dataRep']['description-cat-edit']
            );
            echo $this->Teacher_link_and_document_model->update($_POST['dataRep']['id_repertory_edit'],$data);
        }
    }

    public function delete(){
       if (isset($_POST['id_repertory'])) {
            if ($_POST['id_repertory'] == 0 || $_POST['id_repertory'] == '0') {                
                //$this->document_model->deleteByIdRepertory(NULL);
            }
            else{               
                //$this->document_model->deleteByIdRepertory($_POST['id_repertory']);
                $this->Teacher_link_and_document_model->delete($_POST['id_repertory']); 
            }
            echo "1";
        } 
    }

    public function deletecontent(){
        $id   =  $this->input->post('id');
        $this->Teacher_link_and_document_model->deleteContent($id);
        echo $id;
    }

    public function deleteDoc(){
        $id   =  $this->input->post('id');
        if($this->Teacher_link_and_document_model->RequestContent('type',$id) != 0){
            unlink(RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/documentTodo/'.$this->Teacher_link_and_document_model->RequestContent('link',$id));
        }
        $this->Teacher_link_and_document_model->deleteContent($id);
        echo $id;
    }

    public function getAll(){
        if(isset($_POST)){
            $allResult = $this->Teacher_link_and_document_model->getAllByOthor($this->session->userdata ('GUSERID'),$_POST['id_repertory'],$_POST['rowperpage'],$_POST['rowid']);

            $all_document   = array();
            $all_document[] = array("allcount" => count($allResult));

            foreach ($allResult as $res) {              
                $all_document[] = array(
                    "id"           => $res->id,
                    "titre"        => $res->titre,
                    "fichier"      => $res->link,
                    "repertory"    => $res->id_repertory
                );
            }
            echo json_encode($all_document);
        }
    }

    public function update(){
        if (isset($_POST)) {
            $idGroupe = '';
            for ($i=0; $i < count($_POST['databasedocument']); $i++) { 
                if ($this->isTuteurConnet()) { 
                    $idGroupe = $this->session->userdata ('STAGIAIREGRP');  
                } 
                else{
                    $idGroupe = $this->session->userdata ('GROUPE');       
                }
                $data = array('id_repertory'   => $_POST['id_repertory']);
                echo $this->Teacher_link_and_document_model->updateContent($_POST['databasedocument'][$i],$data);
            }
        }
    }

    public function editComment(){
        $this->loadTrackingEl(0,0,$this->tracking_type);
        if (isset($_POST['commentaire'])) {
            $data = array(
                'commentaire' => $_POST['commentaire']
            );
            echo $this->Teacher_link_and_document_model->updateContent($_POST['id_new_data'],$data);
        }
    }

    public function editData(){
        $this->loadTrackingEl(0,0,$this->tracking_type);
        $this->global['pageTitle'] = 'E-learning : Edition data in library';
        $this->global['groupe'] = $this->session->userdata ('STAGIAIREGRP');
        if (isset($_GET['id']) && $_GET['id'] != NULL) {
            $data['library_result']           = $this->Teacher_link_and_document_model->getByAuthor($this->session->userdata ('GUSERID'),'an');
            $data['dataResult']  = $this->Teacher_link_and_document_model->getContentById($_GET['id']);
            $this->loadViews("tutor/library/edit-data", $this->global,$data, NULL );    
        }
    }

    public function saveEdit(){
        $retour = array();
        $fichier = '';
        $groupe = $this->session->userdata ('STAGIAIREGRP');

        if (isset($_POST['inputTitleDoc_edit'])) {
            if ($_POST['type_doc_edit'] == 0) {
                $fichier          = $_POST['inputLink_edit'];
            }
            else{
                $rep = RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/documentTodo/';
                if ( ! is_dir($rep) ) {
                    mkdir($rep, 0755,true);
                }
                $config['upload_path']=$rep;
                $config['allowed_types']='*';
                $config['encrypt_name'] = TRUE;
                $config['max_size'] = '100000';
                $this->load->library('upload');
                $this->upload->initialize($config); 
                if($this->upload->do_upload("inputFileDoc_edit")){
                    $data = array('upload_data' => $this->upload->data());
                    $fichier   = $data['upload_data']['file_name'];
                    $retour['upload'] = true;
                }
                
            }

            if ($_POST['textareaCommentDoc_edit'] != "") {
                if (isset($fichier) && $fichier != '') {                
                    $edit_data = array(
                        'titre'          => $_POST['inputTitleDoc_edit'],
                        'link'        => $fichier,
                        'id_repertory'   => $_POST['repertory_edit'],
                        'commentaire'        => $_POST['textareaCommentDoc_edit']
                    );
                }
                else{
                    $edit_data = array(
                        'titre'          => $_POST['inputTitleDoc_edit'],
                        'id_repertory'   => $_POST['repertory_edit'],
                        'commentaire'        => $_POST['textareaCommentDoc_edit']
                    );                    
                }
            }
            else{
                if (isset($fichier) && $fichier != '') {                    
                    $edit_data = array(
                        'titre'          => $_POST['inputTitleDoc_edit'],
                        'link'        => $fichier,
                        'id_repertory'   => $_POST['repertory_edit']
                    );
                }
                else{
                    $edit_data = array(
                        'titre'          => $_POST['inputTitleDoc_edit'],
                        'id_repertory'   => $_POST['repertory_edit']
                    );
                }
            }
            $retour['idDoc'] = $this->Teacher_link_and_document_model->updateContent($_POST['id_doc_edit'],$edit_data);
        }
        echo json_encode($retour);
    }

    public function addToFav(){
        if (isset($_POST['idNewSeq'])) {
           if (is_numeric($_POST['classification'])) {
                $id_classification = $_POST['classification'];
            } 
            else{
                $data_classification = array(
                    'intitule'    => $_POST['classification'],
                    'user_create' => $this->session->userdata ('GUSERID'),
                    'id_groupe'   => $this->session->userdata ('STAGIAIREGRP'),
                    'date'        => time(),
                );
                $id_classification = $this->classificationFavoris_Model->add($data_classification);
            }
            $data = array(
                'id_membres'               => $this->session->userdata ('STAGIAIREID'), 
                'user_create'              => $this->session->userdata ('GUSERID'),
                'id_classification_favoris'=> $id_classification,
                'id_prg'                   => $_POST['idNewSeq'],
                'numero'                   => is_int($this->todolist_model->RequestNewSequence('id_sequence',$_POST['idNewSeq'])) ? $this->todolist_model->RequestNewSequence('id_sequence',$_POST['idNewSeq']) : NULL,
                'intitule'                 => htmlentities($this->todolist_model->RequestNewSequence('titre',$_POST['idNewSeq'])),
                'status'                   => 1,
                'type'                     => 'library_professor',
                'commentaire'              => $this->todolist_model->RequestNewSequence('commentaire',$_POST['idNewSeq']),
                'date_creation'            => time()
            );
            $ret = $this->stat_prg_model->add($data);
            echo '##'.$ret;
        }
        else{
            echo var_dump($_POST);
        }
    }

    public function scan(){
        $ret = array();
        $url = "";
        $ret['retour'] = "tracking and url final";
        if (isset($_POST['page_name']) && $_POST['page_name'] == 'favoris') {
            $this->tracking_type = 24;
        }
        if (isset($_POST['idNewSeq'])) {
            if (isset($_POST['page_name']) && $_POST['page_name'] == 'favoris' && $this->isTrainee()) {
                $all_data_new_seq = $this->todolist_model->getInfoNewSequence($_POST['idNewSeq']);
                foreach ($all_data_new_seq as $res) {
                    $urlTodo1 = $res->link;
                    if ($res->type == 0 && strpos($urlTodo1, 'youtube') === false && strpos($urlTodo1, 'youtu.be') === false && strpos($urlTodo1, 'vimeo.com') === false && strpos($urlTodo1, 'facebook.com') === false && strpos($urlTodo1, 'dailymotion.com') === false) {
                        $url = $res->link;
                    }
                    elseif ($res->type == 0 && (strpos($urlTodo1, 'vimeo.com') !== false || strpos($urlTodo1, 'facebook.com') !== false || strpos($urlTodo1, 'dailymotion.com') !== false || strpos($urlTodo1, 'youtube') !== false || strpos($urlTodo1, 'youtu.be') !== false)) {
                        $url = $this->getEmbedUrl($urlTodo1);
                    }            
                    elseif ((strpos(HTTP_MAIN.'groupes/GRPT'.$res->user_create.'/documentTodo/'.$urlTodo1, '.doc') !== false) || (strpos(HTTP_MAIN.'groupes/GRPT'.$res->user_create.'/documentTodo/'.$urlTodo1, '.docx') !== false) || (strpos(HTTP_MAIN.'groupes/GRPT'.$res->user_create.'/documentTodo/'.$urlTodo1, '.ppt') !== false) || (strpos(HTTP_MAIN.'groupes/GRPT'.$res->user_create.'/documentTodo/'.$urlTodo1, '.pdf') !== false)){

                        //$url = "https://docs.google.com/gview?url=".HTTP_MAIN.'groupes/GRPT'.$res->user_create.'/documentTodo/'.$urlTodo1."&amp;embedded=true";
                        $url = HTTP_MAIN.'groupes/GRPT'.$res->user_create.'/documentTodo/'.$urlTodo1;
                    }
                    else{
                        $url = HTTP_MAIN.'groupes/GRPT'.$res->user_create.'/documentTodo/'.$urlTodo1;
                    }
                }

                $ret['finalUrl']  = $this->findUltimateDestination($url,10);
                $ret['responses'] = $this->getHeaderResponses($ret['finalUrl']);
            }
            else{
                $all_data_new_seq = $this->todolist_model->getInfoNewSequence($_POST['idNewSeq']);
                foreach ($all_data_new_seq as $res) {
                    $urlTodo1 = $res->link;
                    if ($res->type == 0 && strpos($urlTodo1, 'youtube') === false && strpos($urlTodo1, 'youtu.be') === false && strpos($urlTodo1, 'vimeo.com') === false && strpos($urlTodo1, 'facebook.com') === false && strpos($urlTodo1, 'dailymotion.com') === false) {
                        $url = $res->link;
                    }
                    elseif ($res->type == 0 && (strpos($urlTodo1, 'vimeo.com') !== false || strpos($urlTodo1, 'facebook.com') !== false || strpos($urlTodo1, 'dailymotion.com') !== false || strpos($urlTodo1, 'youtube') !== false || strpos($urlTodo1, 'youtu.be') !== false)) {
                        $url = $this->getEmbedUrl($urlTodo1);
                    }            
                    elseif ((strpos(HTTP_MAIN.'groupes/GRPT'.$res->user_create.'/documentTodo/'.$urlTodo1, '.doc') !== false) || (strpos(HTTP_MAIN.'groupes/GRPT'.$res->user_create.'/documentTodo/'.$urlTodo1, '.docx') !== false) || (strpos(HTTP_MAIN.'groupes/GRPT'.$res->user_create.'/documentTodo/'.$urlTodo1, '.ppt') !== false) || (strpos(HTTP_MAIN.'groupes/GRPT'.$res->user_create.'/documentTodo/'.$urlTodo1, '.pdf') !== false)){

                        //$url = "https://docs.google.com/gview?url=".HTTP_MAIN.'groupes/GRPT'.$res->user_create.'/documentTodo/'.$urlTodo1."&amp;embedded=true";
                        $url = HTTP_MAIN.'groupes/GRPT'.$res->user_create.'/documentTodo/'.$urlTodo1;
                    }
                    else{
                        $url = HTTP_MAIN.'groupes/GRPT'.$res->user_create.'/documentTodo/'.$urlTodo1;
                    }
                }

                $ret['finalUrl']  = $this->findUltimateDestination($url,10);
                $ret['responses'] = $this->getHeaderResponses($ret['finalUrl']);
            }

            if($this->isTuteurConnet()) {
                
                /*$trackingid = $this->tracking_model->AddTuteur($_POST['id_plan_de_travail'],$id_new_seq,$this->tracking_type);
                $sessionArray = array('TRACKINGID'=>$trackingid);                                    
                $this->session->set_userdata($sessionArray);
                $this->global['trackingsession'] = $this->session->userdata ('TRACKINGID');*/
            }

            if ($this->isTrainee()) {  
                /*$trackingid = $this->tracking_model->Add($_POST['id'],$_POST['id'],$this->tracking_type);
                $sessionArray = array('TRACKINGID'=>$trackingid);                                    
                $this->session->set_userdata($sessionArray);
                $this->global['trackingsession'] = $this->session->userdata ('TRACKINGID');*/
            }        
        }

        echo json_encode($ret);
    }

    public function majDataInLibAfterDev(){
        $returns = array();
        $i = 0;
        $allResultsLib = $this->Teacher_link_and_document_model->getAll();
        if (isset($allResultsLib) && count($allResultsLib) >= 1) {
            foreach ($allResultsLib as $res) {
                $dataContentLibResult = $this->todolist_model->getContentByAuthorAndLib($res->user_create,$res->id);
                foreach ($dataContentLibResult as $content) {
                    $data = array(
                        'id_sequence'    =>$this->Teacher_link_and_document_model->getSequenceMaxOrder(), 
                        'titre'          =>$content->titre, 
                        'link'           =>$content->link,
                        'type'           =>$content->type, 
                        'commentaire'    =>$content->commentaire,
                        'date_create'    =>$content->date_create, 
                        'user_create'    =>$content->user_create,
                        "ifrmaccess"     =>$content->ifrmaccess,
                        "id_repertory"   =>$content->id_repertory
                    );
                    $returns['data'][$i] = $data;
                    $checkDataExist = $this->Teacher_link_and_document_model->checkData($data);
                    if (isset($checkDataExist) && count($checkDataExist) < 1) {
                        $this->Teacher_link_and_document_model->addContent($data);
                        $i++;
                    }
                    
                }
            }
        }
        echo json_encode($returns);
    }

    public function majDataNotInLibAfterDev(){
        $returns = array();
        $i = 0;
        $allResultsLib = $this->Teacher_link_and_document_model->getAll();
        if (isset($allResultsLib) && count($allResultsLib) >= 1) {
            foreach ($allResultsLib as $res) {
                $dataContentLibResult = $this->todolist_model->getContentByAuthorAndLib($res->user_create,null);
                foreach ($dataContentLibResult as $content) {
                    $data = array(
                        'id_sequence'    =>$this->Teacher_link_and_document_model->getSequenceMaxOrder(), 
                        'titre'          =>$content->titre, 
                        'link'           =>$content->link,
                        'type'           =>$content->type, 
                        'commentaire'    =>$content->commentaire,
                        'date_create'    =>$content->date_create, 
                        'user_create'    =>$content->user_create,
                        "ifrmaccess"     =>$content->ifrmaccess,
                        "id_repertory"   =>$content->id_repertory
                    );
                    $returns['data'][$i] = $data;
                    $checkDataExist = $this->Teacher_link_and_document_model->checkData($data);
                    if (isset($checkDataExist) && count($checkDataExist) < 1) {
                        $this->Teacher_link_and_document_model->addContent($data);
                        $i++;
                    }
                    
                }
            }
        }
        echo json_encode($returns);
    }
}

?>