<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Video extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->isLoggedIn();   
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->load->library('pagination');
        $this->global['pageTitle'] = 'E-learning : Audio List';
        $this->global['groupe'] = $this->session->userdata ('STAGIAIREGRP');
        // $data['videoResult'] = $this->video_model->tutorVideolist($this->session->userdata ('STAGIAIREGRP'));
        $data = array(
            'videoResult' => $this->video_model->traineeVideolist($this->global['STAGIAIREID']),
            'videoFirstResult' => $this->video_model->trainee_first_videolist($this->global['STAGIAIREID']),
            'groupeid' => $this->global['groupe'],
            'IDstag' => $this->global['STAGIAIREID'],
            'grps' => $this->global['groupe'],
    );
        if(!empty($data['videoResult'])){
            $this->loadViews("tutor/video/list", $this->global,$data, NULL );
        }else{
            $this->loadViews("tutor/video/nofile.php", $this->global,NULL, NULL );
        }
        
    }

}

?>