<?php
	include (APPPATH.'libraries/httpful.phar');

	class SmsLib
	{
		private $url = "";
		private $_url = "https://api.ovh.com/1.0/sms/sms-pp265513-1/";
		private $signature;
		
		public $headers = array();
		public $data = array();
		public $now;

		private function calculateTimeDelta()
	    {
	        $urlTime = 'https://api.ovh.com/1.0/auth/time';
	        $response = \Httpful\Request::get($urlTime)->send();
	        $serverTimestamp = (int)(string)$response->body;
	        $timeDelta = $serverTimestamp - (int)\time();   
	        return $timeDelta;
	    }

		public function setOvhTime()
		{
			$timeDelta = self::calculateTimeDelta();
			$this->now = time() + $timeDelta;
			return $this->now;
		}

		private function setSignature($signature)
		{
			return $this->signature = $signature;
			
		}

		private function setHeader()
		{   
	        $this->headers['X-Ovh-Consumer']  = OVH_CONSUMER_KEY;
	        $this->headers['X-Ovh-Signature'] = $this->signature;
	        $this->headers['X-Ovh-Timestamp'] = $this->now;
	        $this->headers['Content-Type']    = 'application/json; charset=utf-8';
	        
	        return $this->headers;
		}

		public function setUrl($service)
		{
			$url_ = $this->_url.$service;

			return $url_;
		}

		public function setSecret($data,$getMethod = true)
		{

			if ($getMethod == false){
				
				$secret  = OVH_APPLICATION_SECRET . '+' . OVH_CONSUMER_KEY . '+POST' . '+'. $this->url.'+' .json_encode($data). '+' . $this->now;	
			}
			else{
				if(isset($data['id'])){
					$secret  = OVH_APPLICATION_SECRET . '+' . OVH_CONSUMER_KEY . '+GET' . '+' . $this->url.'/'.$data['id'] .'+' .$data['body']. '+' . $this->now;
					
				}else{
					$secret  = OVH_APPLICATION_SECRET . '+' . OVH_CONSUMER_KEY . '+GET' . '+'. $this->url.'?'.http_build_query($data) .'+' .json_encode($data). '+' .$this->now; 
				}
			}
	   
			$secret                  = '$1$' . sha1($secret);
		   
		    return $secret; 
		}

		public function request($data,$methodGet = true)
		{
			if($methodGet == false){
				$request = \Httpful\Request::post($this->url)->expectsJson()->addHeader('X-Ovh-Application', OVH_APPLICATION_KEY)->addHeaders($this->headers);
		        $response = $request->sendsJson()->body(json_encode($data))->send();
	    	}
			else if($methodGet == true){
				if(isset($data['id']) && $data['id'] > 0 ){
					$request = \Httpful\Request::get($this->url.'/'.$data['id'])->expectsJson()->addHeader('X-Ovh-Application', OVH_APPLICATION_KEY)->addHeaders($this->headers);
					
					$response = $request->send();
				}else{
					$request = \Httpful\Request::get($this->url.'?'.http_build_query($data))->expectsJson()->addHeader('X-Ovh-Application', OVH_APPLICATION_KEY)->addHeaders($this->headers);
					$response = $request->sendsJson()->body($data)->send();
				}
			}

			return $response;
		}

		// recupere les ids
		public function getIncoming()
		{
			$creationDatetime = date('Y-m-d\TH:i');
			$this->setOvhTime();

			$this->url = $this->setUrl('incoming');

		 	$this->data = array(
		 		"creationDatetime.from" => $creationDatetimeFrom,		
						"creationDatetime.to" => $creationDatetimeTo
		 				
			);
		
		 	$sign_incoming = $this->setSecret($this->data);

			$this->setSignature($sign_incoming);
			
			$this->setHeader();

			$response =	$this->request($this->data,true);
			
			return $response->body;
		}

		public function setIncoming($incomingId)
		{
			$this->setOvhTime();
			$this->data = array(
				'id'=>		$incomingId,
				'body' => ''
			);

		 	$sign_incoming = $this->setSecret($this->data);


			$this->setSignature($sign_incoming );

			$this->setHeader();

			$response =	$this->request($this->data,true);
		
			return $response->body;
		}

	   	// recupere les ids
		public function getOutgoing($dateFrom,$dateTo)
		{
			$dateFrom = DateTime::createFromFormat('d/m/Y', $dateFrom);
			$dateTo = DateTime::createFromFormat('d/m/Y', $dateTo);



			//var_dump($dateFrom);
			$dateFrom = date_format($dateFrom,"Y/m/d H:i:s");
			$dateTo = date_format($dateTo,"Y/m/d H:i:s");
			
			$creationDatetimeFrom = date("Y-m-d\TH:i:s",strtotime($dateFrom));
			$creationDatetimeTo  = date("Y-m-d\TH:i:s", strtotime($dateTo));
			
			//echo 'debug'.$creationDatetimeFrom.'*****'.$creationDatetimeTo;
			
			
			$this->setOvhTime();

			$this->url = $this->setUrl('outgoing');

		 	$this->data = array(
		 				"creationDatetime.from" => $creationDatetimeFrom,
						"creationDatetime.to" => $creationDatetimeTo,
			);
		
		
		 	$sign_outgoing = $this->setSecret($this->data);

			$this->setSignature($sign_outgoing);
			
			$this->setHeader();

			$response =	$this->request($this->data,true);
			
			return $response->body ;
		}

		public function setOutgoing($outgoingId)
		{

			//print_r($outgoingId);

			$this->setOvhTime();
			
			$this->url = $this->setUrl('outgoing');

			for ($id = 0; $id < count($outgoingId);$id++){

				$this->data[$id] = array (
				'id'=>		$outgoingId[$id],
				'body' => ''
				);
				
				$sign_outgoing[$id] = $this->setSecret($this->data[$id]);

				$this->setSignature($sign_outgoing[$id]);
				$this->setHeader();
				$response =	$this->request($this->data[$id],true);
				$responseData[$id] = array('code' => '200', 'message' => 'Execution ok','response' => $response->body);
			}

			return $responseData;
		}
		
		public function formatTelNumber($n){
			$patern = "/^(\+33)[1-9](([-][0-9]{2}){4}|([0-9]{2}){4}|([.][0-9]{2}){4}|([ ][0-9]{2}){4})$/";
		   
			if (preg_match($patern, $n))
	        {
	           return $n;
	        }
	         //Remove any parentheses and the numbers they contain:
	        $n = preg_replace("/\([0-9]+?\)/", "", $n);
	        
	        //Strip spaces and non-numeric characters:
	        $n = preg_replace("/[^0-9]/", "", $n);
	        //Strip out leading zeros:
	        $n = ltrim($n, '0');
	        $n = ltrim($n, '0033');
	        $pfx = '+33';

	        if ( !preg_match('/^\+33/', $n)  ) {
	            $n = $pfx.$n;
			}
			
	        return $n;
		}
		

		// envoi sms
		public function sendSms($recipient,$content) {

			//print_r($recipient);
			$nb_numeros = count($recipient);

			$responseData = array();
			$this->setOvhTime();
		
			$this->url = $this->setUrl('jobs');


			if (!empty($recipient) && !empty($content)) {
			   $pattern = "/^(\+33)[1-9](([-][0-9]{2}){4}|([0-9]{2}){4}|([.][0-9]{2}){4}|([ ][0-9]{2}){4})$/";

				if($nb_numeros > 1){
					for ($i = 0; $i < $nb_numeros;$i++){
						$recipient[$i] = preg_match($pattern, $recipient[$i]) ?  $recipient[$i] : $this->formatTelNumber( $recipient[$i]);
					} 
				}else{
					$recipient[0] = preg_match($pattern, $recipient[0]) ?  $recipient[0] : $this->formatTelNumber($recipient[0]);

				}
			
				$content = utf8_decode(urldecode(urlencode($content)));	
					if($recipient) {
						$this->data = array(
						'receivers'=>		$recipient,
						'message' =>  utf8_encode($content),
						'senderForResponse' => true
						);



						$sign_jobs = $this->setSecret($this->data,false);
						$this->setSignature($sign_jobs); 
						$this->setHeader();
						$response =	$this->request($this->data,false);	
						$responseData = array('code' => '200', 'message' => 'Execution ok', 'response' => $response->body);
					} else {
						$responseData = array('code' => '400', 'message' => 'Numero de telephone no valide');
					}
			} else {
						$responseData = array('code' => '400', 'message' => 'Parametre text ou to non renseigné');
			}
			return $responseData; 
	    }
	}