<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/datastream/v1/datastream_resources.proto

namespace Google\Cloud\Datastream\V1\BigQueryDestinationConfig\SourceHierarchyDatasets;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Dataset template used for dynamic dataset creation.
 *
 * Generated from protobuf message <code>google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate</code>
 */
class DatasetTemplate extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The geographic location where the dataset should reside. See
     * https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     *
     * Generated from protobuf field <code>string location = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $location = '';
    /**
     * If supplied, every created dataset will have its name prefixed by the
     * provided value. The prefix and name will be separated by an underscore.
     * i.e. <prefix>_<dataset_name>.
     *
     * Generated from protobuf field <code>string dataset_id_prefix = 2;</code>
     */
    private $dataset_id_prefix = '';
    /**
     * Describes the Cloud KMS encryption key that will be used to
     * protect destination BigQuery table. The BigQuery Service Account
     * associated with your project requires access to this encryption key.
     * i.e.
     * projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryptoKey}.
     * See https://cloud.google.com/bigquery/docs/customer-managed-encryption
     * for more information.
     *
     * Generated from protobuf field <code>string kms_key_name = 3;</code>
     */
    private $kms_key_name = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $location
     *           Required. The geographic location where the dataset should reside. See
     *           https://cloud.google.com/bigquery/docs/locations for supported
     *           locations.
     *     @type string $dataset_id_prefix
     *           If supplied, every created dataset will have its name prefixed by the
     *           provided value. The prefix and name will be separated by an underscore.
     *           i.e. <prefix>_<dataset_name>.
     *     @type string $kms_key_name
     *           Describes the Cloud KMS encryption key that will be used to
     *           protect destination BigQuery table. The BigQuery Service Account
     *           associated with your project requires access to this encryption key.
     *           i.e.
     *           projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryptoKey}.
     *           See https://cloud.google.com/bigquery/docs/customer-managed-encryption
     *           for more information.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Datastream\V1\DatastreamResources::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The geographic location where the dataset should reside. See
     * https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     *
     * Generated from protobuf field <code>string location = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * Required. The geographic location where the dataset should reside. See
     * https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     *
     * Generated from protobuf field <code>string location = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->location = $var;

        return $this;
    }

    /**
     * If supplied, every created dataset will have its name prefixed by the
     * provided value. The prefix and name will be separated by an underscore.
     * i.e. <prefix>_<dataset_name>.
     *
     * Generated from protobuf field <code>string dataset_id_prefix = 2;</code>
     * @return string
     */
    public function getDatasetIdPrefix()
    {
        return $this->dataset_id_prefix;
    }

    /**
     * If supplied, every created dataset will have its name prefixed by the
     * provided value. The prefix and name will be separated by an underscore.
     * i.e. <prefix>_<dataset_name>.
     *
     * Generated from protobuf field <code>string dataset_id_prefix = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDatasetIdPrefix($var)
    {
        GPBUtil::checkString($var, True);
        $this->dataset_id_prefix = $var;

        return $this;
    }

    /**
     * Describes the Cloud KMS encryption key that will be used to
     * protect destination BigQuery table. The BigQuery Service Account
     * associated with your project requires access to this encryption key.
     * i.e.
     * projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryptoKey}.
     * See https://cloud.google.com/bigquery/docs/customer-managed-encryption
     * for more information.
     *
     * Generated from protobuf field <code>string kms_key_name = 3;</code>
     * @return string
     */
    public function getKmsKeyName()
    {
        return $this->kms_key_name;
    }

    /**
     * Describes the Cloud KMS encryption key that will be used to
     * protect destination BigQuery table. The BigQuery Service Account
     * associated with your project requires access to this encryption key.
     * i.e.
     * projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryptoKey}.
     * See https://cloud.google.com/bigquery/docs/customer-managed-encryption
     * for more information.
     *
     * Generated from protobuf field <code>string kms_key_name = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setKmsKeyName($var)
    {
        GPBUtil::checkString($var, True);
        $this->kms_key_name = $var;

        return $this;
    }

}


