<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/gkebackup/v1/backup.proto

namespace Google\Cloud\GkeBackup\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a request to perform a single point-in-time capture of
 * some portion of the state of a GKE cluster, the record of the backup
 * operation itself, and an anchor for the underlying artifacts that
 * comprise the Backup (the config backup and VolumeBackups).
 * Next id: 28
 *
 * Generated from protobuf message <code>google.cloud.gkebackup.v1.Backup</code>
 */
class Backup extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The fully qualified name of the Backup.
     * projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;&#47;backups/&#42;
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $name = '';
    /**
     * Output only. Server generated global unique identifier of
     * [UUID4](https://en.wikipedia.org/wiki/Universally_unique_identifier)
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $uid = '';
    /**
     * Output only. The timestamp when this Backup resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. The timestamp when this Backup resource was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    /**
     * Output only. This flag indicates whether this Backup resource was created manually
     * by a user or via a schedule in the BackupPlan. A value of True means that
     * the Backup was created manually.
     *
     * Generated from protobuf field <code>bool manual = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $manual = false;
    /**
     * A set of custom labels supplied by user.
     *
     * Generated from protobuf field <code>map<string, string> labels = 6;</code>
     */
    private $labels;
    /**
     * Minimum age for this Backup (in days). If this field is set to a non-zero
     * value, the Backup will be "locked" against deletion (either manual or
     * automatic deletion) for the number of days provided (measured from the
     * creation time of the Backup).  MUST be an integer value between 0-90
     * (inclusive).
     * Defaults to parent BackupPlan's
     * [backup_delete_lock_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_delete_lock_days]
     * setting and may only be increased
     * (either at creation time or in a subsequent update).
     *
     * Generated from protobuf field <code>int32 delete_lock_days = 7;</code>
     */
    private $delete_lock_days = 0;
    /**
     * Output only. The time at which an existing delete lock will expire for this backup
     * (calculated from create_time + [delete_lock_days][google.cloud.gkebackup.v1.Backup.delete_lock_days]).
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_lock_expire_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $delete_lock_expire_time = null;
    /**
     * The age (in days) after which this Backup will be automatically deleted.
     * Must be an integer value >= 0:
     * - If 0, no automatic deletion will occur for this Backup.
     * - If not 0, this must be >= [delete_lock_days][google.cloud.gkebackup.v1.Backup.delete_lock_days].
     * Once a Backup is created, this value may only be increased.
     * Defaults to the parent BackupPlan's
     * [backup_retain_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_retain_days] value.
     *
     * Generated from protobuf field <code>int32 retain_days = 9;</code>
     */
    private $retain_days = 0;
    /**
     * Output only. The time at which this Backup will be automatically deleted (calculated
     * from create_time + [retain_days][google.cloud.gkebackup.v1.Backup.retain_days]).
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp retain_expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $retain_expire_time = null;
    /**
     * Output only. The customer managed encryption key that was used to encrypt the Backup's
     * artifacts.  Inherited from the parent BackupPlan's
     * [encryption_key][google.cloud.gkebackup.v1.BackupPlan.BackupConfig.encryption_key] value.
     *
     * Generated from protobuf field <code>.google.cloud.gkebackup.v1.EncryptionKey encryption_key = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $encryption_key = null;
    /**
     * Output only. Whether or not the Backup contains volume data.  Controlled by the parent
     * BackupPlan's
     * [include_volume_data][google.cloud.gkebackup.v1.BackupPlan.BackupConfig.include_volume_data] value.
     *
     * Generated from protobuf field <code>bool contains_volume_data = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $contains_volume_data = false;
    /**
     * Output only. Whether or not the Backup contains Kubernetes Secrets.  Controlled by the
     * parent BackupPlan's
     * [include_secrets][google.cloud.gkebackup.v1.BackupPlan.BackupConfig.include_secrets] value.
     *
     * Generated from protobuf field <code>bool contains_secrets = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $contains_secrets = false;
    /**
     * Output only. Information about the GKE cluster from which this Backup was created.
     *
     * Generated from protobuf field <code>.google.cloud.gkebackup.v1.Backup.ClusterMetadata cluster_metadata = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $cluster_metadata = null;
    /**
     * Output only. Current state of the Backup
     *
     * Generated from protobuf field <code>.google.cloud.gkebackup.v1.Backup.State state = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state = 0;
    /**
     * Output only. Human-readable description of why the backup is in the current `state`.
     *
     * Generated from protobuf field <code>string state_reason = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state_reason = '';
    /**
     * Output only. Completion time of the Backup
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp complete_time = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $complete_time = null;
    /**
     * Output only. The total number of Kubernetes resources included in the Backup.
     *
     * Generated from protobuf field <code>int32 resource_count = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $resource_count = 0;
    /**
     * Output only. The total number of volume backups contained in the Backup.
     *
     * Generated from protobuf field <code>int32 volume_count = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $volume_count = 0;
    /**
     * Output only. The total size of the Backup in bytes = config backup size + sum(volume
     * backup sizes)
     *
     * Generated from protobuf field <code>int64 size_bytes = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $size_bytes = 0;
    /**
     * Output only. `etag` is used for optimistic concurrency control as a way to help
     * prevent simultaneous updates of a backup from overwriting each other.
     * It is strongly suggested that systems make use of the `etag` in the
     * read-modify-write cycle to perform backup updates in order to avoid
     * race conditions: An `etag` is returned in the response to `GetBackup`,
     * and systems are expected to put that etag in the request to
     * `UpdateBackup` or `DeleteBackup` to ensure that their change will be
     * applied to the same version of the resource.
     *
     * Generated from protobuf field <code>string etag = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $etag = '';
    /**
     * User specified descriptive string for this Backup.
     *
     * Generated from protobuf field <code>string description = 25;</code>
     */
    private $description = '';
    /**
     * Output only. The total number of Kubernetes Pods contained in the Backup.
     *
     * Generated from protobuf field <code>int32 pod_count = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $pod_count = 0;
    /**
     * Output only. The size of the config backup in bytes.
     *
     * Generated from protobuf field <code>int64 config_backup_size_bytes = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $config_backup_size_bytes = 0;
    protected $backup_scope;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The fully qualified name of the Backup.
     *           projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;&#47;backups/&#42;
     *     @type string $uid
     *           Output only. Server generated global unique identifier of
     *           [UUID4](https://en.wikipedia.org/wiki/Universally_unique_identifier)
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The timestamp when this Backup resource was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The timestamp when this Backup resource was last updated.
     *     @type bool $manual
     *           Output only. This flag indicates whether this Backup resource was created manually
     *           by a user or via a schedule in the BackupPlan. A value of True means that
     *           the Backup was created manually.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           A set of custom labels supplied by user.
     *     @type int $delete_lock_days
     *           Minimum age for this Backup (in days). If this field is set to a non-zero
     *           value, the Backup will be "locked" against deletion (either manual or
     *           automatic deletion) for the number of days provided (measured from the
     *           creation time of the Backup).  MUST be an integer value between 0-90
     *           (inclusive).
     *           Defaults to parent BackupPlan's
     *           [backup_delete_lock_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_delete_lock_days]
     *           setting and may only be increased
     *           (either at creation time or in a subsequent update).
     *     @type \Google\Protobuf\Timestamp $delete_lock_expire_time
     *           Output only. The time at which an existing delete lock will expire for this backup
     *           (calculated from create_time + [delete_lock_days][google.cloud.gkebackup.v1.Backup.delete_lock_days]).
     *     @type int $retain_days
     *           The age (in days) after which this Backup will be automatically deleted.
     *           Must be an integer value >= 0:
     *           - If 0, no automatic deletion will occur for this Backup.
     *           - If not 0, this must be >= [delete_lock_days][google.cloud.gkebackup.v1.Backup.delete_lock_days].
     *           Once a Backup is created, this value may only be increased.
     *           Defaults to the parent BackupPlan's
     *           [backup_retain_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_retain_days] value.
     *     @type \Google\Protobuf\Timestamp $retain_expire_time
     *           Output only. The time at which this Backup will be automatically deleted (calculated
     *           from create_time + [retain_days][google.cloud.gkebackup.v1.Backup.retain_days]).
     *     @type \Google\Cloud\GkeBackup\V1\EncryptionKey $encryption_key
     *           Output only. The customer managed encryption key that was used to encrypt the Backup's
     *           artifacts.  Inherited from the parent BackupPlan's
     *           [encryption_key][google.cloud.gkebackup.v1.BackupPlan.BackupConfig.encryption_key] value.
     *     @type bool $all_namespaces
     *           Output only. If True, all namespaces were included in the Backup.
     *     @type \Google\Cloud\GkeBackup\V1\Namespaces $selected_namespaces
     *           Output only. If set, the list of namespaces that were included in the Backup.
     *     @type \Google\Cloud\GkeBackup\V1\NamespacedNames $selected_applications
     *           Output only. If set, the list of ProtectedApplications whose resources were included
     *           in the Backup.
     *     @type bool $contains_volume_data
     *           Output only. Whether or not the Backup contains volume data.  Controlled by the parent
     *           BackupPlan's
     *           [include_volume_data][google.cloud.gkebackup.v1.BackupPlan.BackupConfig.include_volume_data] value.
     *     @type bool $contains_secrets
     *           Output only. Whether or not the Backup contains Kubernetes Secrets.  Controlled by the
     *           parent BackupPlan's
     *           [include_secrets][google.cloud.gkebackup.v1.BackupPlan.BackupConfig.include_secrets] value.
     *     @type \Google\Cloud\GkeBackup\V1\Backup\ClusterMetadata $cluster_metadata
     *           Output only. Information about the GKE cluster from which this Backup was created.
     *     @type int $state
     *           Output only. Current state of the Backup
     *     @type string $state_reason
     *           Output only. Human-readable description of why the backup is in the current `state`.
     *     @type \Google\Protobuf\Timestamp $complete_time
     *           Output only. Completion time of the Backup
     *     @type int $resource_count
     *           Output only. The total number of Kubernetes resources included in the Backup.
     *     @type int $volume_count
     *           Output only. The total number of volume backups contained in the Backup.
     *     @type int|string $size_bytes
     *           Output only. The total size of the Backup in bytes = config backup size + sum(volume
     *           backup sizes)
     *     @type string $etag
     *           Output only. `etag` is used for optimistic concurrency control as a way to help
     *           prevent simultaneous updates of a backup from overwriting each other.
     *           It is strongly suggested that systems make use of the `etag` in the
     *           read-modify-write cycle to perform backup updates in order to avoid
     *           race conditions: An `etag` is returned in the response to `GetBackup`,
     *           and systems are expected to put that etag in the request to
     *           `UpdateBackup` or `DeleteBackup` to ensure that their change will be
     *           applied to the same version of the resource.
     *     @type string $description
     *           User specified descriptive string for this Backup.
     *     @type int $pod_count
     *           Output only. The total number of Kubernetes Pods contained in the Backup.
     *     @type int|string $config_backup_size_bytes
     *           Output only. The size of the config backup in bytes.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Gkebackup\V1\Backup::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The fully qualified name of the Backup.
     * projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;&#47;backups/&#42;
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The fully qualified name of the Backup.
     * projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;&#47;backups/&#42;
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Server generated global unique identifier of
     * [UUID4](https://en.wikipedia.org/wiki/Universally_unique_identifier)
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. Server generated global unique identifier of
     * [UUID4](https://en.wikipedia.org/wiki/Universally_unique_identifier)
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when this Backup resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The timestamp when this Backup resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when this Backup resource was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The timestamp when this Backup resource was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. This flag indicates whether this Backup resource was created manually
     * by a user or via a schedule in the BackupPlan. A value of True means that
     * the Backup was created manually.
     *
     * Generated from protobuf field <code>bool manual = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getManual()
    {
        return $this->manual;
    }

    /**
     * Output only. This flag indicates whether this Backup resource was created manually
     * by a user or via a schedule in the BackupPlan. A value of True means that
     * the Backup was created manually.
     *
     * Generated from protobuf field <code>bool manual = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setManual($var)
    {
        GPBUtil::checkBool($var);
        $this->manual = $var;

        return $this;
    }

    /**
     * A set of custom labels supplied by user.
     *
     * Generated from protobuf field <code>map<string, string> labels = 6;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * A set of custom labels supplied by user.
     *
     * Generated from protobuf field <code>map<string, string> labels = 6;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Minimum age for this Backup (in days). If this field is set to a non-zero
     * value, the Backup will be "locked" against deletion (either manual or
     * automatic deletion) for the number of days provided (measured from the
     * creation time of the Backup).  MUST be an integer value between 0-90
     * (inclusive).
     * Defaults to parent BackupPlan's
     * [backup_delete_lock_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_delete_lock_days]
     * setting and may only be increased
     * (either at creation time or in a subsequent update).
     *
     * Generated from protobuf field <code>int32 delete_lock_days = 7;</code>
     * @return int
     */
    public function getDeleteLockDays()
    {
        return $this->delete_lock_days;
    }

    /**
     * Minimum age for this Backup (in days). If this field is set to a non-zero
     * value, the Backup will be "locked" against deletion (either manual or
     * automatic deletion) for the number of days provided (measured from the
     * creation time of the Backup).  MUST be an integer value between 0-90
     * (inclusive).
     * Defaults to parent BackupPlan's
     * [backup_delete_lock_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_delete_lock_days]
     * setting and may only be increased
     * (either at creation time or in a subsequent update).
     *
     * Generated from protobuf field <code>int32 delete_lock_days = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setDeleteLockDays($var)
    {
        GPBUtil::checkInt32($var);
        $this->delete_lock_days = $var;

        return $this;
    }

    /**
     * Output only. The time at which an existing delete lock will expire for this backup
     * (calculated from create_time + [delete_lock_days][google.cloud.gkebackup.v1.Backup.delete_lock_days]).
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_lock_expire_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getDeleteLockExpireTime()
    {
        return $this->delete_lock_expire_time;
    }

    public function hasDeleteLockExpireTime()
    {
        return isset($this->delete_lock_expire_time);
    }

    public function clearDeleteLockExpireTime()
    {
        unset($this->delete_lock_expire_time);
    }

    /**
     * Output only. The time at which an existing delete lock will expire for this backup
     * (calculated from create_time + [delete_lock_days][google.cloud.gkebackup.v1.Backup.delete_lock_days]).
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_lock_expire_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setDeleteLockExpireTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->delete_lock_expire_time = $var;

        return $this;
    }

    /**
     * The age (in days) after which this Backup will be automatically deleted.
     * Must be an integer value >= 0:
     * - If 0, no automatic deletion will occur for this Backup.
     * - If not 0, this must be >= [delete_lock_days][google.cloud.gkebackup.v1.Backup.delete_lock_days].
     * Once a Backup is created, this value may only be increased.
     * Defaults to the parent BackupPlan's
     * [backup_retain_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_retain_days] value.
     *
     * Generated from protobuf field <code>int32 retain_days = 9;</code>
     * @return int
     */
    public function getRetainDays()
    {
        return $this->retain_days;
    }

    /**
     * The age (in days) after which this Backup will be automatically deleted.
     * Must be an integer value >= 0:
     * - If 0, no automatic deletion will occur for this Backup.
     * - If not 0, this must be >= [delete_lock_days][google.cloud.gkebackup.v1.Backup.delete_lock_days].
     * Once a Backup is created, this value may only be increased.
     * Defaults to the parent BackupPlan's
     * [backup_retain_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_retain_days] value.
     *
     * Generated from protobuf field <code>int32 retain_days = 9;</code>
     * @param int $var
     * @return $this
     */
    public function setRetainDays($var)
    {
        GPBUtil::checkInt32($var);
        $this->retain_days = $var;

        return $this;
    }

    /**
     * Output only. The time at which this Backup will be automatically deleted (calculated
     * from create_time + [retain_days][google.cloud.gkebackup.v1.Backup.retain_days]).
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp retain_expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getRetainExpireTime()
    {
        return $this->retain_expire_time;
    }

    public function hasRetainExpireTime()
    {
        return isset($this->retain_expire_time);
    }

    public function clearRetainExpireTime()
    {
        unset($this->retain_expire_time);
    }

    /**
     * Output only. The time at which this Backup will be automatically deleted (calculated
     * from create_time + [retain_days][google.cloud.gkebackup.v1.Backup.retain_days]).
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp retain_expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setRetainExpireTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->retain_expire_time = $var;

        return $this;
    }

    /**
     * Output only. The customer managed encryption key that was used to encrypt the Backup's
     * artifacts.  Inherited from the parent BackupPlan's
     * [encryption_key][google.cloud.gkebackup.v1.BackupPlan.BackupConfig.encryption_key] value.
     *
     * Generated from protobuf field <code>.google.cloud.gkebackup.v1.EncryptionKey encryption_key = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\GkeBackup\V1\EncryptionKey|null
     */
    public function getEncryptionKey()
    {
        return $this->encryption_key;
    }

    public function hasEncryptionKey()
    {
        return isset($this->encryption_key);
    }

    public function clearEncryptionKey()
    {
        unset($this->encryption_key);
    }

    /**
     * Output only. The customer managed encryption key that was used to encrypt the Backup's
     * artifacts.  Inherited from the parent BackupPlan's
     * [encryption_key][google.cloud.gkebackup.v1.BackupPlan.BackupConfig.encryption_key] value.
     *
     * Generated from protobuf field <code>.google.cloud.gkebackup.v1.EncryptionKey encryption_key = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\GkeBackup\V1\EncryptionKey $var
     * @return $this
     */
    public function setEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\GkeBackup\V1\EncryptionKey::class);
        $this->encryption_key = $var;

        return $this;
    }

    /**
     * Output only. If True, all namespaces were included in the Backup.
     *
     * Generated from protobuf field <code>bool all_namespaces = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getAllNamespaces()
    {
        return $this->readOneof(12);
    }

    public function hasAllNamespaces()
    {
        return $this->hasOneof(12);
    }

    /**
     * Output only. If True, all namespaces were included in the Backup.
     *
     * Generated from protobuf field <code>bool all_namespaces = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setAllNamespaces($var)
    {
        GPBUtil::checkBool($var);
        $this->writeOneof(12, $var);

        return $this;
    }

    /**
     * Output only. If set, the list of namespaces that were included in the Backup.
     *
     * Generated from protobuf field <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\GkeBackup\V1\Namespaces|null
     */
    public function getSelectedNamespaces()
    {
        return $this->readOneof(13);
    }

    public function hasSelectedNamespaces()
    {
        return $this->hasOneof(13);
    }

    /**
     * Output only. If set, the list of namespaces that were included in the Backup.
     *
     * Generated from protobuf field <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\GkeBackup\V1\Namespaces $var
     * @return $this
     */
    public function setSelectedNamespaces($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\GkeBackup\V1\Namespaces::class);
        $this->writeOneof(13, $var);

        return $this;
    }

    /**
     * Output only. If set, the list of ProtectedApplications whose resources were included
     * in the Backup.
     *
     * Generated from protobuf field <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\GkeBackup\V1\NamespacedNames|null
     */
    public function getSelectedApplications()
    {
        return $this->readOneof(14);
    }

    public function hasSelectedApplications()
    {
        return $this->hasOneof(14);
    }

    /**
     * Output only. If set, the list of ProtectedApplications whose resources were included
     * in the Backup.
     *
     * Generated from protobuf field <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\GkeBackup\V1\NamespacedNames $var
     * @return $this
     */
    public function setSelectedApplications($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\GkeBackup\V1\NamespacedNames::class);
        $this->writeOneof(14, $var);

        return $this;
    }

    /**
     * Output only. Whether or not the Backup contains volume data.  Controlled by the parent
     * BackupPlan's
     * [include_volume_data][google.cloud.gkebackup.v1.BackupPlan.BackupConfig.include_volume_data] value.
     *
     * Generated from protobuf field <code>bool contains_volume_data = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getContainsVolumeData()
    {
        return $this->contains_volume_data;
    }

    /**
     * Output only. Whether or not the Backup contains volume data.  Controlled by the parent
     * BackupPlan's
     * [include_volume_data][google.cloud.gkebackup.v1.BackupPlan.BackupConfig.include_volume_data] value.
     *
     * Generated from protobuf field <code>bool contains_volume_data = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setContainsVolumeData($var)
    {
        GPBUtil::checkBool($var);
        $this->contains_volume_data = $var;

        return $this;
    }

    /**
     * Output only. Whether or not the Backup contains Kubernetes Secrets.  Controlled by the
     * parent BackupPlan's
     * [include_secrets][google.cloud.gkebackup.v1.BackupPlan.BackupConfig.include_secrets] value.
     *
     * Generated from protobuf field <code>bool contains_secrets = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getContainsSecrets()
    {
        return $this->contains_secrets;
    }

    /**
     * Output only. Whether or not the Backup contains Kubernetes Secrets.  Controlled by the
     * parent BackupPlan's
     * [include_secrets][google.cloud.gkebackup.v1.BackupPlan.BackupConfig.include_secrets] value.
     *
     * Generated from protobuf field <code>bool contains_secrets = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setContainsSecrets($var)
    {
        GPBUtil::checkBool($var);
        $this->contains_secrets = $var;

        return $this;
    }

    /**
     * Output only. Information about the GKE cluster from which this Backup was created.
     *
     * Generated from protobuf field <code>.google.cloud.gkebackup.v1.Backup.ClusterMetadata cluster_metadata = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\GkeBackup\V1\Backup\ClusterMetadata|null
     */
    public function getClusterMetadata()
    {
        return $this->cluster_metadata;
    }

    public function hasClusterMetadata()
    {
        return isset($this->cluster_metadata);
    }

    public function clearClusterMetadata()
    {
        unset($this->cluster_metadata);
    }

    /**
     * Output only. Information about the GKE cluster from which this Backup was created.
     *
     * Generated from protobuf field <code>.google.cloud.gkebackup.v1.Backup.ClusterMetadata cluster_metadata = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\GkeBackup\V1\Backup\ClusterMetadata $var
     * @return $this
     */
    public function setClusterMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\GkeBackup\V1\Backup\ClusterMetadata::class);
        $this->cluster_metadata = $var;

        return $this;
    }

    /**
     * Output only. Current state of the Backup
     *
     * Generated from protobuf field <code>.google.cloud.gkebackup.v1.Backup.State state = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. Current state of the Backup
     *
     * Generated from protobuf field <code>.google.cloud.gkebackup.v1.Backup.State state = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\GkeBackup\V1\Backup\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. Human-readable description of why the backup is in the current `state`.
     *
     * Generated from protobuf field <code>string state_reason = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getStateReason()
    {
        return $this->state_reason;
    }

    /**
     * Output only. Human-readable description of why the backup is in the current `state`.
     *
     * Generated from protobuf field <code>string state_reason = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setStateReason($var)
    {
        GPBUtil::checkString($var, True);
        $this->state_reason = $var;

        return $this;
    }

    /**
     * Output only. Completion time of the Backup
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp complete_time = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCompleteTime()
    {
        return $this->complete_time;
    }

    public function hasCompleteTime()
    {
        return isset($this->complete_time);
    }

    public function clearCompleteTime()
    {
        unset($this->complete_time);
    }

    /**
     * Output only. Completion time of the Backup
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp complete_time = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCompleteTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->complete_time = $var;

        return $this;
    }

    /**
     * Output only. The total number of Kubernetes resources included in the Backup.
     *
     * Generated from protobuf field <code>int32 resource_count = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getResourceCount()
    {
        return $this->resource_count;
    }

    /**
     * Output only. The total number of Kubernetes resources included in the Backup.
     *
     * Generated from protobuf field <code>int32 resource_count = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setResourceCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->resource_count = $var;

        return $this;
    }

    /**
     * Output only. The total number of volume backups contained in the Backup.
     *
     * Generated from protobuf field <code>int32 volume_count = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getVolumeCount()
    {
        return $this->volume_count;
    }

    /**
     * Output only. The total number of volume backups contained in the Backup.
     *
     * Generated from protobuf field <code>int32 volume_count = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setVolumeCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->volume_count = $var;

        return $this;
    }

    /**
     * Output only. The total size of the Backup in bytes = config backup size + sum(volume
     * backup sizes)
     *
     * Generated from protobuf field <code>int64 size_bytes = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getSizeBytes()
    {
        return $this->size_bytes;
    }

    /**
     * Output only. The total size of the Backup in bytes = config backup size + sum(volume
     * backup sizes)
     *
     * Generated from protobuf field <code>int64 size_bytes = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setSizeBytes($var)
    {
        GPBUtil::checkInt64($var);
        $this->size_bytes = $var;

        return $this;
    }

    /**
     * Output only. `etag` is used for optimistic concurrency control as a way to help
     * prevent simultaneous updates of a backup from overwriting each other.
     * It is strongly suggested that systems make use of the `etag` in the
     * read-modify-write cycle to perform backup updates in order to avoid
     * race conditions: An `etag` is returned in the response to `GetBackup`,
     * and systems are expected to put that etag in the request to
     * `UpdateBackup` or `DeleteBackup` to ensure that their change will be
     * applied to the same version of the resource.
     *
     * Generated from protobuf field <code>string etag = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Output only. `etag` is used for optimistic concurrency control as a way to help
     * prevent simultaneous updates of a backup from overwriting each other.
     * It is strongly suggested that systems make use of the `etag` in the
     * read-modify-write cycle to perform backup updates in order to avoid
     * race conditions: An `etag` is returned in the response to `GetBackup`,
     * and systems are expected to put that etag in the request to
     * `UpdateBackup` or `DeleteBackup` to ensure that their change will be
     * applied to the same version of the resource.
     *
     * Generated from protobuf field <code>string etag = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * User specified descriptive string for this Backup.
     *
     * Generated from protobuf field <code>string description = 25;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * User specified descriptive string for this Backup.
     *
     * Generated from protobuf field <code>string description = 25;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Output only. The total number of Kubernetes Pods contained in the Backup.
     *
     * Generated from protobuf field <code>int32 pod_count = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getPodCount()
    {
        return $this->pod_count;
    }

    /**
     * Output only. The total number of Kubernetes Pods contained in the Backup.
     *
     * Generated from protobuf field <code>int32 pod_count = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setPodCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->pod_count = $var;

        return $this;
    }

    /**
     * Output only. The size of the config backup in bytes.
     *
     * Generated from protobuf field <code>int64 config_backup_size_bytes = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getConfigBackupSizeBytes()
    {
        return $this->config_backup_size_bytes;
    }

    /**
     * Output only. The size of the config backup in bytes.
     *
     * Generated from protobuf field <code>int64 config_backup_size_bytes = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setConfigBackupSizeBytes($var)
    {
        GPBUtil::checkInt64($var);
        $this->config_backup_size_bytes = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getBackupScope()
    {
        return $this->whichOneof("backup_scope");
    }

}

