<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class ClassificationFavoris_Model extends CI_Model
{
    
    public function __construct(){        
        parent::__construct();
        $this->table        = 'classification_favoris ';      
        $this->table_groupe = 'list_groupe';      
    }

    public function update($id,$data) {
        $this->db->where('id', $id);
        $this->db->update($this->table, $data);

    }

    public function delete($id){
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }

    public function add($arrayData){
        $this->db->select('*');
        $this->db->from($this->table);
        if (isset($arrayData['intitule'])) {
            $this->db->where('intitule', $arrayData['intitule']);
        }

        if (isset($arrayData['user_create'])) {
            $this->db->where('user_create', $arrayData['user_create']);
        }

        if (isset($arrayData['id_groupe'])) {
            $this->db->where('id_groupe', $arrayData['id_groupe']);
        }

        if (isset($arrayData['id_classification_favoris'])) {
            $this->db->where('id_classification_favoris', $arrayData['id_classification_favoris']);
        }

        if (isset($arrayData['id_prg'])) {
            $this->db->where('id_prg', $arrayData['id_prg']);
        }

        if (isset($arrayData['numero'])) {
            $this->db->where('numero', $arrayData['numero']);
        }

        if (isset($arrayData['type'])) {
            $this->db->where('type', $arrayData['type']);
        }

        if (isset($arrayData['module_id'])) {
            $this->db->where('module_id', $arrayData['module_id']);
        }
        
        $query = $this->db->get(); 
        $cnt = $query->num_rows();  
        if ($cnt >= 1) {
            foreach ($query->result() as $res) {
                return $res->id;
            }
        }  
        else{
            $this->db->trans_start();
            $this->db->insert($this->table, $arrayData);        
            $insert_id = $this->db->insert_id();        
            $this->db->trans_complete();
            return $insert_id;
        }
    }

    public function getAll($idm) {
        $this->db->select('*');
        $this->db->from($this->table);
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function getByUserCreateIdGroup($idUserCreate,$idGroup) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('user_create', $idUserCreate);
        $this->db->where('id_groupe', $idGroup);
        $this->db->order_by('id', 'desc');
        $query = $this->db->get(); 
        return $query->result()  ; 
    }


    public function getByUserCreateIdGroupDashbordTrainee($idUserCreate,$idGroup) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('user_create', $idUserCreate);
        $this->db->where('id_groupe', $idGroup);
        $this->db->order_by('id', 'desc');
        $this->db->limit(2);
        $query = $this->db->get(); 
        return $query->result()  ; 
    }

    public function getByIdGroupNotInTrainee($membresId,$idGroup) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('user_create !=', $membresId);
        $this->db->where('id_groupe', $idGroup);
        $this->db->order_by('id', 'desc');
        $query = $this->db->get(); 
        return $query->result()  ; 
    }

    public function getClassTuteurByTrainee($idGroup) {
        $this->db->select('*');
        $this->db->from($this->table.' as c');
        $this->db->where('id_groupe', $idGroup);
        $this->db->order_by('id', 'desc');
        $query = $this->db->get(); 
        return $query->result()  ; 
    }

    public function Request($field,$idu) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id', $idu);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function getAllByKey($key,$user_create,$idGroup) {
        $this->db->select('*');
        $this->db->from($this->table);
        if(!empty($key)) {
            $likeCriteria = "(intitule  LIKE '%".$key."%')";
            $this->db->where($likeCriteria);
        } 
        $this->db->where('user_create', $user_create);
        $this->db->where('id_groupe', $idGroup);
        $query = $this->db->get(); 
        return $query->result()  ;
    }
    public function getTraineeAllByKey($key,$idGroup) {
        $this->db->select('*');
        $this->db->from($this->table);
        if(!empty($key)) {
            $likeCriteria = "(intitule  LIKE '%".$key."%')";
            $this->db->where($likeCriteria);
        } 
        $this->db->where('id_groupe', $idGroup);
        $query = $this->db->get(); 
        return $query->result()  ;
    }

}

?>
