<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Content_community_library_forma2plus_model extends CI_Model
{
    
    public function __construct(){
        
        parent::__construct();
        $this->table = 'content_community_library_forma2plus';             
    }

    public function update($id,$data) {
        $this->db->where('id', $id);
        return $this->db->update($this->table, $data);
    }

    public function delete($id){
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }

    public function add($arrayData){
        $this->db->trans_start();
        $this->db->insert($this->table, $arrayData);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $insert_id;
    }

    public function getAll() {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->order_by('titre', 'ASC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function getById($id) {        
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id', $id);
        $query = $this->db->get();         
        return $query->result()  ; 
    }

    public function deleteByIdCommunityLibraryForma2Plus($id_community_library_forma2plus){
        $this->db->where('id_community_library_forma2plus', $id_community_library_forma2plus);
        $this->db->delete($this->table);
    }

    public function getByIdCommunityLibraryForma2Plus($id_community_library_forma2plus) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_community_library_forma2plus', $id_community_library_forma2plus);
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function Request($field,$id) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id', $id);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }    
}

?>
