<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class CoursProduit_model extends CI_Model
{
    
    public function __construct(){
        
        parent::__construct();
        $this->table           = 'cours_produit';  
        $this->table_connexion = 'connexion';           
        $this->table_stag      = 'stag_individu';           
        $this->table_membres   = 'membres';           
    }



    public function add($arrayData){
        $this->db->trans_start();
        $this->db->insert($this->table, $arrayData);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $insert_id;
    }

    public function update($id,$data) {
        $this->db->where('idCoursProduit', $id);
        $this->db->update($this->table, $data);

    }

    public function delete($id){
        $this->db->where('idCoursProduit', $id);
        $this->db->delete($this->table);
    }

    public function getAll() {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->order_by('idCoursProduit', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }


    public function getAllTrainer() {
        $this->db->select('CONCAT(prenomProfCoursProduit," ",nomProfCoursProduit) AS trainer');
        $this->db->from($this->table);
        $this->db->order_by('prenomProfCoursProduit', 'ASC');
        $this->db->group_by('CONCAT(prenomProfCoursProduit," ",nomProfCoursProduit)');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function Request($field,$id) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('idCoursProduit', $id);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function RequestByIdStage($field,$id) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('idStageCoursProduit', $id);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function getByEventId($evennementId) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('evennementId', $evennementId);
        $query = $this->db->get();
        return $query->result();
    }

    public function getAllCrenauRes() {
        $this->db->distinct('CAST(dateHeureDebutCoursProduit AS time) AS creneauHoraire');
        $this->db->from($this->table);
        $this->db->order_by('CAST(dateHeureDebutCoursProduit AS time)', 'ASC');
        $this->db->group_by('CAST(dateHeureDebutCoursProduit AS time)');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function search($criteriaFilter) {
        $likeCriteria = '';
        $this->db->select('c.*');
        $this->db->from($this->table.' as c');

        if(isset($criteriaFilter['statusConnexion']) && $criteriaFilter['statusConnexion'] != ''){
            $this->db->join($this->table_stag.' AS s', 's.id_stage_ext = c.idStageCoursProduit', 'INNER');       
        }

        if(isset($criteriaFilter['traineeFilter']) && $criteriaFilter['traineeFilter'] != ''){
            $this->db->join($this->table_membres.' AS m', 'c.idStageCoursProduit IN (SELECT MAX (id_stage_ext) FROM stag_individu WHERE id_stagiare_el = m.id LIMIT 1)', 'INNER');
        }

        if (isset($criteriaFilter['creneauHoraire']) && $criteriaFilter['creneauHoraire'] != '') {
            $this->db->where('TIME(c.dateHeureDebutCoursProduit)', $criteriaFilter['creneauHoraire']);
        }

        if(isset($criteriaFilter['trainer']) && $criteriaFilter['trainer'] != ''){
            $likeCriteria .= 'CONCAT(c.prenomProfCoursProduit," ",c.nomProfCoursProduit) LIKE "%'.$criteriaFilter['trainer'].'%" ';
        }

        if (isset($criteriaFilter['datecoursplanifier']) && $criteriaFilter['datecoursplanifier'] != '') {
            $date = date('Y-m-d');
            $finalyDate = '';
            switch ($criteriaFilter['datecoursplanifier']) {
                case 'jm1':
                    $finalyDate .= date('Y-m-d', strtotime("-1 day"));
                    break;
                case 'j':
                    $finalyDate .= $date;
                    break;
                case 'jp1':
                    $finalyDate .= date('Y-m-d', strtotime("+1 day"));
                    break;
                
                default:
                    // code...
                    break;
            }
            if (isset($finalyDate) && $finalyDate != '') {
                $this->db->where('DATE(c.dateHeureDebutCoursProduit)', $finalyDate);
            }
        }

        if(isset($criteriaFilter['statusConnexion']) && $criteriaFilter['statusConnexion'] != ''){     
            switch ($criteriaFilter['statusConnexion']) {
                case 'En ligne':
                    $this->db->where_in('s.id_stagiare_el', $criteriaFilter['allTraineeConnected']);
                    break;
                case 'Deconnecté':
                    $this->db->where_not_in('s.id_stagiare_el', $criteriaFilter['allTraineeConnected']);
                    break;
                
                default:
                    // code...
                    break;
            }
            
        }

        if(isset($criteriaFilter['traineeFilter']) && $criteriaFilter['traineeFilter'] != ''){
            if (isset($likeCriteria) && $likeCriteria != '') {
                $likeCriteria .= 'AND CONCAT(m.prenom," ",m.nom) LIKE "%'.$criteriaFilter['traineeFilter'].'%"';
            }
            else{
                $likeCriteria .= 'CONCAT(m.prenom," ",m.nom) LIKE "%'.$criteriaFilter['traineeFilter'].'%"';
            }
        }

        if (isset($likeCriteria) && $likeCriteria != '') {
            $this->db->where($likeCriteria);
        }

        $this->db->group_by(array("c.dateHeureDebutCoursProduit", "c.idStageCoursProduit"));
        $this->db->order_by('c.dateHeureDebutCoursProduit', 'ASC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }
    
}

?>
