<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Log_model extends CI_Model
{
    public function __construct(){        
        parent::__construct();  
        $this->table_stat = "stat_connexion";        
        $this->table_track= "tracking";        
        $this->table_user = "membres";        
    }

    public function update($CNX,$arrayData) {
        $this->db->where('CNX', $CNX);
        $this->db->update($this->table_stat, $arrayData);
        $this->db->affected_rows();
    }

    public function Request($field,$CNX) {
        $ret = "";
        $this->db->select($field);
        $this->db->from($this->table_stat);
        $this->db->where('CNX', $CNX);
        $query = $this->db->get();
        $result = $query->result();
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function read($idu,$limit=NULL) {
        $ret = Array() ;
        $i=0 ;

        $this->db->select("s.cnx, s.id_membres, s.id_groupe, date(from_unixtime(s.date_cnx)) as 'date', time(from_unixtime(s.date_cnx)) as 'heure', sum(time_cnx) as 'time',
                (select count(*) from ".$this->table_track." t where t.user_id=s.id_membres and date(from_unixtime(t.`date`))=date(from_unixtime(s.date_cnx)) and t.groupe_id=s.id_groupe) as 'activite',
                (select count(*) from session_tutoree st where (date(from_unixtime(st.date_debut_cnx))=date(from_unixtime(s.date_cnx)) and st.id_stagiaire=s.id_membres)) as session_tutoree");
        $this->db->from($this->table_stat." as s");
        $this->db->join($this->table_user.' as m', 'm.id=s.id_membres','inner');
        $this->db->where('s.id_membres', $idu);
        $this->db->group_by('date(from_unixtime(s.date_cnx))');
        $this->db->order_by('s.date_cnx', 'desc');
        if ($limit != NULL) {
           $this->db->limit($limit);
        }
        $query = $this->db->get(); 
        $ret['cnt'] = $query->num_rows();
        $result = $query->result()  ;   
        if (is_array($result)) {
            foreach ($result as $res){
                $ret[$i]['stagiaire_cnx'] = $res->cnx ;
                $ret[$i]['id_membres'] = $res->id_membres ;
                $ret[$i]['id_groupe'] = $res->id_groupe ;
                $ret[$i]['date'] = $res->date ;
                $ret[$i]['heure'] = $res->heure ;           
                $ret[$i]['time'] = $res->time ;
                $ret[$i]['activite'] = $res->activite ;
                $ret[$i++]['session_tutoree'] = $res->session_tutoree ;         
            }
        } 
        return $ret;
        
    }

    public function readTuteur($stagiaire_id,$limit=NULL){
        $this->db->select("s.cnx, s.id_membres, s.id_groupe,s.date_cnx as date_cnx_unix, date(from_unixtime(s.date_cnx)) as  date_cnx, time(from_unixtime(s.date_cnx)) as heures_cnx, SEC_TO_TIME(sum(time_cnx)) as duree_cnx,sum(time_cnx) as time_cnx_tot,
            (select count(*) from tracking t where t.user_id=".$stagiaire_id." AND t.groupe_id=s.id_groupe and date(from_unixtime(t.`date`))=date(from_unixtime(s.date_cnx))) as total_activite,
            (select count(*) from session_tutoree st where (date(from_unixtime(st.date_debut_cnx))=date(from_unixtime(s.date_cnx)) and st.id_stagiaire=s.id_membres)) as session_tutoree");
        $this->db->from($this->table_stat." as s");
        $this->db->join($this->table_user." as m", 'm.id=s.id_membres','inner');
        $this->db->where('m.id', $stagiaire_id);
        $this->db->where('s.date_cnx >=', "m.date_creation");
        $this->db->group_by('date(from_unixtime(s.date_cnx))');
        $this->db->order_by('s.date_cnx', 'desc');
        $query = $this->db->get();        
        return $query->result();
    }

     public function readTot($idu) {
        $ret = Array() ;      
        $this->db->select("*");
        $this->db->from($this->table_stat." as s");
        $this->db->join($this->table_user.' as m', 'm.id=s.id_membres','inner');
        $this->db->where('s.id_membres', $idu);
        $this->db->group_by('date(from_unixtime(s.date_cnx))');
        $this->db->order_by('s.date_cnx', 'desc');
        
        $query = $this->db->get(); 
        $ret['cnt'] = $query->num_rows();        
        return $ret;
        
    }

    public function del($idu,$idg) {
        $this->db->delete($this->table_stat, array('id_membres' => $idu,'id_groupe' => $idg));
    }
}

  