window.onload=function(){
	URL = window.URL || window.webkitURL;
	var gumStream; 			
	var rec; 				
	var input; 			
	var AudioContext = window.AudioContext || window.webkitAudioContext;
	var recordButton = document.getElementById("recordButton");
	var stopButton   = document.getElementById("stopButton");
	var urlUpload    = document.getElementById("urlUpload").value;
	var usertype     = document.getElementById("usertype").value;
	var loader      = document.getElementById("loader-content-record");
	var loader_save_audio      = document.getElementById("loader_save_audio");
	stopButton.addEventListener("click", stopRecording);

	startRecording();
}

function startRecording() {
	loader_save_audio.style.visibility = 'hidden';
    var constraints = { audio: true, video:false }
	stopButton.disabled = false;
	navigator.mediaDevices.getUserMedia(constraints).then(function(stream) {
		audioContext = new AudioContext();
		gumStream = stream;
		input = audioContext.createMediaStreamSource(stream);
		rec = new Recorder(input,{numChannels:1})
		rec.record()
	}).catch(function(err) {
    	stopButton.disabled = true;
	});
}

function pauseRecording(){
	if (rec.recording){
		rec.stop();
		pauseButton.innerHTML='<i class="fa fa-reply"></i>';
	}else{
		rec.record();
	}
}

function stopRecording() {
	stopButton.disabled = true;
	loader_save_audio.style.visibility = '';
	loader_save_audio.style.marginTop = "100px";
	rec.stop();
	gumStream.getAudioTracks()[0].stop();
	rec.exportWAV(createDownloadLink);
	document.getElementById("div-expression-databank").style.visibility = 'hidden';	
	document.getElementById("message-record").innerHTML = "<span class='message_record'>Recording the audio! Please wait...</span>";
}

function createDownloadLink(blob) {
	var urlUpload    = document.getElementById("urlUpload").value;
	var ul = document.getElementById('ul-audio-origin');
	var table = document.createElement('table');
		table.setAttribute('width', "100%");
		ul.appendChild(table);
	var tr = document.createElement('tr');
		tr.setAttribute('id', "lineExpression");
		table.appendChild(tr);
	
	var url = URL.createObjectURL(blob);
	var au = document.createElement('audio');
	var li = document.createElement('li');

	var btn =  document.createElement('button'); //créer le bouton
  	var t = document.createTextNode("Translate");
  	btn.appendChild(t);
  	btn.setAttribute('name', "btn-traduction"); //lui donner son nom
  	btn.setAttribute('id', "btn-traduction"); //lui donner son nom

	var filename = new Date().toISOString();
	au.controls = true;
	au.src = url;

	var repInput = document.createElement("INPUT");
	repInput.setAttribute("type", "text");
	repInput.setAttribute("class", "textactionexpression reprtoireOrigin");
	repInput.setAttribute("id", "reprtoireOrigin");
	repInput.setAttribute("name", "reprtoireOrigin");
	var y = document.createTextNode("Audio of the original language");

	var td1 = document.createElement('td');
		tr.appendChild(td1);	
  		td1.appendChild(y);

	li.appendChild(au);

	var td2 = document.createElement('td');
		tr.appendChild(td2);	
  		

  	var td3 = document.createElement('td');
		tr.appendChild(td3);	
  		
	

	var xhr=new XMLHttpRequest();
	xhr.onload=function(e) {
	  if(this.readyState === 4) {
	      var retour = e.target.responseText.split('###');
	      var dir = retour[1].split('groupes');
	      var urlbase = urlUpload.split('lms');
	      var urldir = urlbase[0]+"&groupes="+dir[1];
	      repInput.setAttribute("value", urldir);
	      td2.appendChild(repInput);
	      loader_save_audio.style.visibility = 'hidden';
	      if (document.getElementById("usertype").value == "0") {
	      	window.location.href = document.getElementById("base_url").value+"expression";
	      }
	      else{
	      	window.location.href = document.getElementById("base_url").value+"tutorExpression";
	      }
	  }
	  else{
	  	console.log('not found');
	  }
	};
	
	var fd=new FormData();
	fd.append("audio_data",blob, filename);
	xhr.open("POST",urlUpload,true);
	xhr.onerror = function (e) {
	  console.error(xhr.statusText);
	};
	xhr.send(fd);

	li.appendChild(document.createTextNode (" "))//add a space in between
	
	var td4 = document.createElement('td');
		tr.appendChild(td4);	
  		td3.appendChild(li);
  	document.getElementById("ul-audio-origin").style.display = "hidden";
	
  	//alert('cfddf');
  	

	
}