$(document).ready(function(){
   

    var smsList = $('#tableSmsList').DataTable({
    });
    var emailList = $('#tableEmailList').DataTable({
    });

    $('.statDate').datepicker({
        format: "dd/mm/yyyy",
    });
    $('.endDate').datepicker({
        format: "dd/mm/yyyy",
    });
    var normalizeDate = function(dateString) {

        //var correctFormat = dateString;
        var correctFormat = dateString.replace(/(\d+)\/(\d+)\/(\d+)/, "$3/$2/$1");
        var date = new Date(correctFormat);
        var normalized = date.getFullYear() + '' + (("0" + (date.getMonth() + 1)).slice(-2)) + '' + ("0" + date.getDate()).slice(-2);

        return normalized;
    }

    var filterByDate = function(column, startDate, endDate) {

        $.fn.dataTable.ext.search.push(
            function(oSettings, aData, iDataIndex) {
                var rowDate = normalizeDate(aData[column]);
                var start = normalizeDate(startDate);
                var end = normalizeDate(endDate);

                console.log('start : '+start + ' end ' + end + ' rowDate : ' + rowDate);

                // If our date from the row is between the start and end
                if (start <= rowDate && rowDate <= end) {
                    return true;
                } else if (rowDate >= start && end === '' && start !== '') {
                    return true;
                } else if (rowDate <= end && start === '' && end !== '') {
                    return true;
                } else {
                    return false;
                }
            }
        );
    };

    $('#filter').on('click', function(e) {
        e.preventDefault();
        var startDate = $('.statDate').val();
        var endDate = $('.endDate').val();
        var linkExport = $('#exportData').attr('href');
        $('#exportData').attr('href', linkExport + "&date_debut=" + startDate + "&date_fin=" + endDate);
        filterByDate(6, startDate, endDate);

        smsList.draw();
    });
    $('#clearFilter').on('click', function(e) {
        e.preventDefault();
        $.fn.dataTableExt.afnFiltering.length = 0;
        smsList.draw();

    });
    $('.inputPhoneNumbers').select2({
		multiple:true,
		tags: true,
		tokenSeparators: [',']
    });
    $('#btn-send-sms').click(function(e){
    	e.preventDefault();
    	$(".spinner-admin").fadeIn("slow");
    	var errorFormSender = "";

    	if ($('#inputPhoneNumbers').val() == '') {
    		errorFormSender += '<span class="error_form">The phone number field is required</span><br>';
    	}
    	if ($('#inputTextMsg').val() == '') {
    		errorFormSender += '<span class="error_form">The message text field is required</span><br>';
    	}

    	if (errorFormSender != '') {
    		toastr.error(errorFormSender);
    		$(".spinner-admin").fadeOut("slow");
    	}
    	else{
    		var form = $('#form-msg');
            $.ajax({
                url : form.attr('action'),
                type: form.attr('method'),
                data:{inputPhoneNumbers : $('#inputPhoneNumbers').val(), inputTextMsg : $('#inputTextMsg').val()},
                dataType: "json",
                success:function(result){                	
                    $('.btn-close-modal').click();
                    $(".spinner-admin").fadeOut("slow");
                	if (result.envoiSms == 0) {
                		toastr.error(result.response);
                	}
                	else{
                		toastr.success(result.response);
                	}
                	form[0].reset();
                },
    	        error: function(data) {
    	            toastr.error(data.responseText);
    	        }
            });
    	}
    });
    $('.btn-delete-line').click(function(){
        var btn = $(this);
        var allVals = [];  
        $(".spinner-admin").fadeIn("slow");
        $("input[name=sms_checkbox]:checked").each(function(){
            if (this.checked == true){
                allVals.push($(this).attr('data-id'));
                $.ajax({
                    type: "GET",
                    url: $('.baseURL').val()+'delete-sms-history?id='+$(this).val(),                   
                    success: function(data) {  
                        if (data != '') {
                            $(this).parents('.checkbox_sms').parents('.checkbox_sms_line').remove();
                        }                  
                    }
                });
            }           
        });
        if(allVals.length <=0)  
        {  
        alert("Please select row.");  
        }  
        else {
            $.each(allVals, function( index, value ) {
                $('#tableSmsList tr').filter("[data-row-id='" + value + "']").hide();
                smsList.draw();
                $(".spinner-admin").fadeOut("slow");
                toastr.error('Data delete succefully');
            });
        }

    });

    $('.btn-sms-list').click(function(e){
    	e.preventDefault();
    	$('.span-data-title').html('Sms list');
    	$('.divSms').fadeIn('slow');
    	$('.divEmail').fadeOut('slow');

    	$('.btn-email-list').fadeIn('slow');
    	$('.btn-sms-list').fadeOut('slow');
    });

    $('.btn-email-list').click(function(e){
    	e.preventDefault();
    	$('.span-data-title').html('E-mail list');
    	$('.divSms').fadeOut('slow');
    	$('.divEmail').fadeIn('slow');

    	$('.btn-email-list').fadeOut('slow');
    	$('.btn-sms-list').fadeIn('slow');
    });
    $("#inputTextMsgEmail").wysihtml5();
    var nextedu = 0;
    $('.btn-add-cc').on('click', function(e) {
        e.preventDefault();
        var addto = "#field";
        nextedu = nextedu + 1;
        var newIn = '<div class="form-inline" id="field' + nextedu + '" name="field' + nextedu + '"><br><input class="adresse_destinataire form-control" name="mailCc[]" type="email" maxlength="90" size="30" value="" placeholder="Cc">';
        	newIn += '<button id="remove' + (nextedu) + '" class="btn btn-danger remove-me" ><i class="fa fa-trash"></i> Delete</button></div>';
        var newInput = $(newIn);
        var addRemove = "#field" + nextedu;

        var removeBtn = '<button id="remove' + (nextedu) + '" class="btn btn-danger remove-me" ><i class="fa fa-trash"></i> Delete</button>';
        var removeButton = $(removeBtn);
        $(addto).append(newInput);
        //$(addRemove).after(removeButton);
        $("#field" + nextedu).attr('data-source', $(addto).attr('data-source'));
        $("#count").val(nextedu);

        $('.remove-me').click(function(e) {
            e.preventDefault();
            var fieldNum = this.id.charAt(this.id.length - 1);
            var fieldID = "#field" + fieldNum;
            $(this).remove();
            $(fieldID).remove();
        });

    });

    $('#form-email').on('submit',function(e){
    	e.preventDefault();
    	$('.spinner-admin').fadeIn('slow');
    	var form=$("#form-email");
    	/*var dataEmail=form.serializeArray();
        var dataEmailJson = {};
        for (i in dataEmail) {
            dataEmailJson[dataEmail[i].name] = dataEmail[i].value;
        }
        dataEmail=dataEmailJson;  
        console.log(dataEmail);
        var form_data = new FormData(document.getElementById("form-email"));
        console.log(form_data);*/
        $.ajax({
			type :  form.attr('method'),
			url  :  form.attr('action'),
			data :  new FormData(this),
			contentType: false,
			cache: false,
			processData:false,
			success: function(data) {
				//console.log(data);
                var ret = data.split('###');
				$('.btn-close-modal').click();
                $(".spinner-admin").fadeOut("slow");
            	if (ret[1] == "1") {
            		toastr.success('Email send successfully');
            	}
            	else{
            		toastr.error('An error occurred while sending the email. Please check the data entered.');
            	}
            	form[0].reset();
			}
		});
    });
});
function deleteMessage(line){
	$(".spinner-admin").fadeIn("slow");
	$.ajax({
	    type: "GET",
	    url: $('.baseURL').val()+'delete-sms-history?id='+$(line).attr('data-id'),                   
	    success: function(data) {
	        if (data != '') {
	            $(line).parents('.btn-action-data').parents('.checkbox_sms_line').remove();
	        	$(".spinner-admin").fadeOut("slow");  
	        }                
	    }
	});
}
function check_line(line){
    var nb_doc_checked = $( "input[name=sms_checkbox]:checked" ).length;
   
    $(line).parents('.checkbox_sms').parents('.checkbox_sms_line').attr('data-row-id',$(line).attr('data-id'));
    if($(line).is(':checked',true))  
    {
        $(line).prop('checked', true);  
        $('.btn-delete-line').show();
    }  
    else  
    {  
        $(line).prop('checked',false);  
        if (nb_doc_checked >= "1") {
            $('.btn-delete-line').show();
        }
        else{
            $('.btn-delete-line').hide();
        }
    } 
}
function check_all_line(checkbox){
	if($(checkbox).is(':checked',true)){		
		$('.btn-delete-line').show();
		$("input[name=sms_checkbox]").each(function(){
            $(this).prop('checked', true);       
        });
	}
	else{
		$('.btn-delete-line').hide();
		$("input[name=sms_checkbox]").each(function(){
            $(this).prop('checked', false);         
        });
	}
}


