var mediaConstraints = {
  audio: true
};
var mediaRecorder;

$(document).ready(function(){ 
  $('.spinner-border').fadeOut('slow'); 
  $('.audio-list-container').each(function(){
    compareStatisticAudio(this);
  });
  $('.btn-read-transcription-audio-to-speech').click(function(e){
    e.preventDefault();
    var btn = $(this);
    var langage = '';
    var text = '';
    var error = "";
    var identityContainer = btn.attr('data-container');
    $('.language-traduction').each(function(){
      var langageSelector = $(this);
      if (langageSelector.attr('data-container') == identityContainer) {
        langage += langageSelector.find('option:selected').val();
      }
    });

    $('.container-text-origin-audio').each(function(){
      var sentence = $(this);
      if (sentence.attr('data-container') == identityContainer) {
        text += sentence.val();
      }
    });

    if (langage == "") {
      error += label_prefix_required+' '+footer_js_modal_infos_select_voice+' '+label_suffix_required+'<br>';
    }

    if (langage == "") {
      error += label_prefix_required+' '+stat_origin_text+' '+label_suffix_required+'<br>';
    }

    if (error != '') {
      toastr.error(error);
    }
    else{
      responsiveVoice.speak(text,langage);
    }
  });
  $('.audio-item').click(function(e){
    e.preventDefault();
    var linkaudio = $(this);
    $('.audio-item').removeClass('active');
    $('.content-audio').removeClass('active');
    $('.content-audio').each(function(){
      if ($(this).attr('id') == linkaudio.attr('data-id')) {
        $(this).addClass('active');
      }
    });
    linkaudio.addClass('active');
  });

  $('.btn-confirm-delete-audio').click(function(e){
    $('.spinner').fadeIn('slow');
    e.preventDefault();
    var btn = $(this);    
    $.ajax({
      url: $('.baseUrl').val()+'delete-audio',
      type: 'post',
      data: {audioId : $('#audioId').val(), contentOrigin : $('#contentOriginDelete').val()},
      dataType: 'json',
      success: function(result){
        toastr.success(data_delete_ok)
        $('.spinner').fadeOut('slow');
      },
      error: function(error, msg){
        toastr.error(data_save_ok)
        $('.spinner').fadeOut('slow');
      }
   });
  });

  $('#form-delete-audio').on('submit', function(e){
    e.preventDefault();
    $('.spinner').fadeIn('slow');
    $.ajax({
      url: $(this).attr('action'),
      type: $(this).attr('method'),
      data: new FormData(this),
      processData: false,
      contentType: false,
      dataType: 'json',
      success: function(result){
        console.log(result);
        $('.spinner').fadeOut('slow');   
        toastr.success(data_delete_ok);
        $('.active-delete').fadeOut('slow');
        $('#modal_confirm_action_wp').removeClass('open');     
      },
      error: function(error, msg){
        $('.spinner').fadeOut('slow');
      }
   });
  });

  $('#modif-audio').on('submit', function(e){
    e.preventDefault();
    $('.spinner').fadeIn('slow');
    var error = '';
    if ($('#num_audio').val() == '') {
      error = label_prefix_required+' '+booster_audio_numero+' '+label_suffix_required+'<br>';
    }

    if ($('#audioLabelDate').val() == '') {
      error = label_prefix_required+' '+global_search_date+' '+label_suffix_required+'<br>';
    }

    if ($('#inputItem').val() == '') {
      error = label_prefix_required+' '+training_expression_new_expression_title+' '+label_suffix_required;
    }

    if (error != '') {
      toastr.error(error);
      $('.spinner').fadeOut('slow');
    }
    else{
      $.ajax({
        url: $(this).attr('action'),
        type: $(this).attr('method'),
        data: new FormData(this),
        processData: false,
        contentType: false,
        dataType: 'json',
        success: function(result){
          console.log(result);
          $('.media-nav-item-list').each(function(){
            var nav = $(this);
            if (nav.attr('data-id') == result.navItemActive) {
              nav.html('<i class="bx bxs-movie-play"></i>'+result.title);
            }
          });
          $('.spinner').fadeOut('slow');   
          toastr.success(data_save_ok);
          $('#modal-edit-audio').removeClass('open');     
        },
        error: function(error, msg){
          $('.spinner').fadeOut('slow');
        }
     });
    }
  });

  $('#ajax-add-category-expression').on('submit', function(e){
    e.preventDefault();
    $('.spinner').fadeIn('slow');
    var error = '';
    if ($('#cetgoryName').val() == '') {
      error = label_prefix_required+' '+training_expression_new_expression_title+' '+label_suffix_required+'<br>';
    }

    if (error != '') {
      toastr.error(error);
      $('.spinner').fadeOut('slow');
    }
    else{
      $.ajax({
        url: $(this).attr('action'),
        type: $(this).attr('method'),
        data: new FormData(this),
        processData: false,
        contentType: false,
        dataType: 'json',
        success: function(result){
          console.log(result);
          //$('.container-view-theme').prepend('<div class="col-sm-6 col-lg-4 col-xl-3"><h4 class="mb-2">'+result.data.intitule+'</h4><ul class="bs-list-item bs-video-icon"></ul></div>');
          $('.spinner').fadeOut('slow');   
          toastr.success(data_save_ok);
          $('#form-new-theme').removeClass('open');     
        },
        error: function(error, msg){
          $('.spinner').fadeOut('slow');
        }
     });
    }
  });

  /*$('.rework-audio').click(function(){
    var btn = $(this);
    $('#div-rework-audio').fadeOut('slow');
    $('#source-audio-rework').attr('src',btn.attr('data-media'));
    $('.expressionidRework').val(btn.attr('data-expression-id'));
    $('#textboxname').val(btn.attr('data-media-name'));
    $('.video-rework-class').load();
    $('#rework-audio').addClass('open');
    reinitialisebtnControl();
  });*/

  /*$("#btn-record").click(function(){
    captureUserMedia(mediaConstraints, onMediaSuccess, onMediaError);
    disablerec();
    disablesave();
    activestp();
  });

  $('#btn-stop-record').click(function(){
    mediaRecorder.stop();
    mediaRecorder.stream.stop();
    disablestp();
    activerec();
    activeSave();
    // 
    document.querySelector('.video-rework-class').pause();
    //document.getElementById('videomain').currentTime = 0;
  });*/

  $('#btn-save-record').click(function(){
    disablesave();
    $('#div-rework-audio').fadeIn('slow');
  });

  /*$('#form-rework-audio').on('submit', function(e){
    e.preventDefault();
    //console.log('teststs');
    var form = $(this);
    formData.append('fname', $('#textboxname').val());
    formData.append('legende_f', $('#new_legende').val());
    formData.append('id_stagiaire', $('#traineeId').val());
    formData.append('id_groupe', $('#traineeGroupe').val());
    formData.append('infolangue', $('#langChoice').val());
    formData.append('idexp', $('#expressionidRework').val());
    formData.append('repertoireGroupe', $('#repertoireGroupe').val());
    formData.append('urlBaseAudio', $('#urlBaseAudio').val());
    $('.spinner').fadeIn('slow');
    //console.log(formData);
    for (const value of formData.values()) {
      //console.log(value);
    }
    $.ajax({
      url: form.attr('action'),
      type: form.attr('method'),
      data: formData,
      processData: false,
      contentType: false,
      dataType: 'json',
      success: function(result){
        console.log(result);
        $('.spinner').fadeOut('slow');
        form.fadeOut('slow');
        disablestp();
        activerec();
        disablesave();
        location.reload(true);
      },
      error: function(error, msg){
        $('.spinner').fadeOut('slow');
        console.log(error);
        console.log(msg);
      }
   });
  });*/
  $(".comment-audio").on("keyup", function(e){
    var comment = $(this);
    var value = comment.val();
    var idExpression = comment.attr('data-id-expression');
    if (value.length > 3) {
      $.ajax({
        url: $('.baseURL').val()+'register-comment-audio',
        type: 'post',
        data: {value : value, idExpression : idExpression},
        dataType: 'json',
        success: function(result){
        },
        error: function(error, msg){
        }
     });
    }
    // Your logic of translate
  });
});

/*function onMediaSuccess(stream) {
  var audio = document.createElement('audio');
  document.querySelector('.video-rework-class').play();
  document.querySelector('.video-rework-class').muted = true; 
  audio = mergeProps(audio, {controls: true, muted: true});
  audio.srcObject = stream;
  audio.play();
  $( "#audios-container" ).empty();
  mediaRecorder = new MediaStreamRecorder(stream);
  mediaRecorder.stream = stream;
  //var recorderType = document.getElementById('audio-recorderType').value;
  mediaRecorder.mimeType = 'audio/wav';
  mediaRecorder.audioChannels = 1;
  mediaRecorder.ondataavailable = function(blob) {
    var urlblob =  URL.createObjectURL(blob);
    $('#btn-stop-record').click();
    formData = new FormData(document.getElementById('form-rework-audio'));
    formData.append('fileUpload', blob);
  };
  var timeInterval = document.getElementById('time-interval').value;
  if (timeInterval) timeInterval = parseInt(timeInterval);
  else timeInterval = 5000 * 1000;
  // get blob after specific time interval
  mediaRecorder.start(timeInterval);
  activestp();
  activeSave();
}
function onMediaError(e) {
  console.error('media error', e);
}

function reinitialisebtnControl(){
  $('#btn-record').prop('disabled', false);
  $('#btn-stop-record').prop('disabled', true);
  $('#btn-save-record').prop('disabled', true);
  $('#btn-merge-record').prop('disabled', true);

  $('#btn-record').removeClass('el-btn-dark');
  $('#btn-record').addClass('el-btn-pink');

  $('#btn-stop-record').removeClass('el-btn-pink');
  $('#btn-stop-record').addClass('el-btn-dark');

  $('#btn-save-record').removeClass('el-btn-pink');
  $('#btn-save-record').addClass('el-btn-dark');

  $('#btn-merge-record').removeClass('el-btn-pink');
  $('#btn-merge-record').addClass('el-btn-dark');
}
function captureUserMedia(mediaConstraints, successCallback, errorCallback) {
  navigator.mediaDevices.getUserMedia(mediaConstraints).then(successCallback).catch(errorCallback);
}
// button animation
function disablesave(){
  $('#btn-save-record').prop('disabled', true);
  $('#btn-save-record').removeClass('el-btn-pink');
  $('#btn-save-record').addClass('el-btn-dark');
}
function activeSave(){
  $('#btn-save-record').prop('disabled', false);
  $('#btn-save-record').removeClass('el-btn-dark');
  $('#btn-save-record').addClass('el-btn-pink');
}

function active_merge(){
  $('#btn-merge-record').prop('disabled', false);
  $('#btn-merge-record').removeClass('el-btn-dark');
  $('#btn-merge-record').addClass('el-btn-pink');
}
function disable_merge(){
  $('#btn-merge-record').prop('disabled', true);  
  $('#btn-merge-record').removeClass('el-btn-pink');
  $('#btn-merge-record').addClass('el-btn-dark');
}
function activestp(){
  $('#btn-stop-record').prop('disabled', false);
  $('#btn-stop-record').removeClass('el-btn-dark');
  $('#btn-stop-record').addClass('el-btn-pink');
}
function disablestp(){
  $('#btn-stop-record').prop('disabled', true);
  $('#btn-stop-record').removeClass('el-btn-pink');
  $('#btn-stop-record').addClass('el-btn-dark');
}

function activerec(){
  $('#btn-record').prop('disabled', false);
  $('#btn-record').addClass('el-btn-pink');
  $('#btn-record').removeClass('el-btn-dark');
} 

function disablerec(){
  $('#btn-record').prop('disabled', true);
  $('#btn-record').removeClass('el-btn-pink');
  $('#btn-record').addClass('el-btn-dark');
}*/

function deleteAudio(link){
  var btn = $(link);
  $('.link-list-media-item').removeClass('active-delete');
  $('#form-delete-audio #audioId').val(btn.attr('data-audio-id'));
  $('#form-delete-audio #contentOriginDelete').val(btn.attr('data-content-origin'));
  $('#modal_confirm_action_wp').addClass('open');
  btn.parents('.bs-action').parents('li').addClass('active-delete');
}

function editLabelAudio(link){
  var btn = $(link);
  $('#modif-audio #navItemActive').val(btn.attr('data-nav-item-active'));
  $('#modif-audio #audioIdModif').val(btn.attr('data-audio-id'));
  $('#modif-audio #contentOrigin').val(btn.attr('data-content-origin'));
  $('#modif-audio #inputItemOrigin').val(btn.attr('data-title'));
  $('#modif-audio #audioLabelDate').val(btn.attr('data-date-audio'));
  $('#modal-edit-audio').addClass('open');
}

function copyTextContentOther(link){
  var btn = $(link);
  var contents = '';
  $('.content-cible').each(function(){
    var container = $(this);
    if (container.is(':visible')) {
      contents += container.val();
    }
  });
  var temp = $("<input>");
  $("body").append(temp);
  temp.val(contents).select();
  document.execCommand("copy");
  temp.remove();
}

function saveContentOtherAudio(link){
  $('.spinner').fadeIn('slow');
  var btn = $(link);
  var contents = '';
  var cible = '';
  var label = '';
  var request = '';
  var expressionId = btn.attr('data-btn-id');
  $('.content-cible').each(function(){
    var container = $(this);
    if (container.is(':visible')) {
      contents += container.val();
      cible    += container.attr('data-cible');
      label    += container.attr('data-label');
      request  += container.attr('data-request');
    }
  });

  if (contents != '') {
    $.ajax({
      url: $('.baseURL').val()+'update-content-other-audio',
      type: 'post',
      data: {expressionId : expressionId, cible : cible, contents : contents, request : request},
      dataType: 'json',
      success: function(result){
        $('option', '.stat-other-data-expression').each(function(){
          var option = $(this);
          var select = option.parents('select');
          if (option.attr('data-cible') == cible) {
            option.attr('value',contents); 
            if (option.attr('selected') !== undefined) {
              loadStatOtherData(select);
            }
          }
        });
        $('option', '.analyse-lexical-select-modal').each(function(){
          var option1 = $(this);
          var select = option1.parents('select');
          if (option1.attr('data-cible') == cible) {
            option1.attr('value',contents); 
          }
        });
        toastr.success(data_save_ok)
        $('.spinner').fadeOut('slow');
      },
      error: function(error, msg){
        toastr.error(data_saved_ko)
        $('.spinner').fadeOut('slow');
      }
   });
  }
  else{
    toastr.error(label_prefix_required+' '+label+' '+label_suffix_required)
    $('.spinner').fadeOut('slow');
  }
}


function loadStatOtherData(link){
  var btn = $(link);
  $('.spinner-border').fadeIn('slow');
  var expressionId = $('option:selected', link).attr('data-audio-id');
  var contentOrigin = btn.val();
  //analyse lexical modal
  $('.stat-modal-expression').attr('data-expression-id',expressionId);
  $('.stat-modal-expression').attr('data-expression-origin',contentOrigin);
  
  if (contentOrigin != "") {
    setVideoStats('analyse-lexicale',contentOrigin,'',expressionId);    
  }
  else{
    $('.stat_duration').html('0');
    $('.stat_words').html('0');
    $('.stat_happaxes').html('0');
    $('.stat_debit').html('0');
    $('.stat_verbs').html('0');
    $('.stat_adjectif').html('0');
    $('.stat_active_voice').html('0');
    $('.stat_passive_voice').html('0');
  }
           

  var result = loadStat(expressionId, contentOrigin);
  if (result == true) {
    $('.spinner-border').fadeOut('slow');
  }
  else{
    $('.spinner-border').fadeOut('slow');
  }
}

function registerMediaContentOrigin(link){
  var btn = $(link);
  $('.spinner').fadeIn('slow');
  //reinitialiseContentStat();
  $('.content-origin').each(function(){
    var textarea = $(this);
    if (textarea.is(':visible')) {
      var contents = textarea.val();
      var request = textarea.attr('data-request');
      var langage = textarea.attr('data-langage');
      var idExpression = textarea.attr('data-content-id');
      $.ajax({
        url: $('.baseURL').val()+'edit-content-expression-origin',
        type: 'POST',
        data: {idExpression : idExpression, contentOrigin : contents, request : request, langage : langage},
        dataType: 'json',
        success: function(result){          
          $('option', '.stat-other-data-expression').each(function(){
            var option = $(this);
            var select = option.parents('select');
            if (option.attr('data-cible') == 'origin') {
              option.attr('value',result.origin);
              if (option.attr('selected') !== undefined) {
                loadStatOtherData(select);
              }
            }
          });
          $('option', '.analyse-lexical-select-modal').each(function(){
            var option1 = $(this);
            if (option1.attr('data-cible') == 'origin') {
              option1.attr('value',result.origin);
            }
          });
          toastr.success(data_save_ok);
          $('.spinner').fadeOut('slow');
        },
        error: function(error, msg){
          $('.spinner').fadeOut('slow');
          toastr.error(msg);
        }
     });
    }
  });
}

function loadAudioRewordContent(link){
  var btn = $(link);
  $('.spinner-border').fadeIn('slow');
  if ($(':selected', btn).attr("data-request") == 'rework') {
    $('.rework-audio').fadeOut('slow');
  }
  else{
    $('.rework-audio').fadeIn('slow');
  }

  var expressionId = $(':selected', btn).attr("data-id-expression");
  var expressionContentOrigin = $(':selected', btn).attr("data-content-lang-origin");
  var epxressionReviseText = $(':selected', btn).attr("data-revise-text");
  var expressionIaReformulation = $(':selected', btn).attr("data-ia-reformulation");

  $('.revise_text').val(epxressionReviseText);
  $('.ia_reformulation').val(expressionIaReformulation);
  $('.content-cible').attr('data-request',$(':selected', btn).attr("data-request"));
  $('.content-cible').attr('data-content-id',expressionId);
  $('.btn-save-data-content').attr('data-btn-id',expressionId);
  $('.btn-copy-content-cible').attr('data-btn-id',expressionId);

  //form content origin
  $('#content-origin').val(expressionContentOrigin);
  $('#content-origin').attr('data-content-id',expressionId);
  $('#content-origin').attr('data-request','rework');

  $('.btn-copy-content-origin').attr('data-btn-id',expressionId);
  $('.btn-edit-content-origin').attr('data-btn-id',expressionId);


  $('.audio-link-read').parent('.main-audio').stop();
  $('.audio-link-read').attr('src',btn.val());
  $('.audio-link-read').attr('data-course',btn.val());
  $('.audio-link-read').parent('.main-audio').load();

  $('.stat_duration').html('');
  $('.stat_words').html('');
  $('.stat_happaxes').html('');
  $('.stat_debit').html('');
  $('.stat_verbs').html('');
  $('.stat_adjectif').html('');
  $('.stat_active_voice').html('');
  $('.stat_passive_voice').html('');

  //load stat from change
  $('.audio-statistics').attr('data-expression-id',expressionId);
  $('.audio-statistics').attr('data-expression-origin',expressionContentOrigin);
  

  $('.stat_duration').attr('data-id-expression',expressionId);
  $('.stat_words').attr('data-id-expression',expressionId);
  $('.stat_happaxes').attr('data-id-expression',expressionId);
  $('.stat_debit').attr('data-id-expression',expressionId);
  $('.stat_verbs').attr('data-id-expression',expressionId);
  $('.stat_adjectif').attr('data-id-expression',expressionId);
  $('.stat_active_voice').attr('data-id-expression',expressionId);
  $('.stat_passive_voice').attr('data-id-expression',expressionId);

  //console.log(expressionId);
  //console.log(expressionContentOrigin);
  //console.log(epxressionReviseText);
  //console.log(expressionIaReformulation);

  var request = loadStat(expressionId, expressionContentOrigin);
  if (request == true) {
    $('.spinner-border').fadeOut('slow');
  }

  var options = '<option data-audio-id="'+expressionId+'" value="'+expressionContentOrigin+'">'+transcription_origin_text+'</option>';
      options += '<option data-audio-id="'+expressionId+'" value="'+epxressionReviseText+'">'+transcription_text_rework+'</option>';
      options += '<option data-audio-id="'+expressionId+'" value="'+expressionIaReformulation+'">'+transcription_reformule_ia+'</option>';


  //analyse lexical modal
  $('.stat-modal-expression').attr('data-expression-id',expressionId);
  $('.stat-modal-expression').attr('data-expression-origin',expressionContentOrigin);
  setVideoStats('analyse-lexicale',expressionContentOrigin,'',expressionId);   
  $('.analyse-lexical-select-modal').html(options);

  //change option select  
  $('.stat-other-data-expression').html(options);
}

function compareAnalyseLexical(link){
  var btn = $(link);
  //$('.spinner-border').fadeIn('slow');
  var expressionId = $('option:selected', link).attr('data-audio-id');
  var contentOrigin = btn.val();
  setVideoStats('analyse-lexicale',contentOrigin,'',expressionId); 
}

function compareStatisticAudio(link){
  var btn = $(link);
  var identityContainer          = $('option:selected', link).attr('data-container');
  var expressionId               = $('option:selected', link).attr('data-id-content-origin');
  var contentOriginText          = $('option:selected', link).attr('data-content-origin');
  var contentReviseText          = btn.attr('data-content-revise');
  var contentIaReformulationText = btn.attr('data-content-ia-reformulation');

  //reinitialise select option from audio
  $('.option-audio-list-container'+identityContainer+'').prop('selectedIndex',0);

  initialiseContentInContainerComparaison(identityContainer);
  initialiseSpinerContainerComparaison(identityContainer);
  //content or transcription original text
  $('.container-text-origin-audio').each(function(){
    var textarea = $(this);
    if (textarea.attr('data-container') == identityContainer) {
      textarea.val(contentOriginText);
    }
  });

  //load stat from audio selected
  if (contentOriginText == '') {
    initialiseContainerComparaison(identityContainer);
    finaliseSpinerContainerComparaison(identityContainer);
  }
  else{
    compareStatAudio(contentOriginText,identityContainer);
    finaliseSpinerContainerComparaison(identityContainer);
  }
}

function compareStatisticAudioFromOtherData(link){
  var btn = $(link);
  var identityContainer       = $('option:selected', link).attr('data-container');
  var containerOrigin         = btn.val();
  var contentOriginText       = '';

  $('.audio-list-container').each(function(){
    var selector = $(this);
    if (selector.attr('data-container') == identityContainer) {
      contentOriginText += selector.find('option:selected').attr('data-content-'+containerOrigin+'');
    }
  });

  initialiseContentInContainerComparaison(identityContainer);
  initialiseSpinerContainerComparaison(identityContainer);
  if (contentOriginText == '') {
    initialiseContainerComparaison(identityContainer);
    finaliseSpinerContainerComparaison(identityContainer);
  }
  else{
    compareStatAudio(contentOriginText,identityContainer);
    finaliseSpinerContainerComparaison(identityContainer);
  }
}

function initialiseSpinerContainerComparaison(identityContainer){
  $('.cell-last-debit'+identityContainer+'').find('.spinner-border').fadeIn('slow');
  $('.cell-last-nbword'+identityContainer+'').find('.spinner-border').fadeIn('slow');
  $('.cell-last-hapax'+identityContainer+'').find('.spinner-border').fadeIn('slow');
  $('.cell-last-pass'+identityContainer+'').find('.spinner-border').fadeIn('slow');
  $('.cell-last-adj'+identityContainer+'').find('.spinner-border').fadeIn('slow');
  $('.cell-last-verb'+identityContainer+'').find('.spinner-border').fadeIn('slow');
  $('.cell-last-pres1'+identityContainer+'').find('.spinner-border').fadeIn('slow');
  $('.cell-last-past'+identityContainer+'').find('.spinner-border').fadeIn('slow');
  $('.cell-last-act'+identityContainer+'').find('.spinner-border').fadeIn('slow');
  $('.cell-last-pass'+identityContainer+'').find('.spinner-border').fadeIn('slow');
}

function finaliseSpinerContainerComparaison(identityContainer){
  $('.cell-last-debit'+identityContainer+'').find('.spinner-border').fadeOut('slow');
  $('.cell-last-nbword'+identityContainer+'').find('.spinner-border').fadeOut('slow');
  $('.cell-last-hapax'+identityContainer+'').find('.spinner-border').fadeOut('slow');
  $('.cell-last-pass'+identityContainer+'').find('.spinner-border').fadeOut('slow');
  $('.cell-last-adj'+identityContainer+'').find('.spinner-border').fadeOut('slow');
  $('.cell-last-verb'+identityContainer+'').find('.spinner-border').fadeOut('slow');
  $('.cell-last-pres1'+identityContainer+'').find('.spinner-border').fadeOut('slow');
  $('.cell-last-past'+identityContainer+'').find('.spinner-border').fadeOut('slow');
  $('.cell-last-act'+identityContainer+'').find('.spinner-border').fadeOut('slow');
  $('.cell-last-pass'+identityContainer+'').find('.spinner-border').fadeOut('slow');
}

function initialiseContainerComparaison(identityContainer){
  $('.cell-last-debit'+identityContainer+'').find('.contentainer-result-stat').text('0 w/min');
  $('.cell-last-nbword'+identityContainer+'').find('.contentainer-result-stat').text('0');
  $('.cell-last-hapax'+identityContainer+'').find('.contentainer-result-stat').text('0');
  $('.cell-last-pass'+identityContainer+'').find('.contentainer-result-stat').text('0');
  $('.cell-last-adj'+identityContainer+'').find('.contentainer-result-stat').text('0');
  $('.cell-last-verb'+identityContainer+'').find('.contentainer-result-stat').text('0');
  $('.cell-last-pres1'+identityContainer+'').find('.contentainer-result-stat').text('0');
  $('.cell-last-past'+identityContainer+'').find('.contentainer-result-stat').text('0');
  $('.cell-last-act'+identityContainer+'').find('.contentainer-result-stat').text('0');
  $('.cell-last-pass'+identityContainer+'').find('.contentainer-result-stat').text('0');
}

function initialiseContentInContainerComparaison(identityContainer){
  $('.cell-last-debit'+identityContainer+'').find('.contentainer-result-stat').text('');
  $('.cell-last-nbword'+identityContainer+'').find('.contentainer-result-stat').text('');
  $('.cell-last-hapax'+identityContainer+'').find('.contentainer-result-stat').text('');
  $('.cell-last-pass'+identityContainer+'').find('.contentainer-result-stat').text('');
  $('.cell-last-adj'+identityContainer+'').find('.contentainer-result-stat').text('');
  $('.cell-last-verb'+identityContainer+'').find('.contentainer-result-stat').text('');
  $('.cell-last-pres1'+identityContainer+'').find('.contentainer-result-stat').text('');
  $('.cell-last-past'+identityContainer+'').find('.contentainer-result-stat').text('');
  $('.cell-last-act'+identityContainer+'').find('.contentainer-result-stat').text('');
  $('.cell-last-pass'+identityContainer+'').find('.contentainer-result-stat').text('');
}
