var scales = {};
var rotations = {};
var positions = {};
$(document).ready(function(){
  if ($('#main-slider').length >= '1') {
    var main       = new Splide( '#main-slider', {
        type      : 'slide',
        drag      : false,
        rewind    : true,
        pagination: false,
        arrows    : false,
    } );
    var thumbnails = new Splide( '#thumbnail-slider', {
        fixedWidth  : 100,
        fixedHeight : 60,
        gap         : 5,
        rewind      : true,
        pagination  : false,
        cover       : true,
        isNavigation: true,
        breakpoints : {
          600: {
            fixedWidth : 60,
            fixedHeight: 44,
          },
        },
    } );


    main.sync( thumbnails );
    main.mount();
    thumbnails.mount();
  }

  var images = document.querySelectorAll('.img-zoom');
  images.forEach(function(image) {
      var imageId = image.id;

      // Initialiser les valeurs par défaut de zoom, rotation et position pour chaque image
      scales[imageId] = 1;
      rotations[imageId] = 0;
      positions[imageId] = { x: 0, y: 0 };

      wheelzoom(image,
          { 
              zoomOnWheel: false
           }
      );  // Active Wheelzoom sur chaque image
      enableDrag(image); // Activer le déplacement avec la souris
  });

  $('.bs-save-modif-content-picture').click(function(e){
    e.preventDefault();
    var btn = $(this);
    var concent = '';
    $('#'+btn.attr('data-cible')+'').each(function(){
      var textarea = $(this);
      if (textarea.is(':visible')) {
        concent += textarea.val();
      }
    });
     $.ajax({  
      url: $('.baseURL').val()+'picture-update-content',  
      type: "POST",
      dataType: "json",
      data: {cible: btn.attr('data-cible'), content: btn.parents('.bs-action').parents('.img-transcription-header').parents('.img-transcription').find('.img-transcription-txt #'+btn.attr('data-cible')+'').val(), expression_id: btn.attr('data-expression')}, 
      dataType: 'json',
      success: function(data) {  
        toastr.success(data_save_ok);
      }
    });
  });

  $('.bs-speach-content-picture').click(function (e) {
    e.preventDefault();
    var btn = $(this);
    //var API_KEY_GOOGLE = $('#API_KEY_GOOGLE').val();
    var SENTENCE = btn.parents('.bs-action').parents('.img-transcription-header').parents('.img-transcription').find('.img-transcription-txt #'+btn.attr('data-cible')+'').val();
    getVoiceLanguage(SENTENCE);
    //var langue = detecterLangue(SENTENCE, API_KEY_GOOGLE);
    //console.log(langue);
    //var obj = $.parseJSON(JSON.stringify(detect));
    //console.log(JSON.stringify(detect));
    //console.log(obj);
    
    //console.log(detect.responseJSON);
    //console.log(detect.statusText);
    //textToSpeachGoogleApi(SENTENCE);
  });

  $('.btn-read-text-to-speech-content-picture').click(function(e){
    e.preventDefault();
    responsiveVoice.speak($('.content-sentence').html().replace('"', "'"),$('#language-voice').val());
    //$(this).attr("disabled","");
    //$(".btn-pause-text-to-speech-article").removeAttr("disabled");
  });

});

function getVoiceLanguage(SENTENCE){
  $.ajax({
    url: 'get-voice-language',
    type: 'POST',
    data: {SENTENCE : SENTENCE},
    dataType: 'json',
    success: function (response) {
      //console.log(response);
      if (response.status == true) {
        $('#language-voice').html(response.message);
        $('.content-sentence').html(SENTENCE);
        $('#text-to-speach-responsive-voice').addClass('open');
      }
      else{
        toastr.error(response.message);
      }
    },
    error: function (err) {
      toastr.error(err);
    }
  });
}

function detecterLangue(SENTENCE,API_KEY_GOOGLE) {
  var langue = "";
  const url = `https://translation.googleapis.com/language/translate/v2/detect?key=${API_KEY_GOOGLE}`;
  $.ajax({
    url: url,
    type: 'POST',
    data: JSON.stringify({ q: SENTENCE }),
    contentType: 'application/json',
    success: function (response) {
      langue += response.data.detections[0][0].language;
      //console.log("Langue détectée :", langue);
      //textToSpeachGoogleApi(SENTENCE);
    },
    error: function (err) {
      //console.error("Erreur :", err);
      //return error;
    }
  });
  console.log(langue);
  return langue;
}

function textToSpeachGoogleApi(text){
  //const text = $('#text').val();
  //const languageCode = $('#language').val();
  //const voiceName = $('#voice').val();

  const languageCode = 'fr-FR';
  const voiceName = 'fr-FR-Wavenet-B';

  $.ajax({
    url:      'load-google-api-text-to-speach',
    type:     'POST',
    data:     {text: text, languageCode: languageCode, voiceName: voiceName},
    dataType: 'json',
    success: function (blob) {
      console.log(blob);
      //const url = URL.createObjectURL(blob);
      //$('#audio').attr('src', url);
    },
    error: function () {
      console.log('Error generating speech!');
    }
  });
}

function editLabelImage(btn){
  $('#imageIdModif').val($(btn).attr('data-id'));
  $('#inputTitleImage').val($(btn).attr('data-title'));
  $('#modal-edit-image').addClass('open');
}

function deleteImage(btn){
  $('#imageIdDelete').val($(btn).attr('data-id'));
  $('#modal-confirm-delete-image').addClass('open');
}