
function tab(nav, content){

    
    let tab_nav_item = document.querySelectorAll(nav);
    let tabcontent = document.querySelectorAll(content);
    
    document.addEventListener('click', e =>{
        const id = e.target.dataset.id;
        if(id && e.target.classList.contains(nav.split('.')[1])){
            tab_nav_item.forEach(btn => {
            btn.classList.remove('active');
            })
            e.target.classList.add('active')

            tabcontent.forEach(content => {
            content.classList.remove('active');
            })

            let element = document.getElementById(id);
            element.classList.add('active');
        }
    }, false);

}

tab('.tab-slide-first-navigation','.tab-content-first');
tab('.tab-slide-second-navigation','.tab-content-second');

/*slick*/
$('.tab-slide-first-view').slick({
  dots: false,
  infinite: false,
  speed: 300,
  slidesToShow: 5,
  slidesToScroll: 5,
  responsive: [
    {
      breakpoint: 1200,
      settings: {
        slidesToShow: 4,
        slidesToScroll: 4,
        dots: false
      }
    },
    {
      breakpoint: 1024,
      settings: {
        slidesToShow: 3,
        slidesToScroll: 3,
        dots: true
      }
    },
    {
      breakpoint: 767,
      settings: {
        slidesToShow: 2,
        slidesToScroll: 2
      }
    }
    
  ]
});

$('.tab-slide-second-view').slick({
  dots: false,
  infinite: false,
  speed: 300,
  slidesToShow: 5,
  slidesToScroll: 5,
  responsive: [
    {
      breakpoint: 1200,
      settings: {
        slidesToShow: 4,
        slidesToScroll: 4,
        dots: false
      }
    },
    {
      breakpoint: 1024,
      settings: {
        slidesToShow: 3,
        slidesToScroll: 3,
        dots: true
      }
    },
    {
      breakpoint: 767,
      settings: {
        slidesToShow: 2,
        slidesToScroll: 2
      }
    }
    
  ]
});


$('.post-nav-content').slick({
    dots: true,
    infinite: false,
    speed: 300,
    slidesToShow: 4,
    slidesToScroll: 4,
    responsive: [
      {
        breakpoint: 1200,
        settings: {
          slidesToShow: 3,
          slidesToScroll: 3,
          dots: true
        }
      },
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 2,
          dots: true
        }
      },
      {
        breakpoint: 767,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1
        }
      }
      
    ]
  });
/*slick*/



const tabs = document.querySelector('#content-1');
const tabButtons = tabs != null ? tabs.querySelectorAll('[role="tabNav"]') : null;
const tabPanels = tabs != null ? tabs.querySelectorAll('[role="tabPanel"]') : null;
if(tabs != null){
  tabButtons.forEach(button => button.addEventListener('click', tabClick));
}

function tabClick(event) {
    
    tabPanels.forEach(panel => {
        panel.setAttribute('aria-current', false)
    });
    
    tabButtons.forEach(tab => {
    
        tab.setAttribute('aria-selected', false);

    });

    event.currentTarget.setAttribute('aria-selected', true);

    const  id  = event.currentTarget.getAttribute('data-id');

    const tabPanel = document.getElementById(id);
    
    tabPanel.setAttribute('aria-current', true);

}
