$(document).ready(function(){
	$('.sequence_prog').each(function(){
		if ($(this).is(':checked')) {
			$('.btn-check-sequence').prop('disabled', true);
			$('.btn-remove-sequence-program').prop('disabled', false);
        }
        else{
        	$('.btn-uncheck-sequence').prop('disabled', true);
        	$('.btn-remove-sequence-program').prop('disabled', true);
        }
	});

	$('.btn-check-sequence').click(function(e){
		e.preventDefault();
		$('.switch-data-le').each(function(){
			$(this).click();
		});
		$(this).prop('disabled', true);
		$('.btn-uncheck-sequence').prop('disabled', false);
		$('.btn-remove-sequence-program').prop('disabled', false);
	});

	$('.btn-uncheck-sequence').click(function(e){
		e.preventDefault();
		$('.switch-data-le').each(function(){
			$(this).click();
		});
		$(this).prop('disabled', true);
		$('.btn-check-sequence').prop('disabled', false);
		$('.btn-remove-sequence-program').prop('disabled', true);
	});
	$('.sequence_prog').change(function() {
	   	if($(this).is(":checked")) {
	   		$('.btn-remove-sequence-program').prop('disabled', false);
	   		$('.btn-uncheck-sequence').prop('disabled', false);
	   	}
	   	else{
	   		$('.btn-remove-sequence-program').prop('disabled', true);
	   	}
	});

	$('.btn-remove-sequence-program').click(function(e){
		e.preventDefault();
		if(confirm('Are you sure you want to delete this selection ?')){
			$(".spinner").fadeIn("slow");
			var dataSequence = [];
			$('.sequence_prog').each(function(){
				var checkbox = $(this);
				if (checkbox.is(':checked')) {
					dataSequence=$(this).serializeArray();
			        var dataSequencejson = {};
			        for (i in dataSequence) {
			            dataSequencejson[dataSequence[i].name] = dataSequence[i].value;
			        }
			        dataSequence=dataSequencejson;  
			        checkbox.parents('.material').remove();
		        }
				$.ajax({
				    url : $('.session-form').attr('action'),
				    type : $('.session-form').attr('method'),  
				    data:  {"dataSequencejson":dataSequence},   
				    success : function(data){
				    }
				});
				$(".spinner").fadeOut("slow");
			});
		}

	});

	$('.btn-remove-module').click(function(e){
		var btn = $(this);
		e.preventDefault();
		if(confirm('Are you sure you want to delete this module ?')){
			$(".spinner").fadeIn("slow");
			var module_id     = btn.attr('data-id');
			var parcours_id   = btn.attr('data-parcours-id');
			var groupe_id     = btn.attr('data-groupes-id');
			$.ajax({
			    url : $('.baseURL').val()+'del-module-items-session',
			    type : 'POST',  
			    data:  {"module_id":module_id,"parcours_id":parcours_id,"groupe_id":groupe_id},   
			    success : function(data){ 
			    	btn.parents('.domaineName').parents('li').hide();
			        $(".spinner").fadeOut("slow");		        
			    }
			});
		}
	});

	$('.btn-delete-sequence').click(function(e){
		var btn = $(this);
		e.preventDefault();
		if(confirm('Are you sure you want to delete this sequence ?')){
			$(".spinner").fadeIn("slow");
			var dataSequence   = btn.parents('.materialName').parents('.material').find('.sequence_prog').val();
			$.ajax({
			    url : $('.session-form').attr('action')+'?mod=unique',
			    type : $('.session-form').attr('method'),  
			    data:  {"dataSequencejson":dataSequence},   
			    success : function(data){ 
			    	btn.parents('.materialName').parents('.material').remove();
			        $(".spinner").fadeOut("slow");		        
			    }
			});
		}
	});

	$('.btn-action-add-parcours').click(function(e){
		e.preventDefault();
		$(".spinner").fadeIn("slow");
		$('.modal-detail-program').text('Add a course');
		$.ajax({
		    url : $('.baseURL').val()+'list-parcours',
		    type : 'GET',    
		    success : function(data){ 
		    	$('#program_stagiaire').html(data);
		    	$('#program_stagiaire').treed();
		    	$('#program_stagiaire').each(function(){
			        $(this).find('.indicator').click();
			    });
		    	$('.modal_edit_program').addClass('open');
				$(".spinner").fadeOut("slow");	        
		    }
		});			
	});
	$('.btn-action-add-sequence').click(function(e){
		e.preventDefault();
		$(".spinner").fadeIn("slow");	
		var datalist = '';
		datalist += '<input  onchange="refreshDataSequence(this);" list="sequence_items" id="sequence_select" class="form-control" name="sequence_select"/>';
		datalist += '<datalist id="sequence_items">';
		$.ajax({
		    url : $('.baseURL').val()+'list-sequence-items',
		    type : 'POST', 
		    data : {'idDomaine' : $(this).attr('data-domaine')}, 
		    success : function(data){ 
		    	var ret = data.split('##'); 
				datalist += ret[0];
				datalist += '</datalist>';
				$('.modal-detail-program').html('<div class="form-inline"><div class="form-group mb-2"><sapn>Add a sequence&nbsp;&nbsp;</sapn></div><div class="form-group mx-sm-3 mb-2">'+datalist+'</div></div>');
		    	$('#program_stagiaire').html(ret[1]);
		    	$('#program_stagiaire').treedSequence();
		    	var test = $('.modal_edit_program').addClass('open');
		    	if(test.length == "1" && $('.modal_edit_program').is(':visible')){
		    		console.log('length : ' + test.length);
					$(".spinner").fadeOut("slow");	   
		    	}
		    }
		});
	});

	$('.btn-delete-parcours').click(function(e){
		var btn = $(this)
		e.preventDefault();
		if(confirm('Are you sure you want to delete this ?')){
			$(".spinner").fadeIn("slow");
			var idParcours  = btn.attr('data-id');
			var idDomaine   = btn.attr('data-domaine');
			var idGroupes   = btn.attr('data-groupe');
			var idMatiere   = btn.attr('data-matiere');
			$.ajax({
			    url : $('.baseURL').val()+'delete-parcours',
			    type : 'POST',  
			    data:  {"idParcours":idParcours,"idDomaine":idDomaine,"idGroupes":idGroupes,"idMatiere":idMatiere},   
			    success : function(data){ 
			    	btn.parents('.branch').remove();
			    	location.reload();
			        $(".spinner").fadeOut("slow");	

			    }
			});
		}
	});

	$('.btn-close-modal-session').click(function(){
		location.reload();
	});

	$('.btn-action-add-module').click(function(e){
		e.preventDefault();
		$(".spinner").fadeIn("slow");
		$('.modal-detail-program').text('Add a module');
		$.ajax({
		    url : $('.baseURL').val()+'list-modules',
		    type : 'POST',
		    data : {'idDomaine' : $(this).attr('data-domaine')},    
		    success : function(data){ 
		    	$('#program_stagiaire').html(data);
		    	$('#program_stagiaire').treed();
		    	$('#program_stagiaire').each(function(){
			        $(this).find('.indicator').click();
			    });
		    	$('.modal_edit_program').addClass('open');
				$(".spinner").fadeOut("slow");	        
		    }
		});		
	});

	$('.btn-add-sequence-in-module').click(function(e){
		e.preventDefault();
		var btn = $(this);
		var datalist = '';
		datalist += '<input  onchange="refreshDataSequence(this);" list="sequence_items" id="sequence_select" class="form-control" name="sequence_select"/>';
		datalist += '<datalist id="sequence_items">';
		$(".spinner").fadeIn("slow");		
		$.ajax({
		    url : $('.baseURL').val()+'list-sequence-items',
		    type : 'POST', 
		    data : {'idDomaine' : 0,'idModule' : btn.attr('data-id'),'idParcours' : btn.attr('data-parcours-id'),'idGroupes' : btn.attr('data-groupes-id')}, 
		    success : function(data){ 
		    	var ret = data.split('##'); 
				datalist += ret[0];
				datalist += '</datalist>';
				$('.modal-detail-program').html('<div class="form-inline"><div class="form-group mb-2"><sapn>Add a sequence&nbsp;&nbsp;</sapn></div><div class="form-group mx-sm-3 mb-2">'+datalist+'</div></div>');
		    	$('#program_stagiaire').html(ret[1]);
		    	$('#program_stagiaire').treedSequence();
		    	$('.modal_edit_program').addClass('open');
				$(".spinner").fadeOut("slow");	        
		    }
		});
	});

    $('.type_content').change(function(event){
        if ($(this).val() == 1) {
            $('.divDoc').fadeOut('slow');
            $('.divLink').fadeIn('slow');
        }
        else{
            $('.divDoc').fadeIn('slow');
            $('.divLink').fadeOut('slow');
        }
    });

    $('#module_content').change(function(event){
        $('.spinner').fadeIn('slow');
        var HTMLOPTIONSEQUENCE = '';
        var i = 0;
        $.ajax({
		    url : $('.baseURL').val()+'list-sequence-by-module',
		    type : 'POST',
		    data : {module : $(this).val()},    
		    dataType: 'json',
		    success : function(data){ 		    	
		    	$.each(data, function(key, seq){
		    		HTMLOPTIONSEQUENCE += i == 0 ? '<option selected value="'+seq.sequence_id+'">'+seq.sequence_titre+'</option>' : '<option value="'+seq.sequence_id+'">'+seq.sequence_titre+'</option>';
		    		i++;
		    	});
		    	$('#modal-add-content-sequence #sequence_content').html(HTMLOPTIONSEQUENCE);
				$(".spinner").fadeOut("slow");	        
		    }
		});	
    });

    $('#add-content-sequence').on('submit', function(e){
	    e.preventDefault();	    
	    $('.spinner').fadeIn('slow');
	    var error = '';
	    var htmlNewActivity = '';
	    var urlFormationFinal = '';
	    var thumbnailFile = '';
	    if ($('#module_content').val() == '') {
	    	error += label_prefix_required+' '+personnal_interest_module_label+' '+label_suffix_required+'<br>';
	    }

	    if ($('#sequence_content').val() == '') {
	    	error += label_prefix_required+' '+other_user_sequences+' '+label_suffix_required+'<br>';
	    }

	    if ($('#title_content').val() == '') {
	    	error += label_prefix_required+' '+personnal_interest_modal_title_label+' '+label_suffix_required+'<br>';
	    }

	    if ($('#type_content').val() == 4 && $('#file_content').val() == '') {
	    	error += label_prefix_required+' '+my_link_and_document_form_doc_inpu_label+' '+label_suffix_required+'<br>';
	    }

	    if ($('#type_content').val() == 1 && $('#link_content').val() == '') {
	    	error += label_prefix_required+' '+my_link_and_document_form_link_label_input+' '+label_suffix_required+'<br>';
	    }

	    if(error != ''){
	    	toastr.error(error);
	    	$('.spinner').fadeOut('slow');	
	    }
	    else{
		    $.ajax({
				type: $(this).attr('method'),
				url:  $(this).attr('action'),
				data:  new FormData(this),
				contentType: false,
				cache: false,
				processData:false,
				dataType: 'json',
				success: function(data){
					if (data.type == 1) {
				    	urlFormationFinal += data.link;
				    }
				    else{
				    	urlFormationFinal += urlFormation+data.link;
				    }

				    if (data.thumbnail_file != '') {
				    	thumbnailFile += $('.baseURL').val()+'groupes/ACTIVITES/'+data.thumbnail_file;
				    }
				    else{
				    	thumbnailFile += $('.baseURL').val()+'groupes/bg-laptop.png';
				    }

					if (data.uploadFile == false) {
						toastr.error(upload_file_error);      
					}
					else{
						$('.tab-content').each(function(){
							var tab = $(this);
							if (tab.hasClass('active')) {
								var tabId = tab.attr('id').split("sequence");
								if (tabId[1] == $('#sequence_content').val()) {
									htmlNewActivity += '<div class="card-style-4 sequenceActivity"  data-sequence="'+data.id_sequence+'" data-numero="'+data.numero+'">';
		                                htmlNewActivity += '<div class="card" value="'+(data.numero - 1)+'" data-brew="validate" data-link="'+urlFormationFinal+'" data-num="'+data.numero+'" data-statusurl="'+data.status_url+'" data-finalurl="'+urlFormationFinal+'">';
		                                    htmlNewActivity += '<div class="card-img">';
		                                        htmlNewActivity += '<a href="#"><img src="'+thumbnailFile+'" alt=""></a>';
		                                    htmlNewActivity += '</div>';
		                                    htmlNewActivity += '<div class="card-title">';
		                                        htmlNewActivity += '<h4>'+data.titre+'</h4>';
		                                    htmlNewActivity += '</div>';
											htmlNewActivity += '<div class="card-footer card-footer-trainner">';
												htmlNewActivity += '<a data-title="'+data.titre+'" onclick="addActivityCourseHistory(this,'+data.id_sequence+','+data.numero+');" class="add-course" title="'+my_link_and_document_add_to_course_history+'">';
													htmlNewActivity += '<i class="fa-solid fa-clock-rotate-left"></i>';
												htmlNewActivity += '</a>';
												htmlNewActivity += '<a href="#" data-title="'+data.titre+'" data-brew="redirect" data-link="'+urlFormationFinal+'" onclick="viewActivity(this,'+data.id_sequence+');" data-num="1" data-statusurl="'+data.status_url+'" data-finalurl="'+urlFormationFinal+'" class="btn-explore" title="'+course_history_placeholder_article+'">';
													htmlNewActivity += ' '+explore_label+'<i class="fa-solid fa-arrow-right"></i>';
												htmlNewActivity += '</a>';
											htmlNewActivity += '</div>';
											htmlNewActivity += '<div class="card-footer card-footer-trainner">';
												htmlNewActivity += '<a class="add-comment" title="'+course_history_placeholder_comment+'" data-title="'+data.titre+'" onclick="addCommentActivity(this,'+data.id_sequence+','+data.numero+');">';
													htmlNewActivity += '<i class="fa-solid fa-comment"></i>';
												htmlNewActivity += '</a>';
												htmlNewActivity += '<a data-title="'+data.titre+'" onclick="addLinksInFavorites(this,'+data.id_sequence+','+data.numero+');" class="add-favorite" title="'+my_link_and_document_add_to_favorite+'">';
													htmlNewActivity += '<i class="fa-solid fa-heart"></i>';
												htmlNewActivity += '</a>';
												htmlNewActivity += '<a data-title="'+data.titre+'" data-type="'+data.type+'" data-link="'+data.link+'" onclick="editContentListSequence(this,'+data.id_sequence+','+data.numero+');" class="btn-edit">';
													htmlNewActivity += '<i class="fa-solid fa-edit"></i>';
												htmlNewActivity += '</a>';
												htmlNewActivity += '<a data-title="'+data.titre+'" onclick="deleteContentListSequence(this,'+data.id_sequence+','+data.numero+');" class="add-favorite">';
													htmlNewActivity += '<i class="fa-solid fa-trash"></i>';
												htmlNewActivity += '</a>';
											htmlNewActivity += '</div>';
										htmlNewActivity += '</div>';
		                            htmlNewActivity += '</div>';
		                            tab.find('.card-container').append(htmlNewActivity);
								}
							}
						});   
						toastr.success(data_save_ok);       
			      	}

					$('#modal-add-content-sequence').removeClass('open'); 
			        //location.reload(true); 
		        	$('.spinner').fadeOut('slow');	
		      	},
		      	error: function(error, msg){
		      		toastr.error(data_saved_ko);
			        $('.spinner').fadeOut('slow');
			    }
		    });
		}
	}); 

	$('#add-content-sequence-rac').on('submit', function(e){
	    e.preventDefault();	    
	    $('.spinner').fadeIn('slow');
	    var error = '';
	    var htmlNewActivity = '';
	    var urlFormationFinal = '';	
	    var thumbnailFile = '';    

	    if ($('#add-content-sequence-rac #title_content_rac').val() == '') {
	    	error += label_prefix_required+' '+personnal_interest_modal_title_label+' '+label_suffix_required+'<br>';
	    }

	    if ($('#add-content-sequence-rac #type_content').val() == 4 && $('#add-content-sequence-rac #file_content').val() == '') {
	    	error += label_prefix_required+' '+my_link_and_document_form_doc_inpu_label+' '+label_suffix_required+'<br>';
	    }

	    if ($('#add-content-sequence-rac #type_content').val() == 1 && $('#add-content-sequence-rac #link_content_rac').val() == '') {
	    	error += label_prefix_required+' '+my_link_and_document_form_link_label_input+' '+label_suffix_required+'<br>';
	    }

	    if(error != ''){
	    	toastr.error(error);
	    	$('.spinner').fadeOut('slow');	
	    }
	    else{
		    $.ajax({
				type: $(this).attr('method'),
				url:  $(this).attr('action'),
				data:  new FormData(this),
				contentType: false,
				cache: false,
				processData:false,
				dataType: 'json',
				success: function(data){
					if (data.type == 1) {
				    	urlFormationFinal += data.link;
				    }
				    else{
				    	urlFormationFinal += urlFormation+data.link;
				    }

				    if (data.thumbnail_file != '') {
				    	thumbnailFile += $('.baseURL').val()+'groupes/ACTIVITES/'+data.thumbnail_file;
				    }
				    else{
				    	thumbnailFile += $('.baseURL').val()+'groupes/bg-laptop.png';
				    }


					if (data.uploadFile == false) {
						toastr.error(upload_file_error);      
					}
					else{
						$('.tab-content').each(function(){
							var tab = $(this);
							if (tab.hasClass('active')) {
								var tabId = tab.attr('id').split("sequence");
								if (tabId[1] == $('#sequence_content').val()) {
									htmlNewActivity += '<div class="card-style-4 sequenceActivity"  data-sequence="'+data.id_sequence+'" data-numero="'+data.numero+'">';
		                                htmlNewActivity += '<div class="card" value="'+(data.numero - 1)+'" data-brew="validate" data-link="'+urlFormationFinal+'" data-num="'+data.numero+'" data-statusurl="'+data.status_url+'" data-finalurl="'+urlFormationFinal+'">';
		                                    htmlNewActivity += '<div class="card-img">';
		                                        htmlNewActivity += '<a href="#"><img src="'+thumbnailFile+'" alt=""></a>';
		                                    htmlNewActivity += '</div>';
		                                    htmlNewActivity += '<div class="card-title">';
		                                        htmlNewActivity += '<h4>'+data.titre+'</h4>';
		                                    htmlNewActivity += '</div>';
											htmlNewActivity += '<div class="card-footer card-footer-trainner">';
												htmlNewActivity += '<a data-title="'+data.titre+'" onclick="addActivityCourseHistory(this,'+data.id_sequence+','+data.numero+');" class="add-course" title="'+my_link_and_document_add_to_course_history+'">';
													htmlNewActivity += '<i class="fa-solid fa-clock-rotate-left"></i>';
												htmlNewActivity += '</a>';
												htmlNewActivity += '<a href="#" data-title="'+data.titre+'" data-brew="redirect" data-link="'+urlFormationFinal+'" onclick="viewActivity(this,'+data.id_sequence+');" data-num="1" data-statusurl="'+data.status_url+'" data-finalurl="'+urlFormationFinal+'" class="btn-explore" title="'+course_history_placeholder_article+'">';
													htmlNewActivity += ' '+explore_label+'<i class="fa-solid fa-arrow-right"></i>';
												htmlNewActivity += '</a>';
											htmlNewActivity += '</div>';
											htmlNewActivity += '<div class="card-footer card-footer-trainner">';
												htmlNewActivity += '<a class="add-comment" title="'+course_history_placeholder_comment+'" data-title="'+data.titre+'" onclick="addCommentActivity(this,'+data.id_sequence+','+data.numero+');">';
													htmlNewActivity += '<i class="fa-solid fa-comment"></i>';
												htmlNewActivity += '</a>';
												htmlNewActivity += '<a data-title="'+data.titre+'" onclick="addLinksInFavorites(this,'+data.id_sequence+','+data.numero+');" class="add-favorite" title="'+my_link_and_document_add_to_favorite+'">';
													htmlNewActivity += '<i class="fa-solid fa-heart"></i>';
												htmlNewActivity += '</a>';
												htmlNewActivity += '<a data-title="'+data.titre+'" data-type="'+data.type+'" data-link="'+data.link+'" onclick="editContentListSequence(this,'+data.id_sequence+','+data.numero+');" class="btn-edit">';
													htmlNewActivity += '<i class="fa-solid fa-edit"></i>';
												htmlNewActivity += '</a>';
												htmlNewActivity += '<a data-title="'+data.titre+'" onclick="deleteContentListSequence(this,'+data.id_sequence+','+data.numero+');" class="add-favorite">';
													htmlNewActivity += '<i class="fa-solid fa-trash"></i>';
												htmlNewActivity += '</a>';
											htmlNewActivity += '</div>';
										htmlNewActivity += '</div>';
		                            htmlNewActivity += '</div>';
		                            tab.find('.card-container').append(htmlNewActivity);
								}
							}
						});   
						toastr.success(data_save_ok);       
			      	}
					$('#modal-add-content-sequence-rac').removeClass('open'); 
		        	$('.spinner').fadeOut('slow');	
		      	},
		      	error: function(error, msg){
		      		toastr.error(data_saved_ko);
			        $('.spinner').fadeOut('slow');
			    }
		    });
		}
	}); 

	$('#edit-content-sequence').on('submit', function(e){
	    e.preventDefault();	    
	    $('.spinner').fadeIn('slow');
	    var error = '';
	    var htmlNewActivity = '';
	    var urlFormationFinal = '';	
	    var thumbnailFile = '';    

	    if ($('#modal-edit-content-sequence #title_content').val() == '') {
	    	error += label_prefix_required+' '+personnal_interest_modal_title_label+' '+label_suffix_required+'<br>';
	    }

	    if ($('#modal-edit-content-sequence #type_content').val() == 4 && $('#modal-edit-content-sequence #file_content').val() == '') {
	    	error += label_prefix_required+' '+my_link_and_document_form_doc_inpu_label+' '+label_suffix_required+'<br>';
	    }

	    if ($('#modal-edit-content-sequence #type_content').val() == 1 && $('#modal-edit-content-sequence #link_content').val() == '') {
	    	error += label_prefix_required+' '+my_link_and_document_form_link_label_input+' '+label_suffix_required+'<br>';
	    }

	    if(error != ''){
	    	toastr.error(error);
	    	$('.spinner').fadeOut('slow');	
	    }
	    else{
		    $.ajax({
				type: $(this).attr('method'),
				url:  $(this).attr('action'),
				data:  new FormData(this),
				contentType: false,
				cache: false,
				processData:false,
				dataType: 'json',
				success: function(data){
					if (data.type == 1) {
				    	urlFormationFinal += data.result.link;
				    }
				    else{
				    	urlFormationFinal += urlFormation+data.result.link;
				    }

				    if (data.thumbnail_file != '') {
				    	thumbnailFile += $('.baseURL').val()+'groupes/ACTIVITES/'+data.thumbnail_file;
				    }
				    else{
				    	thumbnailFile += $('.baseURL').val()+'groupes/bg-laptop.png';
				    }


					if (data.uploadFile == false) {
						toastr.error(upload_file_error);      
					}
					else{
						htmlNewActivity += '<div class="card" value="'+(data.numero - 1)+'" data-brew="validate" data-link="'+urlFormationFinal+'" data-num="'+data.numero+'" data-statusurl="'+data.result.status_url+'" data-finalurl="'+urlFormationFinal+'">';
                            htmlNewActivity += '<div class="card-img">';
                                htmlNewActivity += '<a href="#"><img src="'+thumbnailFile+'" alt=""></a>';
                            htmlNewActivity += '</div>';
                            htmlNewActivity += '<div class="card-title">';
                                htmlNewActivity += '<h4>'+data.result.titre+'</h4>';
                            htmlNewActivity += '</div>';
							htmlNewActivity += '<div class="card-footer card-footer-trainner">';
								htmlNewActivity += '<a data-title="'+data.result.titre+'" onclick="addActivityCourseHistory(this,'+data.id_sequence+','+data.numero+');" class="add-course" title="'+my_link_and_document_add_to_course_history+'">';
									htmlNewActivity += '<i class="fa-solid fa-clock-rotate-left"></i>';
								htmlNewActivity += '</a>';
								htmlNewActivity += '<a href="#" data-title="'+data.result.titre+'" data-brew="redirect" data-link="'+urlFormationFinal+'" onclick="viewActivity(this,'+data.id_sequence+');" data-num="1" data-statusurl="'+data.status_url+'" data-finalurl="'+urlFormationFinal+'" class="btn-explore" title="'+course_history_placeholder_article+'">';
									htmlNewActivity += ' '+explore_label+'<i class="fa-solid fa-arrow-right"></i>';
								htmlNewActivity += '</a>';
							htmlNewActivity += '</div>';
							htmlNewActivity += '<div class="card-footer card-footer-trainner">';
								htmlNewActivity += '<a class="add-comment" title="'+course_history_placeholder_comment+'" data-title="'+data.result.titre+'" onclick="addCommentActivity(this,'+data.id_sequence+','+data.numero+');">';
									htmlNewActivity += '<i class="fa-solid fa-comment"></i>';
								htmlNewActivity += '</a>';
								htmlNewActivity += '<a data-title="'+data.result.titre+'" onclick="addLinksInFavorites(this,'+data.id_sequence+','+data.numero+');" class="add-favorite" title="'+my_link_and_document_add_to_favorite+'">';
									htmlNewActivity += '<i class="fa-solid fa-heart"></i>';
								htmlNewActivity += '</a>';
								htmlNewActivity += '<a data-title="'+data.result.titre+'" data-type="'+data.result.type+'" data-link="'+data.result.link+'" onclick="editContentListSequence(this,'+data.id_sequence+','+data.numero+');" class="btn-edit">';
									htmlNewActivity += '<i class="fa-solid fa-edit"></i>';
								htmlNewActivity += '</a>';
								htmlNewActivity += '<a data-title="'+data.result.titre+'" onclick="deleteContentListSequence(this,'+data.id_sequence+','+data.numero+');" class="add-favorite">';
									htmlNewActivity += '<i class="fa-solid fa-trash"></i>';
								htmlNewActivity += '</a>';
							htmlNewActivity += '</div>';
						htmlNewActivity += '</div>';
						$('.sequenceActivity').each(function(){
				    		var div = $(this);
				    		if (div.attr('data-sequence') == data.id_sequence && div.attr('data-numero') == data.numero) {
				    			div.html(htmlNewActivity);
				    		}
				    	});   
						toastr.success(data_save_ok);       
			      	}
					$('#modal-edit-content-sequence').removeClass('open'); 
		        	$('.spinner').fadeOut('slow');	
		      	},
		      	error: function(error, msg){
		      		toastr.error(data_saved_ko);
			        $('.spinner').fadeOut('slow');
			    }
		    });
		}
	}); 

	$('.btn-confirm-delete-content-sequence').click(function(e){
		e.preventDefault();
		$(".spinner").fadeIn("slow");
		var btn        = $(this);
		var idSequence = $('#alertConfirmDeleteData #idSequence').val();
		var numero     = $('#alertConfirmDeleteData #numSequence').val();
		$.ajax({
		    url        : $('.baseURL').val()+'delete-activity',
		    type       : 'POST',
		    data       : {idSequence : idSequence, numero : numero},    
		    success    : function(data){ 
		    	$('.sequenceActivity').each(function(){
		    		var div = $(this);
		    		if (div.attr('data-sequence') == idSequence && div.attr('data-numero') == numero) {
		    			div.fadeOut('slow');
		    		}
		    	});
		    	$('#alertConfirmDeleteData').removeClass('open');
		    	toastr.error(data_delete_ok);
				$(".spinner").fadeOut("slow");	        
		    }
		});	
	});

	$('.btn-confirm-delete-list-sequence').click(function(e){
		e.preventDefault();
		$(".spinner").fadeIn("slow");
		var btn        = $(this);
		var id = $('#alertConfirmDeleteListSequence #idSequence').val();
		$.ajax({
		    url        : $('.baseURL').val()+'deleteSequence',
		    type       : 'POST',
		    data       : {id : id, loc : 1},    
		    success    : function(data){ 
		    	$('.navigation-course-history').each(function(){
		    		var slick = $(this);
		    		if (slick.attr('data-id-sequence') == id) {
		    			slick.fadeOut('slow');
		    		}
		    	});

		    	$('.dropdown-link').each(function(){
		    		var li = $(this);
		    		if (li.attr('data-sequence-id') == id) {
		    			li.fadeOut('slow');
		    		}
		    	});

		    	$('#alertConfirmDeleteListSequence').removeClass('open');
		    	toastr.error(data_delete_ok);
				$(".spinner").fadeOut("slow");	        
		    }
		});	
	});

	$('#edit-sequence-list').on('submit', function(e){
	    e.preventDefault();	    
	    $('.spinner').fadeIn('slow');
	    var error = '';
	    var htmlNewActivity = '';

	    if ($('#modal-edit-sequence #sequence_titre').val() == '') {
	    	error += label_prefix_required+' '+personnal_interest_modal_title_label+' '+label_suffix_required+'<br>';
	    }

	    if(error != ''){
	    	toastr.error(error);
	    	$('.spinner').fadeOut('slow');	
	    }
	    else{
		    $.ajax({
				type: $(this).attr('method'),
				url:  $(this).attr('action'),
				data:  new FormData(this),
				contentType: false,
				cache: false,
				processData:false,
				dataType: 'json',
				success: function(data){
					location.reload();
					toastr.success(data_save_ok);    
					$('#modal-edit-sequence').removeClass('open'); 
		        	$('.spinner').fadeOut('slow');	
		      	},
		      	error: function(error, msg){
		      		toastr.error(data_saved_ko);
			        $('.spinner').fadeOut('slow');
			    }
		    });
		}
	}); 

	$('#add-new-sequence-list').click(function(e){
		e.preventDefault();
		$('#sequence_list_action_valide').val(1);
		$(".module-sequence-list-content").fadeIn("slow");	
		$(".module-sequence-list-action").fadeOut("slow");	
	});

	$('#cancel-add-new-sequence-list').click(function(e){
		e.preventDefault();
		$('#sequence_list_action_valide').val(0);
		$(".module-sequence-list-content").fadeOut("slow");	
		$(".module-sequence-list-action").fadeIn("slow");	
	});

	$('.btn-confirm-delete-list-module').click(function(e){
		e.preventDefault();
		$(".spinner").fadeIn("slow");
		var btn               = $(this);
		var idModule          = $('#alertConfirmRemoveModule #idModuleDelete').val();
    	var ident             = parseInt($('#identButtonModule').val());
    	var lastContentButton = ident - 1;
    	var nextContentButton = ident + 1;
    	
		$.ajax({
		    url        : $('.baseURL').val()+'delListModule',
		    type       : 'POST',
		    data       : {idModule : idModule},
		    dataType   : 'json',    
		    success    : function(data){
		    	$('.btn-mod').each(function(){
		    		var l = $(this);
		    		if (l.attr('data-module-id') == idModule) {
		    			l.parents('.button-inner').remove();
		    		}
		    	});

		    	if ($('.button-inner-'+lastContentButton+'').length == '1') {
		    		$('.button-inner-'+lastContentButton+'').find('.tablinks').click();
		    	}
		    	else{
		    		$('.button-inner-'+nextContentButton+'').find('.tablinks').click();
		    	}
		    	$('#alertConfirmRemoveModule').removeClass('open');
		    	toastr.error(data_delete_ok);
				$(".spinner").fadeOut("slow");	        
		    }
		});	
	});
});

function saveDataListSequence(btn){
	var actionValue = $(btn).attr('name');
	$('#action_btn').val(actionValue);
	$('#add-sequence-list').on('submit', function(e){
	    e.preventDefault();	    
	    $('.spinner').fadeIn('slow');
	    var error = '';
	    var htmlSequence = '';    
	    var contentBtn = '';    

	    if ($('#modal-add-sequence #sequence_module').val() == '') {
	    	error += label_prefix_required+' '+personnal_interest_modal_title_label+' '+label_suffix_required+'<br>';
	    }

	    if ($('#modal-add-sequence #sequence_titre').val() == '') {
	    	error += label_prefix_required+' '+personnal_interest_modal_title_label+' '+label_suffix_required+'<br>';
	    }

	    if(error != ''){
	    	toastr.error(error);
	    	$('.spinner').fadeOut('slow');	
	    }
	    else{
		    $.ajax({
				type: $(this).attr('method'),
				url:  $(this).attr('action'),
				data:  new FormData(this),
				contentType: false,
				cache: false,
				processData:false,
				dataType: 'json',
				success: function(data){
					htmlSequence += '<li>';
						htmlSequence += '<a href="#" class="dropdown-link" data-name="'+data.sequenceInfos.sequence_titre+'" data-id-module="'+data.moduleInfos.module_id+'" data-id-pave="'+data.sequenceInfos.domaine_id+'" data-sequence-id="'+data.sequenceInfos.idSequence+'" onclick="loadContentSequence(this,event)">'+data.sequenceInfos.sequence_titre+'</a>';
					htmlSequence += '</li>';
					$('.btn-mod').each(function(){
						var moduleContentHTML = $(this);
						if (moduleContentHTML.attr('data-module-id') == data.moduleInfos.module_id) {
							contentBtn = moduleContentHTML.attr('data-id');
						}
					});

					$('.container-dropdown').each(function(){
						var dropdown = $(this);
						if (dropdown.attr('content') == contentBtn) {
							dropdown.find('ul').append(htmlSequence);
						}
					});
				    toastr.success(data_save_ok);
					$('#modal-add-sequence').removeClass('open'); 
		        	$('.spinner').fadeOut('slow');	
		      	},
		      	error: function(error, msg){
		      		toastr.error(data_saved_ko );
			        $('.spinner').fadeOut('slow');
			    }
		    });
		}
	});
	return false;
}

function saveDataListModule(btn){
	var actionValue = $(btn).attr('name');
	$('#add-module-list #action_btn').val(actionValue);
	$('#add-module-list').on('submit', function(e){
	    e.preventDefault();	    
	    $('.spinner').fadeIn('slow');
	    var error = '';
	    var htmlSequence = '';    
	    var contentBtn = '';    

	    if ($('#modal-add-module #module_titre').val() == '') {
	    	error += label_prefix_required+' '+personnal_interest_modal_title_label+' '+label_suffix_required+'<br>';
	    }

	    if ($('#modal-add-module #sequence_list_action_valide').val() == 0 && $('#modal-add-module #sequencesModule').val() == null) {
	    	error += label_prefix_required+' '+other_user_sequences+' '+label_suffix_required+'<br>';
	    }

	    if ($('#modal-add-module #sequence_list_action_valide').val() == 1 && $('#modal-add-module #sequence_titre').val() == '') {
	    	error += label_prefix_required+' '+other_user_sequences+' '+label_suffix_required+'<br>';
	    }

	    if(error != ''){
	    	toastr.error(error);
	    	$('.spinner').fadeOut('slow');	
	    }
	    else{
		    $.ajax({
				type: $(this).attr('method'),
				url:  $(this).attr('action'),
				data:  new FormData(this),
				contentType: false,
				cache: false,
				processData:false,
				dataType: 'json',
				success: function(data){
					location.reload();
				    toastr.success(data_save_ok);
					$('#modal-add-module').removeClass('open'); 
		        	$('.spinner').fadeOut('slow');
		      	},
		      	error: function(error, msg){
		      		toastr.error(data_saved_ko );
			        $('.spinner').fadeOut('slow');
			    }
		    });
		}
	});
	return false;
}

function addContentInListSequence(link){
	var btn = $(link);
	$('#modal-add-content-sequence-rac #module_content').val(btn.attr('data-module'));
	$('#modal-add-content-sequence-rac #sequence_content').val(btn.attr('data-id'));
	$('#modal-add-content-sequence-rac').addClass('open'); 
}

function openModulesInMatiere(ln,idMatiere){
	var btn = $(ln);
	$(".spinner").fadeIn("slow");
	$.ajax({
	    url : $('.baseURL').val()+'list-modules-in-matiere',
	    type : 'POST',
	    data : {'idMatiere' : idMatiere},    
	    success : function(data){ 
	    	btn.parents('.moduleName').parents('.sequence-link').append(data);
	    	btn.find('i').removeClass('glyphicon glyphicon-eye-open glyphicon-open-module');
	    	btn.find('i').addClass('indicator glyphicon glyphicon-minus-sign');
	    	btn.removeAttr('onclick');
			$(".spinner").fadeOut("slow");	        
	    }
	});	
}

function addModuleItemSession(btn,idModule){
	$(".spinner").fadeIn("slow");
	$.ajax({
	    url : $('.baseURL').val()+'add-items-module-formation',
	    type : 'POST',  
	    data:  {"idModule":idModule},   
	    success : function(data){ 
	    	$(btn).find('i').removeClass('glyphicon glyphicon-plus-sign glyphicon-plus-sign-modules');
	    	$(btn).find('i').addClass('indicator glyphicon glyphicon-minus-sign');
	    	$(btn).remove();
	        $(".spinner").fadeOut("slow");		        
	    }
	});
	return false;
}

function addItemsFormation(btn){
	$(".spinner").fadeIn("slow");
	$.ajax({
	    url : $('.baseURL').val()+'add-items-formation',
	    type : 'POST',  
	    data:  {"idParcours":$(btn).attr('data-id'),"domaine":$(btn).attr('data-domaine')},   
	    success : function(data){ 
	    	$(btn).parents('.material').find('.materialName').attr('style','color:brown;font-weight:bold;');
	    	$(btn).remove();
	    	location.reload();
	        $(".spinner").fadeOut("slow");		        
	    }
	});
	return false;
}

function saveSequenceToCurrentItems(btn){
	$(".spinner").fadeIn("slow");
	var link = $(btn);
	var sequence_id = link.parents('.sequence-link').find('.sequence_id').val();
	var matiere_id  = link.parents('.sequence-link').find('.matiere_id').val();
	var domaine_id  = link.parents('.sequence-link').find('.domaine_id').val();
	if ($('.module_id').length >= "1") {
		var data = {"sequence_id":sequence_id,"matiere_id":matiere_id,"domaine_id":domaine_id,"module_id":$('.module_id').val(),"parcours_id":$('.parcours_id').val()};
	}
	else{
		var data = {"sequence_id":sequence_id,"matiere_id":matiere_id,"domaine_id":domaine_id};
	}

	$.ajax({
	    url : $('.baseURL').val()+'add-sequence-items-formation',
	    type : 'POST',  
	    data:  data,   
	    success : function(data){ 
	    	link.removeClass('indicator glyphicon glyphicon-plus-sign glyphicon-hover-add-sequence');
	    	link.addClass('indicator glyphicon glyphicon-minus-sign glyphicon-ok');
	    	$(".spinner").fadeOut("slow");		        
	    }
	});
	return false;
}

function refreshDataSequence(ln){
	$(".spinner").fadeIn("slow");
	$('.domaineName').each(function(){
		var seq = $(this);
		/*if (seq.text().indexOf(ln.value) != -1) {
			seq.parents('.sequence-link').show();
		}
		else{
			seq.parents('.sequence-link').hide();
		}*/
		if (seq.text().includes(ln.value) >= 1) {
			seq.parents('.sequence-link').show();
		}
		else{
			seq.parents('.sequence-link').hide();
		}
	});
	$(".spinner").fadeOut("slow");
	
}

function deleteContentListSequence(btn, idSequence, numero){
	$('#alertConfirmDeleteData #idSequence').val(idSequence);
	$('#alertConfirmDeleteData #numSequence').val(numero);
	$('#alertConfirmDeleteData').addClass('open');
}

function editContentListSequence(btn, idSequence, numero){
	$('#modal-edit-content-sequence #idSequence').val(idSequence);
	$('#modal-edit-content-sequence #numSequence').val(numero);
	$('#modal-edit-content-sequence #title_content').val($(btn).attr('data-title'));
	$('#modal-edit-content-sequence #type_content').val($(btn).attr('data-type'));
	if ($(btn).attr('data-type') == 1) {
		$('#modal-edit-content-sequence #link_content').val($(btn).attr('data-link'));
		$('.divDoc').fadeOut('slow');
		$('.divLink').fadeIn('slow');
	}
	else{
		$('.divDoc').fadeIn('slow');
		$('.divLink').fadeOut('slow');
	}
	$('#modal-edit-content-sequence').addClass('open');
}

function deleteListSequence(btn){
	var link = $(btn);
	$('#alertConfirmDeleteListSequence #idSequence').val(link.attr('data-id'));
	$('#alertConfirmDeleteListSequence').addClass('open');
}
function editListSequence(btn){
	var link = $(btn);
	$('#modal-edit-sequence #idSequence').val(link.attr('data-id'));
	$('#modal-edit-sequence #sequence_titre').val(link.attr('data-title'));
	$('#modal-edit-sequence #sequence_objectifs').val(link.attr('data-sequence-objectif'));
	$('#modal-edit-sequence').addClass('open');
}

function removeModule(btn,event){
	event.preventDefault();
	var link = $(btn);
	$('#idModuleDelete').val(link.attr('data-module-id'));
	$('#identButtonModule').val(link.parents('.button-inner').attr('data-ident'));
	$('#alertConfirmRemoveModule').addClass('open');
}


function editModule(btn,event){
	event.preventDefault();
	var link = $(btn);
	$.ajax({
	    url     :  $('.baseURL').val()+'list-sequence-by-module',
	    type    :  'post',  
	    data    :  {module: link.attr('data-module-id')}, 
	    dataType:  'json',  
	    success : function(data){
	    	$.each(data, function(key, seq){
	    		$('#sequencesModuleEdit').find('option').each(function() {
	    			var option = $(this);
	    			console.log(option.val() +' '+seq.sequence_id);
				    if (option.val() == seq.sequence_id) {
				    	option.attr('selected', 'selected');
				    }
				});
	    	});
			$('#modal-edit-list-module #idModule').val(link.attr('data-module-id'));
			$('#modal-edit-list-module #module_titre').val(link.attr('data-module-title'));
			$('#modal-edit-list-module #module_objectifs').val(link.attr('data-module-objectif'));
			$('#modal-edit-list-module').addClass('open');
	    }
	});
}