<?php 
    if(!defined('BASEPATH')) exit('No direct script access allowed');
    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\SMTP;
    use PHPMailer\PHPMailer\Exception;
    require APPPATH . '/libraries/vendor/autoload.php';
    /**
     * Class : BaseController
     * Base Class to control over all the classes
     * @author : Alexandre Bors
     * @version : 1.1
     * @since : 22 November 2018
     */
    class Login extends CI_Controller
    {
        /**
         * This is default constructor of the class
         */
        public function __construct()
        {
            parent::__construct();
            $this->load->model('login_model');
            $this->load->model('connexion_model');
            $this->load->model('groupes_model');
            $this->load->model('historik_course_nl_model');
            $this->load->model('Stag_individu_model');
            $this->load->model('classificationFavoris_Model');
            $this->load->model('Connexion_failure_model');
        }

        /**
         * Index Page for this controller.
         */
        public function index()
        {
            $this->isLoggedIn();
        }
        
        /**
         * This function used to check the user is logged in or not
         */
        function isLoggedIn()
        {
            $isLoggedIn = $this->session->userdata('isLoggedIn');
            
            if(!isset($isLoggedIn) || $isLoggedIn != TRUE)
            {
                $this->load->view('login');
            }
            elseif ($this->session->userdata ('GUSERTYPE')==ADMIN) {
                redirect('/admindashbord');
            }
            elseif ($this->session->userdata ('GUSERTYPE')==TUTEUR) {
                redirect('/tutordashbord');
            }
            elseif ($this->session->userdata ('GUSERTYPE')==SUPERVISEUR) {
                redirect('/screen-piloting');
            }
            elseif ($this->session->userdata ('GUSERTYPE')==STAGIAIRE) {
                redirect('/dashboard');
            }
            else
            {
                redirect('/dashboard');
            }
        }
        
        
        /**
         * This function used to logged in user
         */
        public function loginMe()
        {
            $infoserror = '';           
            
            if(isset($_GET['action']) && $_GET['action'] == 'vg'){
                $email = $_GET['login'];
                $password = $_GET['passwd'];          
                //$result = $this->login_model->loginMe($email, $password);
                $result  =$this->el_f2plus_auth->login($email, $password, FALSE);
                $langagePlateform = '';
                $matches = array();
                if(count($result) > 0 && (is_array($result) || is_object($result))){
                    foreach ($result as $res){
                        $langageFormation = $this->groupes_model->RequestByGrp('langue',$res->id_groupe);
                        if (preg_match('/Anglais/i', $langageFormation, $matches)) {  
                            $langagePlateform = 'english';
                        } 
                        else if (preg_match('/Français/i', $langageFormation, $matches)){
                            $langagePlateform = 'french';
                        } 
                        else if ($langageFormation == NULL || $langageFormation == ''){
                            $langagePlateform = 'english';
                        }
                        else{
                            $langagePlateform = 'french';
                            $langagePlateform = 'french';
                        }

                        
                        if ($res->type==0) {
                            if (!empty($res->date_fin_acces)) {
                                if($res->date_fin_acces+((24*3600)+(60*60)+60) <= time()) {
                                    $infoserror = 'Your date of access to the platform has expired';
                                    $this->sendMailAndSaveErrorLoginFailed($infoserror, $email, $password);

                                    $this->session->set_flashdata('error', $infoserror);                
                                    redirect('/login');

                                }
                                else{

                                    $role = STAGIAIRE;

                                    $CNX = $this->connexion_model->newconnexion($res->id,'EL V3');

                                    $sessionArray = array(
                                        'GUSERID'                  =>$res->id,
                                        'GEXTRANETID'              =>$res->extranet_id,
                                        'GUSERLOGIN'               =>$res->login,
                                        'GUSER'                    =>$res->prenom." ".$res->nom,
                                        'GUSERINITIAL'             =>$res->nom[0],
                                        'GUSERTYPE'                =>$res->type,
                                        'BAR'                      =>$res->acces_bar,
                                        'MODE_ACCES'               =>$res->mode_acces,
                                        'GROUPE'                   =>$res->id_groupe,
                                        'GLOSSAIREONLINE'          =>$this->groupes_model->Request('glossaireenligne',$res->id_groupe),
                                        'ACCES_FONCTIONS_ADMIN'    =>$res->acces_fonctions_admin,
                                        'TUTEUR_ENTREPRISE'        =>$res->tuteur_entreprise,
                                        'TYPE'                     =>$res->type,
                                        'ROLE'                     =>$role,
                                        'CNX'                      =>$CNX,
                                        'SOCIETE'                  =>$res->description,
                                        'IDSOCIETE'                =>$res->id_societe,
                                        'NBCONNEXION'              =>$res->nbconnexion,
                                        'PDP'                      =>$res->nom_photo,
                                        'IDSTAGE'                  =>$this->Stag_individu_model->getMaxNumStageByIdMembers($res->id),
                                        'isLoggedIn'               => TRUE,
                                        'site_lang'                => $langagePlateform
                                    );
                                    $this->session->set_userdata($sessionArray);
                                    redirect('/traineeglossary?md=direct');
                                }
                            }
                            else{
                                $infoserror = 'Sorry, you are not authorized to access this page';
                                $this->sendMailAndSaveErrorLoginFailed($infoserror, $email, $password);

                                $this->session->set_flashdata('error', $infoserror);                
                                redirect('/login');
                            }

                        }
                        else{ 
                            $infoserror = 'Sorry, you are not authorized to access this page';
                            $this->sendMailAndSaveErrorLoginFailed($infoserror, $email, $password);                    
                            $this->session->set_flashdata('error', $infoserror);                
                            redirect('/login');
                        }
                    }
                }
                else{
                    $infoserror = 'Email or password mismatch';
                    $this->sendMailAndSaveErrorLoginFailed($infoserror, $email, $password);
                    $this->session->set_flashdata('error', $infoserror);
                    
                    redirect('/login');
                }
            }
            if(isset($_GET['auth']) && $_GET['auth'] == 'true'){
                $explodeFullUrl = explode("loginMe?auth=", $_SERVER['REQUEST_URI']);
                
                if (isset($_GET['data_type']) && $_GET['data_type'] == 'article_nl') {
                    $urlRedirect    = 'read-data?id='.$this->historik_course_nl_model->Request('id_article',$_GET['container']).'&id_h_c='.$_GET['container'];
                }
                else{
                    $urlRedirect    = "traineeTodo?auth=".$explodeFullUrl[1];
                }

                if($this->session->userdata('isLoggedIn') == TRUE && $this->session->userdata ('GUSERTYPE')== STAGIAIRE){
                    redirect($urlRedirect);
                }
                else{
                    $email = $_GET['ident'];
                    $password = $_GET['pd'];          
                    //$result = $this->login_model->loginMe($email, $password);
                    $result  =$this->el_f2plus_auth->login($email, $password, FALSE);
                    $langagePlateform = '';
                    $matches = array();
                    if(count($result) > 0 && (is_array($result) || is_object($result))){
                        foreach ($result as $res){
                            $langageFormation = $this->groupes_model->RequestByGrp('langue',$res->id_groupe);
                            if (preg_match('/Anglais/i', $langageFormation, $matches)) {  
                                $langagePlateform = 'english';
                            } 
                            else if (preg_match('/Français/i', $langageFormation, $matches)){
                                $langagePlateform = 'french';
                            } 
                            else if ($langageFormation == NULL || $langageFormation == ''){
                                $langagePlateform = 'english';
                            }
                            else{
                                $langagePlateform = 'french';
                            }

                            
                            if ($res->type==0) {
                                if (!empty($res->date_fin_acces)) {
                                    if($res->date_fin_acces+((24*3600)+(60*60)+60) <= time()) {
                                        $infoserror = 'Your date of access to the platform has expired';
                                        $this->sendMailAndSaveErrorLoginFailed($infoserror, $email, $password);
                                        $this->session->set_flashdata('error', $infoserror);                
                                        redirect('/login');

                                    }
                                    else{

                                        $role = STAGIAIRE;

                                        $CNX = $this->connexion_model->newconnexion($res->id,'EL V3');

                                        $sessionArray = array(
                                            'GUSERID'                  =>$res->id,
                                            'GEXTRANETID'              =>$res->extranet_id,
                                            'GUSERLOGIN'               =>$res->login,
                                            'GUSER'                    =>$res->prenom." ".$res->nom,
                                            'GUSERINITIAL'             =>$res->nom[0],
                                            'GUSERTYPE'                =>$res->type,
                                            'BAR'                      =>$res->acces_bar,
                                            'MODE_ACCES'               =>$res->mode_acces,
                                            'GROUPE'                   =>$res->id_groupe,
                                            'GLOSSAIREONLINE'          =>$this->groupes_model->Request('glossaireenligne',$res->id_groupe),
                                            'ACCES_FONCTIONS_ADMIN'    =>$res->acces_fonctions_admin,
                                            'TUTEUR_ENTREPRISE'        =>$res->tuteur_entreprise,
                                            'TYPE'                     =>$res->type,
                                            'ROLE'                     =>$role,
                                            'CNX'                      =>$CNX,
                                            'SOCIETE'                  =>$res->description,
                                            'NBCONNEXION'              =>$res->nbconnexion,
                                            'IDSOCIETE'                =>$res->id_societe,
                                            'PDP'                      =>$res->nom_photo,
                                            'isLoggedIn'               => TRUE,
                                            'IDSTAGE'                  =>$this->Stag_individu_model->getMaxNumStageByIdMembers($res->id),
                                            'site_lang'                => $langagePlateform
                                        );
                                        $this->session->set_userdata($sessionArray);
                                        redirect($urlRedirect);
                                    }
                                }
                                else{
                                    $infoserror = 'Sorry, you are not authorized to access this page';
                                    $this->sendMailAndSaveErrorLoginFailed($infoserror, $email, $password);
                                    $this->session->set_flashdata('error', $infoserror);                
                                    redirect('/login');
                                }

                            }
                            else{                      
                                $infoserror = 'Sorry, you are not authorized to access this page';
                                $this->sendMailAndSaveErrorLoginFailed($infoserror, $email, $password);
                                $this->session->set_flashdata('error', $infoserror);               
                                redirect('/login');
                            }
                        }
                    }
                    else{
                        $infoserror = 'Email or password mismatch';

                        $this->sendMailAndSaveErrorLoginFailed($infoserror, $email, $password);

                        $this->session->set_flashdata('error', $infoserror);                             
                        redirect('/login');
                    }
                }
            }
            $this->load->library('form_validation');
            
            //$this->form_validation->set_rules('email', 'Email', 'required|valid_email|max_length[128]|trim');
            $this->form_validation->set_rules('email', 'Email', 'required');
            $this->form_validation->set_rules('password', 'Password', 'required|max_length[32]');
            $this->form_validation->set_rules('remember', 'Remember me', '');
            
            if($this->form_validation->run() == FALSE)
            {
                $this->index();
            }        
            else
            {
                $email = $this->input->post('email');
                $password = $this->input->post('password');
                $result  =$this->el_f2plus_auth->login($email, $password, $this->input->post('remember') == 'on' ? TRUE : FALSE);
                $langagePlateform = '';
                $matches = array();
                if(count($result) > 0 && (is_array($result) || is_object($result))){
                    foreach ($result as $res){
                        $langageFormation = $this->groupes_model->RequestByGrp('langue',$res->id_groupe);
                        if (preg_match('/Anglais/i', $langageFormation, $matches)) {  
                            $langagePlateform = 'english';
                        } 
                        else if (preg_match('/Français/i', $langageFormation, $matches)){
                            $langagePlateform = 'french';
                        } 
                        else if ($langageFormation == NULL || $langageFormation == ''){
                            $langagePlateform = 'english';
                        }
                        else{
                            $langagePlateform = 'french';
                        }

                        if ($res->mode_acces == '2') {
                            if ($res->type==0) {
                                $role = STAGIAIRE;
                            }
                            elseif ($res->type==3 && $res->tuteur_entreprise==0) {
                                $role = TUTEUR;                            
                            }
                            elseif ($res->type==3 && $res->tuteur_entreprise==1) {
                                $role = TUTEUR;                            
                            }
                            elseif ($res->type==4) {
                               $role = SUPERVISEUR;                            
                            }
                            elseif ($res->type==2) {
                               $role = ADMIN;                            
                            } 
                            else{
                                $role = ROLEAUTRES;
                            }
                            $CNX = $this->connexion_model->newconnexion($res->id,'EL V3');

                            $sessionArray = array(
                                'GUSERID'=>$res->id,
                                'GEXTRANETID'              =>$res->extranet_id,
                                'GUSER'                    =>$res->prenom." ".$res->nom,
                                'GUSERINITIAL'             =>$res->nom[0],
                                'GUSERLOGIN'               =>$res->login,
                                'GUSERTYPE'                =>$res->type,
                                'BAR'                      =>$res->acces_bar,
                                'MODE_ACCES'               =>$res->mode_acces,
                                'GROUPE'                   =>$res->id_groupe,
                                'GLOSSAIREONLINE'          =>$this->groupes_model->Request('glossaireenligne',$res->id_groupe),
                                'ACCES_FONCTIONS_ADMIN'    =>$res->acces_fonctions_admin,
                                'TUTEUR_ENTREPRISE'        =>$res->tuteur_entreprise,
                                'TYPE'                     =>$res->type,
                                'ROLE'                     =>$role,
                                'CNX'                      =>$CNX,
                                'SOCIETE'                  =>$res->description,
                                'IDSOCIETE'                =>$res->id_societe,
                                'NBCONNEXION'              =>$res->nbconnexion,
                                'PDP'                      =>$res->nom_photo,
                                'IDSTAGE'                  =>$res->type == 0 ? $this->Stag_individu_model->getMaxNumStageByIdMembers($res->id) : NULL,
                                'isLoggedIn'               =>TRUE,
                                'site_lang'                =>($res->id_groupe == 0 && $res->type == 3) ? 'english' : $langagePlateform
                            );
                                        
                            $this->session->set_userdata($sessionArray);
                            if ($res->type==3){
                                redirect('/tutordashbord');
                            }
                            elseif ($res->type==2){
                                redirect('/admindashbord');
                            }
                            elseif ($res->type==4){
                                redirect('/screen-piloting');
                            }
                            else{
                                redirect('/dashboard');                                
                            }
                        }
                        elseif (!empty($res->date_fin_acces)) {
                            if($res->date_fin_acces+((24*3600)+(60*60)+60) <= time()) {
                                $infoserror  = 'Your date of access to the platform has expired';
                                $this->sendMailAndSaveErrorLoginFailed($infoserror, $email, $password);

                                $this->session->set_flashdata('error', $infoserror);                
                                redirect('/login');

                            }
                            else{
                                if ($res->type==0) {
                                    $role = STAGIAIRE;
                                }
                                elseif ($res->type==3 && $res->tuteur_entreprise==0) {
                                    $role = TUTEUR;                            
                                }
                                elseif ($res->type==3 && $res->tuteur_entreprise==1) {
                                    $role = TUTEUR;                            
                                }
                                elseif ($res->type==4) {
                                   $role = SUPERVISEUR;                            
                                }
                                elseif ($res->type==2) {
                                   $role = ADMIN;                            
                                } 
                                else{
                                    $role = ROLEAUTRES;
                                }
                                $CNX = $this->connexion_model->newconnexion($res->id,'EL V3');

                                $sessionArray = array(
                                    'GUSERID'                  =>$res->id,
                                    'GEXTRANETID'              =>$res->extranet_id,
                                    'GUSERLOGIN'               =>$res->login,
                                    'GUSER'                    =>$res->prenom." ".$res->nom,
                                    'GUSERINITIAL'             =>$res->nom[0],
                                    'GUSERTYPE'                =>$res->type,
                                    'BAR'                      =>$res->acces_bar,
                                    'MODE_ACCES'               =>$res->mode_acces,
                                    'GROUPE'                   =>$res->id_groupe,
                                    'GLOSSAIREONLINE'          =>$this->groupes_model->Request('glossaireenligne',$res->id_groupe),
                                    'ACCES_FONCTIONS_ADMIN'    =>$res->acces_fonctions_admin,
                                    'TUTEUR_ENTREPRISE'        =>$res->tuteur_entreprise,
                                    'TYPE'                     =>$res->type,
                                    'ROLE'                     =>$role,
                                    'CNX'                      =>$CNX,
                                    'SOCIETE'                  =>$res->description,
                                    'IDSOCIETE'                =>$res->id_societe,
                                    'NBCONNEXION'              =>$res->nbconnexion,
                                    'PDP'                      =>$res->nom_photo,
                                    'IDSTAGE'                  =>$res->type == 0 ? $this->Stag_individu_model->getMaxNumStageByIdMembers($res->id) : NULL,
                                    'isLoggedIn'               =>TRUE,
                                    'site_lang'                =>($res->id_groupe == 0 && $res->type == 3) ? 'english' : $langagePlateform
                                );
                                $this->session->set_userdata($sessionArray);
                                if ($res->type==3){
                                    redirect('/tutordashbord');
                                }
                                elseif ($res->type==4){
                                    redirect('/screen-piloting');
                                }
                                elseif ($res->type==2){
                                    redirect('/admindashbord');
                                }
                                else{
                                    redirect('/dashboard');                                
                                }
                            }

                        }
                        else{                      

                            if ($res->type==0) {
                                $role = STAGIAIRE;
                            }
                            elseif ($res->type==3 && $res->tuteur_entreprise==0) {
                                $role = TUTEUR;                            
                            }
                            elseif ($res->type==3 && $res->tuteur_entreprise==1) {
                                $role = TUTEUR;                            
                            }
                            elseif ($res->type==4) {
                               $role = SUPERVISEUR;                            
                            }
                            elseif ($res->type==2) {
                               $role = ADMIN;                            
                            } 
                            else{
                                $role = ROLEAUTRES;
                            }
                            $CNX = $this->connexion_model->newconnexion($res->id,'EL V3');

                            $sessionArray = array(
                                'GUSERID'                  =>$res->id,
                                'GEXTRANETID'              =>$res->extranet_id,
                                'GUSER'                    =>$res->prenom." ".$res->nom,
                                'GUSERINITIAL'             =>$res->nom[0],
                                'GUSERLOGIN'               =>$res->login,
                                'GUSERTYPE'                =>$res->type,
                                'BAR'                      =>$res->acces_bar,
                                'MODE_ACCES'               =>$res->mode_acces,
                                'GLOSSAIREONLINE'          =>$this->groupes_model->Request('glossaireenligne',$res->id_groupe),
                                'GROUPE'                   =>$res->id_groupe,
                                'ACCES_FONCTIONS_ADMIN'    =>$res->acces_fonctions_admin,
                                'TUTEUR_ENTREPRISE'        =>$res->tuteur_entreprise,
                                'TYPE'                     =>$res->type,
                                'ROLE'                     =>$role,
                                'CNX'                      =>$CNX,
                                'SOCIETE'                  =>$res->description,
                                'IDSOCIETE'                =>$res->id_societe,
                                'NBCONNEXION'              =>$res->nbconnexion,
                                'PDP'                      =>$res->nom_photo,
                                'IDSTAGE'                  =>$res->type == 0 ? $this->Stag_individu_model->getMaxNumStageByIdMembers($res->id) : NULL,
                                'isLoggedIn'               =>TRUE,
                                'site_lang'                =>($res->id_groupe == 0 && $res->type == 3) ? 'english' : $langagePlateform
                            );
                                        
                            $this->session->set_userdata($sessionArray);
                            if ($res->type==3){
                                redirect('/tutordashbord');
                            }
                            elseif ($res->type==2){
                                redirect('/admindashbord');
                            }
                            elseif ($res->type==4){
                                redirect('/screen-piloting');
                            }
                            else{
                                redirect('/dashboard');                                
                            }
                        }
                    }
                }
                else
                {
                    $infoserror = 'Email or password mismatch';

                    $this->sendMailAndSaveErrorLoginFailed($infoserror, $email, $password);
                    $this->session->set_flashdata('error', $infoserror);
                    
                    redirect('/login');
                }
            }
        }

        public function sendMailAndSaveErrorLoginFailed($infoserror, $email, $password){

            $sender = array(
                'email' => 'elearning@forma2plus.com',
                'name'  => 'Forma2Plus - E-learning platform',
            );

            $destination = array(
                'email' => 'informatique@forma2plus.com',
                'name'  => 'Forma2Plus - IT department',
            );

            $replyto = array(
                'email' => 'informatique@forma2plus.com',
                'name'  => 'Forma2Plus - IT department',
            );

            $mailAltBody = '';
            $filePath    = '';

            $subject  = 'Forma2plus - E-learning plateform  : Attempting to connect to the e-learning platform';

            $mailbody = '<span style="color:red;">A user had just tried to connect to the e-elearning platform.<br>Please verify the authenticity of this user.</span><br><br><br>Username: '.$email.'<br>Password: '.$password.'<br><br><br>Thank you.<br><br><br>Best regards';

            $this->sendMailForgotAuthentification($sender,$destination,$subject,$mailbody,$mailAltBody,$filePath,$replyto);


            $data_connexion_failure = array(
                'login'      => $email,
                'password'   => $password,
                'infoserror' => $infoserror,
                'mailsubject'=> $subject,
                'maibody'    => $mailbody,
                'ipadress'   => $this->input->ip_address(),
                'date'       => date('Y-m-d H:i:s')
            );
            return $this->Connexion_failure_model->add($data_connexion_failure);

        }

        public function encryptPasswordUser(){
            $users = $this->membres_model->getAll();
            foreach ($users as $res) {
                $data = array(
                    'password'   => $this->el_f2plus_auth->hash_password($res->password, FALSE),
                    'register_remember_pwd_time'   => time().'_'.$res->password,
                    'date_modif' => time()
                );
                $this->membres_model->update($res->id,$data);
            }
        }

        /*public function decryptPasswordUser(){
            $users = $this->membres_model->getAll();
            foreach ($users as $res) {
                $data = array(
                    'password'   => $this->el_f2plus_auth->hash_password($res->password, FALSE),
                    'date_modif' => time()
                );
                $this->membres_model->update($res->id,$data);
            }
        }*/

        /**
         * This function used to load forgot password view
         */
        public function forgotPassword()
        {
            $this->load->view('forgotPassword');
        }

        public function forgotUserPassword()
        {
            $this->load->library('form_validation');
            
            $this->form_validation->set_rules('email','Email','trim|required|valid_email|xss_clean');
                    
            if($this->form_validation->run() == FALSE)
            {
                $this->session->set_flashdata('error', 'Invalid email address');
                redirect('/login?capt=fg');

            }
            else 
            {
                $user = $this->membres_model->getInfoMembresByMail($this->input->post('email'));

                if (count($user) >= 1 && $user[0]->email != '') {
                    if (!empty($user[0]->date_fin_acces) && $user[0]->date_fin_acces+((24*3600)+(60*60)+60) <= time()) {
                            $this->session->set_flashdata('error', 'Your date of access to the platform has expired');
                            redirect('/login?capt=fg');
                    }
                    else{ 
                        //echo $user[0]->id.' '.$user[0]->login;
                        $forgotten_password_code = $this->el_f2plus_auth->forgotten_password($user[0]->id,$user[0]->login);

                        if ($forgotten_password_code != '') {
                            $mailAltBody = '';
                            $filePath = '';
                            $sender = array(
                                'email' => 'informatique@forma2plus.com',
                                'name'  => 'Forma2Plus - E-learning platform',
                            );
                            $destination = array(
                                'email' => $user[0]->email,
                                'name'  => $user[0]->prenom.' '.$user[0]->nom,
                            );
                            $replyto = array(
                                'email' => 'informatique@forma2plus.com',
                                'name'  => 'Forma2Plus - E-learning platform',
                            );

                            $subject = 'Forma2plus - E-learning plateform  : Resetting your account password';

                            $mailbody = 'Dear '.$user[0]->prenom.' '.$user[0]->nom.',<br><br>';
                            $mailbody .= 'We inform you that a password change request has been made on our site for the customer identifier: <b>'.$user[0]->login.'</b><br><br>If you are the originator of this request and you still wish to replace your password, simply click on the link below, or copy it into your browser.<br><br><br><a href="'.base_url().'reset-password-el?loading='.$forgotten_password_code.'&confort=bose">E-learning Forma2Plus - Reset Password</a><br><br>';
                            
                            $sendMail = $this->sendMailForgotAuthentification($sender,$destination,$subject,$mailbody,$mailAltBody,$filePath,$replyto);
                            if ($sendMail) {
                                $this->session->set_flashdata('success', 'Thank you.<br>We have just sent you an email.<br>Please check your email inbox to reset your e-learning password.');
                                redirect('/login?capt=fg');
                            }
                            else{
                                $this->session->set_flashdata('error', 'Email not sent, <br>Please contact the site administrator.');
                                redirect('/login?capt=fg');
                            }
                        }
                        else{
                            $this->session->set_flashdata('error', 'Sorry, no email address corresponding to this one in the database. For more information, please contact the administrator.');
                            redirect('/login?capt=fg');
                        }
                    }
                }
                else{
                    $this->session->set_flashdata('error', 'Sorry, no email address corresponding to this one in the database. For more information, please contact the administrator.');
                    redirect('/login?capt=fg');
                }
            }
        }

        public function sendMailForgotAuthentification($sender,$destination,$subject,$mailbody,$mailAltBody,$filePath,$replyto){
            $return = false;
            
            if (!class_exists('PHPMailer\PHPMailer\Exception')) {
                require APPPATH . '/libraries/PHPMailer/src/PHPMailer.php';
                require APPPATH . '/libraries/PHPMailer/src/SMTP.php';
                require APPPATH . '/libraries/PHPMailer/src/Exception.php';
                require APPPATH . '/libraries/PHPMailer/vendor/autoload.php';
            }

            $mail = new PHPMailer(true);
            try {
                //Server settings
                $mail->CharSet = 'UTF-8';
                $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
                $mail->isSMTP();                                            //Send using SMTP
                $mail->Host       = $this->config->item("smtp_host_f2plus");                     //Set the SMTP server to send through
                $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
                $mail->Username   = $this->config->item("smtp_username_f2plus");                     //SMTP username
                $mail->Password   = $this->config->item("smtp_password_f2plus");                               //SMTP password
                $mail->SMTPSecure = $this->config->item("smtp_secure_f2plus");            //Enable implicit TLS encryption
                $mail->Port       = $this->config->item("smtp_port_f2plus"); //TCP port to connect to; use 587 if you have set 
                $mail->isSendmail();   

                //Recipients
                $sender['email'] != '' ? $mail->setFrom($sender['email'], $sender['name'], true) : '';
                $destination['email'] != '' ? $mail->addAddress($destination['email'], $destination['email']) : '';     //Add a recipient
                $replyto['email'] != '' ? $mail->addReplyTo($replyto['email'], $replyto['email']) : '';
                //Content
                $mail->isHTML(true);                                  //Set email format to HTML
                $mail->Subject = $subject;
                $mail->Body    = $mailbody;
                $mail->AltBody = $mailAltBody;

                $mail->send();
                $return = true;
            } catch (Exception $e) {
                $return = false;
            }

            return $return;
        }
        
        /**
         * This function used to generate reset password request link
         */
        function resetPasswordUser()
        {
            $status = '';
            
            $this->load->library('form_validation');
            
            $this->form_validation->set_rules('login_email','Email','trim|required|valid_email|xss_clean');
                    
            if($this->form_validation->run() == FALSE)
            {
                $this->forgotPassword();
            }
            else 
            {
                $email = $this->input->post('login_email');
                
                if($this->login_model->checkEmailExist($email))
                {
                    $encoded_email = urlencode($email);
                    
                    $this->load->helper('string');
                    $data['email'] = $email;
                    $data['activation_id'] = random_string('alnum',15);
                    $data['createdDtm'] = date('Y-m-d H:i:s');
                    $data['agent'] = getBrowserAgent();
                    $data['client_ip'] = $this->input->ip_address();
                    
                    $save = $this->login_model->resetPasswordUser($data);                
                    
                    if($save)
                    {
                        $data1['reset_link'] = base_url() . "resetPasswordConfirmUser/" . $data['activation_id'] . "/" . $encoded_email;
                        $userInfo = $this->login_model->getCustomerInfoByEmail($email);

                        if(!empty($userInfo)){
                            $data1["name"] = $userInfo[0]->name;
                            $data1["email"] = $userInfo[0]->email;
                            $data1["message"] = "Reset Your Password";
                        }

                        $sendStatus = resetPasswordEmail($data1);

                        if($sendStatus){
                            $status = "send";
                            setFlashData($status, "Reset password link sent successfully, please check mails.");
                        } else {
                            $status = "notsend";
                            setFlashData($status, "Email has been failed, try again.");
                        }
                    }
                    else
                    {
                        $status = 'unable';
                        setFlashData($status, "It seems an error while sending your details, try again.");
                    }
                }
                else
                {
                    $status = 'invalid';
                    setFlashData($status, "This email is not registered with us.");
                }
                redirect('/forgotPassword');
            }
        }

        // This function used to reset the password 
        function resetPasswordConfirmUser($activation_id, $email)
        {
            // Get email and activation code from URL values at index 3-4
            $email = urldecode($email);
            
            // Check activation id in database
            $is_correct = $this->login_model->checkActivationDetails($email, $activation_id);
            
            $data['email'] = $email;
            $data['activation_code'] = $activation_id;
            
            if ($is_correct == 1)
            {
                $this->load->view('newPassword', $data);
            }
            else
            {
                redirect('/login');
            }
        }
        
        // This function used to create new password
        function createPasswordUser()
        {
            $status = '';
            $message = '';
            $email = $this->input->post("email");
            $activation_id = $this->input->post("activation_code");
            
            $this->load->library('form_validation');
            
            $this->form_validation->set_rules('password','Password','required|max_length[20]');
            $this->form_validation->set_rules('cpassword','Confirm Password','trim|required|matches[password]|max_length[20]');
            
            if($this->form_validation->run() == FALSE)
            {
                $this->resetPasswordConfirmUser($activation_id, urlencode($email));
            }
            else
            {
                $password = $this->input->post('password');
                $cpassword = $this->input->post('cpassword');
                
                // Check activation id in database
                $is_correct = $this->login_model->checkActivationDetails($email, $activation_id);
                
                if($is_correct == 1)
                {                
                    $this->login_model->createPasswordUser($email, $password);
                    
                    $status = 'success';
                    $message = 'Password changed successfully';
                }
                else
                {
                    $status = 'error';
                    $message = 'Password changed failed';
                }
                
                setFlashData($status, $message);

                redirect("/login");
            }
        }

        public function changePassword($extranetId,$idMembre){
            $returns = array();        
            if (isset($_POST)) {
                $new_password    = $_POST['new_password'];
                $confirm_password    = $_POST['confirm_password'];
                if ($new_password == $confirm_password) {
                    $data = array(
                        'password' => $this->el_f2plus_auth->hash_password($new_password, FALSE),
                        'register_remember_pwd_time' => time().'_'.$new_password,
                        'date_modif' => time()
                    );
                    if ($this->membres_model->update($idMembre,$data)) {
                        $nbconnexion = $this->membres_model->Request('nbconnexion',$idMembre);
                        $sessionArray = array(
                            'NBCONNEXION' => $nbconnexion
                        ); 
                        $this->session->set_userdata($sessionArray);
                        $this->global['NBCONNEXION'] = $nbconnexion;
                        $returns['globaldata'] = $this->global;
                        $returns['success'] = true;

                    }          
                }          
                else{
                    $returns['success'] = false;
                    $returns['error'] = 'The confirmation password is incorrect';
                } 
            }

            echo json_encode($returns);
        }

        public function resetPasswordEl(){
            if (isset($_GET['loading'])) {
                $data['forgotten_password_code'] = $_GET['loading'];
                $data['GEXTRANETID'] = $this->membres_model->RequestByPasswordForgotten('extranet_id',$_GET['loading']);
                $data['GUSERID'     ] = $this->membres_model->RequestByPasswordForgotten('id',$_GET['loading']);
                $this->load->view('reinitialiseUserPsswd', $data);
            }
            else{
                redirect("/login");
            }
        }

        public function reinitialiseUserPsswd(){
            if (isset($_GET['id'])) {
                $register_remember_pwd_time = $this->membres_model->Request('register_remember_pwd_time',$_GET['id']);
                $expoldePassword = explode('_', $register_remember_pwd_time);
                $data = array(
                    'password'   => $this->el_f2plus_auth->hash_password($expoldePassword[1], FALSE),
                    'date_modif' => time()
                );
                if (is_array($data)) {   
                    $mailAltBody = '';
                    $filePath = '';
                    $sender = array(
                        'email' => 'informatique@forma2plus.com',
                        'name'  => 'Forma2Plus - Plateforme E-learning',
                    );
                    $destination = array(
                        'email' => $this->membres_model->Request('email',$_GET['id']),
                        'name'  => $this->membres_model->Request('prenom',$_GET['id']).' '.$this->membres_model->Request('nom',$_GET['id']),
                    );
                    $replyto = array(
                        'email' => 'informatique@forma2plus.com',
                        'name'  => 'Forma2Plus - Plateforme E-learning',
                    );

                    $subject = 'Forma2plus - Plateforme E-learning : Changement de Login';

                    $mailbody = 'Bonjour,<br><br>Nous tenons à vous informer qu\'en raison d\'une mise à jour de nos mesures de sécurité informatique,<br>votre identifiant de connexion à notre plateforme E-learning a été modifié.<br><br>Désormais, vous devez vous connecter en utilisant votre adresse e-mail comme login.<br><br>Nous vous prions de bien vouloir nous excuser pour le désagrément occasionné.<br><br>Cordialement,<br><br><br><br><a href="#" style="text-decoration: none;">Le service informatique</a><br><a href="https://forma2plus.com" target="_blank">Forma2plus</a><br><br><a href="#" style="text-decoration: none;">Service informatique</a><br><a href="#">informatique@forma2plus.com</a><br><br><a href="#" style="text-decoration: none;">Tel : 33 (0) 1 47 31 13 13</a>';
                    
                    $sendMail = $this->sendMailForgotAuthentification($sender,$destination,$subject,$mailbody,$mailAltBody,$filePath,$replyto);
                    if ($sendMail) {
                        $this->membres_model->update($_GET['id'],$data); 
                    }
                    else{
                    }

                }
            }
        }

        public function reinitialiseUserPsswdAndSendMail(){
            $dateTime = 1698796800; //after 01-11-2023
            $users = array();
            $i = 0;
            $allResult = $this->membres_model->getAllDuplicateByConnexionDate($dateTime);
            foreach($allResult as $res){
                $allInfosUser = $this->membres_model->getAllInfosDuplicateByLoginAndDateTime($res->login,$dateTime);
                foreach($allInfosUser as $user){
                    $expoldePassword = explode('_', $user->register_remember_pwd_time);
                    $data = array(
                        'login'      => $user->email,
                        'password'   => $this->el_f2plus_auth->hash_password($expoldePassword[1], FALSE),
                        'date_modif' => time()
                    );

                    $mailAltBody = '';
                    $filePath = '';
                    $sender = array(
                        'email' => 'informatique@forma2plus.com',
                        'name'  => 'Forma2Plus - Plateforme E-learning',
                    );
                    $destination = array(
                        'email' => $user->email,
                        //'email' => 'randrianarikoto@gmail.com',
                        'name'  => $user->prenom.' '.$user->nom,
                    );
                    $replyto = array(
                        'email' => 'informatique@forma2plus.com',
                        'name'  => 'Forma2Plus - Plateforme E-learning',
                    );

                    $subject = 'Forma2plus - Plateforme E-learning : Changement de Login';

                    $mailbody = 'Bonjour,<br><br>Nous tenons à vous informer qu\'en raison d\'une mise à jour de nos mesures de sécurité informatique,<br>votre identifiant de connexion à notre plateforme E-learning a été modifié.<br><br>Désormais, vous devez vous connecter en utilisant votre adresse e-mail comme login.<br><br>Nous vous prions de bien vouloir nous excuser pour le désagrément occasionné.<br><br>Cordialement,<br><br><br><br><a href="#" style="text-decoration: none;">Le service informatique</a><br><a href="https://forma2plus.com" target="_blank">Forma2plus</a><br><br><a href="#" style="text-decoration: none;">Service informatique</a><br><a href="#">informatique@forma2plus.com</a><br><br><a href="#" style="text-decoration: none;">Tel : 33 (0) 1 47 31 13 13</a>';

                    //die($mailbody);
                    
                    $sendMail = $this->sendMailForgotAuthentification($sender,$destination,$subject,$mailbody,$mailAltBody,$filePath,$replyto);
                    if ($sendMail) {
                        $this->membres_model->update($user->id,$data);
                        //$this->session->set_flashdata('success', 'Thank you.<br>We have just sent you an email.<br>Please check your email inbox to reset your e-learning password.');
                        //redirect('/login?capt=fg');
                    }
                    else{
                        //$this->session->set_flashdata('error', 'Email not sent, <br>Please contact the site administrator.');
                        //redirect('/login?capt=fg');
                    }
                }
            }
        }


        public function SwitchToV1(){
            if ($this->session->userdata ('TRACKINGID') != '') {
                $this->tracking_model->update($this->session->userdata ('TRACKINGID'));
            }
            $this->connexion_model->destroy($this->session->userdata ('CNX'));  
            $this->session->sess_destroy ();    
            redirect ($this->config->item('elearning-version-1').'authorization-baerer?token='.$this->session->userdata ('TOKEN_V1').'&token_vf='.$this->session->userdata ('TOKEN_EL_VF'));
        }

    }

?>