<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Bors
 * @version : 1.1
 * @since : 22 November 2018
 */
class Todolist extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('user_model');
        $this->load->model('connexion_model');
        $this->isLoggedIn();   
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->global['pageTitle'] = 'E-learning : Forma2+';
        $this->$global['content'] = 'error_404'; // Let View name 
        
        $this->loadViews("todoList/viewstodo", $this->global, NULL , NULL);
    }


    
    public function viewTodo(){
        $this->global['pageTitle'] = 'E-learning : Forma2+';
        
        $this->loadViews("todoList/viewstodo", $this->global, NULL , NULL);
    }

    public function gviewIfrm ($REPGROUP,$NAMEFILE,$EXT) {
     
        $this->global['pageTitle'] = 'E-learning : Forma2+';
        $this->global['NAMEFILE'] = $NAMEFILE;
        $this->global['EXT'] = $EXT;
        $this->global['REPGROUP'] = $REPGROUP;

        $this->loadViews("todoList/gview", $this->global, NULL , NULL);
    }
    
   
}

?>