<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Domains
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 31 January 2019
 */
class Matiere extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('matieres_model');
        $this->load->model('formations_model');
        $this->load->model('domaines_model');
        $this->load->model('NiveauCorrespondantElExtranet_model');
        $this->isLoggedIn();   
        
    }
  
    public function index(){
    }

    public function getInfosByDomaine(){
        $i = 0;
        $return = array();
        if (isset($_POST['domaine_id'])) {
            $allResults = $this->matieres_model->getByDomaine($_POST['domaine_id']);  
            foreach ($allResults as $res) {
                $return[$i] = array(
                    'matiere_id' => $res->matiere_id , 
                    'name'       => $res->name , 
                    'domaine_id' => $res->domaine_id
                );
                $i++;
            }
        }
        echo json_encode($return);
    }

}

?>