<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Newsletter extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();    
        $this->isLoggedIn();   
        $this->load->model('newsletter_model');
        $this->load->model('utilities_model');
        $this->width      = "1200";
        $this->height     = "1280";
        $this->date       = time();
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->global['pageTitle']  = 'E-learning : Newsletter management';
        $data['listMonth']   = $this->newsletter_model->listMonth();
        $data['listArticle'] = $this->newsletter_model->getAllArticle();
        
        $this->loadViews("admin/newsletter/list", $this->global,$data, NULL );
    }

        public function getThumb(){
        ini_set('max_execution_time', 300); //300 seconds = 5 minutes
        if (isset($_POST)) {
            $ret = "";
            if (isset($_POST['Org']) && $_POST['Org'] != "" && !isset($_POST['ACTION'])) {
            
                $thumbnailFiles = "thumbnail_".$this->date.'_'.$this->session->userdata('GUSERID').'.png';
                
                if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                    mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
                }  
                $fileLocation = REP_ACTIVITY_SEQUENCE."/".$thumbnailFiles; 
                    
                /*On verifie tous d'abord si vignette existe déjà*/
                $nb = $this->utilities_model->getthumbNLS($_POST['idM'],$_POST['idA'])->num_rows();
                //Existe
                if ($nb >= 1) {
                    //Verifion si le fichier existe vraiment dans le dossier local
                    $result = $this->utilities_model->getthumbNLS($_POST['idM'],$_POST['idA'])->result();
                    foreach ($result as $res) {
                        if (is_file(REP_ACTIVITY_SEQUENCE.$res->thumbnail)) {//fichier existe,
                            if ($this->validate_url($_POST['Org'])) {
                            
                                $thumb = $this->generateThumbnail($_POST['Org'],$this->width,$this->height,$fileLocation);
                                if ($thumb) {
                                    $thumbinfo = array(            
                                        "thumbnail"         => $thumbnailFiles, 
                                        "date_create"       => $this->date, 
                                        'user_create'       =>$this->session->userdata ('GUSERID')
                                    );
                                    $this->utilities_model->updateThumbNL1($res->id,$thumbinfo);
                                }
                            }
                        }
                        else{//fichier existe pas, alors on met à jour les données et on regénére de nouveau le thumbnail
                            if ($this->validate_url($_POST['Org'])) {
                            
                                $thumb = $this->generateThumbnail($_POST['Org'],$this->width,$this->height,$fileLocation);
                                if ($thumb) {
                                    $thumbinfo = array(            
                                        "thumbnail"         => $thumbnailFiles, 
                                        "date_create"       => $this->date, 
                                        'user_create'       =>$this->session->userdata ('GUSERID')
                                    );
                                    $this->utilities_model->updateThumbNL1($res->id,$thumbinfo);
                                }
                            }
                        }
                    }
                    
                }
                else{ //Existe pas
                    if ($this->validate_url($_POST['Org'])) {
                        $thumb = $this->generateThumbnail($_POST['Org'],$this->width,$this->height,$fileLocation);

                        if ($thumb) {
                            $thumbinfo = array(            
                                'idMonth'           => $_POST['idM'], 
                                "idArticle"         => $_POST['idA'], 
                                "thumbnail"         => $thumbnailFiles, 
                                "date_create"       => $this->date, 
                                'user_create'       =>$this->session->userdata ('GUSERID')
                            );
                            $this->utilities_model->addthumbNL($thumbinfo);
                        }
                    }
                }

            }
            elseif (isset($_POST['ACTION']) && $_POST['ACTION'] == "ALL" ) {
                $article = $this->newsletter_model->listArticle($_POST['idM']);
                foreach ($article as $res) {
                    $thumbnailFiles = "thumbnail_".$this->date.'_'.$this->session->userdata('GUSERID').'.png';
                    
                    if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                        mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
                    }  
                    $fileLocation = REP_ACTIVITY_SEQUENCE."/".$thumbnailFiles; 
                        
                    /*On verifie tous d'abord si vignette existe déjà*/
                    $result = $this->utilities_model->getthumbNLS($_POST['idM'],$res->ID)->result();
                    //Existe
                    if (count($result) >= 1) {
                        foreach ($result as $res1) {
                            if (is_file(REP_ACTIVITY_SEQUENCE.$res1->thumbnail)) {//fichier existe,
                                if ($this->validate_url($res->origine)) {
                                    $thumb = $this->generateThumbnail($res->origine,$this->width,$this->height,$fileLocation);
                                    if ($thumb) {
                                        $thumbinfo = array(            
                                            "thumbnail"         => $thumbnailFiles, 
                                            "date_create"       => $this->date, 
                                            'user_create'       =>$this->session->userdata ('GUSERID')
                                        );
                                        $this->utilities_model->updateThumbNL1($res1->id,$thumbinfo);
                                    }
                                }
                            }
                            else{//fichier existe pas, alors on met à jour les données et on regénére de nouveau le thumbnail
                                if ($this->validate_url($res->origine)) {
                                    $thumb = $this->generateThumbnail($res->origine,$this->width,$this->height,$fileLocation);
                                    if ($thumb) {
                                        $thumbinfo = array(            
                                            "thumbnail"         => $thumbnailFiles, 
                                            "date_create"       => $this->date, 
                                            'user_create'       =>$this->session->userdata ('GUSERID')
                                        );
                                        $this->utilities_model->updateThumbNL1($res1->id,$thumbinfo);
                                    }
                                }
                            }
                        }
                        
                    }
                    else{ //Existe pas
                        if ($this->validate_url($res->origine)) {
                            $thumb = $this->generateThumbnail($res->origine,$this->width,$this->height,$fileLocation);

                            if ($thumb) {
                                $thumbinfo = array(            
                                    'idMonth'           => $_POST['idM'], 
                                    "idArticle"         => $res->ID, 
                                    "thumbnail"         => $thumbnailFiles, 
                                    "date_create"       => $this->date, 
                                    'user_create'       =>$this->session->userdata ('GUSERID')
                                );
                                $this->utilities_model->addthumbNL($thumbinfo);
                            }
                        }
                    }
                }
            }
          
            echo "1";
        }
        
    }


    public function generateThumbNlByOrigin(){
        $return = array();
        ini_set('max_execution_time', 300); //300 seconds = 5 minutes
        if (isset($_POST)) {

            if (isset($_POST['origine']) && $_POST['origine'] != "" && !isset($_POST['ACTION'])) {
            
                $thumbnailFiles = "thumbnail_".$this->date.'_'.$this->session->userdata('GUSERID').'.png';
                
                if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                    mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
                }  
                $fileLocation = REP_ACTIVITY_SEQUENCE."/".$thumbnailFiles; 
                    
                /*On verifie tous d'abord si vignette existe déjà*/
                $thumbResult = $this->utilities_model->getThumbNlResult($_POST['monthId'],$_POST['artcileId']);
                //Existe
                if (count($thumbResult) >= 1) {
                    //Verifion si le fichier existe vraiment dans le dossier local
                  
                    if (is_file(REP_ACTIVITY_SEQUENCE.$thumbResult[0]->thumbnail)) {//fichier existe,
                        if ($this->validate_url($_POST['origine'])) {
                        
                            $thumb = $this->generateThumbnail($_POST['origine'],$this->width,$this->height,$fileLocation);
                            if ($thumb) {
                                $thumbinfo = array(            
                                    "thumbnail"         => $thumbnailFiles, 
                                    "date_create"       => $this->date, 
                                    'user_create'       =>$this->session->userdata ('GUSERID')
                                );                                    
                                $return['message'] = array(
                                    'status' => 'update0', 
                                    'uploadFileUrl' => base_url().'groupes/ACTIVITES/'.$thumbnailFiles,
                                    'infos' => $this->utilities_model->updateThumbNL1($thumbResult[0]->id,$thumbinfo)
                                );
                            }
                        }
                    }
                    else{//fichier existe pas, alors on met à jour les données et on regénére de nouveau le thumbnail
                        if ($this->validate_url($_POST['origine'])) {
                        
                            $thumb = $this->generateThumbnail($_POST['origine'],$this->width,$this->height,$fileLocation);
                            if ($thumb) {
                                $thumbinfo = array(            
                                    "thumbnail"         => $thumbnailFiles, 
                                    "date_create"       => $this->date, 
                                    'user_create'       =>$this->session->userdata ('GUSERID')
                                );
                                $return['message'] = array(
                                    'status' => 'update1', 
                                    'uploadFileUrl' => base_url().'groupes/ACTIVITES/'.$thumbnailFiles,
                                    'infos' => $this->utilities_model->updateThumbNL1($thumbResult[0]->id,$thumbinfo)
                                );
                            }
                        }
                    }
                    
                }
                else{ //Existe pas
                    if ($this->validate_url($_POST['origine'])) {
                        $thumb = $this->generateThumbnail($_POST['origine'],$this->width,$this->height,$fileLocation);

                        if ($thumb) {
                            $thumbinfo = array(            
                                'idMonth'           => $_POST['monthId'], 
                                "idArticle"         => $_POST['artcileId'], 
                                "thumbnail"         => $thumbnailFiles, 
                                "date_create"       => $this->date, 
                                'user_create'       =>$this->session->userdata ('GUSERID')
                            );
                            
                            $return['message'] = array(
                                'status' => 'insert', 
                                'uploadFileUrl' => base_url().'groupes/ACTIVITES/'.$thumbnailFiles,
                                'infos' => $this->utilities_model->addthumbNL($thumbinfo)
                            );
                        }
                    }
                }

            }
            elseif (isset($_POST['ACTION']) && $_POST['ACTION'] == "ALL" ) {
                $article = $this->newsletter_model->listArticle($_POST['monthId']);
                foreach ($article as $res) {
                    $thumbnailFiles = "thumbnail_".$this->date.'_'.$this->session->userdata('GUSERID').'.png';
                    
                    if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                        mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
                    }  
                    $fileLocation = REP_ACTIVITY_SEQUENCE."/".$thumbnailFiles; 
                        
                    /*On verifie tous d'abord si vignette existe déjà*/
                    $result = $this->utilities_model->getthumbNLS($_POST['monthId'],$res->ID)->result();
                    //Existe
                    if (count($result) >= 1) {
                        foreach ($result as $res1) {
                            if (is_file(REP_ACTIVITY_SEQUENCE.$res1->thumbnail)) {//fichier existe,
                                if ($this->validate_url($res->origine)) {
                                    $thumb = $this->generateThumbnail($res->origine,$this->width,$this->height,$fileLocation);
                                    if ($thumb) {
                                        $thumbinfo = array(            
                                            "thumbnail"         => $thumbnailFiles, 
                                            "date_create"       => $this->date, 
                                            'user_create'       =>$this->session->userdata ('GUSERID')
                                        );                       
                                        $return['message'] = array(
                                            'status' => 'update0', 
                                            'uploadFileUrl' => base_url().'groupes/ACTIVITES/'.$thumbnailFiles,
                                            'infos' => $this->utilities_model->updateThumbNL1($res->id,$thumbinfo)
                                        );
                                    }
                                }
                            }
                            else{//fichier existe pas, alors on met à jour les données et on regénére de nouveau le thumbnail
                                if ($this->validate_url($res->origine)) {
                                    $thumb = $this->generateThumbnail($res->origine,$this->width,$this->height,$fileLocation);
                                    if ($thumb) {
                                        $thumbinfo = array(            
                                            "thumbnail"         => $thumbnailFiles, 
                                            "date_create"       => $this->date, 
                                            'user_create'       =>$this->session->userdata ('GUSERID')
                                        );
                                                                            
                                        $return['message'] = array(
                                            'status' => 'update1', 
                                            'uploadFileUrl' => base_url().'groupes/ACTIVITES/'.$thumbnailFiles,
                                            'infos' => $this->utilities_model->updateThumbNL1($res->id,$thumbinfo)
                                        );
                                    }
                                }
                            }
                        }
                        
                    }
                    else{ //Existe pas
                        if ($this->validate_url($res->origine)) {
                            $thumb = $this->generateThumbnail($res->origine,$this->width,$this->height,$fileLocation);

                            if ($thumb) {
                                $thumbinfo = array(            
                                    'idMonth'           => $_POST['monthId'], 
                                    "idArticle"         => $res->ID, 
                                    "thumbnail"         => $thumbnailFiles, 
                                    "date_create"       => $this->date, 
                                    'user_create'       =>$this->session->userdata ('GUSERID')
                                );
                                                                    
                                $return['message'] = array(
                                    'status' => 'insert', 
                                    'uploadFileUrl' => base_url().'groupes/ACTIVITES/'.$thumbnailFiles,
                                    'infos' => $this->utilities_model->addthumbNL($thumbinfo)
                                );
                                
                            }
                        }
                    }
                }
            }
          
        }
    
        echo json_encode($return);
        
    }
}

?>