<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

class FavoriteClassification extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->isLoggedIn(); 
    }
    public function merge(){
        if (isset($_POST['id_stat_programe'])) {
            if (isset($_GET['type']) && $_GET['type'] == 'todolist') {
                if ($this->isTuteurConnet()) {
                    //verify if todo exist in program stat;
                    $exist = $this->stat_prg_model->getFavorisByIdProgramType($_POST['id_stat_programe'],"todolist");
                    if ($exist >= 1) {
                        if (is_numeric($_POST['classification'])) {
                            $data = array(
                                'id_classification_favoris' => $_POST['classification']
                            );
                            $this->stat_prg_model->update($_POST['id_stat_programe'],$data);
                        } 
                        else{
                            $data = array(
                                'intitule'    => $_POST['classification'],
                                'user_create' => $this->session->userdata ('GUSERID'),
                                'id_groupe' => $this->session->userdata ('STAGIAIREGRP'),
                                'date'        => time(),
                            );
                            $id_classification = $this->classificationFavoris_Model->add($data);
                            $data_stat = array(
                                'id_classification_favoris' => $id_classification
                            );
                            $this->stat_prg_model->update($_POST['id_stat_programe'],$data_stat);
                        }
                    }
                    else{

                        $data = array('id_membres' => $this->session->userdata ('STAGIAIREID'), 
                            'user_create'   => $this->session->userdata ('GUSERID'),
                            'id_prg'        => $_POST['id_stat_programe'],
                            'intitule'      => $this->todolist_model->Request('sequence',$_POST['id_stat_programe']),
                            'status'        => 1,
                            'type'          => 'todolist',
                            'commentaire'   => '',
                            'date_creation' => time()
                        );
                        $idFav = $this->stat_prg_model->add($data);
                        if (is_numeric($_POST['classification'])) {
                            $data = array(
                                'id_classification_favoris' => $_POST['classification']
                            );
                            $this->stat_prg_model->update($idFav,$data);
                        } 
                        else{
                            $data = array(
                                'intitule'    => $_POST['classification'],
                                'user_create' => $this->session->userdata ('GUSERID'),
                                'id_groupe' => $this->session->userdata ('STAGIAIREGRP'),
                                'date'        => time(),
                            );
                            $id_classification = $this->classificationFavoris_Model->add($data);
                            $data_stat = array(
                                'id_classification_favoris' => $id_classification
                            );
                            $this->stat_prg_model->update($idFav,$data_stat);
                        } 
                    }
                }
                else{
                    //verify if todo exist in program stat;
                    $exist = $this->stat_prg_model->getFavorisByIdProgramType($_POST['id_stat_programe'],"todolist");
                    if ($exist >= 1) {
                        if (is_numeric($_POST['classification'])) {
                            $data = array(
                                'id_classification_favoris' => $_POST['classification']
                            );
                            $this->stat_prg_model->update($_POST['id_stat_programe'],$data);
                        } 
                        else{
                            $data = array(
                                'intitule'    => $_POST['classification'],
                                'user_create' => $this->session->userdata ('GUSERID'),
                                'id_groupe' => $this->session->userdata ('GROUPE'),
                                'date'        => time(),
                            );
                            $id_classification = $this->classificationFavoris_Model->add($data);
                            $data_stat = array(
                                'id_classification_favoris' => $id_classification
                            );
                            $this->stat_prg_model->update($_POST['id_stat_programe'],$data_stat);
                        }
                    }
                    else{

                        $data = array('id_membres' => $this->session->userdata ('GUSERID'), 
                            'user_create'   => $this->session->userdata ('GUSERID'),
                            'id_prg'        => $_POST['id_stat_programe'],
                            'intitule'      => $this->todolist_model->Request('sequence',$_POST['id_stat_programe']),
                            'status'        => 1,
                            'type'          => 'todolist',
                            'commentaire'   => '',
                            'date_creation' => time()
                        );
                        $idFav = $this->stat_prg_model->add($data);
                        if (is_numeric($_POST['classification'])) {
                            $data = array(
                                'id_classification_favoris' => $_POST['classification']
                            );
                            $this->stat_prg_model->update($idFav,$data);
                        } 
                        else{
                            $data = array(
                                'intitule'    => $_POST['classification'],
                                'user_create' => $this->session->userdata ('GUSERID'),
                                'id_groupe' => $this->session->userdata ('GROUPE'),
                                'date'        => time(),
                            );
                            $id_classification = $this->classificationFavoris_Model->add($data);
                            $data_stat = array(
                                'id_classification_favoris' => $id_classification
                            );
                            $this->stat_prg_model->update($idFav,$data_stat);
                        } 
                    }
                }
            }  
            else{ 
                if ($this->isTuteurConnet()) {
                    if (is_numeric($_POST['classification'])) {
                        $data = array(
                            'id_classification_favoris' => $_POST['classification']
                        );
                        $this->stat_prg_model->update($_POST['id_stat_programe'],$data);
                    } 
                    else{
                        $data = array(
                            'intitule'    => $_POST['classification'],
                            'user_create' => $this->session->userdata ('GUSERID'),
                            'id_groupe' => $this->session->userdata ('STAGIAIREGRP'),
                            'date'        => time(),
                        );
                        $id_classification = $this->classificationFavoris_Model->add($data);
                        $data_stat = array(
                            'id_classification_favoris' => $id_classification
                        );
                        $this->stat_prg_model->update($_POST['id_stat_programe'],$data_stat);
                    }

                    if (isset($_POST['ch']) && $_POST['ch'] != '') {
                        $idCh = '';
                        if (is_numeric($_POST['ch'])) {
                            $idCh = $_POST['ch'];
                        }
                        else{
                            $data = array(
                                'intitule'            => $_POST['ch'],
                                'commentaire'         => '',
                                'back_color'          => '#000000',
                                'user_create'         => $this->session->userdata('GUSERID'),
                                'id_groupe'           => $this->session->userdata('STAGIAIREGRP'),
                                'date'                => time()
                            );
                            $idCh    = $this->coursHistorik_model->add($data);
                        }
                        $linkInfo = array(
                            'titre'=>$this->sequence_model->RequestSeqByIdAndNumero('titre',$this->stat_prg_model->Request('id_prg',$_POST['id_stat_programe']),$this->stat_prg_model->Request('numero',$_POST['id_stat_programe'])), 
                            'link'=>$this->sequence_model->RequestSeqByIdAndNumero('final_url',$this->stat_prg_model->Request('id_prg',$_POST['id_stat_programe']),$this->stat_prg_model->Request('numero',$_POST['id_stat_programe'])),
                            'type'=>0, 
                            'commentaire'=>"",
                            'date_create'=>date('Y-m-d'), 
                            'user_create'=>$this->session->userdata ('GUSERID'),
                            "thumbnail_file"=>$this->sequence_model->RequestSeqByIdAndNumero('thumbnail_file',$this->stat_prg_model->Request('id_prg',$_POST['id_stat_programe']),$this->stat_prg_model->Request('numero',$_POST['id_stat_programe']))
                        );
                        $idNewLink = $this->todolist_model->addnewlink($linkInfo);
                        $this->todolist_model->addTodo($idNewLink,$this->session->userdata ('STAGIAIREGRP'),$idCh);

                        
                        if ($linkInfo['thumbnail_file'] != "") {
                            $rep      =  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/THUMBNAIL'.$this->session->userdata('GUSERID');
                            if ( ! is_dir($rep) ) {
                                mkdir($rep, 0755,true);
                            }
                            $sourceFile      =  REP_ACTIVITY_SEQUENCE.$linkInfo['thumbnail_file'];
                            if (is_file($sourceFile)) {
                                copy($sourceFile,$rep.'/'.$linkInfo['thumbnail_file']);
                            }
                        }
                    }
                }
                else{
                    if (is_numeric($_POST['classification'])) {
                        $data = array(
                            'id_classification_favoris' => $_POST['classification']
                        );
                        $this->stat_prg_model->update($_POST['id_stat_programe'],$data);
                    } 
                    else{
                        $data = array(
                            'intitule'    => $_POST['classification'],
                            'user_create' => $this->session->userdata ('GUSERID'),
                            'id_groupe' => $this->session->userdata ('GROUPE'),
                            'date'        => time(),
                        );
                        $id_classification = $this->classificationFavoris_Model->add($data);
                        $data_stat = array(
                            'id_classification_favoris' => $id_classification
                        );
                        $this->stat_prg_model->update($_POST['id_stat_programe'],$data_stat);
                    } 
                } 
            } 
        }
        echo "1";
    }
    public function mergeSequence(){
        if (isset($_POST['dataSerialise'])) {
            $data = array(
                'id_membres'                 => $this->session->userdata ('GUSERID'), 
                'user_create'                => $this->session->userdata ('GUSERID'),
                'id_prg'                     => $_POST['dataSerialise']['id_sequence'],
                'numero'                     => $_POST['dataSerialise']['numero_sequence'],
                'id_classification_favoris'  => $_POST['dataSerialise']['classification'],
                'module_id'                  => isset($_POST['module_id']) ? $_POST['module_id'] : NULL,
                'intitule'                   => $_POST['dataSerialise']['intitle_seuquence'],
                'status'                     => 1,
                'type'                       => $_POST['dataSerialise']['type_stat_programme'],
                'commentaire'                => '',
                'date_creation'              => time()
            );
            $dataResultControl = $this->stat_prg_model->verifyExistance($data);
            if (count($dataResultControl) < 1) {
                $this->stat_prg_model->add($data);
            }
            return '1';
        }
    }

    public function edit(){
        $retour = array();
        if (isset($_POST['inputEditName'])) {
            $data = array(
                'intitule'    => $_POST['inputEditName'],
                'date'        => time()
            );
            $retour['idUpdate'] = $_POST['inputEditId'];
            $retour['nameUpdate'] = $_POST['inputEditName'];
            $retour['update'] = $this->classificationFavoris_Model->update($_POST['inputEditId'],$data);
        }

        echo json_encode($retour);
    }
    public function new(){
        $return = array();
        if (isset($_POST['intitule'])) {
            $data = array(
                'intitule'            => $_POST['intitule'],
                'user_create'         => $this->session->userdata ('GUSERID'),
                'id_groupe' => $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREGRP') :  $this->session->userdata ('GROUPE'),
                'date'                => time(),
            );
            $return['id'] = $this->classificationFavoris_Model->add($data);
        }
        echo json_encode($return);
    }

    public function del(){
        if (isset($_POST['id_program_stat'])) {
            $this->classificationFavoris_Model->delete($_POST['id_program_stat']);
            echo '1';
        }
    }

    public function delclassandfav(){
        $retour = array();
        if (isset($_POST['id_class'])) {
            $this->stat_prg_model->deleteByClass($_POST['id_class']);            
            $this->classificationFavoris_Model->delete($_POST['id_class']);
            $retour['idDelete'] = $_POST['id_class'];
        }
        echo json_encode($retour);
    }

    public function getAllByKey(){
        $output = '';
        if (isset($_POST['key'])) {
            $output   .= '<ul class="nav classification-favoris-list">';
            if ($this->isTuteurConnet()) {
                $allResult = $this->classificationFavoris_Model->getAllByKey($_POST['key'],$this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP'));
            }
            else{
                $allResult = $this->classificationFavoris_Model->getTraineeAllByKey($_POST['key'],$this->session->userdata ('GROUPE'));
            }
            if (count($allResult) >= 1) {                
                foreach ($allResult as $res) {
                    $output   .= '<li class="classification-favoris-list-data">'.$res->intitule.'</li>';
                }
            }
            else{
                $output   .= '<li class="classification-favoris-list-data">No data found</li>';
            }
            $output   .= '</ul>';
        }
        echo $output;
    }

    public function classify(){
        if (isset($_POST['dataSerialise'])) {
            if ($this->isTuteurConnet()) {
                $id_classification;
                $idCh;
                $retour = '1';
                $sender = Array();
                $replyto = Array();
                $destination = Array();
                $subject = '';
                $mailbody = '';
                $mailAltBody = '';
                $filePath = '';
                $paramsotherdata = '';
                $idHistorikCours;
                //verify if todo exist in program stat;
                if (is_numeric($_POST['dataSerialise']['classification'])) {
                    $data_area = array(
                        'id_membres'                  => $this->session->userdata ('STAGIAIREID'), 
                        'user_create'                 => $this->session->userdata ('GUSERID'),
                        'id_classification_favoris'   => $_POST['dataSerialise']['classification'],
                        'id_prg'                      => $_POST['dataSerialise']['article_id'],
                        'numero'                      => null,
                        'intitule'                    => htmlentities($_POST['dataSerialise']['intitule_article']),
                        'status'                      => $_POST['dataSerialise']['status_article'],
                        'type'                        => $_POST['dataSerialise']['data_type_fav'],
                        'commentaire'                 => $_POST['dataSerialise']['comment_article'],
                        'date_creation'               => time()
                    );
                } 
                else{
                    $data = array(
                        'intitule'    => $_POST['dataSerialise']['classification'],
                        'user_create' => $this->session->userdata ('GUSERID'),
                        'id_groupe' => $this->session->userdata ('STAGIAIREGRP'),
                        'date'        => time(),
                    );

                    $data_area = array(
                        'id_membres'                  => $this->session->userdata ('STAGIAIREID'), 
                        'user_create'                 => $this->session->userdata ('GUSERID'),
                        'id_classification_favoris'   => $this->classificationFavoris_Model->add($data),
                        'id_prg'                      => $_POST['dataSerialise']['article_id'],
                        'numero'                      => null,
                        'intitule'                    => htmlentities($_POST['dataSerialise']['intitule_article']),
                        'status'                      => $_POST['dataSerialise']['status_article'],
                        'type'                        => $_POST['dataSerialise']['data_type_fav'],
                        'commentaire'                 => $_POST['dataSerialise']['comment_article'],
                        'date_creation'               => time()
                    );
                }

                $idStatPr = $this->stat_prg_model->add($data_area);

                if (isset($_POST['dataSerialise']['course-historik']) && $_POST['dataSerialise']['course-historik'] != '') {
                    
                    if (is_numeric($_POST['dataSerialise']['course-historik'])) {
                        $idHistorikCours = $_POST['dataSerialise']['course-historik'];
                    }
                    else{
                        $data = array(
                            'intitule'            => $_POST['dataSerialise']['course-historik'],
                            'commentaire'         => '',
                            'back_color'          => '#000000',
                            'user_create'         => $this->session->userdata('GUSERID'),
                            'id_groupe'           => $this->session->userdata('STAGIAIREGRP'),
                            'date'                => time()
                        );
                        $idHistorikCours    = $this->coursHistorik_model->add($data);
                    }

                    $data = array(
                        'id_article'            => $_POST['dataSerialise']['article_id'],
                        'user_create'           => $this->session->userdata('GUSERID'),
                        'id_groupe'             => $this->session->userdata('STAGIAIREGRP'),
                        'id_h_c'                => $idHistorikCours,
                        'date_create'           => time()
                    );

                    $id_ch_nl = $this->historik_course_nl_model->add($data);

                    if (isset($_POST['notify']) && $_POST['notify'] == 'on') {

                        $sender = array(
                            'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                            'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
                        );
                        $replyto = array(
                            'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                            'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
                        );
                        $destination = array(
                            'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('STAGIAIREID'))),
                            'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))),
                        );

                        $subject = 'Forma2plus - E-learning plateform ('.$this->convert_utf8($this->lang->line('training_period_course_history')).' - '.utf8_decode($this->coursHistorik_model->Request('intitule',$idHistorikCours)).')';

                        $mailbody .= $this->lang->line('el_send_mail_infos_hello').' '.$this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))).',<br><br>';

                        if (isset($_POST['dataSerialise']['data_type_fav']) && $_POST['dataSerialise']['data_type_fav'] == 'nl_article') {
                            $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_new_article_nl')).' ';
                        }

                        if (isset($_POST['dataType']) && $_POST['dataType'] != 'nl_article') {
                            $paramsotherdata = '&data_type=article_nl';
                        }

                        $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been')).'<br>';
                        $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been_access')).' : <br>';
                        
                        $mailbody .= '<a href="'.base_url().'loginMe?auth=true&pr='.$this->session->userdata ('GUSERID').'&action=ch_tr&ident='.$this->convert_utf8($this->membres_model->Request('login',$this->session->userdata ('STAGIAIREID'))).'&pd='.$this->convert_utf8($this->membres_model->Request('password',$this->session->userdata ('STAGIAIREID'))).'&access=ch&id='.$idHistorikCours.'&container='.$_POST['dataSerialise']['article_id'].''.$paramsotherdata.'" target="_blank">F2+ | E-learning Plateform</a><br>';
                        $mailbody .= '<br><br><br>';
                        $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_sign')).' <br>';
                        $mailbody .= $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))).' <br>';
                        $mailbody .= $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID')));

                        $sendMail = $this->sendMailElearning($sender,$destination,$subject,$mailbody,$mailAltBody,$filePath,$replyto);
                        if ($sendMail) {
                            $retour = '1';
                        }
                        else{
                            $retour = '0';
                        }
                        
                    }

                }
            }
        }
        echo "###".$retour;
    }
    public function classActivity(){
        if (isset($_POST['dataSerialise'])) {
            if ($this->isTuteurConnet()) {
                $id_classification;
                $idCh;
                $retour = '1';
                $sender = Array();
                $replyto = Array();
                $destination = Array();
                $subject = '';
                $mailbody = '';
                $mailAltBody = '';
                $filePath = '';
                $paramsotherdata = '';
                $idHistorikCours;
                $link;
                //verify if todo exist in program stat;
                if (is_numeric($_POST['dataSerialise']['classification'])) {
                    $data_area = array(
                        'id_membres'                  => $this->session->userdata ('STAGIAIREID'), 
                        'user_create'                 => $this->session->userdata ('GUSERID'),
                        'id_classification_favoris'   => $_POST['dataSerialise']['classification'],
                        'id_prg'                      => $_POST['dataSerialise']['article_id'],
                        'module_id'                   => is_int($_POST['dataSerialise']['article_module_id']) ? $_POST['dataSerialise']['article_module_id'] : NULL,
                        'numero'                   => is_int($_POST['dataSerialise']['article_numero_id']) ? $_POST['dataSerialise']['article_numero_id'] : NULL,
                        'intitule'                    => htmlentities($_POST['dataSerialise']['article_intitule']),
                        'status'                      => $_POST['dataSerialise']['article_status'],
                        'type'                        => $_POST['dataSerialise']['article_data_type_fav'],
                        'commentaire'                 => $_POST['dataSerialise']['article_comment'],
                        'date_creation'               => time()
                    );
                } 
                else{
                    $data = array(
                        'intitule'    => $_POST['dataSerialise']['classification'],
                        'user_create' => $this->session->userdata ('GUSERID'),
                        'id_groupe' => $this->session->userdata ('STAGIAIREGRP'),
                        'date'        => time(),
                    );

                    $data_area = array(
                        'id_membres'                  => $this->session->userdata ('STAGIAIREID'), 
                        'user_create'                 => $this->session->userdata ('GUSERID'),
                        'id_classification_favoris'   => $this->classificationFavoris_Model->add($data),
                        'id_prg'                      => $_POST['dataSerialise']['article_id'],
                        'module_id'                   => is_int($_POST['dataSerialise']['article_module_id']) ? $_POST['dataSerialise']['article_module_id'] : NULL,
                        'numero'                   => is_int($_POST['dataSerialise']['article_numero_id']) ? $_POST['dataSerialise']['article_numero_id'] : NULL,
                        'intitule'                    => htmlentities($_POST['dataSerialise']['article_intitule']),
                        'status'                      => $_POST['dataSerialise']['article_status'],
                        'type'                        => $_POST['dataSerialise']['article_data_type_fav'],
                        'commentaire'                 => $_POST['dataSerialise']['article_comment'],
                        'date_creation'               => time()
                    );
                }

                $idStatPr = $this->stat_prg_model->add($data_area);

                if (isset($_POST['dataSerialise']['course-historik']) && $_POST['dataSerialise']['course-historik'] != '') {
                    
                    if (is_numeric($_POST['dataSerialise']['course-historik'])) {
                        $idHistorikCours = $_POST['dataSerialise']['course-historik'];
                    }
                    else{
                        $data = array(
                            'intitule'            => $_POST['dataSerialise']['course-historik'],
                            'commentaire'         => '',
                            'back_color'          => '#000000',
                            'user_create'         => $this->session->userdata('GUSERID'),
                            'id_groupe'           => $this->session->userdata('STAGIAIREGRP'),
                            'date'                => time()
                        );
                        $idHistorikCours    = $this->coursHistorik_model->add($data);
                    }

                    
                    if ($this->sequence_model->RequestSeqByIdAndNumero('final_url',$_POST['dataSerialise']['article_id'],$_POST['dataSerialise']['article_numero_id']) != '') {
                       $link = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$_POST['dataSerialise']['article_id'],$_POST['dataSerialise']['article_numero_id']);
                    }
                    else{
                        $link = $this->sequence_model->RequestSeqByIdAndNumero('link',$_POST['dataSerialise']['article_id'],$_POST['dataSerialise']['article_numero_id']);
                    }
                    $linkInfo = array(
                        'titre'         => $this->sequence_model->RequestSeqByIdAndNumero('titre',$_POST['dataSerialise']['article_id'],$_POST['dataSerialise']['article_numero_id']), 
                        'link'          => $link,
                        'type'          =>$this->sequence_model->RequestSeqByIdAndNumero('type',$_POST['dataSerialise']['article_id'],$_POST['dataSerialise']['article_numero_id']) == 1 ? 0 : 2, 
                        'commentaire'   =>"",
                        'date_create'   =>date('Y-m-d'), 
                        'user_create'   =>$this->session->userdata ('GUSERID'),
                        "thumbnail_file"=>$this->sequence_model->RequestSeqByIdAndNumero('thumbnail_file',$_POST['dataSerialise']['article_id'],$_POST['dataSerialise']['article_numero_id'])
                    );

                    $idNewLink = $this->todolist_model->addnewlink($linkInfo);
                    $todoId = $this->todolist_model->addTodo($idNewLink,$this->session->userdata ('STAGIAIREGRP'),$idHistorikCours);

                    if ($this->sequence_model->RequestSeqByIdAndNumero('thumbnail_file',$_POST['dataSerialise']['article_id'],$_POST['dataSerialise']['article_numero_id']) != "") {
                        $rep      =  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/THUMBNAIL'.$this->session->userdata('GUSERID');
                        if ( ! is_dir($rep) ) {
                            mkdir($rep, 0755,true);
                        }
                        $sourceFile      =  REP_ACTIVITY_SEQUENCE.$this->sequence_model->RequestSeqByIdAndNumero('thumbnail_file',$_POST['dataSerialise']['article_id'],$_POST['dataSerialise']['article_numero_id']);
                        if (is_file($sourceFile)) {
                            copy($sourceFile,$rep.'/'.$this->sequence_model->RequestSeqByIdAndNumero('thumbnail_file',$_POST['dataSerialise']['article_id'],$_POST['dataSerialise']['article_numero_id']));
                        }
                    }

                    if (isset($_POST['notify']) && $_POST['notify'] == 'on') {

                        $sender = array(
                            'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                            'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
                        );
                        $replyto = array(
                            'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                            'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
                        );
                        $destination = array(
                            'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('STAGIAIREID'))),
                            'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))),
                        );

                        $subject = 'Forma2plus - E-learning plateform ('.$this->convert_utf8($this->lang->line('training_period_course_history')).' - '.utf8_decode($this->coursHistorik_model->Request('intitule',$idHistorikCours)).')';

                        $mailbody .= $this->lang->line('el_send_mail_infos_hello').' '.$this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))).',<br><br>';

                        if ($this->todolist_model->RequestNewSequence('type',$idNewLink) == 2) {
                            $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_new_doc')).' ';
                        }
                        else{
                            $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_new_link')).' ';
                        }

                        $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been')).'<br>';
                        $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been_access')).' : <br>';
                        
                        $mailbody .= '<a href="'.base_url().'loginMe?auth=true&pr='.$this->session->userdata ('GUSERID').'&action=ch_tr&ident='.$this->convert_utf8($this->membres_model->Request('login',$this->session->userdata ('STAGIAIREID'))).'&pd='.$this->convert_utf8($this->membres_model->Request('password',$this->session->userdata ('STAGIAIREID'))).'&access=ch&id='.$idHistorikCours.'&container='.$todoId.''.$paramsotherdata.'" target="_blank">F2+ | E-learning Plateform</a><br>';
                        $mailbody .= '<br><br><br>';
                        $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_sign')).' <br>';
                        $mailbody .= $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))).' <br>';
                        $mailbody .= $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID')));

                        $sendMail = $this->sendMailElearning($sender,$destination,$subject,$mailbody,$mailAltBody,$filePath,$replyto);
                        if ($sendMail) {
                            $retour = '1';
                        }
                        else{
                            $retour = '0';
                        }
                        
                    }

                }
            }
        }
        echo "###".$retour;
    }

}

?>