<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
require APPPATH . '/libraries/vendor/autoload.php';

/**
 * Class : Login (LoginController)
 * Login class to control to authenticate user credentials and starts user's session.
 * @author : Kishor Mali
 * @version : 1.1
 * @since : 15 November 2016
 */
class Thumbnail extends CI_Controller
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->width      = "1200";
        $this->height     = "1280";
        $this->date       = time();

    }

    /**
     * Index Page for this controller.
     */
    public function index()
    {            
        
        die('welcome');
    }
    
    public function generateAllThumbailNL()
    {            
        
        //Get all article
        $article = $this->newsletter_model->getAllArticle();
        foreach ($article as $art) {
            //Get all thumbnail from article
            $thumb = $this->utilities_model->getthumbNL($art->ID);
            if ($thumb == "") {
                //On regenere le thumbnail
                $thumbnailFiles = "thumbnail_".$this->date.'_'.$this->session->userdata('GUSERID').'.png';
                
                if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                    mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
                }  
                $fileLocation = REP_ACTIVITY_SEQUENCE.$thumbnailFiles; 
                if ($this->validate_url($art->origine)) {
                    $thumb = $this->generateThumbnail($art->origine,$this->width,$this->height,$fileLocation);

                    if ($thumb) {
                        $thumbinfo = array(            
                            'idMonth'           => $art->nl_monthnewsletter_id, 
                            "idArticle"         => $art->ID, 
                            "thumbnail"         => $thumbnailFiles, 
                            "date_create"       => $this->date, 
                            'user_create'       =>$this->session->userdata ('GUSERID')
                        );
                        $this->utilities_model->addthumbNL($thumbinfo);
                        $this->addLog("success url : ".$art->origine);
                    }
                    else{
                        $this->addLog("unsuccess url : ".$art->origine);
                    }
                   
                }

            }
        }

    }

    public function addThumbNlManagement(){
        if (isset($_GET) && $_GET['url'] != "") {
            $article = $this->newsletter_model->getEndArticle($_GET['url']);
            foreach ($article as $art) {
                $thumb = $this->utilities_model->getthumbNL($art->ID);
                if ($thumb == "") {
            
                    //On regenere le thumbnail
                    $thumbnailFiles = "thumbnail_".$this->date.'_9851.png';
                    
                    if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                        mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
                    }  
                    $fileLocation = REP_ACTIVITY_SEQUENCE.$thumbnailFiles; 
                    if ($this->validate_url($art->origine)) {
                        $thumb = $this->generateThumbnail($art->origine,$this->width,$this->height,$fileLocation);

                        if ($thumb) {
                            $thumbinfo = array(            
                                'idMonth'           => $art->nl_monthnewsletter_id, 
                                "idArticle"         => $art->ID, 
                                "thumbnail"         => $thumbnailFiles, 
                                "date_create"       => $this->date, 
                                'user_create'       => 9851
                            );
                            $this->utilities_model->addthumbNL($thumbinfo);
                            $this->addLog("success url : ".$art->origine);
                        }
                        else{
                            $this->addLog("unsuccess url : ".$art->origine);
                        }
                       
                    }
                }

            }
            //Add thumb temp
            $thumbnailFilesTemp = "thumbnail_".$this->date.'_9851.png';
                
            if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
            }  
            $fileLocationTemp = REP_ACTIVITY_SEQUENCE.$thumbnailFilesTemp; 
            if ($this->validate_url($_GET['url'])) {
                $thumbTemp = $this->generateThumbnail($_GET['url'],$this->width,$this->height,$fileLocationTemp);

                if ($thumbTemp) {
                    $thumbinfotemp = array( 
                        "thumbnail"         => $thumbnailFilesTemp, 
                        "url"               => $_GET['url'],
                        "date_create"       => $this->date
                    );
                    $this->utilities_model->addthumbNLTemp($thumbinfotemp);
                }
               
            }
        }
    }

    public function addLog($txt) {
        if (!file_exists("log.txt")) file_put_contents("log.txt", "");
        file_put_contents("log.txt",date("[j/m/y H:i:s]")." - $txt \r\n".file_get_contents("log.txt"));
    }
    


}

?>