<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningSupervisorForma2PlusController.php';

/**
 * Class : BaseController
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Query extends ElearningSupervisorForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();     
        $this->load->model('queryStat_model');     
        $this->load->model('membres_model');         
        $this->load->model('societe_model');         
        $this->load->model('coursHistorik_model');         
        $this->load->model('todolist_model');         
        $this->load->model('document_model');         
        $this->load->model('newsletter_model');        
        $this->load->model('modules_model');        
        $this->load->model('sequence_model');        
        $this->load->model('stat_prg_model');
        $this->load->model('classificationFavoris_Model');
        $this->load->model('document_repository_model');
        $this->load->model('lib_time_model');
        $this->load->model('connexion_model');
        $this->isLoggedIn(); 
        $this->tracking_type = 54;  
        $this->menu = array();
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
    }
    public function list()
    {
        ini_set('memory_limit', -1);
        $trackingid = $this->tracking_model->Add(0,0,$this->tracking_type);
        $sessionArray = array('TRACKINGID'=>$trackingid);                                    
        $this->session->set_userdata($sessionArray);
        $this->global['trackingsession'] = $this->session->userdata ('TRACKINGID');
        $this->global['pageTitle'] = 'E-learning : Query list'; 
        $this->loadViews("supervisor/query/list", $this->global, NULL , NULL);
    }
    public function monitoringtraineecnx(){
        ini_set('memory_limit', -1);
        $this->load->library('form_validation');
        $this->form_validation->set_rules('connexion_date', 'Date connexion', 'required');
        $this->form_validation->set_rules('trainee', 'Stagiaire', '');
        $this->form_validation->set_rules('societe', 'Société', '');
        $this->global['pageTitle'] = 'E-learning : Suivi des connexions stagiaires'; 

        $data['traineeResults'] = $this->membres_model->filtrer('',STAGIAIRE,'2'); 
        $data['companyResults'] = $this->societe_model->read(''); 

        if ($this->form_validation->run() != FALSE) { 
            $connexion_date = explode(' - ', $this->input->post('connexion_date'));
            $postData = array(
                'connexion_date'   => array(
                    0 => isset($connexion_date[0]) ? $connexion_date[0] : '',
                    1 => isset($connexion_date[1]) ? $connexion_date[1] : ''
                ),
                'trainee'                => $this->input->post('trainee'),
                'societe'                => $this->input->post('societe')
            );

            $data['postData']       = $postData; 
            $data['allResults']     = $this->queryStat_model->monitoringtraineecnx($postData); 
        }
        $this->loadViews("supervisor/query/page/monitoringtraineecnx", $this->global, $data , NULL);
        
    }
    public function monitoringtraineetracking(){
        ini_set('memory_limit', -1);
        $this->global['pageTitle'] = 'E-learning : Suivi des connexion et tracking des stagiaire'; 
        $this->load->library('form_validation');

        $this->form_validation->set_rules('trainee', 'Stagiaire', 'required');
        $this->form_validation->set_rules('connexion_date', 'Dateconnexion', '');
        $this->form_validation->set_rules('societe', 'Société', '');

        if ($this->input->post('trainee')[1] != '') { 
            $connexion_date = explode(' - ', $this->input->post('connexion_date'));
            $postData = array(
                'connexion_date'   => array(
                    0 => isset($connexion_date[0]) ? $connexion_date[0] : '',
                    1 => isset($connexion_date[1]) ? $connexion_date[1] : ''
                ),
                'trainee'                => $this->input->post('trainee'),
                'societe'                => $this->input->post('societe')
            );

            $data['allResults']     = $this->queryStat_model->monitoringtraineetracking($postData); 
            $data['postData']       = $postData; 
    
        }       

        $data['traineeResults'] = $this->membres_model->filtrer('',STAGIAIRE,'2'); 
        $data['companyResults'] = $this->societe_model->read('');

        $this->loadViews("supervisor/query/page/monitoringtraineetracking", $this->global, $data , NULL);
        
    }


    public function coursHistorikList(){
        ini_set('memory_limit', -1);
        $this->global['pageTitle'] = 'E-learning : Historique de cours des professuers'; 
        $this->load->library('form_validation');
        $this->form_validation->set_rules('connexion_date', 'Date connexion', 'required');
        $this->form_validation->set_rules('trainer', 'Professeur', '');

        $data['trainerResults'] = $this->membres_model->filtrer('',STAGIAIRE,'2'); 

        if ($this->form_validation->run() != FALSE) { 
            $connexion_date = explode(' - ', $this->input->post('connexion_date'));
            $postData = array(
                'connexion_date'   => array(
                    0 => isset($connexion_date[0]) ? $connexion_date[0] : '',
                    1 => isset($connexion_date[1]) ? $connexion_date[1] : ''
                ),
                'trainer'                => $this->input->post('trainer')
            );

            $data['postData']       = $postData; 
            $data['allResults']     = $this->todolist_model->getAllSourceByProfessorForStat($postData);
        }
        die('this page is not disponible at this moment');

        $this->loadViews("supervisor/query/page/courseHistoryList", $this->global, $data , NULL);
        
    }
}

?>