<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Trainingobjectif extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();        
        $this->isLoggedIn();   
        $this->tracking_type = 14; 
    }
    
    /**
     * This function used to load the first screen of the user
     */
   
    public function index()
    {
        $this->loadTrackingEl(0,0,$this->tracking_type);
        $this->global['pageTitle'] = 'E-learning : Professional objectives';


        $this->global['BNO_stagiaire'] = $this->bno_model->AfficheBNO($this->session->userdata ('GROUPE'), $this->session->userdata ('GUSERID'), 2) ;        
        
        $this->loadViews("trainee/bno/index", $this->global, NULL , NULL);
    }



    public function pageNotFound()
    {
        $this->global['pageTitle'] = 'CodeInsect : 404 - Page Not Found';
        
        $this->loadViews("404", $this->global, NULL, NULL);
    }
}

?>