<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Audio extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->isLoggedIn();   
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->load->library('pagination');
        $this->global['pageTitle'] = 'E-learning : Audio List';
        $this->global['groupe'] = $this->session->userdata ('STAGIAIREGRP');

        $searchText = $this->input->post('searchText');
        $count      = $this->Audio_model->countTutorlist($searchText,$this->session->userdata ('STAGIAIREGRP'));
        $returns    = $this->paginationCompress ( "trainee-todo-in-tutor/", $count,12);
        $data['audioResult'] = $this->Audio_model->tutorlist($this->session->userdata ('STAGIAIREGRP'),$searchText, $returns["page"], $returns["segment"]);
      
        $this->loadViews("tutor/audio/list", $this->global,$data, NULL );
    }

     public function delete(){
        if (isset($_POST['id'])) {
            
            $this->Audio_model->delete($_POST['id']);
            $filename = $_POST["titre"];
            $filename_prof = str_replace("_pre.wav","",$filename);
            $filename_stag = $filename_prof."_stag";
            $dir_prof = '/var/www/html/audio_transcript/MediaStreamRecorder/demos/'.$filename_prof;
            $dir_stag = '/var/www/html/audio_transcript/MediaStreamRecorder/demos/'.$filename_stag;
            $this->rrmdir($dir_prof);
            $this->rrmdir($dir_stag);
        }
    }

    public function updatevisibilite(){
        if (isset($_POST['id'])) {
            $data = array(
                'autoriser' => $_POST['autoriser']
            );
            $this->Audio_model->update($_POST['id'],$data);
        }
    }

    public function rrmdir($dir) { 
       if (is_dir($dir)) { 
         $objects = scandir($dir);
         foreach ($objects as $object) { 
           if ($object != "." && $object != "..") { 
             if (is_dir($dir. DIRECTORY_SEPARATOR .$object) && !is_link($dir."/".$object))
               $this->rrmdir($dir. DIRECTORY_SEPARATOR .$object);
             else
               unlink($dir. DIRECTORY_SEPARATOR .$object); 
           } 
         }
         $this->rmdir($dir); 
       } 
     }
}

?>