<?php

return [
    'interfaces' => [
        'google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService' => [
            'CreateClientConnectorService' => [
                'longRunning' => [
                    'operationReturnType' => '\Google\Cloud\BeyondCorp\ClientConnectorServices\V1\ClientConnectorService',
                    'metadataReturnType' => '\Google\Cloud\BeyondCorp\ClientConnectorServices\V1\ClientConnectorServiceOperationMetadata',
                    'initialPollDelayMillis' => '500',
                    'pollDelayMultiplier' => '1.5',
                    'maxPollDelayMillis' => '5000',
                    'totalPollTimeoutMillis' => '300000',
                ],
            ],
            'DeleteClientConnectorService' => [
                'longRunning' => [
                    'operationReturnType' => '\Google\Protobuf\GPBEmpty',
                    'metadataReturnType' => '\Google\Cloud\BeyondCorp\ClientConnectorServices\V1\ClientConnectorServiceOperationMetadata',
                    'initialPollDelayMillis' => '500',
                    'pollDelayMultiplier' => '1.5',
                    'maxPollDelayMillis' => '5000',
                    'totalPollTimeoutMillis' => '300000',
                ],
            ],
            'UpdateClientConnectorService' => [
                'longRunning' => [
                    'operationReturnType' => '\Google\Cloud\BeyondCorp\ClientConnectorServices\V1\ClientConnectorService',
                    'metadataReturnType' => '\Google\Cloud\BeyondCorp\ClientConnectorServices\V1\ClientConnectorServiceOperationMetadata',
                    'initialPollDelayMillis' => '500',
                    'pollDelayMultiplier' => '1.5',
                    'maxPollDelayMillis' => '5000',
                    'totalPollTimeoutMillis' => '300000',
                ],
            ],
            'ListClientConnectorServices' => [
                'pageStreaming' => [
                    'requestPageTokenGetMethod' => 'getPageToken',
                    'requestPageTokenSetMethod' => 'setPageToken',
                    'requestPageSizeGetMethod' => 'getPageSize',
                    'requestPageSizeSetMethod' => 'setPageSize',
                    'responsePageTokenGetMethod' => 'getNextPageToken',
                    'resourcesGetMethod' => 'getClientConnectorServices',
                ],
            ],
            'ListLocations' => [
                'pageStreaming' => [
                    'requestPageTokenGetMethod' => 'getPageToken',
                    'requestPageTokenSetMethod' => 'setPageToken',
                    'requestPageSizeGetMethod' => 'getPageSize',
                    'requestPageSizeSetMethod' => 'setPageSize',
                    'responsePageTokenGetMethod' => 'getNextPageToken',
                    'resourcesGetMethod' => 'getLocations',
                ],
            ],
        ],
    ],
];
