<?php
// GENERATED CODE -- DO NOT EDIT!

// Original file comments:
// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
namespace Google\Cloud\Channel\V1;

/**
 * CloudChannelReportsService lets Google Cloud resellers and
 * distributors retrieve and combine a variety of data in Cloud Channel for
 * multiple products (Google Cloud Platform (GCP), Google Voice, and
 * Google Workspace.)
 */
class CloudChannelReportsServiceGrpcClient extends \Grpc\BaseStub {

    /**
     * @param string $hostname hostname
     * @param array $opts channel options
     * @param \Grpc\Channel $channel (optional) re-use channel object
     */
    public function __construct($hostname, $opts, $channel = null) {
        parent::__construct($hostname, $opts, $channel);
    }

    /**
     * Begins generation of data for a given report. The report
     * identifier is a UID (for example, `613bf59q`).
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The user doesn't have access to this report.
     * * INVALID_ARGUMENT: Required request parameters are missing
     *   or invalid.
     * * NOT_FOUND: The report identifier was not found.
     * * INTERNAL: Any non-user error related to a technical issue
     *   in the backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue
     *   in the backend. Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The Operation metadata contains an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * To get the results of report generation, call
     * [CloudChannelReportsService.FetchReportResults][google.cloud.channel.v1.CloudChannelReportsService.FetchReportResults]
     * with the
     * [RunReportJobResponse.report_job][google.cloud.channel.v1.RunReportJobResponse.report_job].
     * @param \Google\Cloud\Channel\V1\RunReportJobRequest $argument input argument
     * @param array $metadata metadata
     * @param array $options call options
     * @return \Grpc\UnaryCall
     */
    public function RunReportJob(\Google\Cloud\Channel\V1\RunReportJobRequest $argument,
      $metadata = [], $options = []) {
        return $this->_simpleRequest('/google.cloud.channel.v1.CloudChannelReportsService/RunReportJob',
        $argument,
        ['\Google\LongRunning\Operation', 'decode'],
        $metadata, $options);
    }

    /**
     * Retrieves data generated by
     * [CloudChannelReportsService.RunReportJob][google.cloud.channel.v1.CloudChannelReportsService.RunReportJob].
     * @param \Google\Cloud\Channel\V1\FetchReportResultsRequest $argument input argument
     * @param array $metadata metadata
     * @param array $options call options
     * @return \Grpc\UnaryCall
     */
    public function FetchReportResults(\Google\Cloud\Channel\V1\FetchReportResultsRequest $argument,
      $metadata = [], $options = []) {
        return $this->_simpleRequest('/google.cloud.channel.v1.CloudChannelReportsService/FetchReportResults',
        $argument,
        ['\Google\Cloud\Channel\V1\FetchReportResultsResponse', 'decode'],
        $metadata, $options);
    }

    /**
     * Lists the reports that RunReportJob can run. These reports include an ID,
     * a description, and the list of columns that will be in the result.
     * @param \Google\Cloud\Channel\V1\ListReportsRequest $argument input argument
     * @param array $metadata metadata
     * @param array $options call options
     * @return \Grpc\UnaryCall
     */
    public function ListReports(\Google\Cloud\Channel\V1\ListReportsRequest $argument,
      $metadata = [], $options = []) {
        return $this->_simpleRequest('/google.cloud.channel.v1.CloudChannelReportsService/ListReports',
        $argument,
        ['\Google\Cloud\Channel\V1\ListReportsResponse', 'decode'],
        $metadata, $options);
    }

}
